/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.ir.AttrBuilder;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.Function;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.java.IChild;

public class Argument
extends Value
implements ilist_node<Argument>,
IChild<Function>,
Destructors.ClassWithDestructor {
    private Function Parent;
    private final ilist_node.ilist_node.Fields ilist_node$Flds = this.$ilist_node();

    protected void anchor() {
    }

    @Override
    public void setParent(Function parent) {
        this.Parent = parent;
    }

    public Argument(Type Ty) {
        this(Ty, new Twine(NativePointer.$EMPTY), null);
    }

    public Argument(Type Ty, Twine Name) {
        this(Ty, Name, null);
    }

    public Argument(Type Ty, Twine Name, Function Par) {
        super(Ty, Value.ValueTy.ArgumentVal.getValue());
        this.Parent = null;
        if (Par != null) {
            Par.getArgumentList().push_back(this);
        }
        this.setName(Name);
    }

    public Function getParent$Const() {
        return this.Parent;
    }

    @Override
    public Function getParent() {
        return this.Parent;
    }

    public int getArgNo() {
        Function F = this.getParent$Const();
        assert (F != null) : "Argument is not in a function";
        ilist_iterator<Argument> AI = F.arg_begin$Const();
        int ArgIdx = 0;
        while (Native.$AddrOf((Object)((Argument)AI.$star())) != this) {
            ++ArgIdx;
            AI.$preInc();
        }
        return ArgIdx;
    }

    public boolean hasNonNullAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        if (this.getParent$Const().getAttributes().hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.NonNull)) {
            return true;
        }
        return Unsigned.$greater_ulong_ullong((long)this.getDereferenceableBytes(), (long)Unsigned.$int2ullong((int)0)) && this.getType().getPointerAddressSpace() == 0;
    }

    public long getDereferenceableBytes() {
        assert (this.getType().isPointerTy()) : "Only pointers have dereferenceable bytes";
        return this.getParent$Const().getDereferenceableBytes(this.getArgNo() + 1);
    }

    public long getDereferenceableOrNullBytes() {
        assert (this.getType().isPointerTy()) : "Only pointers have dereferenceable bytes";
        return this.getParent$Const().getDereferenceableOrNullBytes(this.getArgNo() + 1);
    }

    public boolean hasByValAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        return this.hasAttribute(Attribute.AttrKind.ByVal);
    }

    public boolean hasSwiftSelfAttr() {
        return this.getParent$Const().getAttributes().hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.SwiftSelf);
    }

    public boolean hasSwiftErrorAttr() {
        return this.getParent$Const().getAttributes().hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.SwiftError);
    }

    public boolean hasByValOrInAllocaAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        AttributeSet Attrs = this.getParent$Const().getAttributes();
        return Attrs.hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.ByVal) || Attrs.hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.InAlloca);
    }

    public int getParamAlignment() {
        assert (this.getType().isPointerTy()) : "Only pointers have alignments";
        return this.getParent$Const().getParamAlignment(this.getArgNo() + 1);
    }

    public boolean hasNestAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        return this.hasAttribute(Attribute.AttrKind.Nest);
    }

    public boolean hasNoAliasAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        return this.hasAttribute(Attribute.AttrKind.NoAlias);
    }

    public boolean hasNoCaptureAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        return this.hasAttribute(Attribute.AttrKind.NoCapture);
    }

    public boolean hasStructRetAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        return this.hasAttribute(Attribute.AttrKind.StructRet);
    }

    public boolean hasReturnedAttr() {
        return this.hasAttribute(Attribute.AttrKind.Returned);
    }

    public boolean onlyReadsMemory() {
        return this.getParent$Const().getAttributes().hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.ReadOnly) || this.getParent$Const().getAttributes().hasAttribute(this.getArgNo() + 1, Attribute.AttrKind.ReadNone);
    }

    public boolean hasInAllocaAttr() {
        if (!this.getType().isPointerTy()) {
            return false;
        }
        return this.hasAttribute(Attribute.AttrKind.InAlloca);
    }

    public boolean hasZExtAttr() {
        return this.hasAttribute(Attribute.AttrKind.ZExt);
    }

    public boolean hasSExtAttr() {
        return this.hasAttribute(Attribute.AttrKind.SExt);
    }

    public void addAttr(AttributeSet AS) {
        AttrBuilder B2 = null;
        try {
            assert (Unsigned.$lesseq_uint((int)AS.getNumSlots(), (int)1)) : "Trying to add more than one attribute set to an argument!";
            B2 = new AttrBuilder(new AttributeSet(AS), AS.getSlotIndex(0));
            this.getParent().addAttributes(this.getArgNo() + 1, AttributeSet.get(this.Parent.getContext(), this.getArgNo() + 1, B2));
        }
        finally {
            if (B2 != null) {
                B2.$destroy();
            }
        }
    }

    public void addAttr(Attribute.AttrKind Kind2) {
        this.addAttr(AttributeSet.get_LLVMContext_uint_ArrayRef$AttrKind(this.getContext(), this.getArgNo() + 1, (ArrayRef<Attribute.AttrKind>)new ArrayRef((Object)Kind2)));
    }

    public void removeAttr(AttributeSet AS) {
        AttrBuilder B2 = null;
        try {
            assert (Unsigned.$lesseq_uint((int)AS.getNumSlots(), (int)1)) : "Trying to remove more than one attribute set from an argument!";
            B2 = new AttrBuilder(new AttributeSet(AS), AS.getSlotIndex(0));
            this.getParent().removeAttributes(this.getArgNo() + 1, AttributeSet.get(this.Parent.getContext(), this.getArgNo() + 1, B2));
        }
        finally {
            if (B2 != null) {
                B2.$destroy();
            }
        }
    }

    public void removeAttr(Attribute.AttrKind Kind2) {
        this.removeAttr(AttributeSet.get_LLVMContext_uint_ArrayRef$AttrKind(this.getContext(), this.getArgNo() + 1, (ArrayRef<Attribute.AttrKind>)new ArrayRef((Object)Kind2)));
    }

    public boolean hasAttribute(Attribute.AttrKind Kind2) {
        return this.getParent$Const().hasAttribute(this.getArgNo() + 1, Kind2);
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ArgumentVal.getValue();
    }

    @Override
    public void $destroy() {
        super.$destroy();
        super.$destroy$ilist_node();
    }

    public Argument() {
    }

    public final ilist_node.ilist_node.Fields $ilist_node$Fields() {
        return this.ilist_node$Flds;
    }

    @Override
    public String toString() {
        return "Parent=" + this.Parent + super.toString();
    }
}

