/*
 * Decompiled with CFR 0.152.
 */
package fleet.api.topology;

import fleet.api.HostId;
import fleet.api.topology.ApiFqn;
import fleet.api.topology.ApiInstanceDescription;
import fleet.api.topology.Provider;
import fleet.api.topology.ProviderId;
import fleet.rpc.core.InstanceId;
import fleet.util.UitilKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 $2\u00020\u0001:\u0001$B]\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u0003H\u00c6\u0003Jg\u0010\u001c\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006%"}, d2={"Lfleet/api/topology/Indices;", "", "providers", "Lkotlinx/collections/immutable/PersistentMap;", "Lfleet/api/topology/ProviderId;", "Lfleet/api/topology/Provider;", "byServiceId", "Lfleet/rpc/core/InstanceId;", "byServingHostId", "Lfleet/api/HostId;", "byApiFqn", "Lfleet/api/topology/ApiFqn;", "", "<init>", "(Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;)V", "getProviders", "()Lkotlinx/collections/immutable/PersistentMap;", "getByServiceId", "getByServingHostId", "getByApiFqn", "put", "providerId", "provider", "remove", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "fleet.protocol"})
@SourceDebugExtension(value={"SMAP\nTopologyClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopologyClient.kt\nfleet/api/topology/Indices\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1288#2,3:238\n1288#2,3:241\n1288#2,3:244\n1288#2,3:247\n1#3:250\n*S KotlinDebug\n*F\n+ 1 TopologyClient.kt\nfleet/api/topology/Indices\n*L\n164#1:238,3\n168#1:241,3\n195#1:244,3\n199#1:247,3\n*E\n"})
public final class Indices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentMap<ProviderId, Provider> providers;
    @NotNull
    private final PersistentMap<InstanceId, ProviderId> byServiceId;
    @NotNull
    private final PersistentMap<HostId, ProviderId> byServingHostId;
    @NotNull
    private final PersistentMap<ApiFqn, Set<InstanceId>> byApiFqn;
    @NotNull
    private static final Indices EMPTY = new Indices((PersistentMap<ProviderId, Provider>)ExtensionsKt.persistentHashMapOf(), (PersistentMap<InstanceId, ProviderId>)ExtensionsKt.persistentHashMapOf(), (PersistentMap<HostId, ProviderId>)ExtensionsKt.persistentHashMapOf(), (PersistentMap<ApiFqn, ? extends Set<InstanceId>>)ExtensionsKt.persistentHashMapOf());

    public Indices(@NotNull PersistentMap<ProviderId, Provider> providers, @NotNull PersistentMap<InstanceId, ProviderId> byServiceId, @NotNull PersistentMap<HostId, ProviderId> byServingHostId, @NotNull PersistentMap<ApiFqn, ? extends Set<InstanceId>> byApiFqn) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter(byServiceId, (String)"byServiceId");
        Intrinsics.checkNotNullParameter(byServingHostId, (String)"byServingHostId");
        Intrinsics.checkNotNullParameter(byApiFqn, (String)"byApiFqn");
        this.providers = providers;
        this.byServiceId = byServiceId;
        this.byServingHostId = byServingHostId;
        this.byApiFqn = byApiFqn;
    }

    @NotNull
    public final PersistentMap<ProviderId, Provider> getProviders() {
        return this.providers;
    }

    @NotNull
    public final PersistentMap<InstanceId, ProviderId> getByServiceId() {
        return this.byServiceId;
    }

    @NotNull
    public final PersistentMap<HostId, ProviderId> getByServingHostId() {
        return this.byServingHostId;
    }

    @NotNull
    public final PersistentMap<ApiFqn, Set<InstanceId>> getByApiFqn() {
        return this.byApiFqn;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Indices put(@NotNull ProviderId providerId, @NotNull Provider provider) {
        void $this$fold$iv;
        void $this$fold$iv2;
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        PersistentMap persistentMap = this.providers.put((Object)providerId, (Object)provider);
        PersistentMap persistentMap2 = MapsKt.asSequence(provider.getCapabilities());
        Sequence initial$iv = this.byServiceId;
        boolean $i$f$fold = false;
        Sequence accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv2) {
            Map.Entry entry = (Map.Entry)element$iv;
            Sequence map2 = accumulator$iv;
            boolean bl = false;
            ApiInstanceDescription desc = (ApiInstanceDescription)entry.getValue();
            accumulator$iv = map2.put((Object)desc.getInstanceId(), (Object)providerId);
        }
        Sequence sequence = accumulator$iv;
        initial$iv = MapsKt.asSequence(provider.getCapabilities());
        PersistentMap initial$iv2 = this.byApiFqn;
        boolean $i$f$fold2 = false;
        PersistentMap accumulator$iv2 = initial$iv2;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            PersistentMap map3 = accumulator$iv2;
            boolean bl = false;
            ApiFqn fqn = (ApiFqn)entry.getKey();
            ApiInstanceDescription service2 = (ApiInstanceDescription)entry.getValue();
            accumulator$iv2 = UitilKt.update(map3, (Object)fqn, (Function1)((Function1)new Function1<Set<? extends InstanceId>, Set<? extends InstanceId>>(service2){
                final /* synthetic */ ApiInstanceDescription $service;
                {
                    this.$service = $service;
                    super(1);
                }

                public final Set<InstanceId> invoke(Set<InstanceId> set) {
                    Set set2 = set;
                    if (set2 == null || (set2 = SetsKt.plus(set2, (Object)this.$service.getInstanceId())) == null) {
                        Object[] objectArray = new InstanceId[]{this.$service.getInstanceId()};
                        set2 = (Set)ExtensionsKt.persistentSetOf((Object[])objectArray);
                    }
                    return set2;
                }
            }));
        }
        persistentMap2 = accumulator$iv2;
        HostId servingHost = provider.getServingHostId();
        PersistentMap persistentMap3 = servingHost == null ? this.byServingHostId : UitilKt.update(this.byServingHostId, (Object)servingHost, (Function1)((Function1)new Function1<ProviderId, ProviderId>(providerId, servingHost){
            final /* synthetic */ ProviderId $providerId;
            final /* synthetic */ HostId $servingHost;
            {
                this.$providerId = $providerId;
                this.$servingHost = $servingHost;
                super(1);
            }

            public final ProviderId invoke(ProviderId old) {
                boolean bl = old == null;
                ProviderId providerId = this.$providerId;
                HostId hostId = this.$servingHost;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "conflicting topology, both " + old + " and " + providerId + " declare to serve host " + hostId;
                    throw new IllegalStateException(string.toString());
                }
                return this.$providerId;
            }
        }));
        return new Indices((PersistentMap<ProviderId, Provider>)persistentMap, (PersistentMap<InstanceId, ProviderId>)sequence, (PersistentMap<HostId, ProviderId>)persistentMap3, persistentMap2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Indices remove(@NotNull ProviderId providerId) {
        Indices indices;
        block5: {
            PersistentMap persistentMap;
            Sequence sequence;
            PersistentMap persistentMap2;
            PersistentMap persistentMap3;
            block7: {
                block6: {
                    void $this$fold$iv;
                    void $this$fold$iv2;
                    Provider provider;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
                        provider = (Provider)this.providers.get((Object)providerId);
                        if (provider != null) break block4;
                        indices = this;
                        break block5;
                    }
                    persistentMap3 = this.providers.remove((Object)providerId);
                    persistentMap2 = MapsKt.asSequence(provider.getCapabilities());
                    Sequence initial$iv = this.byServiceId;
                    boolean $i$f$fold = false;
                    Sequence accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv2) {
                        Map.Entry entry = (Map.Entry)element$iv;
                        Sequence map2 = accumulator$iv;
                        boolean bl = false;
                        ApiInstanceDescription ser = (ApiInstanceDescription)entry.getValue();
                        accumulator$iv = map2.remove((Object)ser.getInstanceId());
                    }
                    sequence = accumulator$iv;
                    initial$iv = MapsKt.asSequence(provider.getCapabilities());
                    PersistentMap initial$iv2 = this.byApiFqn;
                    boolean $i$f$fold2 = false;
                    PersistentMap accumulator$iv2 = initial$iv2;
                    for (Object element$iv : $this$fold$iv) {
                        Map.Entry entry = (Map.Entry)element$iv;
                        PersistentMap map3 = accumulator$iv2;
                        boolean bl = false;
                        ApiFqn fqn = (ApiFqn)entry.getKey();
                        ApiInstanceDescription service2 = (ApiInstanceDescription)entry.getValue();
                        accumulator$iv2 = UitilKt.update(map3, (Object)fqn, (Function1)((Function1)new Function1<Set<? extends InstanceId>, Set<? extends InstanceId>>(service2){
                            final /* synthetic */ ApiInstanceDescription $service;
                            {
                                this.$service = $service;
                                super(1);
                            }

                            public final Set<InstanceId> invoke(Set<InstanceId> set) {
                                Set<E> set2;
                                Set<E> set3 = set;
                                if (set3 != null && (set3 = SetsKt.minus(set3, (Object)this.$service.getInstanceId())) != null) {
                                    Set<E> set4;
                                    Set<E> it = set4 = set3;
                                    boolean bl = false;
                                    set2 = !it.isEmpty() ? set4 : null;
                                } else {
                                    set2 = null;
                                }
                                return set2;
                            }
                        }));
                    }
                    persistentMap2 = accumulator$iv2;
                    persistentMap = provider.getServingHostId();
                    if (persistentMap == null) break block6;
                    PersistentMap it = persistentMap;
                    boolean bl = false;
                    PersistentMap persistentMap4 = this.byServingHostId.remove(it, (Object)providerId);
                    persistentMap = persistentMap4;
                    if (persistentMap4 != null) break block7;
                }
                persistentMap = this.byServingHostId;
            }
            PersistentMap persistentMap5 = persistentMap;
            indices = new Indices((PersistentMap<ProviderId, Provider>)persistentMap3, (PersistentMap<InstanceId, ProviderId>)sequence, (PersistentMap<HostId, ProviderId>)persistentMap5, persistentMap2);
        }
        return indices;
    }

    @NotNull
    public final PersistentMap<ProviderId, Provider> component1() {
        return this.providers;
    }

    @NotNull
    public final PersistentMap<InstanceId, ProviderId> component2() {
        return this.byServiceId;
    }

    @NotNull
    public final PersistentMap<HostId, ProviderId> component3() {
        return this.byServingHostId;
    }

    @NotNull
    public final PersistentMap<ApiFqn, Set<InstanceId>> component4() {
        return this.byApiFqn;
    }

    @NotNull
    public final Indices copy(@NotNull PersistentMap<ProviderId, Provider> providers, @NotNull PersistentMap<InstanceId, ProviderId> byServiceId, @NotNull PersistentMap<HostId, ProviderId> byServingHostId, @NotNull PersistentMap<ApiFqn, ? extends Set<InstanceId>> byApiFqn) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter(byServiceId, (String)"byServiceId");
        Intrinsics.checkNotNullParameter(byServingHostId, (String)"byServingHostId");
        Intrinsics.checkNotNullParameter(byApiFqn, (String)"byApiFqn");
        return new Indices(providers, byServiceId, byServingHostId, byApiFqn);
    }

    public static /* synthetic */ Indices copy$default(Indices indices, PersistentMap persistentMap, PersistentMap persistentMap2, PersistentMap persistentMap3, PersistentMap persistentMap4, int n, Object object) {
        if ((n & 1) != 0) {
            persistentMap = indices.providers;
        }
        if ((n & 2) != 0) {
            persistentMap2 = indices.byServiceId;
        }
        if ((n & 4) != 0) {
            persistentMap3 = indices.byServingHostId;
        }
        if ((n & 8) != 0) {
            persistentMap4 = indices.byApiFqn;
        }
        return indices.copy(persistentMap, persistentMap2, persistentMap3, persistentMap4);
    }

    @NotNull
    public String toString() {
        return "Indices(providers=" + this.providers + ", byServiceId=" + this.byServiceId + ", byServingHostId=" + this.byServingHostId + ", byApiFqn=" + this.byApiFqn + ")";
    }

    public int hashCode() {
        int result = this.providers.hashCode();
        result = result * 31 + this.byServiceId.hashCode();
        result = result * 31 + this.byServingHostId.hashCode();
        result = result * 31 + this.byApiFqn.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Indices)) {
            return false;
        }
        Indices indices = (Indices)other;
        if (!Intrinsics.areEqual(this.providers, indices.providers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.byServiceId, indices.byServiceId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.byServingHostId, indices.byServingHostId)) {
            return false;
        }
        return Intrinsics.areEqual(this.byApiFqn, indices.byApiFqn);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lfleet/api/topology/Indices$Companion;", "", "<init>", "()V", "EMPTY", "Lfleet/api/topology/Indices;", "getEMPTY", "()Lfleet/api/topology/Indices;", "fleet.protocol"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Indices getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

