/*
 * Decompiled with CFR 0.152.
 */
package fleet.api;

import fleet.api.FileAddress;
import fleet.api.FileDescriptor;
import fleet.api.ProtocolPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a#\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0013\u001a\u0018\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0001\u001a,\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0015\u0018\u00010\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015\u001a,\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0015\u0018\u00010\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015\u001a\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u0002\u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00020\"\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006#"}, d2={"name", "", "Lfleet/api/FileAddress;", "getName", "(Lfleet/api/FileAddress;)Ljava/lang/String;", "extension", "getExtension", "nameWithoutExtension", "getNameWithoutExtension", "parent", "selfAndParents", "Lkotlin/sequences/Sequence;", "getSelfAndParents", "(Lfleet/api/FileAddress;)Lkotlin/sequences/Sequence;", "parents", "getParents", "child", "names", "", "(Lfleet/api/FileAddress;[Ljava/lang/String;)Lfleet/api/FileAddress;", "elements", "", "resolveChild", "relativePath", "Lkotlin/Pair;", "roots", "maybeEmptyRelativePath", "root", "startsWith", "", "another", "location", "Lfleet/api/FileDescriptor$Address;", "rootDirectories", "", "fleet.protocol"})
@SourceDebugExtension(value={"SMAP\nFileAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAddress.kt\nfleet/api/FileAddressKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n607#2:109\n183#2,2:110\n607#2:112\n2163#2,2:115\n774#3:113\n865#3:114\n866#3:117\n*S KotlinDebug\n*F\n+ 1 FileAddress.kt\nfleet/api/FileAddressKt\n*L\n71#1:109\n73#1:110,2\n84#1:112\n107#1:115,2\n107#1:113\n107#1:114\n107#1:117\n*E\n"})
public final class FileAddressKt {
    @NotNull
    public static final String getName(@NotNull FileAddress $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        return $this$name.getPath().getName();
    }

    @NotNull
    public static final String getExtension(@NotNull FileAddress $this$extension) {
        Intrinsics.checkNotNullParameter((Object)$this$extension, (String)"<this>");
        return StringsKt.substringAfterLast((String)FileAddressKt.getName($this$extension), (char)'.', (String)"");
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull FileAddress $this$nameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$nameWithoutExtension, (String)"<this>");
        return StringsKt.substringBeforeLast$default((String)FileAddressKt.getName($this$nameWithoutExtension), (char)'.', null, (int)2, null);
    }

    @Nullable
    public static final FileAddress parent(@NotNull FileAddress $this$parent) {
        FileAddress fileAddress;
        Intrinsics.checkNotNullParameter((Object)$this$parent, (String)"<this>");
        ProtocolPath protocolPath = $this$parent.getPath().parent();
        if (protocolPath != null) {
            ProtocolPath parentPath = protocolPath;
            boolean bl = false;
            fileAddress = new FileAddress($this$parent.getHostId(), parentPath);
        } else {
            fileAddress = null;
        }
        return fileAddress;
    }

    @NotNull
    public static final Sequence<FileAddress> getSelfAndParents(@NotNull FileAddress $this$selfAndParents) {
        Intrinsics.checkNotNullParameter((Object)$this$selfAndParents, (String)"<this>");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super FileAddress>, Continuation<? super Unit>, Object>($this$selfAndParents, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileAddress $this_selfAndParents;
            {
                this.$this_selfAndParents = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        directory = this.$this_selfAndParents;
lbl7:
                        // 2 sources

                        while (directory != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = directory;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)directory, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl21
                        }
                        break;
                    }
                    case 1: {
                        directory = (FileAddress)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        directory = FileAddressKt.parent(directory);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super FileAddress> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public static final Sequence<FileAddress> getParents(@NotNull FileAddress $this$parents) {
        Intrinsics.checkNotNullParameter((Object)$this$parents, (String)"<this>");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super FileAddress>, Continuation<? super Unit>, Object>($this$parents, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileAddress $this_parents;
            {
                this.$this_parents = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        directory = FileAddressKt.parent(this.$this_parents);
lbl7:
                        // 2 sources

                        while (directory != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = directory;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)directory, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl21
                        }
                        break;
                    }
                    case 1: {
                        directory = (FileAddress)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        directory = FileAddressKt.parent(directory);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super FileAddress> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public static final FileAddress child(@NotNull FileAddress $this$child, String ... names) {
        Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return FileAddress.copy$default($this$child, null, $this$child.getPath().child(Arrays.copyOf(names, names.length)), 1, null);
    }

    @NotNull
    public static final FileAddress child(@NotNull FileAddress $this$child, @NotNull List<String> elements) {
        Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return FileAddress.copy$default($this$child, null, $this$child.getPath().child(elements), 1, null);
    }

    @NotNull
    public static final FileAddress resolveChild(@NotNull FileAddress $this$resolveChild, @NotNull String relativePath2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath2, (String)"relativePath");
        return FileAddress.copy$default($this$resolveChild, null, $this$resolveChild.getPath().resolveChild(relativePath2), 1, null);
    }

    @Nullable
    public static final Pair<FileAddress, List<String>> relativePath(@NotNull FileAddress $this$relativePath, @NotNull List<FileAddress> roots) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$relativePath, (String)"<this>");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)((Function1)new Function1<FileAddress, Boolean>($this$relativePath){
                final /* synthetic */ FileAddress $this_relativePath;
                {
                    this.$this_relativePath = $receiver;
                    super(1);
                }

                public final Boolean invoke(FileAddress root) {
                    Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                    return Intrinsics.areEqual((Object)root.getHostId(), (Object)this.$this_relativePath.getHostId());
                }
            }));
            boolean $i$f$sortedBy = false;
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    FileAddress root = (FileAddress)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(root.getPath().getComponents().size());
                    root = (FileAddress)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(root.getPath().getComponents().size()));
                }
            }), (Function1)((Function1)new Function1<FileAddress, Pair<? extends FileAddress, ? extends List<? extends String>>>($this$relativePath){
                final /* synthetic */ FileAddress $this_relativePath;
                {
                    this.$this_relativePath = $receiver;
                    super(1);
                }

                public final Pair<FileAddress, List<String>> invoke(FileAddress root) {
                    Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                    return TuplesKt.to((Object)root, this.$this_relativePath.getPath().relativeSegmentsTo(root.getPath()));
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                List relativePath2 = (List)pair.component2();
                boolean bl2 = !((Collection)relativePath2).isEmpty();
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final Pair<FileAddress, List<String>> maybeEmptyRelativePath(@NotNull FileAddress $this$maybeEmptyRelativePath, @NotNull List<FileAddress> roots) {
        Intrinsics.checkNotNullParameter((Object)$this$maybeEmptyRelativePath, (String)"<this>");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)((Function1)new Function1<FileAddress, Boolean>($this$maybeEmptyRelativePath){
            final /* synthetic */ FileAddress $this_maybeEmptyRelativePath;
            {
                this.$this_maybeEmptyRelativePath = $receiver;
                super(1);
            }

            public final Boolean invoke(FileAddress root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                return Intrinsics.areEqual((Object)root.getHostId(), (Object)this.$this_maybeEmptyRelativePath.getHostId());
            }
        }));
        boolean $i$f$sortedBy = false;
        return (Pair)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FileAddress root = (FileAddress)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(root.getPath().getComponents().size());
                root = (FileAddress)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(root.getPath().getComponents().size()));
            }
        }), (Function1)((Function1)new Function1<FileAddress, Pair<? extends FileAddress, ? extends List<? extends String>>>($this$maybeEmptyRelativePath){
            final /* synthetic */ FileAddress $this_maybeEmptyRelativePath;
            {
                this.$this_maybeEmptyRelativePath = $receiver;
                super(1);
            }

            public final Pair<FileAddress, List<String>> invoke(FileAddress root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                return this.$this_maybeEmptyRelativePath.getPath().startsWith(root.getPath()) ? TuplesKt.to((Object)root, (Object)CollectionsKt.drop((Iterable)this.$this_maybeEmptyRelativePath.getPath().getComponents(), (int)root.getPath().getComponents().size())) : null;
            }
        })));
    }

    @Nullable
    public static final List<String> relativePath(@NotNull FileAddress $this$relativePath, @NotNull FileAddress root) {
        Intrinsics.checkNotNullParameter((Object)$this$relativePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (!Intrinsics.areEqual((Object)root.getHostId(), (Object)$this$relativePath.getHostId())) {
            return null;
        }
        return $this$relativePath.getPath().relativeSegmentsTo(root.getPath());
    }

    public static final boolean startsWith(@NotNull FileAddress $this$startsWith, @NotNull FileAddress another) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return Intrinsics.areEqual((Object)$this$startsWith.getHostId(), (Object)another.getHostId()) && $this$startsWith.getPath().startsWith(another.getPath());
    }

    @NotNull
    public static final FileDescriptor.Address location(@NotNull FileAddress $this$location) {
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        return new FileDescriptor.Address($this$location);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FileAddress> rootDirectories(@NotNull Set<FileAddress> $this$rootDirectories) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$rootDirectories, (String)"<this>");
        Iterable $this$filter$iv = $this$rootDirectories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                FileAddress it = (FileAddress)element$iv$iv;
                boolean bl2 = false;
                Sequence<FileAddress> $this$none$iv = FileAddressKt.getParents(it);
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    FileAddress ancestor = (FileAddress)element$iv;
                    boolean bl3 = false;
                    if (!$this$rootDirectories.contains(ancestor)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

