/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.topology;

import fleet.common.topology.ServiceEntity2;
import fleet.common.topology.ServiceEntityKt;
import fleet.common.topology.ServiceProviderEntity;
import fleet.common.topology.ServiceProviderEntityKt;
import fleet.common.topology.impl.Implementation;
import fleet.common.topology.impl.ImplementationContainerKt;
import fleet.rpc.RemoteApi;
import fleet.rpc.RemoteApiDescriptor;
import fleet.rpc.core.InstanceId;
import fleet.rpc.server.RpcServiceLocator;
import fleet.rpc.server.ServiceImplementation;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lfleet/workspace/topology/WorkspaceServiceLocator;", "Lfleet/rpc/server/RpcServiceLocator;", "route", "Lfleet/util/UID;", "<init>", "(Lfleet/util/UID;)V", "getRoute", "()Lfleet/util/UID;", "resolve", "Lfleet/rpc/server/ServiceImplementation;", "serviceId", "Lfleet/rpc/core/InstanceId;", "fleet.workspace"})
public final class WorkspaceServiceLocator
implements RpcServiceLocator {
    @NotNull
    private final UID route;

    public WorkspaceServiceLocator(@NotNull UID route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.route = route;
    }

    @NotNull
    public final UID getRoute() {
        return this.route;
    }

    @Nullable
    public ServiceImplementation resolve(@NotNull InstanceId serviceId) {
        ServiceImplementation serviceImplementation;
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        ServiceEntity2 serviceEntity2 = ServiceEntityKt.serviceById((InstanceId)serviceId);
        if (serviceEntity2 != null) {
            ServiceEntity2 service2 = serviceEntity2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)ServiceProviderEntityKt.getRoute((ServiceProviderEntity)service2.getProvider()), (Object)this.route)) {
                boolean bl2 = false;
                String string = "Invariant broken: accessing " + serviceId + " owned by " + ServiceProviderEntityKt.getRoute((ServiceProviderEntity)service2.getProvider()) + " as " + this.route;
                throw new IllegalStateException(string.toString());
            }
            Implementation implementation = ImplementationContainerKt.getImpl((ServiceEntity2)service2);
            Object object = implementation != null ? ImplementationContainerKt.getInstance((Implementation)implementation) : null;
            if (object == null) {
                boolean bl3 = false;
                String string = "Workspace has no implementation for service " + serviceId + ", the call should not have been routed here";
                throw new IllegalStateException(string.toString());
            }
            Implementation.Instance impl2 = object;
            RemoteApi remoteApi = impl2.getImpl();
            RemoteApiDescriptor remoteApiDescriptor = impl2.getRemoteApiDescriptor();
            serviceImplementation = new ServiceImplementation(remoteApiDescriptor, remoteApi);
        } else {
            serviceImplementation = null;
        }
        return serviceImplementation;
    }
}

