/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCollectionFactory {
    private static final SerializableHashingStrategy<File> FILE_HASH_STRATEGY = new SerializableHashingStrategy<File>(){

        public int hashCode(@Nullable File o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.getPath());
        }

        public boolean equals(@Nullable File a, @Nullable File b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.getPath(), b == null ? null : b.getPath());
        }
    };

    @NotNull
    public static <V> Map<Path, V> createCanonicalPathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<String>(){

            public int hashCode(@Nullable String value) {
                return FileUtilRt.pathHashCode(value);
            }

            public boolean equals(@Nullable String val1, @Nullable String val2) {
                return FileUtilRt.pathsEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        return new Object2ObjectOpenCustomHashMap(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(int expected) {
        return new Object2ObjectOpenCustomHashMap(expected, FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(@NotNull Map<? extends File, ? extends V> map) {
        if (map == null) {
            FileCollectionFactory.$$$reportNull$$$0(0);
        }
        Map<File, V> result = FileCollectionFactory.createCanonicalFileMap(map.size());
        result.putAll(map);
        Map<File, V> map2 = result;
        if (map2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    public static Set<File> createCanonicalFileSet() {
        return new ObjectOpenCustomHashSet(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files) {
        if (files == null) {
            FileCollectionFactory.$$$reportNull$$$0(2);
        }
        Set<File> set = FileCollectionFactory.createCanonicalFileSet();
        set.addAll(files);
        Set<File> set2 = set;
        if (set2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet() {
        return new ObjectOpenCustomHashSet((Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files) {
        if (files == null) {
            FileCollectionFactory.$$$reportNull$$$0(4);
        }
        return new ObjectOpenCustomHashSet(files, (Hash.Strategy)new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<String> createCanonicalFilePathSet() {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.FILE_PATH_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<File>(){

            public int hashCode(@Nullable File o) {
                return FileUtilRt.pathHashCode(o == null ? null : o.getPath());
            }

            public boolean equals(@Nullable File a, @Nullable File b) {
                return FileUtilRt.pathsEqual(a == null ? null : a.getPath(), b == null ? null : b.getPath());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileMap";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileSet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalPathSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PathSerializableHashStrategy
    implements FastUtilHashingStrategies.SerializableHashStrategy<Path> {
        private PathSerializableHashStrategy() {
        }

        public int hashCode(@Nullable Path o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.toString());
        }

        public boolean equals(@Nullable Path a, @Nullable Path b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.toString(), b == null ? null : b.toString());
        }
    }

    private static interface SerializableHashingStrategy<T>
    extends Hash.Strategy<T>,
    Serializable {
    }
}

