/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.impl.fus;

import com.jetbrains.fus.reporting.anonymization.AnonymizerUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import fleet.dock.impl.fus.MachineIdManager;
import fleet.util.os.Os;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lfleet/dock/impl/fus/MachineIdManager;", "", "<init>", "()V", "IOREG_COMMAND_TIMEOUT_MS", "", "macMachineIdPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "linuxMachineIdPaths", "", "", "machineId", "getMachineId", "()Ljava/lang/String;", "machineId$delegate", "Lkotlin/Lazy;", "getAnonymizedMachineId", "purpose", "salt", "calcMachineId", "getLinuxMachineId", "getMacOsMachineId", "fleet.dock.impl"})
public final class MachineIdManager {
    @NotNull
    public static final MachineIdManager INSTANCE = new MachineIdManager();
    private static final long IOREG_COMMAND_TIMEOUT_MS = 2000L;
    private static final Pattern macMachineIdPattern = Pattern.compile("\"IOPlatformUUID\"\\s*=\\s*\"(?<machineId>.*)\"");
    @NotNull
    private static final List<String> linuxMachineIdPaths;
    @NotNull
    private static final Lazy machineId$delegate;

    private MachineIdManager() {
    }

    private final String getMachineId() {
        Lazy lazy = machineId$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getAnonymizedMachineId(@NotNull String purpose, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        if (((CharSequence)purpose).length() == 0) {
            throw new IllegalArgumentException("Argument [purpose] should not be empty.");
        }
        String string = this.getMachineId();
        if (string == null) {
            return null;
        }
        String machineId2 = string;
        String string2 = System.getProperty("user.name") + purpose + salt;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return AnonymizerUtil.INSTANCE.anonymize(byArray, machineId2);
    }

    private final String calcMachineId() {
        String string;
        try {
            Os.Type type = Os.INSTANCE.getType();
            string = switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Cryptography", (String)"MachineGuid");
                case 2 -> this.getMacOsMachineId();
                case 3 -> this.getLinuxMachineId();
                default -> null;
            };
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    private final String getLinuxMachineId() {
        for (String machineIdPath : linuxMachineIdPaths) {
            try {
                String machineId2 = Files.readString(Paths.get(machineIdPath, new String[0]));
                CharSequence charSequence = machineId2;
                if (charSequence == null || charSequence.length() == 0) continue;
                return ((Object)StringsKt.trim((CharSequence)machineId2)).toString();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private final String getMacOsMachineId() {
        return (String)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Matcher matcher;
                        Object $i$a$-runCatching-MachineIdManager$getMacOsMachineId$1$32;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        Object[] objectArray = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice"};
                        Process process = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start();
                        BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, null){
                            int label;
                            final /* synthetic */ Process $process;
                            {
                                this.$process = $process;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Process process = this.$process;
                                        try {
                                            boolean bl = false;
                                            Object object2 = Result.constructor-impl((Object)Boxing.boxBoolean((boolean)process.waitFor(2000L, TimeUnit.MILLISECONDS)));
                                        }
                                        catch (Throwable throwable) {
                                            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                        }
                                        this.$process.destroyForcibly();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        String output2 = TextStreamsKt.readText((Reader)new InputStreamReader(process.getInputStream()));
                        try {
                            boolean $i$a$-runCatching-MachineIdManager$getMacOsMachineId$1$32 = false;
                            $i$a$-runCatching-MachineIdManager$getMacOsMachineId$1$32 = Result.constructor-impl((Object)Boxing.boxBoolean((boolean)process.waitFor(2000L, TimeUnit.MILLISECONDS)));
                        }
                        catch (Throwable throwable) {
                            $i$a$-runCatching-MachineIdManager$getMacOsMachineId$1$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        if (process.exitValue() == 0 && (matcher = MachineIdManager.access$getMacMachineIdPattern$p().matcher(output2)).find()) {
                            return matcher.group("machineId");
                        }
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ Pattern access$getMacMachineIdPattern$p() {
        return macMachineIdPattern;
    }

    public static final /* synthetic */ String access$calcMachineId(MachineIdManager $this) {
        return $this.calcMachineId();
    }

    static {
        Object[] objectArray = new String[]{"/etc/machine-id", "/var/lib/dbus/machine-id"};
        linuxMachineIdPaths = CollectionsKt.listOf((Object[])objectArray);
        machineId$delegate = LazyKt.lazy((Function0)machineId.2.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

