/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.impl;

import fleet.dock.api.LocalStorage;
import fleet.dock.api.LocalStorageKey;
import fleet.dock.impl.LocalStorageInDirectory;
import fleet.dock.impl.LocalStorageInDirectoryKt;
import fleet.tracing.TracingKt;
import fleet.util.logging.KLogger;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aC\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042'\u0010\u0005\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0006\u00a2\u0006\u0002\b\nH\u0086@\u00a2\u0006\u0002\u0010\u000b\u001a\u0012\u0010\u0000\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"inDirectory", "", "Lfleet/dock/api/LocalStorage$Companion;", "path", "Ljava/nio/file/Path;", "body", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lfleet/dock/api/LocalStorage$Companion;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lfleet/dock/api/LocalStorage;", "fleet.dock.impl"})
public final class LocalStorageInDirectoryKt {
    @Nullable
    public static final Object inDirectory(@NotNull LocalStorage.Companion $this$inDirectory, @NotNull Path path, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> body, @NotNull Continuation<? super Unit> $completion) {
        Object object = TracingKt.spannedScope$default((String)"withLocalStorage", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$inDirectory, path, body, null){
            int label;
            final /* synthetic */ LocalStorage.Companion $this_inDirectory;
            final /* synthetic */ Path $path;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $body;
            {
                this.$this_inDirectory = $receiver;
                this.$path = $path;
                this.$body = $body;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LocalStorage localStorage = LocalStorageInDirectoryKt.inDirectory(this.$this_inDirectory, this.$path);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)localStorage), this.$body, (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion, (int)2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public static final LocalStorage inDirectory(@NotNull LocalStorage.Companion $this$inDirectory, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$inDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (LocalStorage)TracingKt.span$default((String)"LocalStorage.inDirectory", null, (Function0)((Function0)new Function0<inDirectory.1>(path){
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(0);
            }

            public final inDirectory.1 invoke() {
                return new LocalStorage(this.$path){
                    final /* synthetic */ Path $path;
                    {
                        this.$path = $path;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void writeFile(Path path, ByteBuffer content) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                        Object object = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
                        object = FileChannel.open(path, object);
                        Throwable throwable = null;
                        try {
                            FileChannel channel = (FileChannel)object;
                            boolean bl = false;
                            channel.lock();
                            int n = channel.write(content, 0L);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                    }

                    public ByteBuffer remove(LocalStorageKey key) {
                        Object $i$a$-runCatching-LocalStorageInDirectoryKt$inDirectory$3$1$remove$result$22;
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Path json = this.keyToPath(key);
                        try {
                            boolean $i$a$-runCatching-LocalStorageInDirectoryKt$inDirectory$3$1$remove$result$22 = false;
                            byte[] byArray = Files.readAllBytes(json);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                            $i$a$-runCatching-LocalStorageInDirectoryKt$inDirectory$3$1$remove$result$22 = Result.constructor-impl((Object)ByteBuffer.wrap(byArray));
                        }
                        catch (Throwable throwable) {
                            $i$a$-runCatching-LocalStorageInDirectoryKt$inDirectory$3$1$remove$result$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        Object result = $i$a$-runCatching-LocalStorageInDirectoryKt$inDirectory$3$1$remove$result$22;
                        try {
                            boolean bl = false;
                            Object object = Result.constructor-impl((Object)Files.deleteIfExists(json));
                        }
                        catch (Throwable throwable) {
                            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        return (ByteBuffer)(Result.isFailure-impl((Object)result) ? null : result);
                    }

                    public void put(LocalStorageKey key, ByteBuffer value) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        TracingKt.span$default((String)"localStorage.put", null, (Function0)((Function0)new Function0<Unit>(this, key, value){
                            final /* synthetic */ inDirectory.1 this$0;
                            final /* synthetic */ LocalStorageKey $key;
                            final /* synthetic */ ByteBuffer $value;
                            {
                                this.this$0 = $receiver;
                                this.$key = $key;
                                this.$value = $value;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                block3: {
                                    Path json = inDirectory.1.access$keyToPath(this.this$0, this.$key);
                                    try {
                                        LinkOption[] linkOptionArray = new LinkOption[]{};
                                        if (!Files.exists(json, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(PathsKt.createParentDirectories((Path)json, (FileAttribute[])new FileAttribute[0]), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
                                        }
                                        this.this$0.writeFile(json, this.$value);
                                    }
                                    catch (Exception e) {
                                        void this_$iv;
                                        KLogger kLogger = LocalStorageInDirectory.INSTANCE.getLogger();
                                        LocalStorageKey localStorageKey = this.$key;
                                        boolean $i$f$warn = false;
                                        if (!this_$iv.isWarnEnabled()) break block3;
                                        Throwable throwable = e;
                                        void var7_7 = this_$iv;
                                        boolean bl = false;
                                        String string = "Can't put value by key " + localStorageKey;
                                        var7_7.warn(throwable, (Object)string);
                                    }
                                }
                            }
                        }), (int)2, null);
                    }

                    public ByteBuffer get(LocalStorageKey key) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        return (ByteBuffer)TracingKt.span$default((String)"localStorage.get", null, (Function0)((Function0)new Function0<ByteBuffer>(this, key, this.$path){
                            final /* synthetic */ inDirectory.1 this$0;
                            final /* synthetic */ LocalStorageKey $key;
                            final /* synthetic */ Path $path;
                            {
                                this.this$0 = $receiver;
                                this.$key = $key;
                                this.$path = $path;
                                super(0);
                            }

                            public final ByteBuffer invoke() {
                                Object object;
                                block8: {
                                    Object object2;
                                    Object object3;
                                    object = this.this$0;
                                    LocalStorageKey localStorageKey = this.$key;
                                    try {
                                        boolean bl = false;
                                        byte[] byArray = Files.readAllBytes(inDirectory.1.access$keyToPath(object, localStorageKey));
                                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                                        object3 = Result.constructor-impl((Object)ByteBuffer.wrap(byArray));
                                    }
                                    catch (Throwable throwable) {
                                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                    }
                                    object = object3;
                                    localStorageKey = this.$key;
                                    object3 = this.$path;
                                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                                    if (throwable == null) {
                                        object2 = object;
                                    } else {
                                        Object it;
                                        Object object4 = object;
                                        try {
                                            it = throwable;
                                            boolean bl = false;
                                            String name = Intrinsics.areEqual((Object)localStorageKey.getVersion(), (Object)"0") ? localStorageKey.getKey() + ".json" : localStorageKey.getKey() + "." + localStorageKey.getVersion() + ".json";
                                            Path path = object3.resolve(name);
                                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                                            byte[] byArray = Files.readAllBytes(path);
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                                            it = Result.constructor-impl((Object)ByteBuffer.wrap(byArray));
                                        }
                                        catch (Throwable bl) {
                                            it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                                        }
                                        object2 = it;
                                    }
                                    object = object2;
                                    localStorageKey = this.$key;
                                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                                    if (throwable2 == null) break block8;
                                    Object e = object3 = throwable2;
                                    boolean bl = false;
                                    if (!(e instanceof NoSuchFileException)) {
                                        KLogger this_$iv = LocalStorageInDirectory.INSTANCE.getLogger();
                                        boolean $i$f$warn = false;
                                        if (this_$iv.isWarnEnabled()) {
                                            KLogger kLogger = this_$iv;
                                            boolean bl2 = false;
                                            kLogger.warn((Object)("Can't read value by key " + localStorageKey + " due to " + (Throwable)e));
                                        }
                                    }
                                }
                                return (ByteBuffer)(Result.isFailure-impl((Object)object) ? null : object);
                            }
                        }), (int)2, null);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private final Path keyToPath(LocalStorageKey key) {
                        void $this$fold$iv;
                        char[] cArray = new char[]{'.'};
                        List components = StringsKt.split$default((CharSequence)key.getKey(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                        Iterable iterable = CollectionsKt.dropLast((List)components, (int)1);
                        Path initial$iv = this.$path;
                        boolean $i$f$fold = false;
                        Path accumulator$iv = initial$iv;
                        for (T element$iv : $this$fold$iv) {
                            void part;
                            String string = (String)element$iv;
                            Path path = accumulator$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)path.resolve((String)part), (String)"resolve(...)");
                        }
                        Path path = accumulator$iv.resolve(CollectionsKt.last((List)components) + "." + key.getVersion() + ".json");
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                        return path;
                    }

                    public <E extends CoroutineContext.Element> E get(CoroutineContext.Key<E> key) {
                        return (E)LocalStorage.DefaultImpls.get((LocalStorage)this, key);
                    }

                    public <R> R fold(R initial, Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
                        return (R)LocalStorage.DefaultImpls.fold((LocalStorage)this, initial, operation);
                    }

                    public CoroutineContext minusKey(CoroutineContext.Key<?> key) {
                        return LocalStorage.DefaultImpls.minusKey((LocalStorage)this, key);
                    }

                    public CoroutineContext plus(CoroutineContext context) {
                        return LocalStorage.DefaultImpls.plus((LocalStorage)this, (CoroutineContext)context);
                    }

                    public static final /* synthetic */ Path access$keyToPath(inDirectory.1 $this, LocalStorageKey key) {
                        return $this.keyToPath(key);
                    }
                };
            }
        }), (int)2, null);
    }
}

