/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko.themes;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import fleet.util.logging.KLogger;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.windowManagement.impl.skiko.mac.Foundation;
import noria.windowManagement.impl.skiko.mac.ID;
import noria.windowManagement.impl.skiko.themes.ConcurrentHashSet;
import noria.windowManagement.impl.skiko.themes.MacOSThemeDetector;
import noria.windowManagement.impl.skiko.themes.OsThemeDetector;
import noria.windowManagement.impl.skiko.themes.SystemInfoRt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\u0016\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lnoria/windowManagement/impl/skiko/themes/MacOSThemeDetector;", "Lnoria/windowManagement/impl/skiko/themes/OsThemeDetector;", "<init>", "()V", "listeners", "", "Ljava/util/function/Consumer;", "", "callbackExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/ExecutorService;", "themeChangedCallback", "Lcom/sun/jna/Callback;", "initObserver", "", "useAppearanceApi", "isDark", "()Z", "registerListener", "darkThemeListener", "removeAllListeners", "notifyListeners", "Companion", "DetectorThread", "fleet.noria.windowManagement.impl"})
public final class MacOSThemeDetector
extends OsThemeDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Consumer<Boolean>> listeners = new ConcurrentHashSet();
    private final ExecutorService callbackExecutor = Executors.newSingleThreadExecutor(MacOSThemeDetector::callbackExecutor$lambda$0);
    @NotNull
    private final Callback themeChangedCallback = new Callback(this){
        final /* synthetic */ MacOSThemeDetector this$0;
        {
            this.this$0 = $receiver;
        }

        public final void callback() {
            MacOSThemeDetector.access$getCallbackExecutor$p(this.this$0).execute(() -> themeChangedCallback.1.callback$lambda$0(this.this$0));
        }

        private static final void callback$lambda$0(MacOSThemeDetector this$0) {
            MacOSThemeDetector.access$notifyListeners(this$0, this$0.isDark());
        }
    };
    @NotNull
    private static final Lazy<KLogger> logger$delegate = LazyKt.lazy((Function0)Companion.logger.2.INSTANCE);

    public MacOSThemeDetector() {
        this.initObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initObserver() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            Pointer selector = this.useAppearanceApi() ? Foundation.createSelector("observeValueForKeyPath:ofObject:change:context:") : Foundation.createSelector("handleAppleThemeChanged:");
            ID delegateClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), "NSColorChangesObserver");
            if (!Intrinsics.areEqual((Object)((Object)ID.NIL), (Object)((Object)delegateClass))) {
                if (!Foundation.addMethod(delegateClass, selector, this.themeChangedCallback, "v@")) {
                    MacOSThemeDetector.Companion.getLogger().error((Object)"Observer method cannot be added");
                }
                Foundation.registerObjcClassPair(delegateClass);
            }
            ID delegate = Foundation.invoke("NSColorChangesObserver", "new", new Object[0]);
            if (this.useAppearanceApi()) {
                ID app = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                Object[] objectArray = new Object[]{delegate, Foundation.nsString("effectiveAppearance"), 1, ID.NIL};
                v0 = Foundation.invoke(app, "addObserver:forKeyPath:options:context:", objectArray);
            } else {
                Object[] objectArray = new Object[]{delegate, selector, Foundation.nsString("AppleInterfaceThemeChangedNotification"), ID.NIL};
                v0 = Foundation.invoke(Foundation.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]), "addObserver:selector:name:object:", objectArray);
            }
        }
        finally {
            pool.drain();
        }
    }

    private final boolean useAppearanceApi() {
        boolean isMacOSCatalina = SystemInfoRt.isOsVersionAtLeast("10.15");
        return isMacOSCatalina && StringsKt.equals((String)"system", (String)System.getProperty("apple.awt.application.appearance"), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDark() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            String appleInterfaceStyle;
            if (this.useAppearanceApi()) {
                String name;
                ID app = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                String string = name = Foundation.toStringViaUTF8(Foundation.invoke(Foundation.invoke(app, "effectiveAppearance", new Object[0]), "name", new Object[0]));
                boolean bl = string != null ? string.equals("NSAppearanceNameDarkAqua") : false;
                return bl;
            }
            ID userDefaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            Object[] objectArray = new Object[]{Foundation.nsString("AppleInterfaceStyle")};
            String string = appleInterfaceStyle = Foundation.toStringViaUTF8(Foundation.invoke(userDefaults, "objectForKey:", objectArray));
            boolean bl = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"dark", (boolean)true) : false;
            return bl;
        }
        catch (RuntimeException e) {
            MacOSThemeDetector.Companion.getLogger().error((Throwable)e, (Object)"Couldn't execute theme name query with the Os");
        }
        finally {
            pool.drain();
        }
        return false;
    }

    @Override
    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        Intrinsics.checkNotNullParameter(darkThemeListener, (String)"darkThemeListener");
        this.removeAllListeners();
        this.listeners.add(darkThemeListener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    private final void notifyListeners(boolean isDark) {
        this.listeners.forEach(arg_0 -> MacOSThemeDetector.notifyListeners$lambda$1(isDark, arg_0));
    }

    private static final Thread callbackExecutor$lambda$0(Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return new DetectorThread(runnable);
    }

    private static final void notifyListeners$lambda$1(boolean $isDark, Consumer listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        listener.accept($isDark);
    }

    public static final /* synthetic */ ExecutorService access$getCallbackExecutor$p(MacOSThemeDetector $this) {
        return $this.callbackExecutor;
    }

    public static final /* synthetic */ void access$notifyListeners(MacOSThemeDetector $this, boolean isDark) {
        $this.notifyListeners(isDark);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lnoria/windowManagement/impl/skiko/themes/MacOSThemeDetector$Companion;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "fleet.noria.windowManagement.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final KLogger getLogger() {
            Lazy lazy = logger$delegate;
            return (KLogger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnoria/windowManagement/impl/skiko/themes/MacOSThemeDetector$DetectorThread;", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/Runnable;)V", "fleet.noria.windowManagement.impl"})
    private static final class DetectorThread
    extends Thread {
        public DetectorThread(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            super(runnable);
            this.setName("MacOS Theme Detector Thread");
            this.setDaemon(true);
        }
    }
}

