/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko.accessibility;

import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleTextSequence;
import javax.swing.text.AttributeSet;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import noria.windowManagement.api.TextSegmentGranularity;
import noria.windowManagement.extensions.AccessibilityNodeCapabilities;
import noria.windowManagement.extensions.TextSegmentGranularities;
import noria.windowManagement.impl.skiko.ConvertersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\u0017\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010$\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010%\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020\f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnoria/windowManagement/impl/skiko/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "selectableText", "Lnoria/windowManagement/extensions/AccessibilityNodeCapabilities$SelectableText;", "<init>", "(Lnoria/windowManagement/extensions/AccessibilityNodeCapabilities$SelectableText;)V", "getIndexAtPoint", "", "p", "Ljava/awt/Point;", "getCharacterBounds", "Ljava/awt/Rectangle;", "i", "getCharCount", "getCaretPosition", "partToPositionKind", "Lnoria/windowManagement/api/TextSegmentGranularity;", "part", "partToPositionKind-lZK53Ug", "(I)Ljava/lang/String;", "getAtIndex", "", "index", "getAfterIndex", "getBeforeIndex", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "getSelectionStart", "getSelectionEnd", "getSelectedText", "getTextRange", "startIndex", "endIndex", "getTextSequenceAt", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAfter", "getTextSequenceBefore", "getTextBounds", "fleet.noria.windowManagement.impl"})
public class AccessibleText
implements javax.accessibility.AccessibleText,
AccessibleExtendedText {
    @NotNull
    private final AccessibilityNodeCapabilities.SelectableText selectableText;

    public AccessibleText(@NotNull AccessibilityNodeCapabilities.SelectableText selectableText) {
        Intrinsics.checkNotNullParameter((Object)selectableText, (String)"selectableText");
        this.selectableText = selectableText;
    }

    @Override
    public int getIndexAtPoint(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Long l = this.selectableText.getOffsetAtPoint(ConvertersKt.toWindowManagementPoint(p));
        return l != null ? (int)l.longValue() : -1;
    }

    @Override
    @Nullable
    public Rectangle getCharacterBounds(int i) {
        return null;
    }

    @Override
    public int getCharCount() {
        return (int)this.selectableText.getTextLength();
    }

    @Override
    public int getCaretPosition() {
        return (int)this.selectableText.getCaretPosition();
    }

    private final String partToPositionKind-lZK53Ug(int part) {
        return switch (part) {
            case 1 -> TextSegmentGranularities.INSTANCE.getCharacter-3UYBBlI();
            case 2 -> TextSegmentGranularities.INSTANCE.getWord-3UYBBlI();
            case 3 -> TextSegmentGranularities.INSTANCE.getSentence-3UYBBlI();
            default -> TextSegmentGranularities.INSTANCE.getCharacter-3UYBBlI();
        };
    }

    @Override
    @NotNull
    public String getAtIndex(int part, int index) {
        return this.selectableText.getAtOffset(TuplesKt.to((Object)index, (Object)TextSegmentGranularity.box-impl((String)this.partToPositionKind-lZK53Ug(part))));
    }

    @Override
    @NotNull
    public String getAfterIndex(int part, int index) {
        return this.selectableText.getAfterOffset(TuplesKt.to((Object)index, (Object)TextSegmentGranularity.box-impl((String)this.partToPositionKind-lZK53Ug(part))));
    }

    @Override
    @NotNull
    public String getBeforeIndex(int part, int index) {
        return this.selectableText.getBeforeOffset(TuplesKt.to((Object)index, (Object)TextSegmentGranularity.box-impl((String)this.partToPositionKind-lZK53Ug(part))));
    }

    @Override
    @Nullable
    public AttributeSet getCharacterAttribute(int i) {
        return null;
    }

    @Override
    public int getSelectionStart() {
        return (int)this.selectableText.getSelectionRange().getFirst();
    }

    @Override
    public int getSelectionEnd() {
        return (int)this.selectableText.getSelectionRange().getLast();
    }

    @Override
    @NotNull
    public String getSelectedText() {
        return this.selectableText.getSelectedText();
    }

    @Override
    @NotNull
    public String getTextRange(int startIndex, int endIndex) {
        return this.selectableText.getTextRange(new LongRange((long)startIndex, (long)endIndex));
    }

    @Override
    @NotNull
    public AccessibleTextSequence getTextSequenceAt(int part, int index) {
        System.out.println((Object)"Not implemented: getBeforeIndex");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
        System.out.println((Object)"Not implemented: getTextSequenceAfter");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
        System.out.println((Object)"Not implemented: getTextSequenceBefore");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Rectangle getTextBounds(int startIndex, int endIndex) {
        System.out.println((Object)"Not implemented: getTextBounds");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

