/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko;

import fleet.util.logging.KLogger;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.im.InputMethodRequests;
import javax.accessibility.Accessible;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.windowManagement.api.TextInputOperations;
import noria.windowManagement.impl.skiko.AwtSkikoWindowManager;
import noria.windowManagement.impl.skiko.InputMethodsKt;
import noria.windowManagement.impl.skiko.TextInputOperationsAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0018\u00010\u001fJ\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020!J\u0006\u0010%\u001a\u00020\u0014J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001bH\u0016J\b\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\b\u0010,\u001a\u00020\u0014H\u0016J\b\u0010-\u001a\u00020\u0014H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lnoria/windowManagement/impl/skiko/SkiaLayerWrapper;", "Lorg/jetbrains/skiko/SkiaLayer;", "windowId", "", "Lnoria/windowManagement/api/WindowId;", "accessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "pixelGeometry", "Lorg/jetbrains/skia/PixelGeometry;", "<init>", "(JLkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;Lorg/jetbrains/skia/PixelGeometry;)V", "getWindowId", "()J", "doLayout", "", "paint", "g", "Ljava/awt/Graphics;", "textInputOperationsAdapter", "Lnoria/windowManagement/impl/skiko/TextInputOperationsAdapter;", "value", "", "isDisposed", "()Z", "getActiveTextInput", "Lkotlin/Pair;", "", "Lnoria/windowManagement/api/TextInputOperations;", "setActiveTextInput", "textInputId", "textInputOperations", "dropActiveTextInput", "getInputMethodRequests", "Ljava/awt/im/InputMethodRequests;", "enableInputMethods", "enable", "requestFocusInWindow", "addNotify", "removeNotify", "dispose", "fleet.noria.windowManagement.impl"})
@SourceDebugExtension(value={"SMAP\nAwtSkikoWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtSkikoWindowManager.kt\nnoria/windowManagement/impl/skiko/SkiaLayerWrapper\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,1793:1\n10#2,2:1794\n10#2,2:1796\n6#2,2:1798\n6#2,2:1800\n6#2,2:1802\n6#2,2:1804\n*S KotlinDebug\n*F\n+ 1 AwtSkikoWindowManager.kt\nnoria/windowManagement/impl/skiko/SkiaLayerWrapper\n*L\n112#1:1794,2\n118#1:1796,2\n141#1:1798,2\n155#1:1800,2\n171#1:1802,2\n175#1:1804,2\n*E\n"})
public final class SkiaLayerWrapper
extends SkiaLayer {
    private final long windowId;
    @NotNull
    private final TextInputOperationsAdapter textInputOperationsAdapter;
    private boolean isDisposed;

    public SkiaLayerWrapper(long windowId, @NotNull Function1<? super Component, ? extends Accessible> accessibleFactory2, @NotNull SkiaLayerAnalytics analytics, @NotNull GraphicsApi renderApi, @NotNull PixelGeometry pixelGeometry) {
        Intrinsics.checkNotNullParameter(accessibleFactory2, (String)"accessibleFactory");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)renderApi, (String)"renderApi");
        Intrinsics.checkNotNullParameter((Object)pixelGeometry, (String)"pixelGeometry");
        super(accessibleFactory2, true, true, null, renderApi, analytics, pixelGeometry, 8, null);
        this.windowId = windowId;
        this.textInputOperationsAdapter = new TextInputOperationsAdapter(this, null, null);
        super.enableInputMethods(false);
        this.getCanvas().addKeyListener(new KeyAdapter(){});
        this.addInputMethodListener(this.textInputOperationsAdapter);
    }

    public final long getWindowId() {
        return this.windowId;
    }

    public void doLayout() {
        super.doLayout();
        KLogger this_$iv = AwtSkikoWindowManager.INSTANCE.getLogger();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("AWT doLayout called for " + this.windowId));
        }
    }

    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        KLogger this_$iv = AwtSkikoWindowManager.INSTANCE.getLogger();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("AWT repaint called for " + this.windowId));
        }
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    @Nullable
    public final Pair<Object, TextInputOperations> getActiveTextInput() {
        if (this.textInputOperationsAdapter.getTextInputId() == null || this.textInputOperationsAdapter.getTextInputOperations() == null) {
            return null;
        }
        Object object = this.textInputOperationsAdapter.getTextInputId();
        Intrinsics.checkNotNull((Object)object);
        TextInputOperations textInputOperations = this.textInputOperationsAdapter.getTextInputOperations();
        Intrinsics.checkNotNull((Object)textInputOperations);
        return TuplesKt.to((Object)object, (Object)textInputOperations);
    }

    public final void setActiveTextInput(@NotNull Object textInputId, @NotNull TextInputOperations textInputOperations) {
        Intrinsics.checkNotNullParameter((Object)textInputId, (String)"textInputId");
        Intrinsics.checkNotNullParameter((Object)textInputOperations, (String)"textInputOperations");
        KLogger this_$iv = InputMethodsKt.getInputMethodsLogger();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.trace((Object)("setActiveTextInput: textInputId:\u3000" + textInputId + " textInputOperations: " + textInputOperations));
        }
        if (this.textInputOperationsAdapter.getTextInputId() != null && !Intrinsics.areEqual((Object)this.textInputOperationsAdapter.getTextInputId(), (Object)textInputId)) {
            this.dropActiveTextInput();
        }
        boolean wasDisabled = this.textInputOperationsAdapter.getTextInputOperations() == null;
        this.textInputOperationsAdapter.setTextInputId(textInputId);
        this.textInputOperationsAdapter.setTextInputOperations(textInputOperations);
        if (wasDisabled) {
            this.enableInputMethods(true);
        }
    }

    public final void dropActiveTextInput() {
        KLogger this_$iv = InputMethodsKt.getInputMethodsLogger();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.trace((Object)"dropActiveTextInput");
        }
        if (this.textInputOperationsAdapter.getTextInputOperations() != null) {
            this.enableInputMethods(false);
            this.textInputOperationsAdapter.setTextInputId(null);
            this.textInputOperationsAdapter.setTextInputOperations(null);
        }
    }

    @NotNull
    public InputMethodRequests getInputMethodRequests() {
        return this.textInputOperationsAdapter;
    }

    public void enableInputMethods(boolean enable) {
        if (enable) {
            KLogger this_$iv = InputMethodsKt.getInputMethodsLogger();
            boolean $i$f$trace = false;
            if (this_$iv.isTraceEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.trace((Object)"enable input methods");
            }
            super.enableInputMethods(true);
        } else {
            KLogger this_$iv = InputMethodsKt.getInputMethodsLogger();
            boolean $i$f$trace = false;
            if (this_$iv.isTraceEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.trace((Object)"disable input methods");
            }
            this.getInputContext().endComposition();
            super.enableInputMethods(false);
        }
    }

    public boolean requestFocusInWindow() {
        return this.getCanvas().requestFocusInWindow();
    }

    public void addNotify() {
        super.addNotify();
        this.isDisposed = false;
    }

    public void removeNotify() {
        this.getInputContext().removeNotify(this.getCanvas());
        super.removeNotify();
    }

    public void dispose() {
        super.dispose();
        this.isDisposed = true;
    }
}

