/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko;

import com.apple.eawt.Application;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.event.FullScreenEvent;
import fleet.util.os.Os;
import java.awt.GraphicsDevice;
import java.awt.Window;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import noria.windowManagement.api.PropertyKey;
import noria.windowManagement.api.Window;
import noria.windowManagement.extensions.WindowEvent;
import noria.windowManagement.extensions.WindowPropertyKeys;
import noria.windowManagement.impl.skiko.AwtSkikoWindow;
import noria.windowManagement.impl.skiko.FullScreenDelegateKt;
import noria.windowManagement.impl.skiko.FullScreenState;
import noria.windowManagement.impl.skiko.JFrameState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u0003H\u0002J\"\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0096\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0002H\u0002J\f\u0010\u0016\u001a\u00020\u0014*\u00020\u0002H\u0002R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lnoria/windowManagement/impl/skiko/FullScreenDelegate;", "Lkotlin/properties/ReadWriteProperty;", "Lnoria/windowManagement/impl/skiko/AwtSkikoWindow;", "", "thisRef", "<init>", "(Lnoria/windowManagement/impl/skiko/AwtSkikoWindow;)V", "getThisRef", "()Lnoria/windowManagement/impl/skiko/AwtSkikoWindow;", "value", "Lnoria/windowManagement/impl/skiko/FullScreenState;", "state", "setState", "(Lnoria/windowManagement/impl/skiko/FullScreenState;)V", "stateAsBoolean", "getValue", "property", "Lkotlin/reflect/KProperty;", "(Lnoria/windowManagement/impl/skiko/AwtSkikoWindow;Lkotlin/reflect/KProperty;)Ljava/lang/Boolean;", "setValue", "", "enterFullScreen", "exitFullScreen", "fleet.noria.windowManagement.impl"})
public final class FullScreenDelegate
implements ReadWriteProperty<AwtSkikoWindow, Boolean> {
    @NotNull
    private final AwtSkikoWindow thisRef;
    @NotNull
    private FullScreenState state;

    public FullScreenDelegate(@NotNull AwtSkikoWindow thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        this.thisRef = thisRef;
        this.state = FullScreenState.NotEntered.INSTANCE;
        if (Os.INSTANCE.isMac()) {
            FullScreenUtilities.addFullScreenListenerTo((Window)this.thisRef.getJFrame(), (FullScreenListener)new FullScreenListener(){

                public void windowEnteringFullScreen(FullScreenEvent e) {
                    this.setState(FullScreenState.Entering.INSTANCE);
                }

                public void windowExitingFullScreen(FullScreenEvent e) {
                    this.setState(FullScreenState.Exiting.INSTANCE);
                }

                public void windowEnteredFullScreen(FullScreenEvent e) {
                    this.setState(new FullScreenState.Entered(FullScreenDelegateKt.access$currentState(this.getThisRef().getJFrame())));
                    this.getThisRef().invalidate$fleet_noria_windowManagement_impl((PropertyKey)Window.ReadonlyPropertyKey.box-impl((String)WindowPropertyKeys.INSTANCE.getCustomTitleBarInsets-3At4-GA()));
                }

                public void windowExitedFullScreen(FullScreenEvent e) {
                    this.setState(FullScreenState.NotEntered.INSTANCE);
                    this.getThisRef().invalidate$fleet_noria_windowManagement_impl((PropertyKey)Window.ReadonlyPropertyKey.box-impl((String)WindowPropertyKeys.INSTANCE.getCustomTitleBarInsets-3At4-GA()));
                }
            });
        }
    }

    @NotNull
    public final AwtSkikoWindow getThisRef() {
        return this.thisRef;
    }

    private final void setState(FullScreenState value) {
        this.state = value;
        SwingUtilities.invokeLater(() -> FullScreenDelegate._set_state_$lambda$0(this));
    }

    private final boolean stateAsBoolean() {
        return this.state instanceof FullScreenState.Entered || Intrinsics.areEqual((Object)this.state, (Object)FullScreenState.Exiting.INSTANCE);
    }

    @NotNull
    public Boolean getValue(@NotNull AwtSkikoWindow thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.stateAsBoolean();
    }

    public void setValue(@NotNull AwtSkikoWindow thisRef, @NotNull KProperty<?> property, boolean value) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        AwtSkikoWindow $this$setValue_u24lambda_u241 = thisRef;
        boolean bl = false;
        if (!(this.state instanceof FullScreenState.Entered) && value) {
            this.enterFullScreen($this$setValue_u24lambda_u241);
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)FullScreenState.NotEntered.INSTANCE) && !value) {
            this.exitFullScreen($this$setValue_u24lambda_u241);
        }
    }

    private final void enterFullScreen(AwtSkikoWindow $this$enterFullScreen) {
        Os.Type type = Os.INSTANCE.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                JFrameState previousJFrameState = FullScreenDelegateKt.access$currentState($this$enterFullScreen.getJFrame());
                if (!$this$enterFullScreen.getJFrame().isUndecorated()) {
                    $this$enterFullScreen.getJFrame().dispose();
                    $this$enterFullScreen.getJFrame().setUndecorated(true);
                }
                GraphicsDevice screen2 = $this$enterFullScreen.getJFrame().getGraphicsConfiguration().getDevice();
                $this$enterFullScreen.getJFrame().setBounds(screen2.getDefaultConfiguration().getBounds());
                screen2.setFullScreenWindow($this$enterFullScreen.getJFrame());
                $this$enterFullScreen.getJFrame().setVisible(previousJFrameState.isVisible());
                this.setState(new FullScreenState.Entered(previousJFrameState));
                break;
            }
            case 2: {
                Application.getApplication().requestToggleFullScreen((Window)$this$enterFullScreen.getJFrame());
                break;
            }
            default: {
                JFrameState previousJFrameState = FullScreenDelegateKt.access$currentState($this$enterFullScreen.getJFrame());
                GraphicsDevice screen3 = $this$enterFullScreen.getJFrame().getGraphicsConfiguration().getDevice();
                $this$enterFullScreen.getJFrame().setBounds(screen3.getDefaultConfiguration().getBounds());
                screen3.setFullScreenWindow($this$enterFullScreen.getJFrame());
                this.setState(new FullScreenState.Entered(previousJFrameState));
            }
        }
    }

    private final void exitFullScreen(AwtSkikoWindow $this$exitFullScreen) {
        Os.Type type = Os.INSTANCE.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                FullScreenState fullScreenState = this.state;
                FullScreenState.Entered entered = fullScreenState instanceof FullScreenState.Entered ? (FullScreenState.Entered)fullScreenState : null;
                if (entered == null) {
                    boolean $i$a$-requireNotNull-FullScreenDelegate$exitFullScreen$previousJFrameState$32 = false;
                    String $i$a$-requireNotNull-FullScreenDelegate$exitFullScreen$previousJFrameState$32 = "Cannot exit full screen state with current state " + this.state;
                    throw new IllegalArgumentException($i$a$-requireNotNull-FullScreenDelegate$exitFullScreen$previousJFrameState$32.toString());
                }
                JFrameState previousJFrameState = entered.getPreviousJFrameState();
                if (!previousJFrameState.isUndecorated()) {
                    $this$exitFullScreen.getJFrame().dispose();
                }
                GraphicsDevice screen2 = $this$exitFullScreen.getJFrame().getGraphicsConfiguration().getDevice();
                screen2.setFullScreenWindow(null);
                FullScreenDelegateKt.access$restoreState($this$exitFullScreen, previousJFrameState);
                this.setState(FullScreenState.NotEntered.INSTANCE);
                break;
            }
            case 2: {
                Application.getApplication().requestToggleFullScreen((Window)$this$exitFullScreen.getJFrame());
                break;
            }
            default: {
                Object screen2 = this.state;
                FullScreenState.Entered entered = screen2 instanceof FullScreenState.Entered ? (FullScreenState.Entered)screen2 : null;
                if (entered == null) {
                    boolean bl = false;
                    String string = "Cannot exit full screen state with current state " + this.state;
                    throw new IllegalArgumentException(string.toString());
                }
                JFrameState previousJFrameState = entered.getPreviousJFrameState();
                screen2 = $this$exitFullScreen.getJFrame().getGraphicsConfiguration().getDevice();
                ((GraphicsDevice)screen2).setFullScreenWindow(null);
                $this$exitFullScreen.getJFrame().setBounds(previousJFrameState.getBounds());
                $this$exitFullScreen.getJFrame().setVisible(previousJFrameState.isVisible());
                this.setState(FullScreenState.NotEntered.INSTANCE);
            }
        }
    }

    private static final void _set_state_$lambda$0(FullScreenDelegate this$0) {
        this$0.thisRef.invalidate$fleet_noria_windowManagement_impl((PropertyKey)Window.WritablePropertyKey.box-impl((String)WindowPropertyKeys.INSTANCE.getFullScreen-siIV0BI()));
        this$0.thisRef.getEmitEvent().invoke((Object)WindowEvent.Companion.fullScreenChanged$default((WindowEvent.Companion)WindowEvent.Companion, (long)this$0.thisRef.getWindowId(), (boolean)this$0.stateAsBoolean(), (long)0L, (int)4, null));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

