/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/agent/util/WebAddress;", "", "rawAddress", "", "(Ljava/lang/String;)V", "address", "getAddress", "()Ljava/lang/String;", "<set-?>", "protocol", "getProtocol", "equals", "", "other", "equalsWithoutProtocol", "hashCode", "", "toString", "withHttpsProtocol", "withoutProtocol", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerHttpUtils.kt\ncom/intellij/docker/agent/util/WebAddress\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class WebAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawAddress;
    @Nullable
    private String protocol;
    @NotNull
    private static final String HTTP = "http://";
    @NotNull
    private static final String HTTPS = "https://";

    public WebAddress(@NotNull String rawAddress) {
        Intrinsics.checkNotNullParameter((Object)rawAddress, (String)"rawAddress");
        this.rawAddress = rawAddress;
        this.protocol = StringsKt.startsWith$default((String)this.rawAddress, (String)HTTP, (boolean)false, (int)2, null) ? HTTP : (StringsKt.startsWith$default((String)this.rawAddress, (String)HTTPS, (boolean)false, (int)2, null) ? HTTPS : null);
    }

    @Nullable
    public final String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getAddress() {
        String string;
        block3: {
            block2: {
                string = this.protocol;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = StringsKt.removePrefix((String)this.rawAddress, (CharSequence)it);
                string = string2;
                if (string2 != null) break block3;
            }
            string = this.rawAddress;
        }
        return string;
    }

    public final boolean equalsWithoutProtocol(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return Intrinsics.areEqual((Object)this.getAddress(), (Object)new WebAddress(address).getAddress());
    }

    @NotNull
    public final WebAddress withHttpsProtocol() {
        WebAddress webAddress;
        WebAddress it = webAddress = new WebAddress(this.getAddress());
        boolean bl = false;
        it.protocol = HTTPS;
        return webAddress;
    }

    @NotNull
    public final WebAddress withoutProtocol() {
        return new WebAddress(this.getAddress());
    }

    @NotNull
    public String toString() {
        return this.protocol == null ? this.getAddress() : this.protocol + this.getAddress();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebAddress)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.protocol, (Object)((WebAddress)other).protocol)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getAddress(), (Object)((WebAddress)other).getAddress());
    }

    public int hashCode() {
        String string = this.protocol;
        int result2 = string != null ? string.hashCode() : 0;
        result2 = 31 * result2 + this.getAddress().hashCode();
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/util/WebAddress$Companion;", "", "()V", "HTTP", "", "HTTPS", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

