/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.intellij.docker.agent.impl.Architecture;
import com.intellij.docker.agent.impl.CreateContainerCmdConfigKt;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/impl/Platform;", "", "architecture", "", "os", "variant", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArchitecture", "()Ljava/lang/String;", "getOs", "getVariant", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.clouds.docker.agent"})
final class Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String architecture;
    @NotNull
    private final String os;
    @Nullable
    private final String variant;
    private static final Pattern specifierPattern = Pattern.compile("^[A-Za-z0-9_-]+$");

    public Platform(@NotNull String architecture, @NotNull String os, @Nullable String variant) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        this.architecture = architecture;
        this.os = os;
        this.variant = variant;
    }

    public /* synthetic */ Platform(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getArchitecture() {
        return this.architecture;
    }

    @NotNull
    public final String getOs() {
        return this.os;
    }

    @Nullable
    public final String getVariant() {
        return this.variant;
    }

    @NotNull
    public String toString() {
        String string;
        if (((CharSequence)this.os).length() == 0) {
            string = "unknown";
        } else {
            Object[] objectArray = new String[]{this.os, this.architecture, this.variant};
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.architecture;
    }

    @NotNull
    public final String component2() {
        return this.os;
    }

    @Nullable
    public final String component3() {
        return this.variant;
    }

    @NotNull
    public final Platform copy(@NotNull String architecture, @NotNull String os, @Nullable String variant) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return new Platform(architecture, os, variant);
    }

    public static /* synthetic */ Platform copy$default(Platform platform, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = platform.architecture;
        }
        if ((n & 2) != 0) {
            string2 = platform.os;
        }
        if ((n & 4) != 0) {
            string3 = platform.variant;
        }
        return platform.copy(string, string2, string3);
    }

    public int hashCode() {
        int result2 = this.architecture.hashCode();
        result2 = result2 * 31 + this.os.hashCode();
        result2 = result2 * 31 + (this.variant == null ? 0 : this.variant.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Platform)) {
            return false;
        }
        Platform platform = (Platform)other;
        if (!Intrinsics.areEqual((Object)this.architecture, (Object)platform.architecture)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.os, (Object)platform.os)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.variant, (Object)platform.variant);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/impl/Platform$Companion;", "", "()V", "specifierPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parse", "Lcom/intellij/docker/agent/impl/Platform;", "specifier", "", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nCreateContainerCmdConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateContainerCmdConfig.kt\ncom/intellij/docker/agent/impl/Platform$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Platform parse(@NotNull String specifier) {
            Intrinsics.checkNotNullParameter((Object)specifier, (String)"specifier");
            String[] stringArray = new String[]{"/"};
            List parts = StringsKt.split$default((CharSequence)specifier, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String part : parts) {
                if (specifierPattern.matcher(part).matches()) continue;
                throw new IllegalArgumentException(part + " is an invalid component of " + specifier + ": platform specifier component must match " + specifierPattern.pattern());
            }
            switch (parts.size()) {
                case 1: {
                    Object object = CreateContainerCmdConfigKt.access$normalizeArch((String)parts.get(0), null).getFirst();
                    Architecture.Companion companion = Architecture.Companion;
                    String p0 = (String)object;
                    boolean bl = false;
                    String string = (String)(companion.isKnown(p0) ? object : null);
                    if (string == null) {
                        throw new IllegalArgumentException(specifier + ": unknown architecture");
                    }
                    String it = string;
                    boolean bl2 = false;
                    return new Platform(it, "linux", null, 4, null);
                }
                case 2: {
                    String os = CreateContainerCmdConfigKt.access$normalizeOS((String)parts.get(0));
                    Pair pair = CreateContainerCmdConfigKt.access$normalizeArch((String)parts.get(1), null);
                    String architecture = (String)pair.component1();
                    String variant = (String)pair.component2();
                    return new Platform(architecture, os, variant);
                }
                case 3: {
                    String os = CreateContainerCmdConfigKt.access$normalizeOS((String)parts.get(0));
                    Pair pair = CreateContainerCmdConfigKt.access$normalizeArch((String)parts.get(1), (String)parts.get(2));
                    String architecture = (String)pair.component1();
                    String variant = (String)pair.component2();
                    return new Platform(architecture, os, variant);
                }
            }
            throw new IllegalArgumentException(specifier + ": cannot parse platform specifier");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

