/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Volume;
import com.intellij.docker.agent.impl.CreateContainerCmdConfig;
import java.util.Map;
import java.util.Optional;

class CreateContainerCmdInspection
extends CreateContainerCmdConfig {
    private final InspectContainerResponse myInspectContainerResponse;

    CreateContainerCmdInspection(InspectContainerResponse inspectContainerResponse) {
        this.myInspectContainerResponse = inspectContainerResponse;
        Optional.ofNullable(this.myInspectContainerResponse.getNetworkSettings()).map(NetworkSettings::getPorts).ifPresent(ports -> {
            if (!ports.getBindings().isEmpty()) {
                this.myInspectContainerResponse.getHostConfig().withPortBindings(ports);
            }
        });
    }

    private ContainerConfig getContainerConfig() {
        return this.myInspectContainerResponse.getConfig();
    }

    public HostConfig getHostConfig() {
        return this.myInspectContainerResponse.getHostConfig();
    }

    public String[] getCmd() {
        return this.getContainerConfig().getCmd();
    }

    public String[] getEntrypoint() {
        return this.getContainerConfig().getEntrypoint();
    }

    public String[] getEnv() {
        return this.getContainerConfig().getEnv();
    }

    public ExposedPort[] getExposedPorts() {
        return Optional.ofNullable(this.getContainerConfig()).map(ContainerConfig::getExposedPorts).orElse(null);
    }

    public String getHostName() {
        return this.getContainerConfig().getHostName();
    }

    public String getDomainName() {
        return this.getContainerConfig().getHostName();
    }

    public String getImage() {
        return this.getContainerConfig().getImage();
    }

    public String getMacAddress() {
        return this.getContainerConfig().getMacAddress();
    }

    public String getName() {
        return this.myInspectContainerResponse.getName();
    }

    public String[] getPortSpecs() {
        return this.getContainerConfig().getPortSpecs();
    }

    public String getUser() {
        return this.getContainerConfig().getUser();
    }

    public Volume[] getVolumes() {
        Map volumes = this.getContainerConfig().getVolumes();
        if (volumes == null) {
            return null;
        }
        return (Volume[])volumes.keySet().stream().map(Volume::new).toArray(Volume[]::new);
    }

    public String getWorkingDir() {
        return this.getContainerConfig().getWorkingDir();
    }

    public Boolean isAttachStderr() {
        return this.getContainerConfig().getAttachStderr();
    }

    public Boolean isAttachStdin() {
        return this.getContainerConfig().getAttachStdin();
    }

    public Boolean isAttachStdout() {
        return this.getContainerConfig().getAttachStdout();
    }

    public Boolean isNetworkDisabled() {
        return this.getContainerConfig().getNetworkDisabled();
    }

    public Boolean isStdInOnce() {
        return this.getContainerConfig().getStdInOnce();
    }

    public Boolean isStdinOpen() {
        return this.getContainerConfig().getStdinOpen();
    }

    public Boolean isTty() {
        return this.getContainerConfig().getTty();
    }

    public Map<String, String> getLabels() {
        return this.getContainerConfig().getLabels();
    }
}

