/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.build.ContextFolderArchive;
import com.intellij.docker.agent.build.Dockerfile;
import com.intellij.docker.agent.cli.model.DockerBuildCliParser;
import com.intellij.docker.agent.progress.ResponseItemCallbackTemplate;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerEnvVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BuildImageCmdWithCleanup {
    private final BuildImageCmd myCmd;
    private final Dockerfile myDockerfile;
    private final Runnable myCleanup;
    private TtySink myTtySink;

    public static BuildImageCmdWithCleanup forConfig(@NotNull DockerClient client, @NotNull DockerAgentDeploymentConfig config2) throws IOException, ApiTaskException {
        if (client == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(0);
        }
        if (config2 == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(1);
        }
        BuildImageCmdWithCleanup result2 = BuildImageCmdWithCleanup.doCreateForConfig(client, config2);
        result2.withTags(config2.getImageTags());
        result2.withCliOptions(config2.getCustomBuildOptions());
        result2.withBuildArgs(config2.getBuildArgs());
        return result2;
    }

    private static BuildImageCmdWithCleanup doCreateForConfig(@NotNull DockerClient client, @NotNull DockerAgentDeploymentConfig config2) throws IOException {
        if (client == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(2);
        }
        if (config2 == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(3);
        }
        File file2 = config2.getFile();
        if (config2.isFileArchive()) {
            return new BuildImageCmdWithCleanup(client, new FileInputStream(file2));
        }
        File customContextFolder = config2.getCustomContextFolder();
        if (customContextFolder == null || file2 != null && customContextFolder.equals(file2.getParentFile())) {
            Dockerfile dockerfile = new Dockerfile(file2, file2.getParentFile());
            return new BuildImageCmdWithCleanup(client, dockerfile, null);
        }
        Path copiedDockerfile = BuildImageCmdWithCleanup.findUnusedFileName(customContextFolder.toPath(), file2.getName());
        Files.copy(file2.toPath(), copiedDockerfile, new CopyOption[0]);
        Runnable cleanupCopiedDockerfile = () -> {
            try {
                Files.delete(copiedDockerfile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        Dockerfile dockerfile = new Dockerfile(copiedDockerfile.toFile(), customContextFolder);
        return new BuildImageCmdWithCleanup(client, dockerfile, cleanupCopiedDockerfile);
    }

    private BuildImageCmdWithCleanup(@NotNull DockerClient client, @NotNull InputStream tarContents) {
        if (client == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(4);
        }
        if (tarContents == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(5);
        }
        this.myTtySink = TtySink.NULL.INSTANCE;
        this.myCmd = client.buildImageCmd().withTarInputStream(tarContents);
        this.myDockerfile = null;
        this.myCleanup = null;
    }

    private BuildImageCmdWithCleanup(@NotNull DockerClient client, @NotNull Dockerfile dockerFile, @Nullable Runnable cleanup) {
        if (client == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(6);
        }
        if (dockerFile == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(7);
        }
        this.myTtySink = TtySink.NULL.INSTANCE;
        this.myCmd = client.buildImageCmd().withBaseDirectory(dockerFile.getBaseDirectory());
        this.myDockerfile = dockerFile;
        this.myCleanup = cleanup;
    }

    public void withTags(@Nullable String[] tags) {
        if (tags != null) {
            this.myCmd.withTags(new HashSet<String>(Arrays.asList(tags)));
        }
    }

    public void withBuildArgs(@Nullable DockerEnvVar[] args) {
        if (args == null) {
            return;
        }
        for (DockerEnvVar next : args) {
            String nextName;
            if (next == null || (nextName = next.getName()) == null || nextName.length() == 0) continue;
            DockerBuildCliParser.withBuildArg(this.myCmd, nextName, next.getValue());
        }
    }

    public void withCliOptions(String[] cliOptions) throws ApiTaskException {
        if (cliOptions == null) {
            return;
        }
        DockerBuildCliParser parser = new DockerBuildCliParser();
        parser.parse(this.myCmd, cliOptions);
    }

    public void withTtySink(@NotNull TtySink sink) {
        if (sink == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(8);
        }
        this.myTtySink = sink;
    }

    public void asyncBuildImage(@NotNull ResponseItemCallbackTemplate<BuildResponseItem> buildCallback2) throws ApiTaskException {
        if (buildCallback2 == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(9);
        }
        ResultCallback<BuildResponseItem> withCleanupCallback = ResponseItemCallbackTemplate.withCleanup(buildCallback2, this.myCleanup);
        if (this.myCmd.getTarInputStream() == null) {
            try {
                this.prepareTarInputStream();
            }
            catch (IOException e) {
                throw new ApiTaskException(e);
            }
        }
        this.myCmd.exec(withCleanupCallback);
    }

    private void prepareTarInputStream() throws IOException {
        ContextFolderArchive archive = this.myDockerfile.buildContextFolderArchive(this.myTtySink);
        InputStream tarInputStream = archive.createInputStream(this.myTtySink);
        this.myCmd.withTarInputStream(tarInputStream);
        this.myCmd.withDockerfilePath(archive.pathRelativeToBase(this.myDockerfile.getDockerFile().toPath()));
    }

    public void execBuildImage(@NotNull ResponseItemCallbackTemplate<BuildResponseItem> buildCallback2) throws ApiTaskException, InterruptedException {
        if (buildCallback2 == null) {
            BuildImageCmdWithCleanup.$$$reportNull$$$0(10);
        }
        try {
            this.asyncBuildImage(buildCallback2);
            buildCallback2.awaitCompletion();
        }
        catch (RuntimeException e) {
            ApiTaskException.rethrowSoftened(e);
        }
    }

    private static Path findUnusedFileName(Path folder, String namePrefix) {
        for (int i2 = 0; i2 < 10; ++i2) {
            Object suffix = i2 == 0 ? "" : (i2 < 8 ? "_" + i2 : "_" + i2 + "_" + System.nanoTime());
            Path nextResult = folder.resolve(namePrefix + (String)suffix);
            if (nextResult.toFile().exists()) continue;
            return nextResult;
        }
        Object[] files = folder.toFile().listFiles();
        if (files == null) {
            throw new IllegalStateException("Hm... No folder found: " + folder);
        }
        throw new IllegalStateException("Wow, the existing files are: " + Arrays.toString(files));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarContents";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildCallback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/impl/BuildImageCmdWithCleanup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forConfig";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateForConfig";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "withTtySink";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "asyncBuildImage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "execBuildImage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

