/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.image.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.image.search.DockerSearchContext;
import com.intellij.docker.agent.impl.DockerAgentApplicationBase;
import java.io.IOException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u0002H\u000f0\u0012H\u0000\u00a2\u0006\u0002\b\u0015J1\u0010\u0016\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\u001c\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0019H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearchContext;", "", "client", "Ljava/net/http/HttpClient;", "(Ljava/net/http/HttpClient;)V", "getClient$intellij_clouds_docker_agent", "()Ljava/net/http/HttpClient;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper$delegate", "Lkotlin/Lazy;", "executeLater", "Ljava/util/concurrent/CompletableFuture;", "T", "request", "Ljava/net/http/HttpRequest;", "Lkotlin/Function1;", "Ljava/net/http/HttpResponse;", "", "executeLater$intellij_clouds_docker_agent", "parseJSON", "json", "clazz", "Lkotlin/reflect/KClass;", "parseJSON$intellij_clouds_docker_agent", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "parseJSONResource", "resourcePath", "parseJSONResource$intellij_clouds_docker_agent", "BadResponseException", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerSearchContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerSearchContext.kt\ncom/intellij/docker/agent/image/search/DockerSearchContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class DockerSearchContext {
    @NotNull
    private final HttpClient client;
    @NotNull
    private final Lazy mapper$delegate;

    public DockerSearchContext(@NotNull HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.mapper$delegate = LazyKt.lazy((Function0)mapper.2.INSTANCE);
    }

    public /* synthetic */ DockerSearchContext(HttpClient httpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HttpClient httpClient2 = HttpClient.newHttpClient();
            Intrinsics.checkNotNullExpressionValue((Object)httpClient2, (String)"newHttpClient(...)");
            httpClient = httpClient2;
        }
        this(httpClient);
    }

    @NotNull
    public final HttpClient getClient$intellij_clouds_docker_agent() {
        return this.client;
    }

    private final ObjectMapper getMapper() {
        Lazy lazy = this.mapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    @Nullable
    public final <T> T parseJSON$intellij_clouds_docker_agent(@NotNull String json2, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.getMapper().readValue(json2, JvmClassMappingKt.getJavaClass(clazz));
    }

    @Nullable
    public final <T> T parseJSONResource$intellij_clouds_docker_agent(@NotNull String resourcePath, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            T t;
            URL uRL = DockerSearchContext.class.getResource(resourcePath);
            if (uRL != null) {
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                String it = new String(byArray, charset);
                boolean bl = false;
                t = this.parseJSON$intellij_clouds_docker_agent(it, clazz);
            } else {
                t = null;
            }
            return t;
        }
        catch (IOException e) {
            DockerAgentApplicationBase.Companion.getLOG$intellij_clouds_docker_agent().error("Can't read bundled resource: " + resourcePath, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final <T> CompletableFuture<T> executeLater$intellij_clouds_docker_agent(@NotNull HttpRequest request2, @NotNull Function1<? super HttpResponse<String>, ? extends T> mapper2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        CompletionStage completionStage = this.client.sendAsync(request2, HttpResponse.BodyHandlers.ofString()).thenApply(arg_0 -> DockerSearchContext.executeLater$lambda$1((Function1)new Function1<HttpResponse<String>, T>(mapper2){
            final /* synthetic */ Function1<HttpResponse<String>, T> $mapper;
            {
                this.$mapper = $mapper;
                super(1);
            }

            public final T invoke(HttpResponse<String> response) {
                int code = response.statusCode();
                if (code < 200 || code >= 300) {
                    HttpRequest httpRequest2 = response.request();
                    Intrinsics.checkNotNullExpressionValue((Object)httpRequest2, (String)"request(...)");
                    throw new BadResponseException(code, httpRequest2);
                }
                Intrinsics.checkNotNull(response);
                return (T)this.$mapper.invoke(response);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final Object executeLater$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    public DockerSearchContext() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearchContext$BadResponseException;", "Ljava/io/IOException;", "code", "", "request", "Ljava/net/http/HttpRequest;", "(ILjava/net/http/HttpRequest;)V", "getCode", "()I", "getRequest", "()Ljava/net/http/HttpRequest;", "intellij.clouds.docker.agent"})
    public static final class BadResponseException
    extends IOException {
        private final int code;
        @NotNull
        private final HttpRequest request;

        public BadResponseException(int code, @NotNull HttpRequest request2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Object[] objectArray = new Object[2];
            objectArray[0] = code;
            Intrinsics.checkNotNullExpressionValue((Object)request2.uri(), (String)"uri(...)");
            super(DockerAgentBundle.Companion.message("DockerSearchContext.BadResponseException.message", objectArray));
            this.code = code;
            this.request = request2;
        }

        public final int getCode() {
            return this.code;
        }

        @NotNull
        public final HttpRequest getRequest() {
            return this.request;
        }
    }
}

