/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.image.search;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.docker.agent.image.search.DockerHubRepository;
import com.intellij.docker.agent.image.search.DockerOauthHelper;
import com.intellij.docker.agent.image.search.DockerSearch;
import com.intellij.docker.agent.image.search.DockerSearchContext;
import com.intellij.docker.agent.util.InternalUtilsKt;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 $2\u00020\u0001:\u0004$%&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u00192\u0006\u0010\u001b\u001a\u00020\u0017J$\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u00192\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017J\u0014\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u0019H\u0002J\u001a\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u00192\u0006\u0010\"\u001a\u00020\u0017J\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00040\u00192\u0006\u0010\u001f\u001a\u00020\u0017R\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch;", "", "()V", "_libraryImages", "", "Lcom/intellij/docker/agent/image/search/DockerHubRepository;", "get_libraryImages$annotations", "get_libraryImages", "()Ljava/util/List;", "context", "Lcom/intellij/docker/agent/image/search/DockerSearchContext;", "libraryImages", "getLibraryImages", "libraryImages$delegate", "Lkotlin/Lazy;", "oauth", "Lcom/intellij/docker/agent/image/search/DockerOauthHelper;", "getOauth", "()Lcom/intellij/docker/agent/image/search/DockerOauthHelper;", "oauth$delegate", "isOfficialLibraryImage", "", "tag", "", "listImageTags", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/image/search/DockerSearch$Result;", "image", "imageFqn", "oauthToken", "listImagesV1", "prefix", "listLibraryImages", "listRepositoriesInNamespace", "account", "searchForCompletions", "Companion", "Result", "SearchResultV1", "TagListV2", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerSearch.kt\ncom/intellij/docker/agent/image/search/DockerSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1747#2,3:236\n1549#2:239\n1620#2,3:240\n*S KotlinDebug\n*F\n+ 1 DockerSearch.kt\ncom/intellij/docker/agent/image/search/DockerSearch\n*L\n106#1:236,3\n110#1:239\n110#1:240,3\n*E\n"})
public final class DockerSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerSearchContext context = new DockerSearchContext(null, 1, null);
    @NotNull
    private final Lazy oauth$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DockerOauthHelper>(this){
        final /* synthetic */ DockerSearch this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final DockerOauthHelper invoke() {
            return new DockerOauthHelper(null, DockerSearch.access$getContext$p(this.this$0), 1, null);
        }
    }));
    @NotNull
    private final Lazy libraryImages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<DockerHubRepository>>(this){
        final /* synthetic */ DockerSearch this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DockerHubRepository> invoke() {
            void $this$forEach$iv;
            List result2 = new ArrayList<E>();
            Object object = new String[]{"/hub/docker-hub-library.page1.json", "/hub/docker-hub-library.page2.json"};
            object = CollectionsKt.listOf((Object[])object);
            DockerSearch dockerSearch = this.this$0;
            boolean $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                DockerHubRepository.SinglePage next = (DockerHubRepository.SinglePage)DockerSearch.access$getContext$p(dockerSearch).parseJSONResource$intellij_clouds_docker_agent(it, Reflection.getOrCreateKotlinClass(DockerHubRepository.SinglePage.class));
                Object object2 = next;
                result2.addAll(object2 != null && (object2 = ((DockerHubRepository.SinglePage)object2).getResults()) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList());
            }
            return result2;
        }
    }));
    @NotNull
    private static final Lazy<Logger> LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    @NotNull
    private static final String LIBRARY = "library/";

    private final DockerOauthHelper getOauth() {
        Lazy lazy = this.oauth$delegate;
        return (DockerOauthHelper)lazy.getValue();
    }

    private final List<DockerHubRepository> getLibraryImages() {
        Lazy lazy = this.libraryImages$delegate;
        return (List)lazy.getValue();
    }

    @TestOnly
    @NotNull
    public final List<DockerHubRepository> get_libraryImages() {
        return this.getLibraryImages();
    }

    public static /* synthetic */ void get_libraryImages$annotations() {
    }

    @NotNull
    public final CompletableFuture<List<Result>> searchForCompletions(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (((CharSequence)prefix).length() == 0) {
            return this.listLibraryImages();
        }
        if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)":", (boolean)false, (int)2, null)) {
            String image = StringsKt.substringBeforeLast$default((String)prefix, (String)":", null, (int)2, null);
            return this.listImageTags(image);
        }
        if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)"/", (boolean)false, (int)2, null)) {
            String namespace = StringsKt.substringBeforeLast$default((String)prefix, (String)"/", null, (int)2, null);
            return this.listRepositoriesInNamespace(namespace);
        }
        return this.listImagesV1(prefix);
    }

    @NotNull
    public final CompletableFuture<List<Result>> listImageTags(@NotNull String image) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (((CharSequence)image).length() == 0 || new Regex("[:@$]").containsMatchIn(charSequence = (CharSequence)image)) {
            return DockerSearch.Companion.emptyListLater();
        }
        Object imageFqn = StringsKt.contains$default((CharSequence)image, (CharSequence)"/", (boolean)false, (int)2, null) ? image : LIBRARY + image;
        CompletionStage completionStage = DockerOauthHelper.obtainTokenLater$intellij_clouds_docker_agent$default(this.getOauth(), (String)imageFqn, null, 2, null).thenCompose(arg_0 -> DockerSearch.listImageTags$lambda$0((Function1)new Function1<DockerOauthHelper.OauthToken, CompletionStage<List<? extends Result>>>(this, (String)imageFqn){
            final /* synthetic */ DockerSearch this$0;
            final /* synthetic */ String $imageFqn;
            {
                this.this$0 = $receiver;
                this.$imageFqn = $imageFqn;
                super(1);
            }

            public final CompletionStage<List<Result>> invoke(DockerOauthHelper.OauthToken it) {
                return DockerSearch.access$listImageTags(this.this$0, this.$imageFqn, it.getToken());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private final CompletableFuture<List<Result>> listImageTags(String imageFqn, String oauthToken) {
        URI uri = null;
        try {
            uri = new URI("https://registry-1.docker.io/v2/" + imageFqn + "/tags/list");
        }
        catch (URISyntaxException uRISyntaxException) {
            return DockerSearch.Companion.emptyListLater();
        }
        HttpRequest request2 = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").header("Authorization", "Bearer " + oauthToken).build();
        Intrinsics.checkNotNull((Object)request2);
        return DockerSearch.Companion.onBadResponseCode(this.context.executeLater$intellij_clouds_docker_agent(request2, (Function1)new Function1<HttpResponse<String>, List<? extends Result>>(this, imageFqn){
            final /* synthetic */ DockerSearch this$0;
            final /* synthetic */ String $imageFqn;
            {
                this.this$0 = $receiver;
                this.$imageFqn = $imageFqn;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Result> invoke(@NotNull HttpResponse<String> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                DockerSearchContext dockerSearchContext = DockerSearch.access$getContext$p(this.this$0);
                String string = it.body();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
                Object object2 = (TagListV2)dockerSearchContext.parseJSON$intellij_clouds_docker_agent(string, Reflection.getOrCreateKotlinClass(TagListV2.class));
                List<String> tagList = object2 != null && (object = ((TagListV2)object2).getTags()) != null ? object : CollectionsKt.emptyList();
                object2 = tagList;
                object = this.$imageFqn;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void tag;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Result(StringsKt.removePrefix((String)object, (CharSequence)"library/") + ":" + (String)tag, null, Result.Kind.TAG));
                }
                return (List)destination$iv$iv;
            }
        }), listImageTags.3.INSTANCE);
    }

    @NotNull
    public final CompletableFuture<List<Result>> listImagesV1(@Nullable String prefix) {
        CharSequence charSequence = prefix;
        if (charSequence == null || charSequence.length() == 0) {
            return this.listLibraryImages();
        }
        if (prefix.length() < 2) {
            CompletionStage completionStage = this.listLibraryImages().thenApply(arg_0 -> DockerSearch.listImagesV1$lambda$1((Function1)new Function1<List<? extends Result>, List<? extends Result>>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final List<Result> invoke(List<Result> list) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Intrinsics.checkNotNull(list);
                    Iterable iterable = list;
                    String string = this.$prefix;
                    boolean $i$f$filter = false;
                    void var5_5 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Result it = (Result)element$iv$iv;
                        boolean bl = false;
                        if (!StringsKt.contains$default((CharSequence)it.getLookupText(), (CharSequence)string, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }
        URI url = InternalUtilsKt.addQueryParameter(InternalUtilsKt.addQueryParameter(new URI("https://registry.hub.docker.com/v1/search"), "q", prefix), "n", "100");
        return DockerSearch.Companion.onBadResponseCode(this.context.executeLater$intellij_clouds_docker_agent(DockerSearch.Companion.request(url), (Function1)new Function1<HttpResponse<String>, List<? extends Result>>(this){
            final /* synthetic */ DockerSearch this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Result> invoke(@NotNull HttpResponse<String> response) {
                void $this$mapTo$iv$iv;
                List<SearchResultV1> list;
                Intrinsics.checkNotNullParameter(response, (String)"response");
                String body = response.body();
                DockerSearchContext dockerSearchContext = DockerSearch.access$getContext$p(this.this$0);
                Intrinsics.checkNotNull((Object)body);
                SearchResultV1.SinglePage singlePage = (SearchResultV1.SinglePage)dockerSearchContext.parseJSON$intellij_clouds_docker_agent(body, Reflection.getOrCreateKotlinClass(SearchResultV1.SinglePage.class));
                List<SearchResultV1> v1Results = singlePage != null && (list = singlePage.getResults()) != null ? list : CollectionsKt.emptyList();
                Iterable $this$map$iv = v1Results;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SearchResultV1 searchResultV1 = (SearchResultV1)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toDockerSearchResult());
                }
                return (List)destination$iv$iv;
            }
        }), listImagesV1.3.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOfficialLibraryImage(@NotNull String tag) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (StringsKt.contains$default((CharSequence)tag, (CharSequence)"/", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = this.getLibraryImages();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            DockerHubRepository it = (DockerHubRepository)element$iv;
            boolean bl2 = false;
            if (it.isDefaultNamespace$intellij_clouds_docker_agent() && Intrinsics.areEqual((Object)it.getName(), (Object)tag)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<List<Result>> listLibraryImages() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getLibraryImages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerHubRepository dockerHubRepository = (DockerHubRepository)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toDockerSearchResult());
        }
        CompletableFuture<List<Result>> completableFuture = CompletableFuture.completedFuture((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<List<Result>> listRepositoriesInNamespace(@NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        if (((CharSequence)account).length() == 0) {
            return DockerSearch.Companion.emptyListLater();
        }
        String namespace = StringsKt.removeSuffix((String)account, (CharSequence)"/");
        if (StringsKt.contains$default((CharSequence)namespace, (char)'/', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)namespace, (char)'$', (boolean)false, (int)2, null)) {
            return DockerSearch.Companion.emptyListLater();
        }
        URI url = null;
        try {
            url = InternalUtilsKt.addQueryParameter(new URI("https://hub.docker.com/v2/repositories/" + namespace), "page_size", "200");
        }
        catch (URISyntaxException e) {
            return DockerSearch.Companion.emptyListLater();
        }
        return DockerSearch.Companion.onBadResponseCode(this.context.executeLater$intellij_clouds_docker_agent(DockerSearch.Companion.request(url), (Function1)new Function1<HttpResponse<String>, List<? extends Result>>(this){
            final /* synthetic */ DockerSearch this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Result> invoke(@NotNull HttpResponse<String> response) {
                void $this$mapTo$iv$iv;
                List<DockerHubRepository> list;
                Intrinsics.checkNotNullParameter(response, (String)"response");
                String body = response.body();
                DockerSearchContext dockerSearchContext = DockerSearch.access$getContext$p(this.this$0);
                Intrinsics.checkNotNull((Object)body);
                DockerHubRepository.SinglePage singlePage = (DockerHubRepository.SinglePage)dockerSearchContext.parseJSON$intellij_clouds_docker_agent(body, Reflection.getOrCreateKotlinClass(DockerHubRepository.SinglePage.class));
                List<DockerHubRepository> images = singlePage != null && (list = singlePage.getResults()) != null ? list : CollectionsKt.emptyList();
                Iterable $this$map$iv = images;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DockerHubRepository dockerHubRepository = (DockerHubRepository)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toDockerSearchResult());
                }
                return (List)destination$iv$iv;
            }
        }), listRepositoriesInNamespace.2.INSTANCE);
    }

    private static final CompletionStage listImageTags$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final List listImagesV1$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CompletableFuture access$listImageTags(DockerSearch $this, String imageFqn, String oauthToken) {
        return $this.listImageTags(imageFqn, oauthToken);
    }

    public static final /* synthetic */ DockerSearchContext access$getContext$p(DockerSearch $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\r0\f\"\u0004\b\u0000\u0010\u000eH\u0002J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\f\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$Companion;", "", "()V", "LIBRARY", "", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "emptyListLater", "Ljava/util/concurrent/CompletableFuture;", "", "T", "onBadResponseCode", "onBadResponseValue", "Lkotlin/Function0;", "request", "Ljava/net/http/HttpRequest;", "Ljava/net/URI;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> CompletableFuture<List<T>> emptyListLater() {
            CompletableFuture<List<T>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }

        private final HttpRequest request(URI $this$request) {
            HttpRequest httpRequest2 = HttpRequest.newBuilder($this$request).build();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequest2, (String)"build(...)");
            return httpRequest2;
        }

        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            return (Logger)lazy.getValue();
        }

        private final <T> CompletableFuture<T> onBadResponseCode(CompletableFuture<T> $this$onBadResponseCode, Function0<? extends T> onBadResponseValue) {
            CompletionStage completionStage = $this$onBadResponseCode.exceptionally(arg_0 -> Companion.onBadResponseCode$lambda$0(onBadResponseValue, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
            return completionStage;
        }

        private static final Object onBadResponseCode$lambda$0(Function0 $onBadResponseValue, Throwable ex) {
            Throwable unwrapped;
            Intrinsics.checkNotNullParameter((Object)$onBadResponseValue, (String)"$onBadResponseValue");
            Throwable throwable = unwrapped = ex instanceof CompletionException ? ex.getCause() : ex;
            if (unwrapped instanceof DockerSearchContext.BadResponseException) {
                Companion.getLOG().debug(ex.getMessage(), ex);
                return $onBadResponseValue.invoke();
            }
            Throwable throwable2 = ex;
            if (throwable2 instanceof Error) {
                Intrinsics.checkNotNull((Object)ex);
                throw ex;
            }
            if (throwable2 instanceof CompletionException) {
                Intrinsics.checkNotNull((Object)ex);
                throw ex;
            }
            throw new CompletionException(ex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$Result;", "", "lookupText", "", "description", "kind", "Lcom/intellij/docker/agent/image/search/DockerSearch$Result$Kind;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/docker/agent/image/search/DockerSearch$Result$Kind;)V", "getDescription", "()Ljava/lang/String;", "getKind", "()Lcom/intellij/docker/agent/image/search/DockerSearch$Result$Kind;", "getLookupText", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Kind", "intellij.clouds.docker.agent"})
    public static final class Result {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String lookupText;
        @Nullable
        private final String description;
        @NotNull
        private final Kind kind;
        @NotNull
        public static final String DEFAULT_NAMESPACE = "library";

        public Result(@NotNull String lookupText, @Nullable String description, @NotNull Kind kind) {
            Intrinsics.checkNotNullParameter((Object)lookupText, (String)"lookupText");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.lookupText = lookupText;
            this.description = description;
            this.kind = kind;
        }

        @NotNull
        public final String getLookupText() {
            return this.lookupText;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final String component1() {
            return this.lookupText;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final Kind component3() {
            return this.kind;
        }

        @NotNull
        public final Result copy(@NotNull String lookupText, @Nullable String description, @NotNull Kind kind) {
            Intrinsics.checkNotNullParameter((Object)lookupText, (String)"lookupText");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            return new Result(lookupText, description, kind);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, String string2, Kind kind, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.lookupText;
            }
            if ((n & 2) != 0) {
                string2 = result2.description;
            }
            if ((n & 4) != 0) {
                kind = result2.kind;
            }
            return result2.copy(string, string2, kind);
        }

        @NotNull
        public String toString() {
            return "Result(lookupText=" + this.lookupText + ", description=" + this.description + ", kind=" + this.kind + ")";
        }

        public int hashCode() {
            int result2 = this.lookupText.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + this.kind.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.lookupText, (Object)result2.lookupText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)result2.description)) {
                return false;
            }
            return this.kind == result2.kind;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$Result$Companion;", "", "()V", "DEFAULT_NAMESPACE", "", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$Result$Kind;", "", "(Ljava/lang/String;I)V", "NAMESPACE", "IMAGE", "TAG", "intellij.clouds.docker.agent"})
        public static final class Kind
        extends Enum<Kind> {
            public static final /* enum */ Kind NAMESPACE = new Kind();
            public static final /* enum */ Kind IMAGE = new Kind();
            public static final /* enum */ Kind TAG = new Kind();
            private static final /* synthetic */ Kind[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Kind[] values() {
                return (Kind[])$VALUES.clone();
            }

            public static Kind valueOf(String value) {
                return Enum.valueOf(Kind.class, value);
            }

            @NotNull
            public static EnumEntries<Kind> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = kindArray = new Kind[]{Kind.NAMESPACE, Kind.IMAGE, Kind.TAG};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR \u0010\u0010\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$SearchResultV1;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "isOfficial", "", "()Z", "setOfficial", "(Z)V", "isTrusted", "setTrusted", "name", "getName", "setName", "starCount", "", "getStarCount", "()I", "setStarCount", "(I)V", "toDockerSearchResult", "Lcom/intellij/docker/agent/image/search/DockerSearch$Result;", "SinglePage", "intellij.clouds.docker.agent"})
    private static final class SearchResultV1 {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="star_count")
        private int starCount;
        @JsonProperty(value="is_official")
        private boolean isOfficial;
        @JsonProperty(value="is_trusted")
        private boolean isTrusted;
        @JsonProperty(value="description")
        @Nullable
        private String description;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        public final int getStarCount() {
            return this.starCount;
        }

        public final void setStarCount(int n) {
            this.starCount = n;
        }

        public final boolean isOfficial() {
            return this.isOfficial;
        }

        public final void setOfficial(boolean bl) {
            this.isOfficial = bl;
        }

        public final boolean isTrusted() {
            return this.isTrusted;
        }

        public final void setTrusted(boolean bl) {
            this.isTrusted = bl;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        @NotNull
        public final Result toDockerSearchResult() {
            String string = this.name;
            if (string == null) {
                string = "";
            }
            return new Result(string, this.description, Result.Kind.IMAGE);
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR \u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$SearchResultV1$SinglePage;", "", "()V", "page", "", "getPage", "()I", "setPage", "(I)V", "pageSize", "getPageSize", "setPageSize", "pagesCount", "getPagesCount", "setPagesCount", "query", "", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "results", "", "Lcom/intellij/docker/agent/image/search/DockerSearch$SearchResultV1;", "getResults", "()Ljava/util/List;", "setResults", "(Ljava/util/List;)V", "totalCount", "getTotalCount", "setTotalCount", "intellij.clouds.docker.agent"})
        public static final class SinglePage {
            @JsonProperty(value="num_pages")
            private int pagesCount;
            @JsonProperty(value="num_results")
            private int totalCount;
            @JsonProperty(value="page")
            private int page;
            @JsonProperty(value="page_size")
            private int pageSize;
            @JsonProperty(value="query")
            @Nullable
            private String query;
            @JsonProperty(value="results")
            @Nullable
            private List<SearchResultV1> results;

            public final int getPagesCount() {
                return this.pagesCount;
            }

            public final void setPagesCount(int n) {
                this.pagesCount = n;
            }

            public final int getTotalCount() {
                return this.totalCount;
            }

            public final void setTotalCount(int n) {
                this.totalCount = n;
            }

            public final int getPage() {
                return this.page;
            }

            public final void setPage(int n) {
                this.page = n;
            }

            public final int getPageSize() {
                return this.pageSize;
            }

            public final void setPageSize(int n) {
                this.pageSize = n;
            }

            @Nullable
            public final String getQuery() {
                return this.query;
            }

            public final void setQuery(@Nullable String string) {
                this.query = string;
            }

            @Nullable
            public final List<SearchResultV1> getResults() {
                return this.results;
            }

            public final void setResults(@Nullable List<SearchResultV1> list) {
                this.results = list;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$TagListV2;", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "tags", "", "getTags", "()Ljava/util/List;", "setTags", "(Ljava/util/List;)V", "intellij.clouds.docker.agent"})
    private static final class TagListV2 {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="tags")
        @Nullable
        private List<String> tags;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final List<String> getTags() {
            return this.tags;
        }

        public final void setTags(@Nullable List<String> list) {
            this.tags = list;
        }
    }
}

