/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.cli.AsyncCliProcess;
import com.intellij.docker.agent.cli.Cli;
import com.intellij.docker.agent.devcontainers.DevcontainerJsonModel;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerDataExchangeProxy;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeature;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureBuilder;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureSet;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeaturesKt;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.impl.DockerDefaultImageBuilder;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.future.FutureKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J!\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\tH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\b\u0010$\u001a\u00020\u001aH\u0002J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder;", "", "contextDir", "Ljava/io/File;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "agent", "Lcom/intellij/docker/agent/DockerAgent;", "model", "Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel;", "(Ljava/io/File;Lkotlin/coroutines/CoroutineContext;Lcom/intellij/docker/agent/DockerAgent;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel;)V", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "(Ljava/io/File;Lcom/intellij/docker/agent/DockerAgent;Lcom/intellij/docker/agent/devcontainers/DevcontainerJsonModel;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;)V", "substitutedDockerFile", "Ljava/nio/file/Path;", "tempPath", "cleanup", "", "createBaseDockerfile", "createBaseImageFiles", "createFeatureFiles", "f", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "createImage", "imageName", "", "dockerFile", "(Ljava/lang/String;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createImages", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createInstallScriptWrapper", "destPath", "createSubstitutedDockerFile", "baseImageName", "getBaseImageName", "getExtendedDockerContent", "getHash", "s", "getUserImageName", "userDockerfile", "pullImage", "readFeatureConfigsFromLabel", "", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature$FeatureConfig;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDevcontainerFeatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatureBuilder.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,204:1\n50#2:205\n43#2:206\n1855#3,2:207\n1855#3,2:209\n1855#3:213\n1856#3:218\n13309#4,2:211\n125#5:214\n152#5,3:215\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatureBuilder.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder\n*L\n89#1:205\n89#1:206\n99#1:207,2\n129#1:209,2\n177#1:213\n177#1:218\n163#1:211,2\n181#1:214\n181#1:215,3\n*E\n"})
public final class DevcontainerFeatureBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File contextDir;
    @NotNull
    private final DockerAgent agent;
    @NotNull
    private final DevcontainerJsonModel model;
    @NotNull
    private final DevcontainerDataExchangeProxy proxy;
    @Nullable
    private Path tempPath;
    @Nullable
    private Path substitutedDockerFile;
    @NotNull
    public static final String WRAPPER_SCRIPT = "devcontainer-feature-setup.sh";
    @NotNull
    public static final String FEATURE_SETUP_DIR = "/tmp/jb-devcontainer-features";
    @NotNull
    public static final String BASE_DOCKERFILE = "Dockerfile.features";
    @NotNull
    public static final String BASE_IMAGE_PREFIX = "jb-devcontainer-features";
    @NotNull
    public static final String USER_IMAGE_PREFIX = "user-dockerfile-image";
    @NotNull
    private static final String METADATA_LABEL = "devcontainer.metadata";

    public DevcontainerFeatureBuilder(@NotNull File contextDir, @NotNull DockerAgent agent, @NotNull DevcontainerJsonModel model, @NotNull DevcontainerDataExchangeProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.contextDir = contextDir;
        this.agent = agent;
        this.model = model;
        this.proxy = proxy;
    }

    public DevcontainerFeatureBuilder(@NotNull File contextDir, @NotNull CoroutineContext coroutineContext, @NotNull DockerAgent agent, @NotNull DevcontainerJsonModel model) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this(contextDir, agent, model, new DevcontainerDataExchangeProxy.RemoteProxy(DevcontainerDataExchangeProxy.Companion.getCurrOutputHandler(coroutineContext)));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createImages(@NotNull Continuation<? super DevcontainerJsonModel> var1_1) {
        block15: {
            if (!(var1_1 instanceof createImages.1)) ** GOTO lbl-1000
            var9_2 = var1_1;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ DevcontainerFeatureBuilder this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.createImages((Continuation<? super DevcontainerJsonModel>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.model.getFeatureSet() == null || this.model.getFeatureSet().getFeatures().isEmpty()) {
                        return this.model;
                    }
                    this.createBaseImageFiles();
                    var3_5 = new String[]{"Dockerfile.features"};
                    baseDockerFile = Path.of(String.valueOf(this.tempPath), var3_5).toFile();
                    v0 = this.getBaseImageName();
                    Intrinsics.checkNotNull((Object)baseDockerFile);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v1 = this.createImage(v0, baseDockerFile, (Continuation<? super Unit>)$continuation);
                    if (v1 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    this = (DevcontainerFeatureBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    userImage = this.model.getFeatureSet().getUserImage();
                    userDockerFile = this.model.getFeatureSet().getUserDockerFile();
                    if (userImage == null) break;
                    this.createSubstitutedDockerFile(userImage);
                    this.pullImage(userImage);
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v2 = this.readFeatureConfigsFromLabel(userImage, (Continuation<? super List<DevcontainerFeature.FeatureConfig>>)$continuation);
                    if (v2 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl44
                }
                case 2: {
                    this = (DevcontainerFeatureBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl44:
                    // 2 sources

                    labelConfigs = (List)v2;
                    return DevcontainerFeaturesKt.mergeConfigs(this.model, labelConfigs);
                }
            }
            if (userDockerFile == null) break block15;
            var6_10 = new String[]{userDockerFile};
            path = Path.of(this.contextDir.getPath(), (String[])var6_10);
            Intrinsics.checkNotNull((Object)path);
            v3 = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(v3, v3.length))) {
                var6_10 = new Object[]{userDockerFile};
                this.proxy.error(DockerAgentBundle.Companion.message("devcontainer.features.user.docker.file.is.not.found", var6_10));
                return this.model;
            }
            userImageName = this.getUserImageName(path);
            var7_11 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)var7_11, (String)"toFile(...)");
            $continuation.L$0 = this;
            $continuation.L$1 = userImageName;
            $continuation.label = 3;
            v4 = this.createImage(userImageName, var7_11, (Continuation<? super Unit>)$continuation);
            if (v4 == var10_4) {
                return var10_4;
            }
            ** GOTO lbl70
            {
                case 3: {
                    userImageName = (String)$continuation.L$1;
                    this = (DevcontainerFeatureBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl70:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = userImageName;
                    $continuation.label = 4;
                    v5 = this.readFeatureConfigsFromLabel(userImageName, (Continuation<? super List<DevcontainerFeature.FeatureConfig>>)$continuation);
                    if (v5 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl82
                }
                case 4: {
                    userImageName = (String)$continuation.L$1;
                    this = (DevcontainerFeatureBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl82:
                    // 2 sources

                    labelConfigs = (List)v5;
                    this.createSubstitutedDockerFile(userImageName);
                    return DevcontainerFeaturesKt.mergeConfigs(this.model, labelConfigs);
                }
            }
        }
        this.proxy.error(DockerAgentBundle.Companion.message("devcontainers.feature.missing.image.dockerfile.options", new Object[0]));
        return this.model;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void pullImage(String imageName) {
        Object[] objectArray = new String[]{"pull", imageName};
        AsyncCliProcess.await$default(Cli.execAsyncWithResult$default(this.agent.getCliFacade().docker(), CollectionsKt.mutableListOf((Object[])objectArray), null, (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DevcontainerFeatureBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DevcontainerFeatureBuilder.access$getProxy$p(this.this$0).error(it);
            }
        }, (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DevcontainerFeatureBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DevcontainerFeatureBuilder.access$getProxy$p(this.this$0).message(it);
            }
        }, null, null, null, null, 242, null), 0L, null, 3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object readFeatureConfigsFromLabel(String var1_1, Continuation<? super List<DevcontainerFeature.FeatureConfig>> var2_2) {
        if (!(var2_2 instanceof readFeatureConfigsFromLabel.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ DevcontainerFeatureBuilder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DevcontainerFeatureBuilder.access$readFeatureConfigsFromLabel(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = FutureKt.await((CompletionStage)this.agent.getCliFacade().docker().inspect("image", (String)imageName, "index .Config.Labels \"devcontainer.metadata\""), (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                labelData = (String)v0;
                Intrinsics.checkNotNull((Object)labelData);
                if (StringsKt.isBlank((CharSequence)labelData)) {
                    return CollectionsKt.emptyList();
                }
                var4_7 = DevcontainerFeature.Companion.getJsonMapper();
                content$iv = labelData;
                $i$f$readValue = false;
                $i$f$jacksonTypeRef = false;
                return $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<List<? extends DevcontainerFeature.FeatureConfig>>(){});
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void cleanup() {
        block0: {
            Path path = this.substitutedDockerFile;
            if (path == null) break block0;
            Files.deleteIfExists(path);
        }
    }

    private final String getBaseImageName() {
        StringBuilder content2 = new StringBuilder();
        content2.append(this.contextDir.getPath());
        Object object = this.model.getFeatureSet();
        if (object != null && (object = ((DevcontainerFeatureSet)object).getFeatures()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DevcontainerFeature it = (DevcontainerFeature)element$iv;
                boolean bl = false;
                content2.append(it.getRef());
            }
        }
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "jb-devcontainer-features-" + this.getHash(string);
    }

    private final String getUserImageName(Path userDockerfile) {
        String content2 = Files.readString(userDockerfile);
        Intrinsics.checkNotNull((Object)content2);
        return "user-dockerfile-image-" + this.getHash(content2);
    }

    private final String getHash(String s) {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] hash = messageDigest.digest(byArray);
        String string2 = new BigInteger(1, hash).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final Object createImage(String imageName, File dockerFile, Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{imageName};
        this.proxy.message(DockerAgentBundle.Companion.message("devcontainers.feature.creating.base.image", objectArray));
        DockerAgentDeploymentConfig config2 = new DockerAgentDeploymentConfig(imageName, dockerFile){
            final /* synthetic */ String $imageName;
            final /* synthetic */ File $dockerFile;
            {
                this.$imageName = $imageName;
                this.$dockerFile = $dockerFile;
            }

            @NotNull
            public String[] getImageTags() {
                String[] stringArray = new String[]{this.$imageName};
                return stringArray;
            }

            @NotNull
            public File getFile() {
                return this.$dockerFile;
            }

            public boolean isBuildImageOnly() {
                return true;
            }
        };
        DockerTerminalPipe.WithTty withTty = DevcontainerDataExchangeProxy.Companion.getCurrPipe($completion.getContext());
        Intrinsics.checkNotNull((Object)withTty);
        DockerTerminalPipe.WithTty pipe = withTty;
        DockerDefaultImageBuilder imageBuilder = new DockerDefaultImageBuilder(pipe.asTtySink(), this.agent.getDockerClient(), config2, this.agent);
        Object object = imageBuilder.build($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void createBaseImageFiles() {
        this.tempPath = Files.createTempDirectory("devcontainer-features-image-temp-", new FileAttribute[0]);
        Object object = this.model.getFeatureSet();
        if (object != null && (object = ((DevcontainerFeatureSet)object).getFeatures()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DevcontainerFeature it = (DevcontainerFeature)element$iv;
                boolean bl = false;
                this.createFeatureFiles(it);
            }
        }
        this.createBaseDockerfile();
    }

    private final void createFeatureFiles(DevcontainerFeature f) {
        String cachePath = f.getCachePath$intellij_clouds_docker_agent();
        if (cachePath == null) {
            Object[] objectArray = new Object[]{f.getRef().getId()};
            this.proxy.error(DockerAgentBundle.Companion.message("devcontainers.feature.installation.data.not.found", objectArray));
            return;
        }
        String[] stringArray = new String[]{f.getFeatureFolderName()};
        Path destPath = Path.of(String.valueOf(this.tempPath), stringArray);
        FileUtils.forceMkdir((File)destPath.toFile());
        Object[] objectArray = new String[]{"install.sh"};
        Path installScript = Path.of(cachePath.toString(), (String[])objectArray);
        if (!Files.exists(installScript, new LinkOption[0])) {
            objectArray = new Object[]{f.getRef().getId()};
            this.proxy.error(DockerAgentBundle.Companion.message("devcontainers.feature.install.script.is.missing", objectArray));
            return;
        }
        objectArray = new String[]{"install.sh"};
        Files.copy(installScript, Path.of(((Object)destPath).toString(), (String[])objectArray), new CopyOption[0]);
        Intrinsics.checkNotNull((Object)destPath);
        this.createInstallScriptWrapper(f, destPath);
    }

    private final void createBaseDockerfile() {
        StringBuilder content2 = new StringBuilder();
        content2.append("FROM scratch\nCOPY . /tmp/jb-devcontainer-features");
        Object object = new String[]{BASE_DOCKERFILE};
        Path path = Path.of(String.valueOf(this.tempPath), (String[])object);
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        object = string;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final void createInstallScriptWrapper(DevcontainerFeature f, Path destPath) {
        String[] stringArray = new String[]{WRAPPER_SCRIPT};
        Path scriptPath = Path.of(((Object)destPath).toString(), stringArray);
        StringBuilder scriptContent = new StringBuilder();
        scriptContent.append("echo Installing " + f.getConfig().getId() + " feature...\n");
        DockerEnvVar[] dockerEnvVarArray = f.getFeatureEnv();
        if (dockerEnvVarArray != null) {
            DockerEnvVar[] $this$forEach$iv = dockerEnvVarArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                DockerEnvVar element$iv;
                DockerEnvVar it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                scriptContent.append("export " + it.getName() + "=" + it.getValue() + "\n");
            }
        }
        scriptContent.append("chmod +x ./install.sh\n").append("./install.sh");
        String string = scriptContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(scriptPath, byArray, new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String getExtendedDockerContent() {
        StringBuilder content2 = new StringBuilder();
        content2.append("COPY --from=" + this.getBaseImageName() + " /tmp/jb-devcontainer-features /tmp/jb-devcontainer-features/\n");
        Object object = this.model.getFeatureSet();
        if (object != null && (object = ((DevcontainerFeatureSet)object).getFeatures()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DevcontainerFeature f = (DevcontainerFeature)element$iv;
                boolean bl = false;
                String featurePath = "/tmp/jb-devcontainer-features/" + f.getFeatureFolderName();
                content2.append('\n');
                Object object2 = f.getConfig().getContainerEnv();
                if (object2 != null) {
                    void $this$mapTo$iv$iv;
                    Map<String, String> $this$map$iv = object2;
                    boolean $i$f$map = false;
                    Map<String, String> map = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void env;
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add("ENV " + env.getKey() + "=" + env.getValue());
                    }
                    object2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    if (object2 != null) {
                        Map<String, String> it = object2;
                        boolean bl3 = false;
                        content2.append((String)((Object)it));
                        content2.append('\n');
                    }
                }
                content2.append(StringsKt.trimIndent((String)("\n        RUN chmod -R 0755 " + featurePath + " \\\n        && cd " + featurePath + " \\\n        && chmod +x ./devcontainer-feature-setup.sh \\\n        && ./devcontainer-feature-setup.sh\n      ")));
            }
        }
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void createSubstitutedDockerFile(String baseImageName) {
        String[] stringArray = new String[]{".features.temp.dockerfile"};
        Path path = Path.of(this.contextDir.getPath(), stringArray);
        StringBuilder content2 = new StringBuilder();
        content2.append("FROM " + baseImageName + "\n");
        content2.append(this.getExtendedDockerContent());
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
        this.substitutedDockerFile = path;
    }

    public static final /* synthetic */ DevcontainerDataExchangeProxy access$getProxy$p(DevcontainerFeatureBuilder $this) {
        return $this.proxy;
    }

    public static final /* synthetic */ Object access$readFeatureConfigsFromLabel(DevcontainerFeatureBuilder $this, String imageName, Continuation $completion) {
        return $this.readFeatureConfigsFromLabel(imageName, (Continuation<? super List<DevcontainerFeature.FeatureConfig>>)$completion);
    }

    public static final /* synthetic */ Object access$createImage(DevcontainerFeatureBuilder $this, String imageName, File dockerFile, Continuation $completion) {
        return $this.createImage(imageName, dockerFile, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureBuilder$Companion;", "", "()V", "BASE_DOCKERFILE", "", "BASE_IMAGE_PREFIX", "FEATURE_SETUP_DIR", "METADATA_LABEL", "USER_IMAGE_PREFIX", "WRAPPER_SCRIPT", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

