/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.vim.frontend;

import andel.editor.EditorScrollKind;
import andel.text.LineNumberKt;
import andel.text.Text;
import andel.text.TextLine;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimScrollGroup;
import fleet.plugins.vim.frontend.FleetMutableVimEditor;
import fleet.plugins.vim.frontend.FleetMutableVimEditorKt;
import fleet.plugins.vim.frontend.FleetVimKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import noria.ui.components.editor.IEditorViewport;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\tJ\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\t\u00a8\u0006\u001e"}, d2={"Lfleet/plugins/vim/frontend/FleetVimScrollGroup;", "Lcom/maddyhome/idea/vim/api/VimScrollGroup;", "<init>", "()V", "scrollCurrentLineToDisplayBottom", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "rawCount", "", "start", "scrollCurrentLineToDisplayMiddle", "scrollCaretIntoView", "", "scrollHalfPage", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "down", "scrollLines", "lines", "scrollCurrentLineToDisplayTop", "scrollFullPage", "pages", "scrollColumns", "columns", "scrollCaretColumnToDisplayLeftEdge", "vimEditor", "scrollCaretColumnToDisplayRightEdge", "scrollFullPageDown", "scrollFullPageUp", "fleet.plugins.vim.frontend"})
public final class FleetVimScrollGroup
implements VimScrollGroup {
    public boolean scrollCurrentLineToDisplayBottom(@NotNull VimEditor editor, int rawCount, boolean start) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((FleetMutableVimEditor)editor).getEditorViewport() == null) {
            return false;
        }
        if (((FleetMutableVimEditor)editor).getMonospacedFontMetrics() == null) {
            return false;
        }
        IEditorViewport editorViewport = ((FleetMutableVimEditor)editor).getEditorViewport();
        return FleetMutableVimEditorKt.withTargetLineToScrollTo((FleetMutableVimEditor)editor, rawCount, (Function2<? super FleetMutableVimEditor, ? super TextLine, Boolean>)((Function2)new Function2<FleetMutableVimEditor, TextLine, Boolean>(editor, editorViewport, rawCount){
            final /* synthetic */ VimEditor $editor;
            final /* synthetic */ IEditorViewport $editorViewport;
            final /* synthetic */ int $rawCount;
            {
                this.$editor = $editor;
                this.$editorViewport = $editorViewport;
                this.$rawCount = $rawCount;
                super(2);
            }

            public final Boolean invoke(FleetMutableVimEditor $this$withTargetLineToScrollTo, TextLine line) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withTargetLineToScrollTo), (String)"$this$withTargetLineToScrollTo");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Text text = ((FleetMutableVimEditor)this.$editor).getText();
                long scrollLineNumber = line.getLineNumber() - (this.$editorViewport.linesCount() - (long)3);
                FleetMutableVimEditorKt.scrollTo$default($this$withTargetLineToScrollTo, TextViewExtKt.textLine-g54jA0s$default((TextView)text.view(), (int)LineNumberKt.getLine((long)RangesKt.coerceIn((long)scrollLineNumber, (long)0L, (long)((long)text.getLineCount-bcnjDHU() - 1L))), (boolean)false, (int)2, null), null, false, 6, null);
                if (this.$rawCount != 0) {
                    FleetMutableVimEditorKt.moveCaretToLine$default($this$withTargetLineToScrollTo, line, false, 2, null);
                }
                return true;
            }
        }));
    }

    public boolean scrollCurrentLineToDisplayMiddle(@NotNull VimEditor editor, int rawCount, boolean start) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return FleetMutableVimEditorKt.withTargetLineToScrollTo((FleetMutableVimEditor)editor, rawCount, (Function2<? super FleetMutableVimEditor, ? super TextLine, Boolean>)((Function2)new Function2<FleetMutableVimEditor, TextLine, Boolean>(rawCount){
            final /* synthetic */ int $rawCount;
            {
                this.$rawCount = $rawCount;
                super(2);
            }

            public final Boolean invoke(FleetMutableVimEditor $this$withTargetLineToScrollTo, TextLine line) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withTargetLineToScrollTo), (String)"$this$withTargetLineToScrollTo");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                FleetMutableVimEditorKt.scrollTo$default($this$withTargetLineToScrollTo, line, (EditorScrollKind)EditorScrollKind.Center.INSTANCE, false, 4, null);
                if (this.$rawCount != 0) {
                    FleetMutableVimEditorKt.moveCaretToLine$default($this$withTargetLineToScrollTo, line, false, 2, null);
                }
                return true;
            }
        }));
    }

    public void scrollCaretIntoView(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        FleetMutableVimEditor cfr_ignored_0 = (FleetMutableVimEditor)editor;
        int caretLine = ((FleetMutableVimEditor)editor).primaryCaret().getLine();
        TextLine textLine = TextViewExtKt.textLine-g54jA0s$default((TextView)((FleetMutableVimEditor)editor).getText().view(), (int)LineNumberKt.getLine((int)caretLine), (boolean)false, (int)2, null);
        FleetMutableVimEditorKt.scrollTo$default((FleetMutableVimEditor)editor, textLine, (EditorScrollKind)new EditorScrollKind.Padded(3, 3), false, 4, null);
    }

    public boolean scrollHalfPage(@NotNull VimEditor editor, @NotNull VimCaret caret2, int rawCount, boolean down) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret2, (String)"caret");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((FleetMutableVimEditor)editor).getEditorViewport() == null) {
            return false;
        }
        if (((FleetMutableVimEditor)editor).getMonospacedFontMetrics() == null) {
            return false;
        }
        int count = RangesKt.coerceAtLeast((int)rawCount, (int)1);
        int viewportLinesCount = (int)((FleetMutableVimEditor)editor).getEditorViewport().linesCount();
        int scrollLineCount = viewportLinesCount / 2 * count;
        FleetMutableVimEditorKt.scrollRelative((FleetMutableVimEditor)editor, scrollLineCount, down);
        return true;
    }

    public boolean scrollLines(@NotNull VimEditor editor, int lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FleetMutableVimEditorKt.scrollRelative((FleetMutableVimEditor)editor, Math.abs(lines), lines > 0);
        return true;
    }

    public boolean scrollCurrentLineToDisplayTop(@NotNull VimEditor editor, int rawCount, boolean start) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return FleetMutableVimEditorKt.withTargetLineToScrollTo((FleetMutableVimEditor)editor, rawCount, (Function2<? super FleetMutableVimEditor, ? super TextLine, Boolean>)((Function2)new Function2<FleetMutableVimEditor, TextLine, Boolean>(rawCount){
            final /* synthetic */ int $rawCount;
            {
                this.$rawCount = $rawCount;
                super(2);
            }

            public final Boolean invoke(FleetMutableVimEditor $this$withTargetLineToScrollTo, TextLine line) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withTargetLineToScrollTo), (String)"$this$withTargetLineToScrollTo");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                FleetMutableVimEditorKt.scrollTo$default($this$withTargetLineToScrollTo, line, null, false, 6, null);
                if (this.$rawCount != 0) {
                    FleetMutableVimEditorKt.moveCaretToLine$default($this$withTargetLineToScrollTo, line, false, 2, null);
                }
                return true;
            }
        }));
    }

    public boolean scrollFullPage(@NotNull VimEditor editor, @NotNull VimCaret caret2, int pages) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret2, (String)"caret");
        boolean bl2 = bl = pages != 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return pages > 0 ? this.scrollFullPageDown(editor, caret2, pages) : this.scrollFullPageUp(editor, caret2, -pages);
    }

    public boolean scrollColumns(@NotNull VimEditor editor, int columns) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return FleetVimKt.TODOBOOL();
    }

    public boolean scrollCaretColumnToDisplayLeftEdge(@NotNull VimEditor vimEditor) {
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"vimEditor");
        return FleetVimKt.TODOBOOL();
    }

    public boolean scrollCaretColumnToDisplayRightEdge(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return FleetVimKt.TODOBOOL();
    }

    public final boolean scrollFullPageDown(@NotNull VimEditor editor, @NotNull VimCaret caret2, int pages) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret2, (String)"caret");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((FleetMutableVimEditor)editor).getEditorViewport() == null) {
            return false;
        }
        int linesCount = (int)((FleetMutableVimEditor)editor).getEditorViewport().linesCount() - 1;
        FleetMutableVimEditorKt.scrollRelative((FleetMutableVimEditor)editor, pages * linesCount, true);
        return true;
    }

    public final boolean scrollFullPageUp(@NotNull VimEditor editor, @NotNull VimCaret caret2, int pages) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret2, (String)"caret");
        if (!(editor instanceof FleetMutableVimEditor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((FleetMutableVimEditor)editor).getEditorViewport() == null) {
            return false;
        }
        int linesCount = (int)((FleetMutableVimEditor)editor).getEditorViewport().linesCount() - 1;
        FleetMutableVimEditorKt.scrollRelative((FleetMutableVimEditor)editor, pages * linesCount, false);
        return true;
    }
}

