/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.opentelemetry.exporters.ijperf;

import fleet.reporting.opentelemetry.exporters.ijperf.IJPerfRecord;
import fleet.reporting.opentelemetry.exporters.ijperf.IJPerfReport;
import fleet.reporting.shared.config.TracingConfigProperties;
import fleet.tracing.runtime.SpanKt;
import fleet.util.channels.ChannelExtKt;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016R&\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lfleet/reporting/opentelemetry/exporters/ijperf/IJPerfSpanReporter;", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "dockVersion", "", "outputPath", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "channels", "Lkotlin/Pair;", "Lkotlinx/coroutines/channels/SendChannel;", "Lfleet/reporting/opentelemetry/exporters/ijperf/IJPerfRecord;", "Lkotlinx/coroutines/channels/ReceiveChannel;", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "flush", "shutdown", "fleet.reporting.opentelemetry"})
@SourceDebugExtension(value={"SMAP\nIJPerfTracing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJPerfTracing.kt\nfleet/reporting/opentelemetry/exporters/ijperf/IJPerfSpanReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1855#2,2:80\n1549#2:83\n1620#2,3:84\n1#3:82\n*S KotlinDebug\n*F\n+ 1 IJPerfTracing.kt\nfleet/reporting/opentelemetry/exporters/ijperf/IJPerfSpanReporter\n*L\n24#1:80,2\n69#1:83\n69#1:84,3\n*E\n"})
public final class IJPerfSpanReporter
implements SpanExporter {
    @NotNull
    private final String dockVersion;
    @NotNull
    private final Path outputPath;
    @NotNull
    private final Pair<SendChannel<IJPerfRecord>, ReceiveChannel<IJPerfRecord>> channels;

    public IJPerfSpanReporter(@NotNull String dockVersion, @NotNull Path outputPath) {
        Intrinsics.checkNotNullParameter((Object)dockVersion, (String)"dockVersion");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.dockVersion = dockVersion;
        this.outputPath = outputPath;
        this.channels = ChannelExtKt.channels$default((int)Integer.MAX_VALUE, null, (int)2, null);
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<SpanData> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        String prefix = TracingConfigProperties.INSTANCE.getIjPerfSpanPrefix();
        Iterable $this$forEach$iv = spans;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpanData span = (SpanData)element$iv;
            boolean bl = false;
            CharSequence charSequence = prefix;
            String spanName = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? prefix + "." + span.getName() : span.getName();
            SendChannel sendChannel = (SendChannel)this.channels.getFirst();
            Intrinsics.checkNotNull((Object)spanName);
            long l = span.getStartEpochNanos();
            long l2 = (span.getEndEpochNanos() - span.getStartEpochNanos()) / (long)1000000;
            Object object = (Long)span.getAttributes().get(SpanKt.getTHREAD_ID_KEY());
            if (object == null || (object = String.valueOf(object)) == null) {
                object = "<no thread info>";
            }
            sendChannel.trySend-JP2dKIU((Object)new IJPerfRecord(spanName, l, l2, (String)object));
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode flush() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableResultCode shutdown() {
        Collection<IJPerfRecord> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String osName = System.getProperty("os.name");
        String string = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String osVersion = string2;
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vm.vendor", "Unknown");
        String rtVersion = System.getProperty("java.runtime.version");
        String javaRuntimeVersion = Character.isDigit(rtVersion.charAt(0)) ? rtVersion : javaVersion;
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.channels.getFirst()), null, (int)1, null);
        List items2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends IJPerfRecord>>, Object>(this, null){
            int label;
            final /* synthetic */ IJPerfSpanReporter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChannelsKt.toList((ReceiveChannel)((ReceiveChannel)IJPerfSpanReporter.access$getChannels$p(this.this$0).getSecond()), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<IJPerfRecord>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        OpenOption[] openOptionArray = ((Iterable)items2).iterator();
        if (!openOptionArray.hasNext()) {
            throw new NoSuchElementException();
        }
        IJPerfRecord it22 = (IJPerfRecord)openOptionArray.next();
        boolean bl = false;
        long it22 = it22.getStart();
        while (openOptionArray.hasNext()) {
            IJPerfRecord it32 = (IJPerfRecord)openOptionArray.next();
            $i$a$-minOf-IJPerfSpanReporter$shutdown$startTimeNs$1 = false;
            long it32 = it32.getStart();
            if (it22 <= it32) continue;
            it22 = it32;
        }
        long startTimeNs = it22;
        String string3 = ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String string4 = osName + " " + osVersion;
        String string5 = javaVendor + " " + javaVersion + " " + javaRuntimeVersion;
        String string6 = ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        openOptionArray = items2;
        long l = (System.nanoTime() - startTimeNs) / (long)1000000;
        List list = CollectionsKt.emptyList();
        IJPerfReport.Stats stats = new IJPerfReport.Stats(0, new IJPerfReport.Stat(0, 0, 0), new IJPerfReport.Stat(0, 0, 0));
        String string7 = string6;
        String string8 = this.dockVersion;
        String string9 = string5;
        String string10 = string4;
        String string11 = "Fleet";
        String string12 = string3;
        String string13 = "36";
        boolean $i$f$map = false;
        void it32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IJPerfRecord iJPerfRecord = (IJPerfRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(IJPerfRecord.copy$default((IJPerfRecord)it, null, (it.getStart() - startTimeNs) / (long)1000000, 0L, null, 13, null));
        }
        Collection<IJPerfRecord> collection2 = collection = (List)destination$iv$iv;
        long l2 = l;
        List list2 = list;
        IJPerfReport.Stats stats2 = stats;
        String string14 = string7;
        String string15 = string8;
        String string16 = string9;
        String string17 = string10;
        String string18 = string11;
        String string19 = string12;
        String string20 = string13;
        IJPerfReport report = new IJPerfReport(string20, string19, string18, string17, string16, string15, string14, stats2, list2, l2, (List<IJPerfRecord>)collection2);
        openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        Files.writeString(this.outputPath, (CharSequence)Json.Default.encodeToString((SerializationStrategy)IJPerfReport.Companion.serializer(), (Object)report), openOptionArray);
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    public static final /* synthetic */ Pair access$getChannels$p(IJPerfSpanReporter $this) {
        return $this.channels;
    }
}

