/*
 * Decompiled with CFR 0.152.
 */
package fleet.language.json.parser;

import andel.operation.Op;
import andel.operation.Operation;
import andel.operation.OperationKt;
import fleet.com.intellij.json.JsonElementTypes;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.language.json.parser.ExpandedSyntaxNode;
import fleet.language.json.parser.HungarianMethodKt;
import fleet.language.json.parser.JsonElementPrettifier;
import fleet.language.json.parser.JsonIndentOptions;
import fleet.language.json.parser.JsonObjectProperty;
import fleet.language.json.parser.JsonUpdaterKt;
import fleet.language.json.parser.JsonUpdaterKt$special$;
import fleet.language.json.parser.TreeWalkerUtilsKt;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.logging.KLoggersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001aC\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2)\u0010\u0012\u001a%\u0012\u0004\u0012\u00020\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00030\u0013H\u0002\u001a&\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a0\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00042\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u001d0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a0\u0010\u001e\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0003H\u0002\u001a\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\fH\u0002\u001a\u0018\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0004H\u0002\u001a\f\u0010(\u001a\u00020)*\u00020\u0004H\u0002\u001a\u000e\u0010*\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002\u001a8\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020!0\u001d*\u00020\u00042\u0006\u0010,\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020!H\u0002\u001a\f\u0010/\u001a\u000200*\u00020\u0004H\u0002\u001a\u0016\u00101\u001a\u00020\u0003*\u00020)2\b\b\u0002\u00102\u001a\u000200H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00063"}, d2={"logger", "Lfleet/util/logging/KLogger;", "lineIndent", "", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "getLineIndent", "(Lfleet/com/jetbrains/lang/syntax/SyntaxNode;)Ljava/lang/String;", "getInsertJsonArrayElementsOperation", "Landel/operation/Operation;", "arrayNode", "elements", "", "Lkotlinx/serialization/json/JsonElement;", "indentOptions", "Lfleet/language/json/parser/JsonIndentOptions;", "element", "getInsertJsonListElementsOperation", "list", "newValuesToInsert", "Lkotlin/Function2;", "Lfleet/language/json/parser/JsonElementPrettifier;", "Lkotlin/ParameterName;", "name", "lastElement", "getInsertJsonObjectPropertiesOperation", "objectNode", "key", "value", "properties", "Lkotlin/Pair;", "getJsonConfigUpdateOperation", "newValue", "realStartOffset", "", "totalDocumentLen", "indent", "similarity", "", "astElement", "jsonElement", "expandToListElement", "Lfleet/language/json/parser/ExpandedSyntaxNode;", "getLastListElement", "insertNewListElements", "newElementsText", "elementLineIndent", "offsetShift", "isRecognizedAsSingleLine", "", "joinText", "withExtraComma", "fleet.plugins.json.parsing.common"})
@SourceDebugExtension(value={"SMAP\nJsonUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonUpdater.kt\nfleet/language/json/parser/JsonUpdaterKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 7 KLoggers.kt\nfleet/util/logging/KLoggers\n*L\n1#1,689:1\n41#2,2:690\n1#3:692\n1#3:746\n1726#4,3:693\n1549#4:698\n1620#4,3:699\n1726#4,3:702\n1549#4:707\n1620#4,3:708\n1559#4:719\n1590#4,3:720\n1593#4:729\n1179#4,2:730\n1253#4,4:732\n1603#4,9:736\n1855#4:745\n1856#4:747\n1612#4:748\n766#4:749\n857#4,2:750\n1864#4,2:752\n1866#4:758\n378#4,7:784\n179#5,2:696\n179#5,2:705\n179#5,2:717\n179#5,2:754\n179#5,2:756\n179#5,2:759\n1224#5,2:767\n179#5,2:769\n316#5,7:777\n658#5:791\n739#5,4:792\n163#6,6:711\n163#6,6:723\n602#6,6:761\n602#6,6:771\n17#7,2:796\n*S KotlinDebug\n*F\n+ 1 JsonUpdater.kt\nfleet/language/json/parser/JsonUpdaterKt\n*L\n46#1:690,2\n383#1:746\n65#1:693,3\n154#1:698\n154#1:699,3\n155#1:702,3\n175#1:707\n175#1:708,3\n286#1:719\n286#1:720,3\n286#1:729\n380#1:730,2\n380#1:732,4\n383#1:736,9\n383#1:745\n383#1:747\n383#1:748\n385#1:749\n385#1:750,2\n395#1:752,2\n395#1:758\n627#1:784,7\n115#1:696,2\n158#1:705,2\n273#1:717,2\n409#1:754,2\n422#1:756,2\n448#1:759,2\n454#1:767,2\n570#1:769,2\n613#1:777,7\n665#1:791\n665#1:792,4\n234#1:711,6\n309#1:723,6\n450#1:761,6\n582#1:771,6\n689#1:796,2\n*E\n"})
public final class JsonUpdaterKt {
    @NotNull
    private static final KLogger logger;

    @NotNull
    public static final Operation getJsonConfigUpdateOperation(@NotNull SyntaxNode element, @NotNull JsonElement newValue, @NotNull JsonIndentOptions indentOptions) {
        Operation operation;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        long documentLen = SyntaxNodeExtKt.getLength((SyntaxNode)((SyntaxNode)SequencesKt.last((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)element, (boolean)false, (int)1, null))));
        String indent = indentOptions.getIndent();
        try {
            operation = JsonUpdaterKt.getJsonConfigUpdateOperation(element.getStartOffset(), element, newValue, documentLen, indent);
        }
        catch (Exception e) {
            KLogger this_$iv = logger;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = StringsKt.trimIndent((String)("\n      Failed to calculate inplace replacement of setting\n        New value: " + newValue + "\n        Old value: " + element.getText() + "\n    "));
                kLogger.error(throwable, (Object)string);
            }
            operation = Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)element.getStartOffset(), (String)((Object)element.getText()).toString(), (String)newValue.toString(), (long)documentLen, (boolean)false, (int)16, null);
        }
        return operation;
    }

    private static final Operation getInsertJsonArrayElementsOperation(SyntaxNode arrayNode, JsonElement element, JsonIndentOptions indentOptions) {
        return JsonUpdaterKt.getInsertJsonArrayElementsOperation(arrayNode, CollectionsKt.listOf((Object)element), indentOptions);
    }

    @NotNull
    public static final Operation getInsertJsonArrayElementsOperation(@NotNull SyntaxNode arrayNode, @NotNull List<? extends JsonElement> elements, @NotNull JsonIndentOptions indentOptions) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)arrayNode, (String)"arrayNode");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
            if (!Intrinsics.areEqual((Object)arrayNode.getType(), (Object)JsonElementTypes.ARRAY)) {
                boolean $i$a$-require-JsonUpdaterKt$getInsertJsonArrayElementsOperation$22 = false;
                String $i$a$-require-JsonUpdaterKt$getInsertJsonArrayElementsOperation$22 = "Is not an json array";
                throw new IllegalArgumentException($i$a$-require-JsonUpdaterKt$getInsertJsonArrayElementsOperation$22.toString());
            }
            if (elements.isEmpty()) {
                return Operation.Companion.empty();
            }
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JsonElement it = (JsonElement)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JsonPrimitive) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        boolean isSingleLine = bl && JsonUpdaterKt.isRecognizedAsSingleLine(arrayNode);
        return JsonUpdaterKt.getInsertJsonListElementsOperation(arrayNode, indentOptions, (Function2<? super JsonElementPrettifier, ? super SyntaxNode, String>)((Function2)new Function2<JsonElementPrettifier, SyntaxNode, String>(isSingleLine, elements){
            final /* synthetic */ boolean $isSingleLine;
            final /* synthetic */ List<JsonElement> $elements;
            {
                this.$isSingleLine = $isSingleLine;
                this.$elements = $elements;
                super(2);
            }

            @NotNull
            public final String invoke(@NotNull JsonElementPrettifier prettifier, @Nullable SyntaxNode lastElement) {
                String string;
                Intrinsics.checkNotNullParameter((Object)prettifier, (String)"prettifier");
                if (!this.$isSingleLine || lastElement == null) {
                    string = "";
                } else {
                    Object v1;
                    block3: {
                        Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.siblings((SyntaxNode)lastElement, (boolean)true, (boolean)true);
                        boolean $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            SyntaxNode it = (SyntaxNode)element$iv;
                            boolean bl = false;
                            if (!TreeWalkerUtilsKt.isWhiteSpace(it)) continue;
                            v1 = element$iv;
                            break block3;
                        }
                        v1 = null;
                    }
                    string = v1 == null ? " " : "";
                }
                String prefix = string;
                String postfix = this.$isSingleLine ? "" : "\n";
                return prefix + CollectionsKt.joinToString$default((Iterable)this.$elements, (CharSequence)(this.$isSingleLine ? ", " : ",\n"), null, null, (int)0, null, (Function1)((Function1)new Function1<JsonElement, CharSequence>(prettifier, this.$isSingleLine){
                    final /* synthetic */ JsonElementPrettifier $prettifier;
                    final /* synthetic */ boolean $isSingleLine;
                    {
                        this.$prettifier = $prettifier;
                        this.$isSingleLine = $isSingleLine;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull JsonElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$prettifier.toPresentableString(it, !this.$isSingleLine);
                    }
                }), (int)30, null) + postfix;
            }
        }));
    }

    @NotNull
    public static final Operation getInsertJsonObjectPropertiesOperation(@NotNull SyntaxNode objectNode, @NotNull String key, @NotNull JsonElement value, @NotNull JsonIndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)objectNode, (String)"objectNode");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        return JsonUpdaterKt.getInsertJsonObjectPropertiesOperation(objectNode, CollectionsKt.listOf((Object)TuplesKt.to((Object)key, (Object)value)), indentOptions);
    }

    @NotNull
    public static final Operation getInsertJsonObjectPropertiesOperation(@NotNull SyntaxNode objectNode, @NotNull List<? extends Pair<String, ? extends JsonElement>> properties, @NotNull JsonIndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)objectNode, (String)"objectNode");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        if (!Intrinsics.areEqual((Object)objectNode.getType(), (Object)JsonElementTypes.OBJECT)) {
            boolean bl = false;
            String string = "Is not an json object";
            throw new IllegalArgumentException(string.toString());
        }
        if (properties.isEmpty()) {
            return Operation.Companion.empty();
        }
        return JsonUpdaterKt.getInsertJsonListElementsOperation(objectNode, indentOptions, (Function2<? super JsonElementPrettifier, ? super SyntaxNode, String>)((Function2)new Function2<JsonElementPrettifier, SyntaxNode, String>(properties){
            final /* synthetic */ List<Pair<String, JsonElement>> $properties;
            {
                this.$properties = $properties;
                super(2);
            }

            @NotNull
            public final String invoke(@NotNull JsonElementPrettifier prettifier, @Nullable SyntaxNode syntaxNode) {
                Intrinsics.checkNotNullParameter((Object)prettifier, (String)"prettifier");
                return CollectionsKt.joinToString$default((Iterable)this.$properties, (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends String, ? extends JsonElement>, CharSequence>(prettifier){
                    final /* synthetic */ JsonElementPrettifier $prettifier;
                    {
                        this.$prettifier = $prettifier;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Pair<String, ? extends JsonElement> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return this.$prettifier.getOffset() + "\"" + it.getFirst() + "\": " + this.$prettifier.toPresentableString((JsonElement)it.getSecond(), false);
                    }
                }), (int)30, null) + "\n";
            }
        }));
    }

    private static final Operation getInsertJsonListElementsOperation(SyntaxNode list, JsonIndentOptions indentOptions, Function2<? super JsonElementPrettifier, ? super SyntaxNode, String> newValuesToInsert) {
        Operation operation;
        long documentLen = SyntaxNodeExtKt.getLength((SyntaxNode)((SyntaxNode)SequencesKt.last((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)list, (boolean)false, (int)1, null))));
        String lineIndent = JsonUpdaterKt.getLineIndent(list);
        String indent = indentOptions.getIndent();
        JsonElementPrettifier prettifier = new JsonElementPrettifier(indent, lineIndent + indent);
        SyntaxNode lastListElement = JsonUpdaterKt.getLastListElement(list);
        String insertString = (String)newValuesToInsert.invoke((Object)prettifier, (Object)lastListElement);
        if (lastListElement != null) {
            Object v0;
            block3: {
                Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.siblings((SyntaxNode)lastListElement, (boolean)true, (boolean)true);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SyntaxNode it = (SyntaxNode)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)JsonElementTypes.COMMA)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            SyntaxNode comma = v0;
            operation = comma == null ? Operation.Companion.insertAt(lastListElement.getEndOffset(), ",", documentLen) : Operation.Companion.empty();
        } else {
            operation = Operation.Companion.empty();
        }
        Operation baseOp = operation;
        return OperationKt.plus((Operation)baseOp, (Operation)((Operation)JsonUpdaterKt.insertNewListElements(list, insertString, documentLen, JsonUpdaterKt.getLineIndent(list), 0L).getFirst()));
    }

    /*
     * WARNING - void declaration
     */
    private static final Operation getJsonConfigUpdateOperation(long realStartOffset, SyntaxNode element, JsonElement newValue, long totalDocumentLen, String indent) {
        Operation operation;
        long shift = realStartOffset - element.getStartOffset();
        String elementLineIndent = JsonUpdaterKt.getLineIndent(element);
        String innerIndent = elementLineIndent + indent;
        JsonElementPrettifier prettifier = new JsonElementPrettifier(indent, innerIndent);
        if (Intrinsics.areEqual((Object)element.getType(), (Object)JsonElementTypes.ARRAY) && newValue instanceof JsonArray) {
            long l;
            void $this$mapIndexedTo$iv$iv;
            int n8;
            int it;
            Object current;
            int i;
            CharSequence it2;
            void $this$mapTo$iv$iv;
            boolean bl;
            boolean isSingleLineArray;
            boolean bl2;
            List expandedOldElements;
            int n2;
            Object object;
            List oldElements;
            Operation arrayOperation;
            block63: {
                void $this$mapTo$iv$iv2;
                if (((JsonArray)newValue).isEmpty()) {
                    return Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)realStartOffset, (String)((Object)element.getText()).toString(), (String)"[]", (long)totalDocumentLen, (boolean)false, (int)16, null);
                }
                arrayOperation = null;
                arrayOperation = Operation.Companion.empty();
                Sequence<SyntaxNode> sequence = TreeWalkerUtilsKt.jsonArrayItemsCursor(element);
                Intrinsics.checkNotNull(sequence);
                oldElements = SequencesKt.toList(sequence);
                Iterable $this$map$iv = oldElements;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    SyntaxNode syntaxNode = (SyntaxNode)item$iv$iv;
                    object = destination$iv$iv;
                    n2 = 0;
                    object.add(JsonUpdaterKt.expandToListElement((SyntaxNode)it3));
                }
                expandedOldElements = (List)destination$iv$iv;
                Iterable $this$all$iv = (Iterable)newValue;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        JsonElement it4 = (JsonElement)element$iv;
                        boolean bl3 = false;
                        if (it4 instanceof JsonPrimitive) continue;
                        bl2 = false;
                        break block63;
                    }
                    bl2 = true;
                }
            }
            boolean bl4 = isSingleLineArray = bl2 && JsonUpdaterKt.isRecognizedAsSingleLine(element);
            if (oldElements.isEmpty()) {
                bl = false;
            } else {
                Object v4;
                block64: {
                    Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.siblings((SyntaxNode)((SyntaxNode)CollectionsKt.last((List)oldElements)), (boolean)true, (boolean)true);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SyntaxNode it5 = (SyntaxNode)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it5.getType(), (Object)JsonElementTypes.COMMA)) continue;
                        v4 = element$iv;
                        break block64;
                    }
                    v4 = null;
                }
                bl = v4 != null;
            }
            boolean isTrailingComma = bl;
            List mapping2 = (List)HungarianMethodKt.computeMappingMaximizing((Collection)newValue, oldElements, getJsonConfigUpdateOperation.mapping.1.INSTANCE).getFirst();
            List newElementTextLengths = new ArrayList();
            int element$iv = 0;
            int it5 = oldElements.size();
            long[] bl5 = new long[it5];
            while (element$iv < it5) {
                n2 = element$iv++;
                bl5[n2] = ((SyntaxNode)oldElements.get(n2)).getStartOffset() - ((ExpandedSyntaxNode)expandedOldElements.get(n2)).getStartOffset();
            }
            long[] oldPrefixLengths = bl5;
            long[] newPrefixLengths = (long[])oldPrefixLengths.clone();
            Iterable $this$map$iv = expandedOldElements;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ExpandedSyntaxNode expandedSyntaxNode = (ExpandedSyntaxNode)item$iv$iv;
                object = destination$iv$iv;
                boolean bl6 = false;
                object.add(JsonUpdaterKt.joinText$default((ExpandedSyntaxNode)((Object)it2), false, 1, null));
            }
            List oldElementTexts = (List)destination$iv$iv;
            $i$f$map = Math.min(((JsonArray)newValue).size(), oldElements.size());
            for (i = 0; i < $i$f$map; ++i) {
                String string;
                int oldValueInd = ((Number)mapping2.get(i)).intValue();
                current = (ExpandedSyntaxNode)expandedOldElements.get(i);
                if (oldValueInd == -1) {
                    int prev;
                    prefix = isSingleLineArray && i != 0 ? " " : (isSingleLineArray || i == 0 ? "" : ((prev = ((Number)mapping2.get(i - 1)).intValue()) == -1 || StringsKt.endsWith$default((String)((String)oldElementTexts.get(prev)), (String)"\n", (boolean)false, (int)2, null) ? "" : "\n"));
                    String postfix = i == ((JsonArray)newValue).size() - 1 && isSingleLineArray ? "" : (i == ((JsonArray)newValue).size() - 1 ? "\n" : (isSingleLineArray ? "," : (i == oldElements.size() - 1 ? (StringsKt.contains$default((CharSequence)((ExpandedSyntaxNode)CollectionsKt.last((List)expandedOldElements)).getEndNode().getText(), (CharSequence)"\n", (boolean)false, (int)2, null) ? ",\n" : ",") : ",\n")));
                    string = prefix + prettifier.toPresentableString(((JsonArray)newValue).get(i), !isSingleLineArray) + postfix;
                } else {
                    CharSequence charSequence;
                    String $this$indexOfLast$iv;
                    String string2;
                    String string3;
                    if (isSingleLineArray && i > 0 && oldValueInd == 0) {
                        Character firstChar = StringsKt.firstOrNull((CharSequence)((SyntaxNode)oldElements.get(oldValueInd)).getText());
                        if (firstChar == null || !CharsKt.isWhitespace((char)firstChar.charValue())) {
                            newPrefixLengths[oldValueInd] = newPrefixLengths[oldValueInd] + 1L;
                            string3 = " ";
                        } else {
                            string3 = "";
                        }
                    } else {
                        string3 = "";
                    }
                    prefix = string3;
                    Object object2 = prefix;
                    if (!isTrailingComma && oldValueInd == oldElements.size() - 1 && i != ((JsonArray)newValue).size() - 1) {
                        string2 = JsonUpdaterKt.joinText((ExpandedSyntaxNode)expandedOldElements.get(oldValueInd), true);
                    } else if (!isTrailingComma && oldValueInd < oldElements.size() - 1 && i == ((JsonArray)newValue).size() - 1) {
                        int $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newElementText$22;
                        int n3;
                        block65: {
                            it2 = (CharSequence)oldElementTexts.get(oldValueInd);
                            object = object2;
                            boolean $i$f$indexOfLast = false;
                            int n4 = $this$indexOfLast$iv.length() + -1;
                            if (0 <= n4) {
                                do {
                                    int index$iv = n4--;
                                    it = $this$indexOfLast$iv.charAt(index$iv);
                                    boolean bl7 = false;
                                    if (!(it == 44)) continue;
                                    n3 = index$iv;
                                    break block65;
                                } while (0 <= n4);
                            }
                            n3 = -1;
                        }
                        int n5 = n3;
                        object2 = object;
                        int comma = n5;
                        if (!(comma != -1)) {
                            object = object2;
                            $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newElementText$22 = 0;
                            Object object3 = object;
                            String $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newElementText$22 = "No found comma for non-last array element";
                            throw new IllegalArgumentException($i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newElementText$22.toString());
                        }
                        $this$indexOfLast$iv = (String)oldElementTexts.get(oldValueInd);
                        $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newElementText$22 = comma + 1;
                        string2 = ((Object)StringsKt.removeRange((CharSequence)$this$indexOfLast$iv, (int)comma, (int)$i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newElementText$22)).toString();
                    } else {
                        string2 = (String)oldElementTexts.get(oldValueInd);
                    }
                    $this$indexOfLast$iv = string2;
                    object = object2;
                    boolean bl8 = false;
                    if (isSingleLineArray && i == 0 && ((CharSequence)it2).length() > 0) {
                        char firstChar = StringsKt.first((CharSequence)it2);
                        if (CharsKt.isWhitespace((char)firstChar) && firstChar != '\n') {
                            newPrefixLengths[oldValueInd] = newPrefixLengths[oldValueInd] - 1L;
                            charSequence = StringsKt.drop((String)it2, (int)1);
                        } else {
                            charSequence = it2;
                        }
                    } else {
                        charSequence = it2;
                    }
                    string = (String)object + charSequence;
                }
                String newElementText = string;
                newElementTextLengths.add(Long.valueOf(newElementText.length()));
                arrayOperation = OperationKt.plus((Operation)arrayOperation, (Operation)Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(((ExpandedSyntaxNode)current).getStartOffset(), shift), (String)((String)oldElementTexts.get(i)), (String)newElementText, (long)totalDocumentLen, (boolean)false, (int)16, null));
            }
            $i$f$map = oldElements.size();
            for (i = ((JsonArray)newValue).size(); i < $i$f$map; ++i) {
                Unit unit;
                Iterator<Object> iterator;
                block66: {
                    ExpandedSyntaxNode expanded = JsonUpdaterKt.expandToListElement((SyntaxNode)oldElements.get(i));
                    arrayOperation = OperationKt.plus((Operation)arrayOperation, (Operation)Operation.Companion.deleteAt(JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(expanded.getStartOffset(), shift), JsonUpdaterKt.joinText$default(expanded, false, 1, null), totalDocumentLen));
                    if (i != ((JsonArray)newValue).size() || isTrailingComma) continue;
                    Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.siblings((SyntaxNode)expanded.getStartNode(), (boolean)false, (boolean)true);
                    boolean $i$f$firstOrNull = false;
                    for (Iterator<Object> element$iv2 : $this$firstOrNull$iv) {
                        SyntaxNode it6 = (SyntaxNode)element$iv2;
                        n8 = 0;
                        if (!Intrinsics.areEqual((Object)it6.getType(), (Object)JsonElementTypes.COMMA)) continue;
                        iterator = element$iv2;
                        break block66;
                    }
                    iterator = null;
                }
                if ((SyntaxNode)iterator != null) {
                    SyntaxNode it7;
                    boolean bl9 = false;
                    arrayOperation = OperationKt.plus((Operation)arrayOperation, (Operation)Operation.Companion.deleteAt(JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(it7.getStartOffset(), shift), ",", totalDocumentLen));
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Iterable $this$mapIndexed$iv = CollectionsKt.drop((Iterable)((Iterable)newValue), (int)oldElements.size());
            boolean $i$f$mapIndexed22 = false;
            current = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Object object4;
                void ind;
                if ((n8 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JsonElement index$iv = (JsonElement)item$iv$iv;
                it = n8;
                object = destination$iv$iv2;
                boolean bl10 = false;
                int oldValueInd = ((Number)mapping2.get((int)(ind + oldElements.size()))).intValue();
                int last = ((JsonArray)newValue).size() - oldElements.size() - 1;
                if (oldValueInd == -1) {
                    void it8;
                    String prefix = isSingleLineArray && (ind > 0 || !((Collection)oldElements).isEmpty()) ? " " : "";
                    String postfix = ind != last && isSingleLineArray ? "," : (ind != last ? ",\n" : (isSingleLineArray ? "" : "\n"));
                    object4 = prefix + prettifier.toPresentableString((JsonElement)it8, !isSingleLineArray) + postfix;
                } else if (!isTrailingComma && oldValueInd == oldElements.size() - 1 && ind != last) {
                    object4 = JsonUpdaterKt.joinText((ExpandedSyntaxNode)expandedOldElements.get(oldValueInd), true);
                } else if (!isTrailingComma && oldValueInd < oldElements.size() - 1 && ind == last) {
                    int $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newValuesToInsert$1$22;
                    int comma;
                    block67: {
                        int n6;
                        CharSequence $this$indexOfLast$iv = (CharSequence)oldElementTexts.get(oldValueInd);
                        boolean $i$f$indexOfLast = false;
                        int n7 = $this$indexOfLast$iv.length() + -1;
                        if (0 <= n7) {
                            do {
                                int index$iv2 = n7--;
                                char it9 = $this$indexOfLast$iv.charAt(index$iv2);
                                boolean bl11 = false;
                                if (!(it9 == ',')) continue;
                                n6 = index$iv2;
                                break block67;
                            } while (0 <= n7);
                        }
                        n6 = comma = -1;
                    }
                    if (!(comma != -1)) {
                        $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newValuesToInsert$1$22 = 0;
                        String $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newValuesToInsert$1$22 = "No found comma for non-last array element";
                        throw new IllegalArgumentException($i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newValuesToInsert$1$22.toString());
                    }
                    String string = (String)oldElementTexts.get(oldValueInd);
                    $i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newValuesToInsert$1$22 = comma + 1;
                    object4 = ((Object)StringsKt.removeRange((CharSequence)string, (int)comma, (int)$i$a$-require-JsonUpdaterKt$getJsonConfigUpdateOperation$newValuesToInsert$1$22)).toString();
                } else {
                    object4 = (String)oldElementTexts.get(oldValueInd);
                }
                object.add(object4);
            }
            List newValuesToInsert = (List)destination$iv$iv2;
            String elementsTextToInsert = CollectionsKt.joinToString$default((Iterable)newValuesToInsert, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            Pair<Operation, Long> $i$f$mapIndexed22 = JsonUpdaterKt.insertNewListElements(element, elementsTextToInsert, totalDocumentLen, elementLineIndent, shift);
            Operation insertOperation = (Operation)$i$f$mapIndexed22.component1();
            long newValuesOffset = ((Number)$i$f$mapIndexed22.component2()).longValue();
            arrayOperation = OperationKt.plus((Operation)arrayOperation, (Operation)insertOperation);
            if (oldElements.isEmpty()) {
                return arrayOperation;
            }
            Operation updateOperation = Operation.Companion.empty();
            if (arrayOperation.getOps().isEmpty()) {
                l = totalDocumentLen;
            } else {
                Iterable n8 = arrayOperation.getOps();
                long it8 = 0L;
                for (Object oldValueInd : n8) {
                    void it10;
                    Op last = (Op)oldValueInd;
                    long l2 = it8;
                    boolean bl12 = false;
                    long l3 = it10.getLenAfter();
                    it8 = l2 + l3;
                }
                l = it8;
            }
            long updateTotal = l;
            long currentDiff = JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(0L, shift);
            int bl10 = ((JsonArray)newValue).size();
            for (int i2 = 0; i2 < bl10; ++i2) {
                int oldValueInd = ((Number)mapping2.get(i2)).intValue();
                if (oldValueInd == -1) {
                    if (i2 < oldElements.size()) {
                        currentDiff += ((Number)newElementTextLengths.get(i2)).longValue() - (long)((String)oldElementTexts.get(i2)).length();
                        continue;
                    }
                    currentDiff += (long)((String)newValuesToInsert.get(i2 - oldElements.size())).length();
                    continue;
                }
                Pair it10 = i2 < oldElements.size() ? TuplesKt.to((Object)((SyntaxNode)oldElements.get(i2)).getStartOffset(), (Object)(newPrefixLengths[oldValueInd] - oldPrefixLengths[i2])) : TuplesKt.to((Object)newValuesOffset, (Object)newPrefixLengths[oldValueInd]);
                long oldElementOffset = ((Number)it10.component1()).longValue();
                long additionalPrefixLen = ((Number)it10.component2()).longValue();
                updateOperation = OperationKt.plus((Operation)updateOperation, (Operation)JsonUpdaterKt.getJsonConfigUpdateOperation(oldElementOffset + currentDiff + additionalPrefixLen, (SyntaxNode)oldElements.get(oldValueInd), ((JsonArray)newValue).get(i2), updateTotal, indent));
                if (i2 < oldElements.size()) {
                    currentDiff += ((Number)newElementTextLengths.get(i2)).longValue() - (long)((String)oldElementTexts.get(i2)).length();
                    continue;
                }
                currentDiff += (long)((String)newValuesToInsert.get(i2 - oldElements.size())).length();
            }
            operation = OperationKt.compose((Operation)arrayOperation, (Operation)updateOperation);
        } else {
            if (Intrinsics.areEqual((Object)element.getType(), (Object)JsonElementTypes.OBJECT) && newValue instanceof JsonObject) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapNotNullTo$iv$iv;
                Object it;
                void $this$associateTo$iv$iv;
                Operation objectOperation = null;
                objectOperation = Operation.Companion.empty();
                Iterable $this$associate$iv = ((JsonObject)newValue).entrySet();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable mapping2 = $this$associate$iv;
                Object destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map newValuesToInsert = destination$iv$iv;
                    it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    it = TuplesKt.to(it.getKey(), it.getValue());
                    newValuesToInsert.put(it.getFirst(), it.getSecond());
                }
                Map key2JsonElement = destination$iv$iv;
                Sequence<JsonObjectProperty> sequence = TreeWalkerUtilsKt.jsonObjectPropertiesCursorOrNull(element);
                Intrinsics.checkNotNull(sequence);
                List properties = SequencesKt.toList(sequence);
                Iterable $this$mapNotNull$iv = properties;
                boolean $i$f$mapNotNull22 = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    JsonObjectProperty it11 = (JsonObjectProperty)element$iv$iv;
                    boolean bl13 = false;
                    if (TreeWalkerUtilsKt.asJsonString(it11.getKeyNode()) == null) continue;
                    boolean bl14 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Set presented = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                Iterable $i$f$mapNotNull22 = key2JsonElement.entrySet();
                boolean $i$f$filter = false;
                destination$iv$iv3 = $this$filter$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry it12 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!(!presented.contains(it12.getKey()))) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                String it13 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends JsonElement>, CharSequence>(innerIndent, prettifier){
                    final /* synthetic */ String $innerIndent;
                    final /* synthetic */ JsonElementPrettifier $prettifier;
                    {
                        this.$innerIndent = $innerIndent;
                        this.$prettifier = $prettifier;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Map.Entry<String, ? extends JsonElement> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return this.$innerIndent + "\"" + it.getKey() + "\": " + this.$prettifier.toPresentableString(it.getValue(), false);
                    }
                }), (int)30, null);
                boolean bl = false;
                Object newProperties2 = ((CharSequence)it13).length() > 0 ? it13 + "\n" : it13;
                Iterable $this$forEachIndexed$iv = properties;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    SyntaxNode comma;
                    SyntaxNode syntaxNode;
                    SyntaxNode propertyNode;
                    String key;
                    void property;
                    int n;
                    Object element$iv$iv;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    element$iv$iv = (JsonObjectProperty)item$iv;
                    int ind = n;
                    boolean bl15 = false;
                    if (TreeWalkerUtilsKt.asJsonString(property.getKeyNode()) == null) continue;
                    Intrinsics.checkNotNull((Object)property.getKeyNode().parent());
                    if (key2JsonElement.containsKey(key)) {
                        SyntaxNode comma2;
                        Object v22;
                        block68: {
                            long l = JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(property.getValueNode().getStartOffset(), shift);
                            SyntaxNode syntaxNode2 = property.getValueNode();
                            Object v = key2JsonElement.get(key);
                            Intrinsics.checkNotNull(v);
                            objectOperation = OperationKt.plus((Operation)objectOperation, (Operation)JsonUpdaterKt.getJsonConfigUpdateOperation(l, syntaxNode2, (JsonElement)v, totalDocumentLen, indent));
                            if (ind != properties.size() - 1 || !(((CharSequence)newProperties2).length() > 0)) continue;
                            Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.siblings((SyntaxNode)propertyNode, (boolean)true, (boolean)true);
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                SyntaxNode it14 = (SyntaxNode)element$iv;
                                boolean bl16 = false;
                                if (!Intrinsics.areEqual((Object)it14.getType(), (Object)JsonElementTypes.COMMA)) continue;
                                v22 = element$iv;
                                break block68;
                            }
                            v22 = null;
                        }
                        if ((comma2 = (SyntaxNode)v22) != null) continue;
                        objectOperation = OperationKt.plus((Operation)objectOperation, (Operation)Operation.Companion.insertAt(JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(property.getValueNode().getEndOffset(), shift), ",", totalDocumentLen));
                        continue;
                    }
                    ExpandedSyntaxNode expanded = JsonUpdaterKt.expandToListElement(propertyNode);
                    objectOperation = OperationKt.plus((Operation)objectOperation, (Operation)Operation.Companion.deleteAt(JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(expanded.getStartOffset(), shift), JsonUpdaterKt.joinText$default(expanded, false, 1, null), totalDocumentLen));
                    if (ind != properties.size() - 1 || ind == 0 || !(((CharSequence)newProperties2).length() == 0)) continue;
                    SyntaxNode previousProp = ((JsonObjectProperty)CollectionsKt.last((List)CollectionsKt.dropLast((List)properties, (int)1))).getKeyNode().parent();
                    SyntaxNode syntaxNode3 = previousProp;
                    if (syntaxNode3 != null && (syntaxNode3 = SyntaxNodeExtKt.siblings((SyntaxNode)syntaxNode3, (boolean)true, (boolean)true)) != null) {
                        Object v24;
                        block69: {
                            SyntaxNode $this$firstOrNull$iv = syntaxNode3;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                SyntaxNode it15 = (SyntaxNode)element$iv;
                                boolean bl17 = false;
                                if (!Intrinsics.areEqual((Object)it15.getType(), (Object)JsonElementTypes.COMMA)) continue;
                                v24 = element$iv;
                                break block69;
                            }
                            v24 = null;
                        }
                        syntaxNode = v24;
                    } else {
                        syntaxNode = null;
                    }
                    if ((comma = syntaxNode) == null) continue;
                    objectOperation = OperationKt.plus((Operation)objectOperation, (Operation)Operation.Companion.deleteAt(JsonUpdaterKt.getJsonConfigUpdateOperation$toReal(comma.getStartOffset(), shift), ",", totalDocumentLen));
                }
                return OperationKt.plus((Operation)objectOperation, (Operation)((Operation)JsonUpdaterKt.insertNewListElements(element, (String)newProperties2, totalDocumentLen, elementLineIndent, shift).getFirst()));
            }
            String oldText = ((Object)element.getText()).toString();
            String newText = new JsonElementPrettifier(indent, elementLineIndent).toPresentableString(newValue, false);
            operation = Operation.Companion.replaceAt$default((Operation.Companion)Operation.Companion, (long)realStartOffset, (String)oldText, (String)newText, (long)totalDocumentLen, (boolean)false, (int)16, null);
        }
        return operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getLineIndent(SyntaxNode $this$lineIndent) {
        CharSequence charSequence;
        block3: {
            Object v0;
            block2: {
                Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.sequenceLeft((SyntaxNode)$this$lineIndent, (boolean)true);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SyntaxNode it = (SyntaxNode)element$iv;
                    boolean bl = false;
                    if (!(TreeWalkerUtilsKt.isWhiteSpace(it) && StringsKt.contains$default((CharSequence)it.getText(), (char)'\n', (boolean)false, (int)2, null))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SyntaxNode syntaxNode = v0;
            if (syntaxNode == null) return "";
            CharSequence charSequence2 = syntaxNode.getText();
            if (charSequence2 == null) return "";
            CharSequence $this$takeLastWhile$iv = charSequence2;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '\n') continue;
                charSequence = $this$takeLastWhile$iv.subSequence(index$iv + 1, $this$takeLastWhile$iv.length());
                break block3;
            }
            charSequence = $this$takeLastWhile$iv.subSequence(0, $this$takeLastWhile$iv.length());
        }
        CharSequence charSequence3 = charSequence;
        if (charSequence3 == null) return "";
        String string = ((Object)charSequence3).toString();
        if (string == null) return "";
        Object object = string;
        return object;
    }

    private static final boolean isRecognizedAsSingleLine(SyntaxNode $this$isRecognizedAsSingleLine) {
        boolean bl;
        block5: {
            Object object = $this$isRecognizedAsSingleLine.getType();
            if (Intrinsics.areEqual((Object)object, (Object)JsonElementTypes.OBJECT)) {
                bl = false;
            } else if (Intrinsics.areEqual((Object)object, (Object)JsonElementTypes.ARRAY)) {
                Sequence $this$all$iv = SyntaxNodeExtKt.children((SyntaxNode)$this$isRecognizedAsSingleLine);
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    SyntaxNode it = (SyntaxNode)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET, JsonElementTypes.COMMA};
                    if (ArraysKt.contains((Object[])objectArray, (Object)it.getType()) || TreeWalkerUtilsKt.isJsonPrimitiveLiteral(it) || TreeWalkerUtilsKt.isJsonComment(it) || TreeWalkerUtilsKt.isWhiteSpace(it) && !StringsKt.contains$default((CharSequence)it.getText(), (char)'\n', (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private static final ExpandedSyntaxNode expandToListElement(SyntaxNode $this$expandToListElement) {
        long endOffset;
        long startOffset;
        SyntaxNode lastNode;
        SyntaxNode firstNode;
        block15: {
            SyntaxNode last;
            block16: {
                int index;
                block11: {
                    SyntaxNode first2;
                    SyntaxNode syntaxNode;
                    block14: {
                        SyntaxNode leftWsOrComment2;
                        block12: {
                            block13: {
                                SyntaxNode syntaxNode2;
                                IElementType iElementType;
                                SyntaxNode syntaxNode3 = $this$expandToListElement.parent();
                                if (syntaxNode3 == null) {
                                    boolean $i$a$-requireNotNull-JsonUpdaterKt$expandToListElement$parent$22 = false;
                                    String $i$a$-requireNotNull-JsonUpdaterKt$expandToListElement$parent$22 = "Missing list element parent";
                                    throw new IllegalArgumentException($i$a$-requireNotNull-JsonUpdaterKt$expandToListElement$parent$22.toString());
                                }
                                SyntaxNode parent = syntaxNode3;
                                Object $i$a$-requireNotNull-JsonUpdaterKt$expandToListElement$parent$22 = parent.getType();
                                if (Intrinsics.areEqual((Object)$i$a$-requireNotNull-JsonUpdaterKt$expandToListElement$parent$22, (Object)JsonElementTypes.ARRAY)) {
                                    iElementType = JsonElementTypes.L_BRACKET;
                                } else if (Intrinsics.areEqual((Object)$i$a$-requireNotNull-JsonUpdaterKt$expandToListElement$parent$22, (Object)JsonElementTypes.OBJECT)) {
                                    iElementType = JsonElementTypes.L_CURLY;
                                } else {
                                    throw new IllegalStateException((parent.getType() + " is not a json list").toString());
                                }
                                IElementType lPar = iElementType;
                                firstNode = $this$expandToListElement;
                                lastNode = null;
                                lastNode = $this$expandToListElement;
                                startOffset = 0L;
                                endOffset = 0L;
                                leftWsOrComment2 = (SyntaxNode)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)$this$expandToListElement, (boolean)false, (boolean)true), (Function1)expandToListElement.leftWsOrComment.1.INSTANCE));
                                if (leftWsOrComment2 == null) break block11;
                                SyntaxNode syntaxNode4 = leftWsOrComment2.prevSibling();
                                if (Intrinsics.areEqual((Object)(syntaxNode4 != null ? syntaxNode4.getType() : null), (Object)lPar)) break block12;
                                syntaxNode = (SyntaxNode)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)leftWsOrComment2, (boolean)true, (boolean)false), (Function1)expandToListElement.first.1.INSTANCE));
                                if (syntaxNode == null) break block13;
                                SyntaxNode it = syntaxNode;
                                boolean bl = false;
                                if (TreeWalkerUtilsKt.isWhiteSpace(it)) {
                                    syntaxNode2 = it;
                                } else {
                                    syntaxNode2 = it.nextSibling();
                                    if (syntaxNode2 == null) {
                                        syntaxNode2 = it;
                                    }
                                }
                                syntaxNode = syntaxNode2;
                                if (syntaxNode2 != null) break block14;
                            }
                            syntaxNode = leftWsOrComment2;
                            break block14;
                        }
                        syntaxNode = leftWsOrComment2;
                    }
                    firstNode = first2 = syntaxNode;
                    if (TreeWalkerUtilsKt.isWhiteSpace(first2) && StringsKt.contains$default((CharSequence)first2.getText(), (char)'\n', (boolean)false, (int)2, null)) {
                        startOffset += (long)(StringsKt.indexOf$default((CharSequence)first2.getText(), (char)'\n', (int)0, (boolean)false, (int)6, null) + 1);
                    }
                }
                SyntaxNode syntaxNode = (SyntaxNode)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)$this$expandToListElement, (boolean)true, (boolean)true), (Function1)expandToListElement.1.INSTANCE));
                if (syntaxNode == null) break block15;
                last = syntaxNode;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)last.getType(), (Object)TokenType.WHITE_SPACE) || (index = StringsKt.indexOf$default((CharSequence)last.getText(), (char)'\n', (int)0, (boolean)false, (int)6, null)) == -1) break block16;
                lastNode = last;
                endOffset -= SyntaxNodeExtKt.getLength((SyntaxNode)last) - (long)index - 1L;
                break block15;
            }
            SyntaxNode syntaxNode = (SyntaxNode)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)last, (boolean)false, (boolean)false), (Function1)((Function1)new Function1<SyntaxNode, Boolean>($this$expandToListElement){
                final /* synthetic */ SyntaxNode $this_expandToListElement;
                {
                    this.$this_expandToListElement = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SyntaxNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it.getType(), (Object)JsonElementTypes.COMMA) && !Intrinsics.areEqual((Object)it, (Object)this.$this_expandToListElement);
                }
            })));
            if (syntaxNode == null || (syntaxNode = syntaxNode.prevSibling()) == null) break block15;
            SyntaxNode it = syntaxNode;
            boolean bl = false;
            lastNode = it;
        }
        return new ExpandedSyntaxNode(firstNode, lastNode, firstNode.getStartOffset() + startOffset, lastNode.getEndOffset() + endOffset);
    }

    /*
     * Unable to fully structure code
     */
    private static final Pair<Operation, Long> insertNewListElements(SyntaxNode $this$insertNewListElements, String newElementsText, long totalDocumentLen, String elementLineIndent, long offsetShift) {
        block21: {
            newElementsOffset = 0L;
            resultOperation = Operation.Companion.empty();
            if (((CharSequence)newElementsText).length() == 0) {
                return TuplesKt.to((Object)resultOperation, (Object)-1L);
            }
            isSingleLine = StringsKt.contains$default((CharSequence)newElementsText, (char)'\n', (boolean)false, (int)2, null) == false && JsonUpdaterKt.isRecognizedAsSingleLine($this$insertNewListElements) != false;
            var12_8 = $this$insertNewListElements.getType();
            if (Intrinsics.areEqual((Object)var12_8, (Object)JsonElementTypes.ARRAY)) {
                v0 = TuplesKt.to((Object)JsonElementTypes.L_BRACKET, (Object)JsonElementTypes.R_BRACKET);
            } else if (Intrinsics.areEqual((Object)var12_8, (Object)JsonElementTypes.OBJECT)) {
                v0 = TuplesKt.to((Object)JsonElementTypes.L_CURLY, (Object)JsonElementTypes.R_CURLY);
            } else {
                throw new IllegalStateException(($this$insertNewListElements.getType() + " is not a json list").toString());
            }
            var11_9 = v0;
            lType = (IElementType)var11_9.component1();
            rType = (IElementType)var11_9.component2();
            lastListElement = JsonUpdaterKt.getLastListElement($this$insertNewListElements);
            var16_12 = $this$insertNewListElements.lastChild();
            if (var16_12 == null || (var17_13 = SyntaxNodeExtKt.siblings((SyntaxNode)var16_12, (boolean)false, (boolean)false)) == null) ** GOTO lbl-1000
            var19_15 = var17_13;
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (SyntaxNode)element$iv;
                $i$a$-firstOrNull-JsonUpdaterKt$insertNewListElements$rBracket$1 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)rType)) continue;
                v1 = element$iv;
                break block21;
            }
            v1 = null;
        }
        var18_25 = v1;
        if (var18_25 != null) {
            v2 = var18_25;
        } else if ((v2 = $this$insertNewListElements.lastChild()) == null) {
            $i$a$-requireNotNull-JsonUpdaterKt$insertNewListElements$rBracket$2 = false;
            var20_18 = "Expected non-empty list " + lType + rType;
            throw new IllegalArgumentException(var20_18.toString());
        }
        rBracket = v2;
        beforeBracket = (SyntaxNode)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)rBracket, (boolean)false, (boolean)true), (Function1)insertNewListElements.beforeBracket.1.INSTANCE));
        if (lastListElement == null) {
            if (beforeBracket == null || Intrinsics.areEqual((Object)beforeBracket.getType(), (Object)lType)) {
                v3 = rBracket.getStartOffset();
            } else if (Intrinsics.areEqual((Object)beforeBracket.getType(), (Object)TokenType.WHITE_SPACE)) {
                block22: {
                    var21_19 = beforeBracket.getText();
                    var26_27 = beforeBracket.getEndOffset();
                    $i$f$takeLastWhile = false;
                    for (index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                        it = $this$takeLastWhile$iv.charAt(index$iv);
                        $i$a$-takeLastWhile-JsonUpdaterKt$insertNewListElements$offset$offset$1 = false;
                        if (it != '\n') continue;
                        v4 = $this$takeLastWhile$iv.subSequence(index$iv + 1, $this$takeLastWhile$iv.length());
                        break block22;
                    }
                    v4 = $this$takeLastWhile$iv.subSequence(0, $this$takeLastWhile$iv.length());
                }
                var28_29 = v4;
                v3 = var26_27 - (long)var28_29.length();
            } else {
                v3 = offset = beforeBracket.getEndOffset();
            }
            if (!isSingleLine) {
                v5 = beforeBracket;
                if (!Intrinsics.areEqual((Object)(v5 != null ? v5.getType() : null), (Object)TokenType.WHITE_SPACE)) {
                    resultOperation = OperationKt.plus((Operation)resultOperation, (Operation)Operation.Companion.insertAt(offset + offsetShift, "\n", totalDocumentLen));
                }
            }
            v6 = offset;
        } else {
            expanded = JsonUpdaterKt.expandToListElement(lastListElement);
            if (!isSingleLine && !StringsKt.contains$default((CharSequence)expanded.getEndNode().getText(), (char)'\n', (boolean)false, (int)2, null)) {
                resultOperation = OperationKt.plus((Operation)resultOperation, (Operation)Operation.Companion.insertAt(expanded.getEndOffset() + offsetShift, "\n", totalDocumentLen));
                ++newElementsOffset;
            }
            v6 = expanded.getEndOffset();
        }
        offset = v6;
        newElementsOffset += offset;
        if (isSingleLine) ** GOTO lbl-1000
        v7 = beforeBracket;
        if (Intrinsics.areEqual((Object)(v7 != null ? v7.getType() : null), (Object)TokenType.WHITE_SPACE)) lbl-1000:
        // 2 sources

        {
            resultOperation = OperationKt.plus((Operation)resultOperation, (Operation)Operation.Companion.insertAt(offset + offsetShift, newElementsText, totalDocumentLen));
        } else {
            resultOperation = OperationKt.plus((Operation)resultOperation, (Operation)Operation.Companion.insertAt(offset + offsetShift, newElementsText + elementLineIndent, totalDocumentLen));
        }
        return TuplesKt.to((Object)resultOperation, (Object)newElementsOffset);
    }

    private static final SyntaxNode getLastListElement(SyntaxNode $this$getLastListElement) {
        SyntaxNode syntaxNode;
        Object object = $this$getLastListElement.getType();
        if (Intrinsics.areEqual((Object)object, (Object)JsonElementTypes.ARRAY)) {
            Sequence<SyntaxNode> sequence = TreeWalkerUtilsKt.jsonArrayItemsCursor($this$getLastListElement);
            Intrinsics.checkNotNull(sequence);
            syntaxNode = (SyntaxNode)SequencesKt.lastOrNull(sequence);
        } else if (Intrinsics.areEqual((Object)object, (Object)JsonElementTypes.OBJECT)) {
            Sequence $this$lastOrNull$iv = SyntaxNodeExtKt.children((SyntaxNode)$this$getLastListElement);
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                SyntaxNode it = (SyntaxNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)JsonElementTypes.PROPERTY)) continue;
                last$iv = element$iv;
            }
            syntaxNode = last$iv;
        } else {
            throw new IllegalStateException(($this$getLastListElement.getType() + " is not a json list").toString());
        }
        return syntaxNode;
    }

    private static final String joinText(ExpandedSyntaxNode $this$joinText, boolean withExtraComma) {
        String string;
        List nodes2 = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.takeWhile((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)$this$joinText.getStartNode(), (boolean)true, (boolean)false), (Function1)((Function1)new Function1<SyntaxNode, Boolean>($this$joinText){
            final /* synthetic */ ExpandedSyntaxNode $this_joinText;
            {
                this.$this_joinText = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)this.$this_joinText.getEndNode());
            }
        })), (Object)$this$joinText.getEndNode()));
        if (withExtraComma) {
            int last;
            block7: {
                int n;
                List $this$indexOfLast$iv = nodes2;
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    SyntaxNode it = (SyntaxNode)iterator$iv.previous();
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)TokenType.WHITE_SPACE) && !Intrinsics.areEqual((Object)it.getType(), (Object)JsonElementTypes.LINE_COMMENT) && !Intrinsics.areEqual((Object)it.getType(), (Object)JsonElementTypes.BLOCK_COMMENT))) continue;
                    n = iterator$iv.nextIndex();
                    break block7;
                }
                n = last = -1;
            }
            if (last == -1) {
                string = CollectionsKt.joinToString$default((Iterable)nodes2, (CharSequence)"", null, (CharSequence)",", (int)0, null, (Function1)((Function1)new Function1<SyntaxNode, CharSequence>($this$joinText){
                    final /* synthetic */ ExpandedSyntaxNode $this_joinText;
                    {
                        this.$this_joinText = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull SyntaxNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JsonUpdaterKt.access$joinText$text(it, this.$this_joinText);
                    }
                }), (int)26, null);
            } else {
                StringBuilder stringBuilder;
                StringBuilder $this$joinText_u24lambda_u2437 = stringBuilder = new StringBuilder();
                boolean bl = false;
                for (SyntaxNode e : nodes2.subList(0, last + 1)) {
                    $this$joinText_u24lambda_u2437.append(JsonUpdaterKt.joinText$text(e, $this$joinText));
                }
                $this$joinText_u24lambda_u2437.append(",");
                for (SyntaxNode e : nodes2.subList(last + 1, nodes2.size())) {
                    $this$joinText_u24lambda_u2437.append(JsonUpdaterKt.joinText$text(e, $this$joinText));
                }
                String string2 = stringBuilder.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
        } else {
            string = CollectionsKt.joinToString$default((Iterable)nodes2, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SyntaxNode, CharSequence>($this$joinText){
                final /* synthetic */ ExpandedSyntaxNode $this_joinText;
                {
                    this.$this_joinText = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull SyntaxNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JsonUpdaterKt.access$joinText$text(it, this.$this_joinText);
                }
            }), (int)30, null);
        }
        return string;
    }

    static /* synthetic */ String joinText$default(ExpandedSyntaxNode expandedSyntaxNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return JsonUpdaterKt.joinText(expandedSyntaxNode, bl);
    }

    private static final int similarity(JsonElement jsonElement, SyntaxNode astElement) {
        return JsonUpdaterKt.similarity(astElement, jsonElement);
    }

    /*
     * WARNING - void declaration
     */
    private static final int similarity(SyntaxNode astElement, JsonElement jsonElement) {
        int n;
        if (Intrinsics.areEqual((Object)astElement.getType(), (Object)JsonElementTypes.ARRAY) && jsonElement instanceof JsonArray) {
            if (((JsonArray)jsonElement).isEmpty()) {
                n = 100;
            } else {
                Sequence<SyntaxNode> sequence = TreeWalkerUtilsKt.jsonArrayItemsCursor(astElement);
                Intrinsics.checkNotNull(sequence);
                List oldValues = SequencesKt.toList(sequence);
                int arraySimilarity2 = ((Number)HungarianMethodKt.computeMappingMaximizing((Collection)jsonElement, oldValues, similarity.arraySimilarity.1.INSTANCE).getSecond()).intValue();
                n = arraySimilarity2 / ((JsonArray)jsonElement).size();
            }
        } else if (Intrinsics.areEqual((Object)astElement.getType(), (Object)JsonElementTypes.OBJECT) && jsonElement instanceof JsonObject) {
            void $this$associateTo$iv$iv;
            int objectSimilarity = 0;
            Sequence<JsonObjectProperty> sequence = TreeWalkerUtilsKt.jsonObjectPropertiesCursorOrNull(astElement);
            Intrinsics.checkNotNull(sequence);
            Sequence<JsonObjectProperty> $this$associate$iv = sequence;
            boolean $i$f$associate2 = false;
            Sequence<JsonObjectProperty> sequence2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                JsonObjectProperty it = (JsonObjectProperty)element$iv$iv;
                boolean bl = false;
                String string = TreeWalkerUtilsKt.asJsonString(it.getKeyNode());
                Intrinsics.checkNotNull((Object)string);
                Pair pair = TuplesKt.to((Object)string, (Object)it.getValueNode());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map key2ValueNode = destination$iv$iv;
            for (Map.Entry $i$f$associate2 : ((JsonObject)jsonElement).entrySet()) {
                String key = (String)$i$f$associate2.getKey();
                JsonElement value = (JsonElement)$i$f$associate2.getValue();
                if (!key2ValueNode.containsKey(key)) continue;
                Object v = key2ValueNode.get(key);
                Intrinsics.checkNotNull(v);
                objectSimilarity += JsonUpdaterKt.similarity((SyntaxNode)v, value);
            }
            n = objectSimilarity / ((JsonObject)jsonElement).size();
        } else if (TreeWalkerUtilsKt.isJsonPrimitiveLiteral(astElement) && jsonElement instanceof JsonPrimitive) {
            int primitiveSimilarity = 0;
            CharSequence astText = StringsKt.removeSuffix((CharSequence)StringsKt.removePrefix((CharSequence)astElement.getText(), (CharSequence)"\""), (CharSequence)"\"");
            String jsonText = ((JsonPrimitive)jsonElement).getContent();
            int n2 = Math.min(astText.length(), jsonText.length());
            for (int i = 0; i < n2; ++i) {
                if (astText.charAt(i) != jsonText.charAt(i)) continue;
                primitiveSimilarity += 2;
            }
            n = primitiveSimilarity * 1000000 / (astText.length() + jsonText.length());
        } else {
            n = 0;
        }
        return n;
    }

    private static final long getJsonConfigUpdateOperation$toReal(long $this$getJsonConfigUpdateOperation_u24toReal, long shift) {
        return $this$getJsonConfigUpdateOperation_u24toReal + shift;
    }

    private static final CharSequence joinText$text(SyntaxNode $this$joinText_u24text, ExpandedSyntaxNode $this_joinText) {
        SyntaxNode syntaxNode = $this$joinText_u24text;
        return Intrinsics.areEqual((Object)syntaxNode, (Object)$this_joinText.getStartNode()) ? StringsKt.drop((CharSequence)$this$joinText_u24text.getText(), (int)((int)($this_joinText.getStartOffset() - $this$joinText_u24text.getStartOffset()))) : (Intrinsics.areEqual((Object)syntaxNode, (Object)$this_joinText.getEndNode()) ? StringsKt.dropLast((CharSequence)$this$joinText_u24text.getText(), (int)((int)($this$joinText_u24text.getEndOffset() - $this_joinText.getEndOffset()))) : $this$joinText_u24text.getText());
    }

    public static final /* synthetic */ int access$similarity(JsonElement jsonElement, SyntaxNode astElement) {
        return JsonUpdaterKt.similarity(jsonElement, astElement);
    }

    public static final /* synthetic */ CharSequence access$joinText$text(SyntaxNode $receiver, ExpandedSyntaxNode $this_joinText) {
        return JsonUpdaterKt.joinText$text($receiver, $this_joinText);
    }

    static {
        KLoggers this_$iv = KLoggers.INSTANCE;
        boolean $i$f$logger = false;
        Function0 nameSource$iv = special$$inlined$logger$1.INSTANCE;
        logger = this_$iv.logger(KLoggersKt.loggerNameFromSource((Function0)nameSource$iv));
    }
}

