/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko;

import fleet.util.logging.KLogger;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.windowManagement.api.ClipboardContent;
import noria.windowManagement.api.ClipboardFormat;
import noria.windowManagement.impl.skiko.ClipboardFormatImpl;
import noria.windowManagement.impl.skiko.ClipboardImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnoria/windowManagement/impl/skiko/ClipboardContentImpl;", "Lnoria/windowManagement/api/ClipboardContent;", "transferable", "Ljava/awt/datatransfer/Transferable;", "<init>", "(Ljava/awt/datatransfer/Transferable;)V", "getForFormat", "T", "format", "Lnoria/windowManagement/api/ClipboardFormat;", "(Lnoria/windowManagement/api/ClipboardFormat;)Ljava/lang/Object;", "isFormatSupported", "", "fleet.noria.windowManagement.impl"})
@SourceDebugExtension(value={"SMAP\nClipboardImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClipboardImpl.kt\nnoria/windowManagement/impl/skiko/ClipboardContentImpl\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,170:1\n30#2,2:171\n*S KotlinDebug\n*F\n+ 1 ClipboardImpl.kt\nnoria/windowManagement/impl/skiko/ClipboardContentImpl\n*L\n57#1:171,2\n*E\n"})
final class ClipboardContentImpl
implements ClipboardContent {
    @NotNull
    private final Transferable transferable;

    public ClipboardContentImpl(@NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        this.transferable = transferable;
    }

    @Nullable
    public <T> T getForFormat(@NotNull ClipboardFormat<T> format) {
        block6: {
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (!(format instanceof ClipboardFormatImpl)) {
                throw new IllegalArgumentException("Unexpected clipboard format: " + format);
            }
            try {
                if (this.transferable.isDataFlavorSupported(((ClipboardFormatImpl)format).getDataFlavor())) {
                    Object object;
                    Object content = this.transferable.getTransferData(((ClipboardFormatImpl)format).getDataFlavor());
                    if (((ClipboardFormatImpl)format).getCustom()) {
                        Intrinsics.checkNotNull((Object)content, (String)"null cannot be cast to non-null type java.io.InputStream");
                        object = ByteStreamsKt.readBytes((InputStream)((InputStream)content));
                    } else {
                        object = ((ClipboardFormatImpl)format).getClazz().isInstance(content) ? content : null;
                    }
                    return (T)object;
                }
            }
            catch (IOException e) {
                KLogger this_$iv = ClipboardImpl.INSTANCE.getLogger$fleet_noria_windowManagement_impl();
                boolean $i$f$debug = false;
                if (!this_$iv.isDebugEnabled()) break block6;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Failed to retrieve clipboard content for " + ((ClipboardFormatImpl)format).getDataFlavor();
                kLogger.debug(throwable, (Object)string);
            }
        }
        return null;
    }

    public <T> boolean isFormatSupported(@NotNull ClipboardFormat<T> format) {
        Intrinsics.checkNotNullParameter(format, (String)"format");
        if (!(format instanceof ClipboardFormatImpl)) {
            throw new IllegalArgumentException("unexpected clipboard format: " + format);
        }
        return this.transferable.isDataFlavorSupported(((ClipboardFormatImpl)format).getDataFlavor());
    }
}

