/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.desktop;

import fleet.dock.impl.FleetProtocolHandlerKt;
import fleet.util.os.Os;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"showDockErrorAndWait", "", "dockVersion", "", "throwable", "", "openUrl", "url", "fleet.dock.desktop"})
public final class DockErrorViewKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void showDockErrorAndWait(@NotNull String dockVersion, @NotNull Throwable throwable) {
        JLabel jLabel;
        Throwable throwable2;
        Intrinsics.checkNotNullParameter((Object)dockVersion, (String)"dockVersion");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (Intrinsics.areEqual((Object)throwable.getMessage(), (Object)"event loop completed exceptionally")) {
            throwable2 = throwable.getCause();
            if (throwable2 == null) {
                throwable2 = throwable;
            }
        } else {
            throwable2 = throwable;
        }
        Throwable relevantThrowable = throwable2;
        Object[] objectArray = new String[]{relevantThrowable.getMessage(), throwable.getMessage(), ""};
        String errorText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + ExceptionsKt.stackTraceToString((Throwable)relevantThrowable);
        JFrame frame = new JFrame("Fleet Cannot Start");
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(680, 460));
        frame.setLayout(new BorderLayout());
        JLabel $this$showDockErrorAndWait_u24lambda_u240 = jLabel = new JLabel("Fleet Cannot Start");
        boolean bl = false;
        $this$showDockErrorAndWait_u24lambda_u240.setFont(new Font("Inter", 0, 18));
        JLabel titleLabel = jLabel;
        $this$showDockErrorAndWait_u24lambda_u240 = new JLabel("Fleet " + dockVersion + " cannot start because of the following error:");
        JComponent $this$showDockErrorAndWait_u24lambda_u241 = $this$showDockErrorAndWait_u24lambda_u240;
        boolean bl2 = false;
        $this$showDockErrorAndWait_u24lambda_u241.setFont(new Font("Inter", 0, 13));
        JLabel errorLabel = $this$showDockErrorAndWait_u24lambda_u240;
        JComponent $this$showDockErrorAndWait_u24lambda_u242 = $this$showDockErrorAndWait_u24lambda_u241 = new JPanel();
        boolean bl3 = false;
        $this$showDockErrorAndWait_u24lambda_u242.setLayout(new BoxLayout($this$showDockErrorAndWait_u24lambda_u242, 1));
        $this$showDockErrorAndWait_u24lambda_u242.add(titleLabel);
        $this$showDockErrorAndWait_u24lambda_u242.add(Box.createVerticalStrut(10));
        $this$showDockErrorAndWait_u24lambda_u242.add(errorLabel);
        JComponent descPanel = $this$showDockErrorAndWait_u24lambda_u241;
        JComponent $this$showDockErrorAndWait_u24lambda_u243 = $this$showDockErrorAndWait_u24lambda_u242 = new JTextArea();
        boolean bl4 = false;
        ((JTextComponent)$this$showDockErrorAndWait_u24lambda_u243).setText(StringsKt.replace$default((String)errorText, (String)"\t", (String)" ", (boolean)false, (int)4, null));
        ((JTextComponent)$this$showDockErrorAndWait_u24lambda_u243).setEditable(false);
        ((JTextArea)$this$showDockErrorAndWait_u24lambda_u243).setFont(new Font("Inter", 0, 13));
        JComponent errorDetails = $this$showDockErrorAndWait_u24lambda_u242;
        JScrollPane scrollPane = new JScrollPane(errorDetails);
        scrollPane.setVerticalScrollBarPolicy(22);
        JButton $this$showDockErrorAndWait_u24lambda_u246 = bl4 = new JButton("Report\u2026");
        boolean $i$a$-apply-DockErrorViewKt$showDockErrorAndWait$reportButton$22 = false;
        $this$showDockErrorAndWait_u24lambda_u246.addActionListener(arg_0 -> DockErrorViewKt.showDockErrorAndWait$lambda$6$lambda$5(errorText, relevantThrowable, dockVersion, arg_0));
        JButton reportButton = bl4;
        Object lock = new Object();
        JButton $i$a$-apply-DockErrorViewKt$showDockErrorAndWait$reportButton$22 = new JButton("Ignore");
        JComponent $this$showDockErrorAndWait_u24lambda_u249 = $i$a$-apply-DockErrorViewKt$showDockErrorAndWait$reportButton$22;
        boolean bl5 = false;
        ((AbstractButton)$this$showDockErrorAndWait_u24lambda_u249).addActionListener(arg_0 -> DockErrorViewKt.showDockErrorAndWait$lambda$9$lambda$8(frame, lock, arg_0));
        JButton ignoreButton = $i$a$-apply-DockErrorViewKt$showDockErrorAndWait$reportButton$22;
        JComponent $this$showDockErrorAndWait_u24lambda_u2410 = $this$showDockErrorAndWait_u24lambda_u249 = new JPanel(new FlowLayout(2));
        boolean bl6 = false;
        $this$showDockErrorAndWait_u24lambda_u2410.add(ignoreButton);
        $this$showDockErrorAndWait_u24lambda_u2410.add(reportButton);
        JComponent buttonPanel = $this$showDockErrorAndWait_u24lambda_u249;
        Object object = new JPanel(new BorderLayout());
        JPanel $this$showDockErrorAndWait_u24lambda_u2411 = object;
        boolean bl7 = false;
        $this$showDockErrorAndWait_u24lambda_u2411.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        $this$showDockErrorAndWait_u24lambda_u2411.add((Component)descPanel, "North");
        $this$showDockErrorAndWait_u24lambda_u2411.add((Component)scrollPane, "Center");
        $this$showDockErrorAndWait_u24lambda_u2411.add((Component)buttonPanel, "South");
        JPanel contentPanel = object;
        frame.add(contentPanel);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(lock){
            final /* synthetic */ Object $lock;
            {
                this.$lock = $lock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = this.$lock;
                Object object2 = this.$lock;
                Object object3 = object;
                synchronized (object3) {
                    boolean bl = false;
                    object2.notify();
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        object = lock;
        synchronized (object) {
            boolean bl8 = false;
            while (frame.isVisible()) {
                lock.wait();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void openUrl(String url) {
        URI uri = new URI(url);
        if (Os.INSTANCE.isLinux()) {
            String string = uri.getScheme();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String protocol = string2;
            if (Intrinsics.areEqual((Object)protocol, (Object)"http") || Intrinsics.areEqual((Object)protocol, (Object)"https")) {
                String[] stringArray = new String[]{"xdg-open", url};
                Runtime.getRuntime().exec(stringArray);
            }
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(uri);
        }
    }

    private static final void showDockErrorAndWait$lambda$6$lambda$5(String $errorText, Throwable $relevantThrowable, String $dockVersion, ActionEvent it) {
        String string;
        String desc = StringsKt.take((String)FleetProtocolHandlerKt.urlEncode((String)$errorText), (int)9000);
        String title = FleetProtocolHandlerKt.urlEncode((String)("Fleet cannot start: " + $relevantThrowable.getMessage()));
        String it2 = string = "&c=Affected%20versions%20" + $dockVersion;
        boolean bl = false;
        String string2 = $dockVersion.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        Object object = !StringsKt.endsWith$default((String)string2, (String)"snapshot", (boolean)false, (int)2, null) ? string : null;
        if (object == null) {
            object = "";
        }
        String affectedVersionParameter = object;
        Os.Type type = Os.INSTANCE.getType();
        String platformName = switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> "Linux";
            case 2 -> "macOS";
            case 3 -> "Windows";
            default -> "";
        };
        String platform = "&c=Platform%20" + FleetProtocolHandlerKt.urlEncode((String)platformName);
        String url = "https://youtrack.jetbrains.com/newIssue?project=FL&" + affectedVersionParameter + platform + "&clearDraft=true&summary=" + title + "&description=" + desc;
        DockErrorViewKt.openUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void showDockErrorAndWait$lambda$9$lambda$8(JFrame $frame, Object $lock, ActionEvent it) {
        $frame.dispose();
        Object object = $lock;
        synchronized (object) {
            boolean bl = false;
            $lock.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

