/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.awt.Color;
import java.awt.Toolkit;
import kotlin.Metadata;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"calculateActiveBorderColor", "Ljava/awt/Color;", "focused", "", "calculateAffectsBorders", "getWindowsReleaseId", "", "fleet.noria.windowManagement.impl"})
public final class CustomHeaderKt {
    private static final boolean calculateAffectsBorders() {
        int windowsVersion;
        Object object = CustomHeaderKt.getWindowsReleaseId();
        int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (windowsVersion = 0);
        if (windowsVersion < 1809) {
            return true;
        }
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.dwm.colorizationColor.affects.borders");
        return bl != null ? bl : true;
    }

    private static final String getWindowsReleaseId() {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", (String)"ReleaseId");
        }
        catch (Win32Exception e) {
            return null;
        }
    }

    @NotNull
    public static final Color calculateActiveBorderColor(boolean focused) {
        Color inactiveColor = new Color(0xAAAAAA);
        Color defaultActiveColor = new Color(0x707070);
        if (!focused) {
            return inactiveColor;
        }
        if (!CustomHeaderKt.calculateAffectsBorders()) {
            return defaultActiveColor;
        }
        try {
            Integer colorizationColorBalance;
            Toolkit $this$calculateActiveBorderColor_u24lambda_u240 = Toolkit.getDefaultToolkit();
            boolean bl = false;
            Color colorizationColor = (Color)$this$calculateActiveBorderColor_u24lambda_u240.getDesktopProperty("win.dwm.colorizationColor");
            if (colorizationColor != null && (colorizationColorBalance = (Integer)$this$calculateActiveBorderColor_u24lambda_u240.getDesktopProperty("win.dwm.colorizationColorBalance")) != null) {
                if (colorizationColorBalance > 100) {
                    colorizationColorBalance = 100;
                }
                if (colorizationColorBalance < 0) {
                    colorizationColorBalance = 100;
                }
                return switch (colorizationColorBalance) {
                    case 0 -> new Color(0xD9D9D9);
                    case 100 -> colorizationColor;
                    default -> {
                        float alpha = (float)colorizationColorBalance.intValue() / 100.0f;
                        float remainder = 1.0f - alpha;
                        int r = MathKt.roundToInt((float)((float)colorizationColor.getRed() * alpha + (float)217 * remainder));
                        int g = MathKt.roundToInt((float)((float)colorizationColor.getGreen() * alpha + (float)217 * remainder));
                        int b = MathKt.roundToInt((float)((float)colorizationColor.getBlue() * alpha + (float)217 * remainder));
                        yield new Color(r, g, b);
                    }
                };
            }
            Color color = colorizationColor;
            if (color == null && (color = (Color)$this$calculateActiveBorderColor_u24lambda_u240.getDesktopProperty("win.frame.activeBorderColor")) == null) {
                color = defaultActiveColor;
            }
            return color;
        }
        catch (Throwable t) {
            return defaultActiveColor;
        }
    }
}

