/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.utils;

import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/research/testspark/core/utils/DataFilesUtil;", "", "()V", "Companion", "core"})
public final class DataFilesUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/research/testspark/core/utils/DataFilesUtil$Companion;", "", "()V", "classpathSeparator", "", "getClasspathSeparator", "()C", "cleanFolder", "", "path", "", "isWindows", "", "makeDir", "makeTmp", "tempDir", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void makeTmp(@NotNull String tempDir) {
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            char sep = File.separatorChar;
            String testResultDirectory = tempDir + sep + "testSparkResults" + sep;
            File tmpDir = new File(testResultDirectory);
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
        }

        public final void makeDir(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }

        public final void cleanFolder(@NotNull String path) {
            File[] files;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File folder = new File(path);
            if (!folder.exists()) {
                return;
            }
            if (folder.isDirectory() && (files = folder.listFiles()) != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        String string = file.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                        this.cleanFolder(string);
                        continue;
                    }
                    file.delete();
                }
            }
            folder.delete();
        }

        public final char getClasspathSeparator() {
            char sep = ':';
            if (this.isWindows()) {
                sep = ';';
            }
            return sep;
        }

        public final boolean isWindows() {
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String os = string3;
            return StringsKt.indexOf$default((CharSequence)os, (String)"win", (int)0, (boolean)false, (int)6, null) >= 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

