/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.generation.llm.network;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.research.testspark.core.data.ChatMessage;
import org.jetbrains.research.testspark.core.generation.llm.network.LLMResponse;
import org.jetbrains.research.testspark.core.generation.llm.network.RequestManager;
import org.jetbrains.research.testspark.core.generation.llm.network.ResponseErrorCode;
import org.jetbrains.research.testspark.core.progress.CustomProgressIndicator;
import org.jetbrains.research.testspark.core.test.TestsAssembler;
import org.jetbrains.research.testspark.core.test.data.TestSuiteGeneratedByLLM;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J2\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0004\u00a8\u0006 "}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/network/RequestManager;", "", "token", "", "(Ljava/lang/String;)V", "chatHistory", "", "Lorg/jetbrains/research/testspark/core/data/ChatMessage;", "getChatHistory", "()Ljava/util/List;", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "getLog", "()Lio/github/oshai/kotlinlogging/KLogger;", "getToken", "()Ljava/lang/String;", "setToken", "processResponse", "Lorg/jetbrains/research/testspark/core/generation/llm/network/LLMResponse;", "testsAssembler", "Lorg/jetbrains/research/testspark/core/test/TestsAssembler;", "packageName", "processUserFeedbackResponse", "request", "prompt", "indicator", "Lorg/jetbrains/research/testspark/core/progress/CustomProgressIndicator;", "isUserFeedback", "", "send", "Lorg/jetbrains/research/testspark/core/generation/llm/network/RequestManager$SendResult;", "SendResult", "core"})
public abstract class RequestManager {
    @NotNull
    private String token;
    @NotNull
    private final List<ChatMessage> chatHistory;
    @NotNull
    private final KLogger log;

    public RequestManager(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token = token;
        this.chatHistory = new ArrayList();
        this.log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public final void setToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.token = string;
    }

    @NotNull
    public final List<ChatMessage> getChatHistory() {
        return this.chatHistory;
    }

    @NotNull
    protected final KLogger getLog() {
        return this.log;
    }

    @NotNull
    public LLMResponse request(@NotNull String prompt, @NotNull CustomProgressIndicator indicator, @NotNull String packageName, @NotNull TestsAssembler testsAssembler, boolean isUserFeedback) {
        LLMResponse lLMResponse;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)testsAssembler, (String)"testsAssembler");
        this.chatHistory.add(new ChatMessage("user", prompt));
        this.log.info((Function0)request.1.INSTANCE);
        SendResult sendResult = this.send(prompt, indicator, testsAssembler);
        if (sendResult == SendResult.PROMPT_TOO_LONG) {
            return new LLMResponse(ResponseErrorCode.PROMPT_TOO_LONG, null);
        }
        if (isUserFeedback) {
            CollectionsKt.removeLast(this.chatHistory);
        }
        if (bl = isUserFeedback) {
            lLMResponse = this.processUserFeedbackResponse(testsAssembler, packageName);
        } else if (!bl) {
            lLMResponse = this.processResponse(testsAssembler, packageName);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lLMResponse;
    }

    public static /* synthetic */ LLMResponse request$default(RequestManager requestManager, String string, CustomProgressIndicator customProgressIndicator, String string2, TestsAssembler testsAssembler, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: request");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return requestManager.request(string, customProgressIndicator, string2, testsAssembler, bl);
    }

    @NotNull
    public LLMResponse processResponse(@NotNull TestsAssembler testsAssembler, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)testsAssembler, (String)"testsAssembler");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String response = testsAssembler.getContent();
        this.log.info((Function0)new Function0<Object>(response){
            final /* synthetic */ String $response;
            {
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "The full response: \n " + this.$response;
            }
        });
        this.chatHistory.add(new ChatMessage("assistant", response));
        if (((CharSequence)response).length() == 0 || StringsKt.isBlank((CharSequence)response)) {
            return new LLMResponse(ResponseErrorCode.EMPTY_LLM_RESPONSE, null);
        }
        TestSuiteGeneratedByLLM testSuiteGeneratedByLLM = testsAssembler.assembleTestSuite(packageName);
        return testSuiteGeneratedByLLM == null ? new LLMResponse(ResponseErrorCode.TEST_SUITE_PARSING_FAILURE, null) : new LLMResponse(ResponseErrorCode.OK, testSuiteGeneratedByLLM.reformat());
    }

    @NotNull
    public abstract SendResult send(@NotNull String var1, @NotNull CustomProgressIndicator var2, @NotNull TestsAssembler var3);

    @NotNull
    public LLMResponse processUserFeedbackResponse(@NotNull TestsAssembler testsAssembler, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)testsAssembler, (String)"testsAssembler");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String response = testsAssembler.getContent();
        this.log.info((Function0)new Function0<Object>(response){
            final /* synthetic */ String $response;
            {
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "The full response: \n " + this.$response;
            }
        });
        if (((CharSequence)response).length() == 0 || StringsKt.isBlank((CharSequence)response)) {
            return new LLMResponse(ResponseErrorCode.EMPTY_LLM_RESPONSE, null);
        }
        TestSuiteGeneratedByLLM testSuiteGeneratedByLLM = testsAssembler.assembleTestSuite(packageName);
        return testSuiteGeneratedByLLM == null ? new LLMResponse(ResponseErrorCode.TEST_SUITE_PARSING_FAILURE, null) : new LLMResponse(ResponseErrorCode.OK, testSuiteGeneratedByLLM);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/network/RequestManager$SendResult;", "", "(Ljava/lang/String;I)V", "OK", "PROMPT_TOO_LONG", "OTHER", "core"})
    public static final class SendResult
    extends Enum<SendResult> {
        public static final /* enum */ SendResult OK = new SendResult();
        public static final /* enum */ SendResult PROMPT_TOO_LONG = new SendResult();
        public static final /* enum */ SendResult OTHER = new SendResult();
        private static final /* synthetic */ SendResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SendResult[] values() {
            return (SendResult[])$VALUES.clone();
        }

        public static SendResult valueOf(String value) {
            return Enum.valueOf(SendResult.class, value);
        }

        @NotNull
        public static EnumEntries<SendResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sendResultArray = new SendResult[]{SendResult.OK, SendResult.PROMPT_TOO_LONG, SendResult.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

