/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.stemmer.snowball;

import ai.grazie.nlp.stemmer.snowball.SnowballAmong;
import ai.grazie.utils.StringBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\u0013\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0004J\u0018\u0010\u001b\u001a\u00060\u001dj\u0002`\u001e2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0000H\u0004J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020%H\u0004J\u0018\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020%H\u0004J\u0010\u0010'\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020(H\u0004J\u0010\u0010)\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020(H\u0004J%\u0010*\u001a\u00020\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b/\u00100J%\u00101\u001a\u00020\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b2\u00100J\b\u0010\u000b\u001a\u00020%H\u0004J \u00103\u001a\u00020#2\u0006\u0010\u001c\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J \u00107\u001a\u00020#2\u0006\u0010\u001c\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J\u0018\u00108\u001a\u00020#2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J\u0018\u00109\u001a\u00020#2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J \u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020(H\u0004J \u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020%H\u0004J \u0010=\u001a\u00020#2\u0006\u0010\u001c\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J \u0010>\u001a\u00020#2\u0006\u0010\u001c\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J\u0018\u0010?\u001a\u00020#2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J\u0018\u0010@\u001a\u00020#2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0004J \u0010A\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020%H\u0002J\u0010\u0010\r\u001a\u00020 2\u0006\u0010B\u001a\u00020%H\u0004J\b\u0010C\u001a\u00020 H\u0002J\b\u0010D\u001a\u00020 H\u0004J\u0010\u0010E\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020(H\u0004J\u0010\u0010E\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020%H\u0004J\u0010\u0010F\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0004J\u0018\u0010F\u001a\u00060\u001dj\u0002`\u001e2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\b\u00a8\u0006G"}, d2={"Lai/grazie/nlp/stemmer/snowball/SnowballProgram;", "", "()V", "bra", "", "getBra", "()I", "setBra", "(I)V", "current", "Lai/grazie/utils/StringBuffer;", "getCurrent", "()Lai/grazie/utils/StringBuffer;", "setCurrent", "(Lai/grazie/utils/StringBuffer;)V", "cursor", "getCursor", "setCursor", "ket", "getKet", "setKet", "limit", "getLimit", "setLimit", "limit_backward", "getLimit_backward", "setLimit_backward", "assign_to", "s", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "copy_from", "", "other", "eq_s", "", "s_size", "", "eq_s_b", "eq_v", "", "eq_v_b", "find_among", "v", "", "Lai/grazie/nlp/stemmer/snowball/SnowballAmong;", "v_size", "find_among$nlp_stemmer", "([Lai/grazie/nlp/stemmer/snowball/SnowballAmong;I)I", "find_among_b", "find_among_b$nlp_stemmer", "in_grouping", "", "min", "max", "in_grouping_b", "in_range", "in_range_b", "insert", "c_bra", "c_ket", "out_grouping", "out_grouping_b", "out_range", "out_range_b", "replace_s", "value", "slice_check", "slice_del", "slice_from", "slice_to", "nlp-stemmer"})
public class SnowballProgram {
    @NotNull
    private StringBuffer current = new StringBuffer();
    private int cursor;
    private int limit;
    private int limit_backward;
    private int bra;
    private int ket;

    protected SnowballProgram() {
        this.setCurrent("");
    }

    protected final void setCurrent(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.current.replace(0, this.current.length(), value);
        this.cursor = 0;
        this.limit = this.current.length();
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    @NotNull
    protected final String getCurrent() {
        String result = this.current.toString();
        this.current = new StringBuffer();
        return result;
    }

    @NotNull
    protected final StringBuffer getCurrent() {
        return this.current;
    }

    protected final void setCurrent(@NotNull StringBuffer stringBuffer) {
        Intrinsics.checkNotNullParameter((Object)stringBuffer, (String)"<set-?>");
        this.current = stringBuffer;
    }

    protected final int getCursor() {
        return this.cursor;
    }

    protected final void setCursor(int n) {
        this.cursor = n;
    }

    protected final int getLimit() {
        return this.limit;
    }

    protected final void setLimit(int n) {
        this.limit = n;
    }

    protected final int getLimit_backward() {
        return this.limit_backward;
    }

    protected final void setLimit_backward(int n) {
        this.limit_backward = n;
    }

    protected final int getBra() {
        return this.bra;
    }

    protected final void setBra(int n) {
        this.bra = n;
    }

    protected final int getKet() {
        return this.ket;
    }

    protected final void setKet(int n) {
        this.ket = n;
    }

    protected final void copy_from(@NotNull SnowballProgram other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.current = other.current;
        this.cursor = other.cursor;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected final boolean in_grouping(@NotNull char[] s, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current.charAt(this.cursor);
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - (char)min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        int n = this.cursor;
        this.cursor = n + 1;
        return true;
    }

    protected final boolean in_grouping_b(@NotNull char[] s, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current.charAt(this.cursor - 1);
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - (char)min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        int n = this.cursor;
        this.cursor = n + -1;
        return true;
    }

    protected final boolean out_grouping(@NotNull char[] s, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current.charAt(this.cursor);
        if (ch > max || ch < min) {
            int n = this.cursor;
            this.cursor = n + 1;
            return true;
        }
        if ((s[(ch = (char)(ch - (char)min)) >> 3] & 1 << (ch & 7)) == 0) {
            int n = this.cursor;
            this.cursor = n + 1;
            return true;
        }
        return false;
    }

    protected final boolean out_grouping_b(@NotNull char[] s, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current.charAt(this.cursor - 1);
        if (ch > max || ch < min) {
            int n = this.cursor;
            this.cursor = n + -1;
            return true;
        }
        if ((s[(ch = (char)(ch - (char)min)) >> 3] & 1 << (ch & 7)) == 0) {
            int n = this.cursor;
            this.cursor = n + -1;
            return true;
        }
        return false;
    }

    protected final boolean in_range(int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current.charAt(this.cursor);
        if (ch > max || ch < min) {
            return false;
        }
        int n = this.cursor;
        this.cursor = n + 1;
        return true;
    }

    protected final boolean in_range_b(int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current.charAt(this.cursor - 1);
        if (ch > max || ch < min) {
            return false;
        }
        int n = this.cursor;
        this.cursor = n + -1;
        return true;
    }

    protected final boolean out_range(int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current.charAt(this.cursor);
        if (ch <= max && ch >= min) {
            return false;
        }
        int n = this.cursor;
        this.cursor = n + 1;
        return true;
    }

    protected final boolean out_range_b(int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current.charAt(this.cursor - 1);
        if (ch <= max && ch >= min) {
            return false;
        }
        int n = this.cursor;
        this.cursor = n + -1;
        return true;
    }

    protected final boolean eq_s(int s_size, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.limit - this.cursor < s_size) {
            return false;
        }
        for (int i = 0; i != s_size; ++i) {
            if (this.current.charAt(this.cursor + i) == s.charAt(i)) continue;
            return false;
        }
        this.cursor += s_size;
        return true;
    }

    protected final boolean eq_s_b(int s_size, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.cursor - this.limit_backward < s_size) {
            return false;
        }
        for (int i = 0; i != s_size; ++i) {
            if (this.current.charAt(this.cursor - s_size + i) == s.charAt(i)) continue;
            return false;
        }
        this.cursor -= s_size;
        return true;
    }

    protected final boolean eq_v(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.eq_s(s.length(), ((Object)s).toString());
    }

    protected final boolean eq_v_b(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.eq_s_b(s.length(), ((Object)s).toString());
    }

    public final int find_among$nlp_stemmer(@NotNull SnowballAmong[] v, int v_size) {
        SnowballAmong w;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int i = 0;
        int j = v_size;
        int c = this.cursor;
        int l = this.limit;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            SnowballAmong w2 = v[k];
            for (int i2 = common; i2 < w2.getSearchSize(); ++i2) {
                if (c + common == l) {
                    diff = -1;
                    break;
                }
                diff = this.current.charAt(c + common) - w2.getSearchString()[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            if (common_i < (w = v[i]).getSearchSize()) continue;
            this.cursor = c + w.getSearchSize();
            return w.getResult();
        } while ((i = w.getSubstringI()) >= 0);
        return 0;
    }

    public final int find_among_b$nlp_stemmer(@NotNull SnowballAmong[] v, int v_size) {
        SnowballAmong w;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int i = 0;
        int j = v_size;
        int c = this.cursor;
        int lb = this.limit_backward;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            SnowballAmong w2 = v[k];
            for (int i2 = w2.getSearchSize() - 1 - common; i2 >= 0; --i2) {
                if (c - common == lb) {
                    diff = -1;
                    break;
                }
                diff = this.current.charAt(c - 1 - common) - w2.getSearchString()[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            if (common_i < (w = v[i]).getSearchSize()) continue;
            this.cursor = c - w.getSearchSize();
            return w.getResult();
        } while ((i = w.getSubstringI()) >= 0);
        return 0;
    }

    private final int replace_s(int c_bra, int c_ket, String s) {
        int adjustment = s.length() - (c_ket - c_bra);
        this.current.replace(c_bra, c_ket, s);
        this.limit += adjustment;
        if (this.cursor >= c_ket) {
            this.cursor += adjustment;
        } else if (this.cursor > c_bra) {
            this.cursor = c_bra;
        }
        return adjustment;
    }

    private final void slice_check() {
        if (this.bra < 0 || this.bra > this.ket || this.ket > this.limit || this.limit > this.current.length()) {
            System.out.println((Object)"faulty slice operation");
        }
    }

    protected final void slice_from(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.slice_check();
        this.replace_s(this.bra, this.ket, s);
    }

    protected final void slice_from(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.slice_from(((Object)s).toString());
    }

    protected final void slice_del() {
        this.slice_from("");
    }

    protected final void insert(int c_bra, int c_ket, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int adjustment = this.replace_s(c_bra, c_ket, s);
        if (c_bra <= this.bra) {
            this.bra += adjustment;
        }
        if (c_bra <= this.ket) {
            this.ket += adjustment;
        }
    }

    protected final void insert(int c_bra, int c_ket, @NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.insert(c_bra, c_ket, ((Object)s).toString());
    }

    @NotNull
    protected final StringBuffer slice_to(@NotNull StringBuffer s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.slice_check();
        s.replace(0, s.length(), ((Object)((CharSequence)this.current).subSequence(this.bra, this.ket)).toString());
        return s;
    }

    @NotNull
    protected final StringBuilder slice_to(@NotNull StringBuilder s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.slice_check();
        s.replace(0, s.length(), ((Object)((CharSequence)this.current).subSequence(this.bra, this.ket)).toString());
        return s;
    }

    @NotNull
    protected final StringBuffer assign_to(@NotNull StringBuffer s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        s.replace(0, s.length(), ((Object)((CharSequence)this.current).subSequence(0, this.limit)).toString());
        return s;
    }

    @NotNull
    protected final StringBuilder assign_to(@NotNull StringBuilder s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        s.replace(0, s.length(), ((Object)((CharSequence)this.current).subSequence(0, this.limit)).toString());
        return s;
    }
}

