/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.run.impl.terminal;

import fleet.api.exec.Line;
import fleet.api.exec.LineShellMarker;
import fleet.api.exec.ShellMarker;
import fleet.util.ImmutableExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\nH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u001c\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010$0\u00192\u0006\u0010\u001a\u001a\u00020$J&\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010$0\u00192\u0006\u0010\u001a\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u001a\u0010'\u001a\u00020$*\u00020$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006+"}, d2={"Lfleet/workspace/run/impl/terminal/TerminalPwshLineTransformer;", "", "()V", "isWaitForCommand", "", "isLastWrapped", "markersQueue", "Lkotlinx/collections/immutable/PersistentList;", "Lfleet/api/exec/LineShellMarker;", "columnShift", "", "screenWidth", "(ZZLkotlinx/collections/immutable/PersistentList;II)V", "getColumnShift", "()I", "()Z", "getMarkersQueue", "()Lkotlinx/collections/immutable/PersistentList;", "getScreenWidth", "component1", "component2", "component3", "component4", "component5", "consumeCommandToken", "Lkotlin/Pair;", "line", "", "consumeMarkerLine", "copy", "equals", "other", "hashCode", "toString", "", "transform", "Lfleet/api/exec/Line;", "tryApplyMarkers", "text", "applyMarkers", "markers", "", "Companion", "fleet.run.workspace"})
@SourceDebugExtension(value={"SMAP\nTerminalPwshLineTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPwshLineTransformer.kt\nfleet/workspace/run/impl/terminal/TerminalPwshLineTransformer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 ImmutableEx.kt\nfleet/util/ImmutableExKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n151#2,6:176\n8#3:182\n1726#4,3:183\n959#4,7:186\n1549#4:193\n1620#4,3:194\n1549#4:197\n1620#4,3:198\n766#4:201\n857#4,2:202\n*S KotlinDebug\n*F\n+ 1 TerminalPwshLineTransformer.kt\nfleet/workspace/run/impl/terminal/TerminalPwshLineTransformer\n*L\n105#1:176,6\n121#1:182\n141#1:183,3\n146#1:186,7\n150#1:193\n150#1:194,3\n154#1:197\n154#1:198,3\n160#1:201\n160#1:202,2\n*E\n"})
public final class TerminalPwshLineTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isWaitForCommand;
    private final boolean isLastWrapped;
    @NotNull
    private final PersistentList<PersistentList<LineShellMarker>> markersQueue;
    private final int columnShift;
    private final int screenWidth;
    @NotNull
    public static final String PROMPT_MARKER = "\u00a0]133;A";
    @NotNull
    public static final String OUTPUT_MARKER = "\u00a0]133;C";

    public TerminalPwshLineTransformer(boolean isWaitForCommand, boolean isLastWrapped, @NotNull PersistentList<? extends PersistentList<LineShellMarker>> markersQueue, int columnShift, int screenWidth) {
        Intrinsics.checkNotNullParameter(markersQueue, (String)"markersQueue");
        this.isWaitForCommand = isWaitForCommand;
        this.isLastWrapped = isLastWrapped;
        this.markersQueue = markersQueue;
        this.columnShift = columnShift;
        this.screenWidth = screenWidth;
    }

    public final boolean isWaitForCommand() {
        return this.isWaitForCommand;
    }

    public final boolean isLastWrapped() {
        return this.isLastWrapped;
    }

    @NotNull
    public final PersistentList<PersistentList<LineShellMarker>> getMarkersQueue() {
        return this.markersQueue;
    }

    public final int getColumnShift() {
        return this.columnShift;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public TerminalPwshLineTransformer() {
        this(false, false, (PersistentList<? extends PersistentList<LineShellMarker>>)ExtensionsKt.persistentListOf(), 0, 80);
    }

    @NotNull
    public final Pair<TerminalPwshLineTransformer, Line> transform(@NotNull Line line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String text = line.text();
        TerminalPwshLineTransformer transformer = this;
        Pair<TerminalPwshLineTransformer, Boolean> markerLineResult = transformer.consumeMarkerLine(text);
        if (((Boolean)markerLineResult.getSecond()).booleanValue()) {
            return TuplesKt.to((Object)markerLineResult.getFirst(), null);
        }
        transformer = (TerminalPwshLineTransformer)markerLineResult.getFirst();
        if (transformer.isWaitForCommand) {
            Pair<TerminalPwshLineTransformer, Boolean> commandResult = transformer.consumeCommandToken(text);
            if (((Boolean)commandResult.getSecond()).booleanValue()) {
                return TuplesKt.to((Object)commandResult.getFirst(), null);
            }
            transformer = (TerminalPwshLineTransformer)commandResult.getFirst();
        }
        return transformer.tryApplyMarkers(line, text);
    }

    private final Pair<TerminalPwshLineTransformer, Boolean> consumeMarkerLine(CharSequence line) {
        Pair pair;
        if (StringsKt.startsWith$default((CharSequence)line, (CharSequence)PROMPT_MARKER, (boolean)false, (int)2, null)) {
            Object[] objectArray = new PersistentList[1];
            Object[] objectArray2 = new LineShellMarker[]{new LineShellMarker(0, ShellMarker.PROMPT)};
            objectArray[0] = ExtensionsKt.persistentListOf((Object[])objectArray2);
            PersistentList persistentList = ExtensionsKt.persistentListOf((Object[])objectArray);
            TerminalPwshLineTransformer transformer = (TerminalPwshLineTransformer)TerminalPwshLineTransformer.copy$default(this, true, false, persistentList, 7, 0, 16, null).consumeCommandToken(line.subSequence(7, line.length())).getFirst();
            pair = TuplesKt.to((Object)transformer, (Object)true);
        } else if (StringsKt.startsWith$default((CharSequence)line, (CharSequence)OUTPUT_MARKER, (boolean)false, (int)2, null)) {
            Object[] objectArray = new PersistentList[1];
            Object[] objectArray3 = new LineShellMarker[]{new LineShellMarker(0, ShellMarker.OUTPUT)};
            objectArray[0] = ExtensionsKt.persistentListOf((Object[])objectArray3);
            PersistentList persistentList = ExtensionsKt.persistentListOf((Object[])objectArray);
            TerminalPwshLineTransformer transformer = TerminalPwshLineTransformer.copy$default(this, false, false, persistentList, 0, 0, 16, null);
            pair = TuplesKt.to((Object)transformer, (Object)true);
        } else {
            pair = TuplesKt.to((Object)this, (Object)false);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TerminalPwshLineTransformer, Boolean> consumeCommandToken(CharSequence line) {
        Pair pair;
        int n;
        int it;
        int n2;
        block6: {
            CharSequence $this$indexOfFirst$iv = line;
            boolean $i$f$indexOfFirst = false;
            n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block6;
            }
            n = -1;
        }
        int nonSpace = n;
        if (nonSpace == -1) {
            pair = TuplesKt.to((Object)TerminalPwshLineTransformer.copy$default(this, false, false, null, this.columnShift + line.length(), 0, 23, null), (Object)false);
        } else if (!Character.isDigit(line.charAt(nonSpace))) {
            pair = TuplesKt.to((Object)TerminalPwshLineTransformer.copy$default(this, false, false, null, 0, 0, 20, null), (Object)false);
        } else {
            void it2;
            LineShellMarker commandMarker = new LineShellMarker(nonSpace + this.columnShift - 7, ShellMarker.COMMAND);
            int promptLines = line.charAt(nonSpace) - 48;
            PersistentList queue = null;
            queue = this.markersQueue;
            n2 = promptLines - this.markersQueue.size();
            it = 0;
            while (it < n2) {
                int it3 = it++;
                boolean bl = false;
                queue = queue.add((Object)ExtensionsKt.persistentListOf());
            }
            PersistentList $this$updateLast$iv = queue;
            boolean $i$f$updateLast = false;
            PersistentList bl = (PersistentList)$this$updateLast$iv.get(CollectionsKt.getLastIndex((List)((List)$this$updateLast$iv)));
            int n3 = CollectionsKt.getLastIndex((List)((List)$this$updateLast$iv));
            PersistentList persistentList = $this$updateLast$iv;
            boolean bl2 = false;
            PersistentList persistentList2 = it2.add((Object)commandMarker);
            PersistentList persistentList3 = persistentList.set(n3, (Object)persistentList2);
            pair = TuplesKt.to((Object)TerminalPwshLineTransformer.copy$default(this, false, false, persistentList3, 0, 0, 16, null), (Object)true);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TerminalPwshLineTransformer, Line> tryApplyMarkers(Line line, CharSequence text) {
        Pair pair;
        List markers;
        PersistentList persistentList = (PersistentList)CollectionsKt.firstOrNull((List)((List)this.markersQueue));
        List list = markers = persistentList != null ? (List)persistentList : CollectionsKt.emptyList();
        if (markers.isEmpty()) {
            return line.isWrapped() ? TuplesKt.to((Object)this, (Object)line) : TuplesKt.to((Object)TerminalPwshLineTransformer.copy$default(this, false, false, ImmutableExKt.drop(this.markersQueue, (int)1), 0, 0, 27, null), (Object)line);
        }
        if (!this.isLastWrapped && StringsKt.isBlank((CharSequence)text)) {
            boolean bl;
            block11: {
                Iterable $this$all$iv = markers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        LineShellMarker it = (LineShellMarker)element$iv;
                        boolean bl2 = false;
                        if (it.getMarker() != ShellMarker.OUTPUT) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return TuplesKt.to((Object)this, (Object)line);
            }
        }
        if (line.isWrapped()) {
            Collection<LineShellMarker> collection;
            void $this$map$iv;
            Iterable $this$takeWhile$iv = markers;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                LineShellMarker it = (LineShellMarker)item$iv;
                boolean bl = false;
                if (!(it.getColumn() < text.length())) break;
                list$iv.add(item$iv);
            }
            lineMarkers = list$iv;
            $this$takeWhile$iv = CollectionsKt.drop((Iterable)markers, (int)lineMarkers.size());
            int n = 0;
            PersistentList<PersistentList<LineShellMarker>> persistentList2 = this.markersQueue;
            boolean bl = true;
            boolean bl3 = false;
            TerminalPwshLineTransformer terminalPwshLineTransformer = this;
            boolean $i$f$map = false;
            list$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LineShellMarker lineShellMarker = (LineShellMarker)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(LineShellMarker.copy$default((LineShellMarker)it, (int)(it.getColumn() - text.length()), null, (int)2, null));
            }
            collection = (List)destination$iv$iv;
            pair = TuplesKt.to((Object)TerminalPwshLineTransformer.copy$default(terminalPwshLineTransformer, bl3, bl, persistentList2.set(n, (Object)ExtensionsKt.toPersistentList((Iterable)collection)), 0, 0, 24, null), (Object)this.applyMarkers(line, lineMarkers));
        } else {
            Iterable $this$map$iv = markers;
            boolean $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LineShellMarker it = (LineShellMarker)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LineShellMarker.copy$default((LineShellMarker)it, (int)RangesKt.coerceAtMost((int)it.getColumn(), (int)text.length()), null, (int)2, null));
            }
            lineMarkers = (List)destination$iv$iv;
            PersistentList persistentList3 = ImmutableExKt.drop(this.markersQueue, (int)1);
            pair = TuplesKt.to((Object)TerminalPwshLineTransformer.copy$default(this, false, false, persistentList3, 0, 0, 24, null), (Object)this.applyMarkers(line, lineMarkers));
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Line applyMarkers(Line $this$applyMarkers, List<LineShellMarker> markers) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = markers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LineShellMarker it = (LineShellMarker)element$iv$iv;
            boolean bl = false;
            if (!(it.getMarker() != ShellMarker.COMMAND || it.getColumn() != this.screenWidth - 7 - 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List adjustedMarkers = (List)destination$iv$iv;
        return Line.copy$default((Line)$this$applyMarkers, null, (boolean)false, (List)adjustedMarkers, (int)3, null);
    }

    public final boolean component1() {
        return this.isWaitForCommand;
    }

    public final boolean component2() {
        return this.isLastWrapped;
    }

    @NotNull
    public final PersistentList<PersistentList<LineShellMarker>> component3() {
        return this.markersQueue;
    }

    public final int component4() {
        return this.columnShift;
    }

    public final int component5() {
        return this.screenWidth;
    }

    @NotNull
    public final TerminalPwshLineTransformer copy(boolean isWaitForCommand, boolean isLastWrapped, @NotNull PersistentList<? extends PersistentList<LineShellMarker>> markersQueue, int columnShift, int screenWidth) {
        Intrinsics.checkNotNullParameter(markersQueue, (String)"markersQueue");
        return new TerminalPwshLineTransformer(isWaitForCommand, isLastWrapped, markersQueue, columnShift, screenWidth);
    }

    public static /* synthetic */ TerminalPwshLineTransformer copy$default(TerminalPwshLineTransformer terminalPwshLineTransformer, boolean bl, boolean bl2, PersistentList persistentList, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            bl = terminalPwshLineTransformer.isWaitForCommand;
        }
        if ((n3 & 2) != 0) {
            bl2 = terminalPwshLineTransformer.isLastWrapped;
        }
        if ((n3 & 4) != 0) {
            persistentList = terminalPwshLineTransformer.markersQueue;
        }
        if ((n3 & 8) != 0) {
            n = terminalPwshLineTransformer.columnShift;
        }
        if ((n3 & 0x10) != 0) {
            n2 = terminalPwshLineTransformer.screenWidth;
        }
        return terminalPwshLineTransformer.copy(bl, bl2, persistentList, n, n2);
    }

    @NotNull
    public String toString() {
        return "TerminalPwshLineTransformer(isWaitForCommand=" + this.isWaitForCommand + ", isLastWrapped=" + this.isLastWrapped + ", markersQueue=" + this.markersQueue + ", columnShift=" + this.columnShift + ", screenWidth=" + this.screenWidth + ")";
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.isWaitForCommand);
        result2 = result2 * 31 + Boolean.hashCode(this.isLastWrapped);
        result2 = result2 * 31 + this.markersQueue.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.columnShift);
        result2 = result2 * 31 + Integer.hashCode(this.screenWidth);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalPwshLineTransformer)) {
            return false;
        }
        TerminalPwshLineTransformer terminalPwshLineTransformer = (TerminalPwshLineTransformer)other;
        if (this.isWaitForCommand != terminalPwshLineTransformer.isWaitForCommand) {
            return false;
        }
        if (this.isLastWrapped != terminalPwshLineTransformer.isLastWrapped) {
            return false;
        }
        if (!Intrinsics.areEqual(this.markersQueue, terminalPwshLineTransformer.markersQueue)) {
            return false;
        }
        if (this.columnShift != terminalPwshLineTransformer.columnShift) {
            return false;
        }
        return this.screenWidth == terminalPwshLineTransformer.screenWidth;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lfleet/workspace/run/impl/terminal/TerminalPwshLineTransformer$Companion;", "", "()V", "OUTPUT_MARKER", "", "PROMPT_MARKER", "fleet.run.workspace"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

