/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.SourceLocation;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.BraceBlockKind;
import org.clang.format.impl.CompoundStatementIndenter;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.FormatTokenSource;
import org.clang.format.impl.IndexedTokenSource;
import org.clang.format.impl.ScopedDeclarationState;
import org.clang.format.impl.ScopedLineState;
import org.clang.format.impl.ScopedMacroState;
import org.clang.format.impl.TokenType;
import org.clang.format.impl.UnwrappedLine;
import org.clang.format.impl.UnwrappedLineConsumer;
import org.clang.format.impl.UnwrappedLineNode;
import org.clank.java.std;
import org.clank.java.std_list;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorInt;
import org.llvm.support.llvm;

public class UnwrappedLineParser
implements Destructors.ClassWithDestructor {
    public std_ptr.unique_ptr<UnwrappedLine> Line = new std_ptr.unique_ptr((Object)new UnwrappedLine());
    private SmallVector<FormatToken> CommentsBeforeNextToken = new SmallVector(1, (Object)null);
    private FormatToken FormatTok;
    public boolean MustBreakBeforeNextToken = false;
    private SmallVector<UnwrappedLine> Lines = new SmallVector(8, (Object)new UnwrappedLine());
    public SmallVector<UnwrappedLine> PreprocessorDirectives = new SmallVector(4, (Object)new UnwrappedLine());
    public SmallVectorImpl<UnwrappedLine> CurrentLines = this.Lines;
    private std.vectorBool DeclarationScopeStack = new std.vectorBool();
    private final FormatStyle Style;
    private final AdditionalKeywords Keywords;
    private FormatTokenSource Tokens;
    private final UnwrappedLineConsumer Callback;
    private ArrayRef<FormatToken> AllTokens;
    private SmallVector<PPBranchKind> PPStack;
    private int PPBranchLevel;
    private SmallVectorInt PPLevelBranchIndex;
    private SmallVectorInt PPLevelBranchCount;
    private std.stackInt PPChainBranchIndex;

    public UnwrappedLineParser(FormatStyle Style, AdditionalKeywords Keywords, ArrayRef<FormatToken> Tokens, UnwrappedLineConsumer Callback) {
        this.Style = Style;
        this.Keywords = Keywords;
        this.Tokens = null;
        this.Callback = Callback;
        this.AllTokens = new ArrayRef(Tokens);
        this.PPStack = new SmallVector(16, (Object)PPBranchKind.valueOf(0));
        this.PPBranchLevel = -1;
        this.PPLevelBranchIndex = new SmallVectorInt(8);
        this.PPLevelBranchCount = new SmallVectorInt(8);
        this.PPChainBranchIndex = new std.stackInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        IndexedTokenSource TokenSource = null;
        try {
            TokenSource = new IndexedTokenSource((ArrayRef<FormatToken>)new ArrayRef(this.AllTokens));
            do {
                this.reset();
                this.Tokens = TokenSource;
                TokenSource.reset();
                this.readToken();
                this.parseFile();
                this.pushToken(this.FormatTok);
                this.addUnwrappedLine();
                type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)this.Lines.begin());
                type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.Lines.end());
                while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                    this.Callback.consumeUnwrappedLine((UnwrappedLine)I.$star());
                    I.$preInc();
                }
                this.Callback.finishRun();
                this.Lines.clear();
                while (!this.PPLevelBranchIndex.empty() && this.PPLevelBranchIndex.back() + 1 >= this.PPLevelBranchCount.back()) {
                    this.PPLevelBranchIndex.resize(this.PPLevelBranchIndex.size() - 1);
                    this.PPLevelBranchCount.resize(this.PPLevelBranchCount.size() - 1);
                }
                if (this.PPLevelBranchIndex.empty()) continue;
                this.PPLevelBranchIndex.ref$back().$assign(this.PPLevelBranchIndex.back() + 1);
                assert (this.PPLevelBranchIndex.size() == this.PPLevelBranchCount.size());
                assert (this.PPLevelBranchIndex.back() <= this.PPLevelBranchCount.back());
            } while (!this.PPLevelBranchIndex.empty());
        }
        finally {
            if (TokenSource != null) {
                TokenSource.$destroy();
            }
        }
    }

    private void reset() {
        this.PPBranchLevel = -1;
        this.Line.reset((Object)new UnwrappedLine());
        this.CommentsBeforeNextToken.clear();
        this.FormatTok = null;
        this.MustBreakBeforeNextToken = false;
        this.PreprocessorDirectives.clear();
        this.CurrentLines = this.Lines;
        this.DeclarationScopeStack.clear();
        this.PPStack.clear();
    }

    private void parseFile() {
        ScopedDeclarationState DeclarationState = null;
        try {
            boolean MustBeDeclaration = !((UnwrappedLine)this.Line.$arrow()).InPPDirective && this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript;
            DeclarationState = new ScopedDeclarationState((UnwrappedLine)this.Line.$star(), this.DeclarationScopeStack, MustBeDeclaration);
            this.parseLevel(false);
            this.flushComments(true);
            this.addUnwrappedLine();
        }
        finally {
            if (DeclarationState != null) {
                DeclarationState.$destroy();
            }
        }
    }

    private void parseLevel(boolean HasOpeningBrace) {
        boolean SwitchLabelEncountered = false;
        block6: do {
            int kind = this.FormatTok.Tok.getKind();
            if (this.FormatTok.Type == TokenType.TT_MacroBlockBegin) {
                kind = 23;
            } else if (this.FormatTok.Type == TokenType.TT_MacroBlockEnd) {
                kind = 24;
            }
            switch (kind) {
                case 4: {
                    this.nextToken();
                    this.addUnwrappedLine();
                    break;
                }
                case 23: {
                    if (!this.FormatTok.is_TokenType(TokenType.TT_MacroBlockBegin) && this.tryToParseBracedList()) continue block6;
                    this.parseBlock(false);
                    this.addUnwrappedLine();
                    break;
                }
                case 24: {
                    if (HasOpeningBrace) {
                        return;
                    }
                    this.nextToken();
                    this.addUnwrappedLine();
                    break;
                }
                case 77: 
                case 81: {
                    if (!SwitchLabelEncountered && (this.Style.IndentCaseLabels || ((UnwrappedLine)this.Line.$arrow()).InPPDirective && ((UnwrappedLine)this.Line.$arrow()).Level == 1)) {
                        ++((UnwrappedLine)this.Line.$arrow()).Level;
                    }
                    SwitchLabelEncountered = true;
                    this.parseStructuralElement();
                    break;
                }
                default: {
                    this.parseStructuralElement();
                }
            }
        } while (!this.eof());
    }

    private void parseBlock(boolean MustBeDeclaration) {
        this.parseBlock(MustBeDeclaration, true, true);
    }

    private void parseBlock(boolean MustBeDeclaration, boolean AddLevel) {
        this.parseBlock(MustBeDeclaration, AddLevel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBlock(boolean MustBeDeclaration, boolean AddLevel, boolean MunchSemi) {
        ScopedDeclarationState DeclarationState = null;
        try {
            assert (this.FormatTok.isOneOf('\u0017', TokenType.TT_MacroBlockBegin)) : "'{' or macro block token expected";
            boolean MacroBlock = this.FormatTok.is_TokenType(TokenType.TT_MacroBlockBegin);
            this.FormatTok.BlockKind = BraceBlockKind.BK_Block;
            int InitialLevel = ((UnwrappedLine)this.Line.$arrow()).Level;
            this.nextToken();
            if (MacroBlock && this.FormatTok.is_TokenKind('\u0015')) {
                this.parseParens();
            }
            this.addUnwrappedLine();
            DeclarationState = new ScopedDeclarationState((UnwrappedLine)this.Line.$star(), this.DeclarationScopeStack, MustBeDeclaration);
            if (AddLevel) {
                ++((UnwrappedLine)this.Line.$arrow()).Level;
            }
            this.parseLevel(true);
            if (this.eof()) {
                return;
            }
            if (MacroBlock ? !this.FormatTok.is_TokenType(TokenType.TT_MacroBlockEnd) : !this.FormatTok.is_TokenKind('\u0018')) {
                ((UnwrappedLine)this.Line.$arrow()).Level = InitialLevel;
                this.FormatTok.BlockKind = BraceBlockKind.BK_Block;
                return;
            }
            this.nextToken();
            if (MacroBlock && this.FormatTok.is_TokenKind('\u0015')) {
                this.parseParens();
            }
            if (MunchSemi && this.FormatTok.Tok.is('=')) {
                this.nextToken();
            }
            ((UnwrappedLine)this.Line.$arrow()).Level = InitialLevel;
        }
        finally {
            if (DeclarationState != null) {
                DeclarationState.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseChildBlock() {
        this.FormatTok.BlockKind = BraceBlockKind.BK_Block;
        this.nextToken();
        ScopedLineState LineState2 = null;
        ScopedDeclarationState DeclarationState = null;
        try {
            boolean GoogScope = this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && FormatStatics.isGoogScope((UnwrappedLine)this.Line.$star());
            LineState2 = new ScopedLineState(this);
            DeclarationState = new ScopedDeclarationState((UnwrappedLine)this.Line.$star(), this.DeclarationScopeStack, false);
            ((UnwrappedLine)this.Line.$arrow()).Level = ((UnwrappedLine)this.Line.$arrow()).Level + (GoogScope ? 0 : 1);
            this.parseLevel(true);
            this.flushComments(this.isOnNewLine(this.FormatTok));
            ((UnwrappedLine)this.Line.$arrow()).Level = ((UnwrappedLine)this.Line.$arrow()).Level - (GoogScope ? 0 : 1);
        }
        finally {
            if (DeclarationState != null) {
                DeclarationState.$destroy();
            }
            if (LineState2 != null) {
                LineState2.$destroy();
            }
        }
        this.nextToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePPDirective() {
        ScopedMacroState MacroState = null;
        try {
            assert (this.FormatTok.Tok.is('A')) : "'#' expected";
            type.ref<FormatTokenSource> Tokens_ref = new type.ref<FormatTokenSource>(){

                public FormatTokenSource $deref() {
                    return UnwrappedLineParser.this.Tokens;
                }

                public FormatTokenSource $set(FormatTokenSource value) {
                    UnwrappedLineParser.this.Tokens = value;
                    return UnwrappedLineParser.this.Tokens;
                }
            };
            type.ref<FormatToken> FormatTok_ref = new type.ref<FormatToken>(){

                public FormatToken $deref() {
                    return UnwrappedLineParser.this.FormatTok;
                }

                public FormatToken $set(FormatToken value) {
                    UnwrappedLineParser.this.FormatTok = value;
                    return UnwrappedLineParser.this.FormatTok;
                }
            };
            MacroState = new ScopedMacroState((UnwrappedLine)this.Line.$star(), Tokens_ref, FormatTok_ref);
            this.nextToken();
            if (this.FormatTok.Tok.getIdentifierInfo() == null) {
                this.parsePPUnknown();
                return;
            }
            switch (this.FormatTok.Tok.getIdentifierInfo().getPPKeywordID()) {
                case '\n': {
                    this.parsePPDefine();
                    return;
                }
                case '\u0001': {
                    this.parsePPIf(false);
                    return;
                }
                case '\u0002': 
                case '\u0003': {
                    this.parsePPIf(true);
                    return;
                }
                case '\u0005': {
                    this.parsePPElse();
                    return;
                }
                case '\u0004': {
                    this.parsePPElIf();
                    return;
                }
                case '\u0006': {
                    this.parsePPEndIf();
                    return;
                }
                default: {
                    this.parsePPUnknown();
                    return;
                }
            }
        }
        finally {
            if (MacroState != null) {
                MacroState.$destroy();
            }
        }
    }

    private void parsePPDefine() {
        this.nextToken();
        if (this.FormatTok.Tok.getKind() != '\u0005') {
            this.parsePPUnknown();
            return;
        }
        this.nextToken();
        if (this.FormatTok.Tok.getKind() == '\u0015' && BasicClangGlobals.$eq_SourceLocation$C((SourceLocation)this.FormatTok.WhitespaceRange.getBegin(), (SourceLocation)this.FormatTok.WhitespaceRange.getEnd())) {
            this.parseParens();
        }
        this.addUnwrappedLine();
        ((UnwrappedLine)this.Line.$arrow()).Level = 1;
        this.parseFile();
    }

    private void parsePPIf(boolean IfDef) {
        this.nextToken();
        boolean IsLiteralFalse = this.FormatTok.Tok.isLiteral() && Native.$noteq_ptr((void.ptr)this.FormatTok.Tok.getLiteralData(), null) && llvm.$eq_StringRef((StringRef)new StringRef(this.FormatTok.Tok.getLiteralData(), this.FormatTok.Tok.getLength()), (String)"0") || this.FormatTok.Tok.is('\u0083');
        this.conditionalCompilationStart(!IfDef && IsLiteralFalse);
        this.parsePPUnknown();
    }

    private void parsePPElIf() {
        this.parsePPElse();
    }

    private void parsePPElse() {
        this.conditionalCompilationAlternative();
        this.parsePPUnknown();
    }

    private void parsePPEndIf() {
        this.conditionalCompilationEnd();
        this.parsePPUnknown();
    }

    private void parsePPUnknown() {
        do {
            this.nextToken();
        } while (!this.eof());
        this.addUnwrappedLine();
    }

    private void readTokenWithJavaScriptASI() {
        boolean NextMustBeValue;
        FormatToken PrePrevious;
        boolean IsOnSameLine;
        FormatToken Previous = this.FormatTok;
        this.readToken();
        FormatToken Next = this.FormatTok;
        boolean bl = this.CommentsBeforeNextToken.empty() ? Next.NewlinesBefore == 0 : (IsOnSameLine = ((FormatToken)this.CommentsBeforeNextToken.front()).NewlinesBefore == 0);
        if (IsOnSameLine) {
            return;
        }
        boolean PreviousMustBeValue = FormatStatics.mustBeJSIdentOrValue(this.Keywords, Previous);
        if (PreviousMustBeValue && this.Line.$bool() && Unsigned.$greater_uint((int)((UnwrappedLine)this.Line.$arrow()).Tokens.size(), (int)1) && (PrePrevious = ((UnwrappedLineNode)((std_list.list.iterator)std.prev((abstract_iterator)((UnwrappedLine)this.Line.$arrow()).Tokens.end(), (int)2)).$arrow()).Tok).is_TokenKind('G')) {
            return;
        }
        if (Next.is_TokenKind('(') && PreviousMustBeValue) {
            this.addUnwrappedLine();
        }
        if ((NextMustBeValue = FormatStatics.mustBeJSIdentOrValue(this.Keywords, Next)) && (PreviousMustBeValue || Previous.isOneOf('\u0014', '\u0016', '!', '%'))) {
            this.addUnwrappedLine();
        }
        if (PreviousMustBeValue && FormatStatics.isJSDeclOrStmt(this.Keywords, Next)) {
            this.addUnwrappedLine();
        }
    }

    private void parseStructuralElement() {
        assert (!this.FormatTok.is_TokenKind('\u0017'));
        if (this.Style.Language == FormatStyle.LanguageKind.LK_TableGen && this.FormatTok.is_PPKeywordKind('\b')) {
            this.nextToken();
            if (this.FormatTok.is_TokenKind('\r')) {
                this.nextToken();
            }
            this.addUnwrappedLine();
            return;
        }
        block0 : switch (this.FormatTok.Tok.getKind()) {
            case 'G': {
                this.nextToken();
                if (this.FormatTok.Tok.is('\u0017')) {
                    this.parseBracedList();
                    break;
                }
                switch (this.FormatTok.Tok.getObjCKeywordID()) {
                    case '\b': 
                    case '\t': 
                    case '\u000b': 
                    case '\u0014': {
                        this.parseAccessSpecifier();
                        return;
                    }
                    case '\u0006': 
                    case '\u0007': {
                        this.parseObjCInterfaceOrImplementation();
                        return;
                    }
                    case '\n': {
                        this.parseObjCProtocol();
                        return;
                    }
                    case '\u0005': {
                        return;
                    }
                    case '\u0015': 
                    case '\u0016': {
                        this.nextToken();
                        this.addUnwrappedLine();
                        return;
                    }
                    case '\u0012': {
                        this.nextToken();
                        if (this.FormatTok.Tok.is('\u0017')) {
                            if (this.Style.BraceWrapping.AfterObjCDeclaration) {
                                this.addUnwrappedLine();
                            }
                            this.parseBlock(false);
                        }
                        this.addUnwrappedLine();
                        return;
                    }
                    case '\u000e': {
                        this.parseTryCatch();
                        return;
                    }
                }
                break;
            }
            case 'z': {
                this.nextToken();
                if (!this.FormatTok.is_TokenKind('\u0017')) break;
                this.FormatTok.Type = TokenType.TT_InlineASMBrace;
                this.nextToken();
                while (this.FormatTok != null && this.FormatTok.isNot('\u0001')) {
                    if (this.FormatTok.is_TokenKind('\u0018')) {
                        this.FormatTok.Type = TokenType.TT_InlineASMBrace;
                        this.nextToken();
                        this.addUnwrappedLine();
                        break block0;
                    }
                    this.FormatTok.Finalized = true;
                    this.nextToken();
                }
                break;
            }
            case '\u0086': {
                this.parseNamespace();
                return;
            }
            case '[': {
                this.nextToken();
                if (!this.FormatTok.Tok.is('\u0086')) break;
                this.parseNamespace();
                return;
            }
            case '\u0089': 
            case '\u008a': 
            case '\u008b': {
                if (this.Style.Language == FormatStyle.LanguageKind.LK_Java || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                    this.nextToken();
                } else {
                    this.parseAccessSpecifier();
                }
                return;
            }
            case 'Z': {
                this.parseIfThenElse();
                return;
            }
            case 'X': 
            case 'l': {
                this.parseForOrWhileLoop();
                return;
            }
            case 'R': {
                this.parseDoWhile();
                return;
            }
            case 'f': {
                this.parseSwitch();
                return;
            }
            case 'Q': {
                this.nextToken();
                this.parseLabel();
                return;
            }
            case 'M': {
                this.parseCaseLabel();
                return;
            }
            case '\u0092': 
            case '\u0138': {
                this.parseTryCatch();
                return;
            }
            case 'V': {
                this.nextToken();
                if (!this.FormatTok.Tok.is('\r')) break;
                this.nextToken();
                if (!this.FormatTok.Tok.is('\u0017')) break;
                this.parseBlock(true, false);
                this.addUnwrappedLine();
                return;
            }
            case '\u0082': {
                if (this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript) break;
                this.parseJavaScriptEs6ImportExport();
                return;
            }
            case '\u0005': {
                if (this.FormatTok.is_TokenType(TokenType.TT_ForEachMacro)) {
                    this.parseForOrWhileLoop();
                    return;
                }
                if (this.FormatTok.is_TokenType(TokenType.TT_MacroBlockBegin)) {
                    this.parseBlock(false, true, false);
                    return;
                }
                if (this.FormatTok.is(this.Keywords.kw_import)) {
                    if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                        this.parseJavaScriptEs6ImportExport();
                        return;
                    }
                    if (this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
                        this.nextToken();
                        if (this.FormatTok.is_TokenKind('\u008b')) {
                            this.nextToken();
                        }
                        if (!this.FormatTok.is_TokenKind('\r')) {
                            return;
                        }
                        this.nextToken();
                        if (this.FormatTok.is_TokenKind('=')) {
                            this.nextToken();
                        }
                        this.addUnwrappedLine();
                        return;
                    }
                }
                if (!this.FormatTok.isOneOf(this.Keywords.kw_signals, this.Keywords.kw_qsignals, this.Keywords.kw_slots, this.Keywords.kw_qslots)) break;
                this.nextToken();
                if (this.FormatTok.is_TokenKind('<')) {
                    this.nextToken();
                    this.addUnwrappedLine();
                }
                return;
            }
        }
        block45: do {
            FormatToken Previous = this.getPreviousToken();
            switch (this.FormatTok.Tok.getKind()) {
                case 'G': {
                    this.nextToken();
                    if (!this.FormatTok.Tok.is('\u0017')) continue block45;
                    this.parseBracedList();
                    break;
                }
                case 'U': {
                    if (Previous != null && Previous.is_TokenKind('.')) {
                        this.nextToken();
                        break;
                    }
                    if (!this.parseEnum() || this.Style.Language == FormatStyle.LanguageKind.LK_Cpp) continue block45;
                    this.addUnwrappedLine();
                    return;
                }
                case 'g': {
                    this.nextToken();
                    if (!this.FormatTok.isOneOf(this.Keywords.kw_NS_ENUM, this.Keywords.kw_NS_OPTIONS, this.Keywords.kw_CF_ENUM, this.Keywords.kw_CF_OPTIONS)) continue block45;
                    this.parseEnum();
                    break;
                }
                case 'e': 
                case 'h': 
                case '}': {
                    this.parseRecord();
                    if (this.Style.Language != FormatStyle.LanguageKind.LK_Java && this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript) continue block45;
                    if (this.FormatTok.is_TokenKind('=')) {
                        this.nextToken();
                    }
                    this.addUnwrappedLine();
                    return;
                }
                case '\u0019': {
                    this.nextToken();
                    if (this.Style.Language == FormatStyle.LanguageKind.LK_Java && this.FormatTok != null && this.FormatTok.is_TokenKind('}')) {
                        this.nextToken();
                    }
                    if (this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript || this.FormatTok == null || this.FormatTok.Tok.getIdentifierInfo() == null) continue block45;
                    this.nextToken();
                    break;
                }
                case '=': {
                    this.nextToken();
                    this.addUnwrappedLine();
                    return;
                }
                case '\u0018': {
                    this.addUnwrappedLine();
                    return;
                }
                case '\u0015': {
                    this.parseParens();
                    break;
                }
                case '\u0088': {
                    this.nextToken();
                    if (!this.FormatTok.isBinaryOperator()) continue block45;
                    this.nextToken();
                    break;
                }
                case '6': {
                    this.nextToken();
                    if (this.FormatTok.Tok.isAnyIdentifier() || this.FormatTok.isSimpleTypeSpecifier()) {
                        this.nextToken();
                    }
                    if (this.FormatTok.is_TokenKind('\u0015')) {
                        this.parseParens();
                    }
                    if (!this.FormatTok.is_TokenKind('\u0017')) continue block45;
                    this.parseChildBlock();
                    break;
                }
                case '\u0017': {
                    if (this.tryToParseBracedList()) continue block45;
                    if (this.Style.BraceWrapping.AfterFunction) {
                        this.addUnwrappedLine();
                    }
                    this.FormatTok.Type = TokenType.TT_FunctionLBrace;
                    this.parseBlock(false);
                    this.addUnwrappedLine();
                    return;
                }
                case '\u0092': {
                    this.parseTryCatch();
                    return;
                }
                case '\u0005': {
                    boolean FollowedByNewline;
                    if (this.FormatTok.is_TokenType(TokenType.TT_MacroBlockEnd)) {
                        this.addUnwrappedLine();
                        return;
                    }
                    if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && (this.FormatTok.is(this.Keywords.kw_function) || this.FormatTok.startsSequence(this.Keywords.kw_async, this.Keywords.kw_function)) && Unsigned.$greater_uint((int)((UnwrappedLine)this.Line.$arrow()).Tokens.size(), (int)0)) {
                        this.tryToParseJSFunction();
                        break;
                    }
                    if ((this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript || this.Style.Language == FormatStyle.LanguageKind.LK_Java) && this.FormatTok.is(this.Keywords.kw_interface)) {
                        if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                            int StoredPosition = this.Tokens.getPosition();
                            FormatToken Next = this.Tokens.getNextToken();
                            this.FormatTok = this.Tokens.setPosition(StoredPosition);
                            if (Next != null && !FormatStatics.mustBeJSIdent(this.Keywords, Next)) {
                                this.nextToken();
                                break;
                            }
                        }
                        this.parseRecord();
                        this.addUnwrappedLine();
                        return;
                    }
                    StringRef Text = new StringRef(this.FormatTok.TokenText);
                    this.nextToken();
                    if (((UnwrappedLine)this.Line.$arrow()).Tokens.size() != 1 || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) continue block45;
                    if (this.FormatTok.Tok.is('<') && !((UnwrappedLine)this.Line.$arrow()).MustBeDeclaration) {
                        ((UnwrappedLineNode)((UnwrappedLine)this.Line.$arrow()).Tokens.begin().$arrow()).Tok.MustBreakBefore = true;
                        this.parseLabel();
                        return;
                    }
                    boolean FunctionLike = this.FormatTok.is_TokenKind('\u0015');
                    if (FunctionLike) {
                        this.parseParens();
                    }
                    boolean bl = FollowedByNewline = this.CommentsBeforeNextToken.empty() ? Unsigned.$greater_uint((int)this.FormatTok.NewlinesBefore, (int)0) : Unsigned.$greater_uint((int)((FormatToken)this.CommentsBeforeNextToken.front()).NewlinesBefore, (int)0);
                    if (!FollowedByNewline || !Unsigned.$greatereq_uint((int)Text.size(), (int)5) && !FunctionLike || !FormatStatics.tokenCanStartNewLine(this.FormatTok.Tok) || !llvm.$eq_StringRef((StringRef)Text, (StringRef)new StringRef(Text.upper()))) continue block45;
                    this.addUnwrappedLine();
                    return;
                }
                case '>': {
                    if (this.FormatTok.is_TokenType(TokenType.TT_JsFatArrow)) {
                        this.nextToken();
                        if (!this.FormatTok.is_TokenKind('\u0017')) continue block45;
                        this.parseChildBlock();
                        break;
                    }
                    this.nextToken();
                    if (!this.FormatTok.Tok.is('\u0017')) continue block45;
                    this.parseBracedList();
                    break;
                }
                case '\u0013': {
                    this.parseSquare();
                    break;
                }
                case '\u0087': {
                    this.parseNew();
                    break;
                }
                default: {
                    this.nextToken();
                }
            }
        } while (!this.eof());
    }

    private boolean tryToParseBracedList() {
        if (this.FormatTok.BlockKind == BraceBlockKind.BK_Unknown) {
            this.calculateBraceTypes();
        }
        assert (this.FormatTok.BlockKind != BraceBlockKind.BK_Unknown);
        if (this.FormatTok.BlockKind == BraceBlockKind.BK_Block) {
            return false;
        }
        this.parseBracedList();
        return true;
    }

    private boolean parseBracedList() {
        return this.parseBracedList(false);
    }

    private boolean parseBracedList(boolean ContinueOnSemicolons) {
        boolean HasError = false;
        this.nextToken();
        block9: do {
            if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                if (this.FormatTok.is(this.Keywords.kw_function) || this.FormatTok.startsSequence(this.Keywords.kw_async, this.Keywords.kw_function)) {
                    this.tryToParseJSFunction();
                    continue;
                }
                if (this.FormatTok.is_TokenType(TokenType.TT_JsFatArrow)) {
                    this.nextToken();
                    if (this.FormatTok.is_TokenKind('\u0017')) {
                        this.parseChildBlock();
                        continue;
                    }
                }
            }
            switch (this.FormatTok.Tok.getKind()) {
                case '6': {
                    this.nextToken();
                    if (!this.FormatTok.is_TokenKind('\u0017')) continue block9;
                    this.parseChildBlock();
                    break;
                }
                case '\u0013': {
                    this.tryToParseLambda();
                    break;
                }
                case '\u0017': {
                    this.FormatTok.BlockKind = BraceBlockKind.BK_BracedInit;
                    this.parseBracedList();
                    break;
                }
                case '\u0015': {
                    this.parseParens();
                    if (this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript || !this.FormatTok.is_TokenKind('\u0017')) continue block9;
                    this.parseChildBlock();
                    break;
                }
                case '\u0018': {
                    this.nextToken();
                    return !HasError;
                }
                case '=': {
                    if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                        this.nextToken();
                        break;
                    }
                    HasError = true;
                    if (!ContinueOnSemicolons) {
                        return !HasError;
                    }
                    this.nextToken();
                    break;
                }
                case '@': {
                    this.nextToken();
                    break;
                }
                default: {
                    this.nextToken();
                }
            }
        } while (!this.eof());
        return false;
    }

    private void parseParens() {
        assert (this.FormatTok.Tok.is('\u0015')) : "'(' expected.";
        this.nextToken();
        block9: do {
            switch (this.FormatTok.Tok.getKind()) {
                case '\u0015': {
                    this.parseParens();
                    if (this.Style.Language != FormatStyle.LanguageKind.LK_Java || !this.FormatTok.is_TokenKind('\u0017')) continue block9;
                    this.parseChildBlock();
                    break;
                }
                case '\u0016': {
                    this.nextToken();
                    return;
                }
                case '\u0018': {
                    return;
                }
                case '\u0013': {
                    this.tryToParseLambda();
                    break;
                }
                case '\u0017': {
                    if (this.tryToParseBracedList()) continue block9;
                    this.parseChildBlock();
                    break;
                }
                case 'G': {
                    this.nextToken();
                    if (!this.FormatTok.Tok.is('\u0017')) continue block9;
                    this.parseBracedList();
                    break;
                }
                case '\u0005': {
                    if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && (this.FormatTok.is(this.Keywords.kw_function) || this.FormatTok.startsSequence(this.Keywords.kw_async, this.Keywords.kw_function))) {
                        this.tryToParseJSFunction();
                        break;
                    }
                    this.nextToken();
                    break;
                }
                default: {
                    this.nextToken();
                }
            }
        } while (!this.eof());
    }

    private void parseSquare() {
        assert (this.FormatTok.Tok.is('\u0013')) : "'[' expected.";
        if (this.tryToParseLambda()) {
            return;
        }
        block8: do {
            switch (this.FormatTok.Tok.getKind()) {
                case '\u0015': {
                    this.parseParens();
                    break;
                }
                case '\u0014': {
                    this.nextToken();
                    return;
                }
                case '\u0018': {
                    return;
                }
                case '\u0013': {
                    this.parseSquare();
                    break;
                }
                case '\u0017': {
                    if (this.tryToParseBracedList()) continue block8;
                    this.parseChildBlock();
                    break;
                }
                case 'G': {
                    this.nextToken();
                    if (!this.FormatTok.Tok.is('\u0017')) continue block8;
                    this.parseBracedList();
                    break;
                }
                default: {
                    this.nextToken();
                }
            }
        } while (!this.eof());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIfThenElse() {
        CompoundStatementIndenter Indenter;
        assert (this.FormatTok.Tok.is('Z')) : "'if' expected";
        this.nextToken();
        if (this.FormatTok.Tok.is('\u0015')) {
            this.parseParens();
        }
        boolean NeedsUnwrappedLine = false;
        if (this.FormatTok.Tok.is('\u0017')) {
            Indenter = null;
            try {
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                if (this.Style.BraceWrapping.BeforeElse) {
                    this.addUnwrappedLine();
                }
                NeedsUnwrappedLine = true;
            }
            finally {
                if (Indenter != null) {
                    Indenter.$destroy();
                }
            }
        } else {
            this.addUnwrappedLine();
            ++((UnwrappedLine)this.Line.$arrow()).Level;
            this.parseStructuralElement();
            --((UnwrappedLine)this.Line.$arrow()).Level;
        }
        if (this.FormatTok.Tok.is('T')) {
            this.nextToken();
            if (this.FormatTok.Tok.is('\u0017')) {
                Indenter = null;
                try {
                    Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                    this.parseBlock(false);
                    this.addUnwrappedLine();
                }
                finally {
                    if (Indenter != null) {
                        Indenter.$destroy();
                    }
                }
            } else if (this.FormatTok.Tok.is('Z')) {
                this.parseIfThenElse();
            } else {
                this.addUnwrappedLine();
                ++((UnwrappedLine)this.Line.$arrow()).Level;
                this.parseStructuralElement();
                if (this.FormatTok.is_TokenKind('\u0001')) {
                    this.addUnwrappedLine();
                }
                --((UnwrappedLine)this.Line.$arrow()).Level;
            }
        } else if (NeedsUnwrappedLine) {
            this.addUnwrappedLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTryCatch() {
        CompoundStatementIndenter Indenter;
        assert (this.FormatTok.isOneOf('\u0092', '\u0138')) : "'try' expected";
        this.nextToken();
        boolean NeedsUnwrappedLine = false;
        if (this.FormatTok.is_TokenKind('<')) {
            this.nextToken();
            while (this.FormatTok.is_TokenKind('\u0005')) {
                this.nextToken();
                if (this.FormatTok.is_TokenKind('\u0015')) {
                    this.parseParens();
                }
                if (!this.FormatTok.is_TokenKind('@')) continue;
                this.nextToken();
            }
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Java && this.FormatTok.is_TokenKind('\u0015')) {
            this.parseParens();
        }
        if (this.FormatTok.is_TokenKind('\u0017')) {
            Indenter = null;
            try {
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                if (this.Style.BraceWrapping.BeforeCatch) {
                    this.addUnwrappedLine();
                }
                NeedsUnwrappedLine = true;
            }
            finally {
                if (Indenter != null) {
                    Indenter.$destroy();
                }
            }
        } else if (!this.FormatTok.is_TokenKind('|')) {
            this.addUnwrappedLine();
            ++((UnwrappedLine)this.Line.$arrow()).Level;
            this.parseStructuralElement();
            --((UnwrappedLine)this.Line.$arrow()).Level;
        }
        while (true) {
            Indenter = null;
            try {
                if (this.FormatTok.is_TokenKind('G')) {
                    this.nextToken();
                }
                if (!this.FormatTok.isOneOf('|', new char[0]) && !this.FormatTok.isOneOf(this.Keywords.kw___except, '\u0139') && (this.Style.Language != FormatStyle.LanguageKind.LK_Java && this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript || !this.FormatTok.is(this.Keywords.kw_finally)) && !this.FormatTok.Tok.isObjCAtKeyword('\u000f') && !this.FormatTok.Tok.isObjCAtKeyword('\u0010')) break;
                this.nextToken();
                while (this.FormatTok.isNot('\u0017')) {
                    if (this.FormatTok.is_TokenKind('\u0015')) {
                        this.parseParens();
                        continue;
                    }
                    if (this.FormatTok.isOneOf('=', '\u0018', '\u0001')) {
                        return;
                    }
                    this.nextToken();
                }
                NeedsUnwrappedLine = false;
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                if (this.Style.BraceWrapping.BeforeCatch) {
                    this.addUnwrappedLine();
                    continue;
                }
                NeedsUnwrappedLine = true;
                continue;
            }
            finally {
                if (Indenter == null) continue;
                Indenter.$destroy();
                continue;
            }
            break;
        }
        if (NeedsUnwrappedLine) {
            this.addUnwrappedLine();
        }
    }

    private void parseForOrWhileLoop() {
        assert (this.FormatTok.isOneOf('X', 'l', TokenType.TT_ForEachMacro)) : "'for', 'while' or foreach macro expected";
        this.nextToken();
        if (this.FormatTok.Tok.is('\u0015')) {
            this.parseParens();
        }
        if (this.FormatTok.Tok.is('\u0017')) {
            CompoundStatementIndenter Indenter = null;
            try {
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                this.addUnwrappedLine();
            }
            finally {
                if (Indenter != null) {
                    Indenter.$destroy();
                }
            }
        } else {
            this.addUnwrappedLine();
            ++((UnwrappedLine)this.Line.$arrow()).Level;
            this.parseStructuralElement();
            --((UnwrappedLine)this.Line.$arrow()).Level;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseDoWhile() {
        if (!UnwrappedLineParser.$assertionsDisabled && !this.FormatTok.Tok.is('R')) {
            throw new AssertionError((Object)"'do' expected");
        }
        this.nextToken();
        if (this.FormatTok.Tok.is('\u0017')) {
            Indenter = null;
            try {
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                if (!this.Style.BraceWrapping.IndentBraces) ** GOTO lbl20
                this.addUnwrappedLine();
            }
            finally {
                if (Indenter != null) {
                    Indenter.$destroy();
                }
            }
        } else {
            this.addUnwrappedLine();
            ++((UnwrappedLine)this.Line.$arrow()).Level;
            this.parseStructuralElement();
            --((UnwrappedLine)this.Line.$arrow()).Level;
        }
lbl20:
        // 3 sources

        if (!this.FormatTok.Tok.is('l')) {
            this.addUnwrappedLine();
            return;
        }
        this.nextToken();
        this.parseStructuralElement();
    }

    private void parseLabel() {
        this.nextToken();
        int OldLineLevel = ((UnwrappedLine)this.Line.$arrow()).Level;
        if (Unsigned.$greater_uint((int)((UnwrappedLine)this.Line.$arrow()).Level, (int)1) || !((UnwrappedLine)this.Line.$arrow()).InPPDirective && Unsigned.$greater_uint((int)((UnwrappedLine)this.Line.$arrow()).Level, (int)0)) {
            --((UnwrappedLine)this.Line.$arrow()).Level;
        }
        if (this.CommentsBeforeNextToken.empty() && this.FormatTok.Tok.is('\u0017')) {
            CompoundStatementIndenter Indenter = null;
            try {
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                if (this.FormatTok.Tok.is('L')) {
                    if (this.Style.BraceWrapping.AfterControlStatement) {
                        this.addUnwrappedLine();
                    }
                    this.parseStructuralElement();
                }
                this.addUnwrappedLine();
            }
            finally {
                if (Indenter != null) {
                    Indenter.$destroy();
                }
            }
        } else {
            if (this.FormatTok.is_TokenKind('=')) {
                this.nextToken();
            }
            this.addUnwrappedLine();
        }
        ((UnwrappedLine)this.Line.$arrow()).Level = OldLineLevel;
        if (this.FormatTok.isNot('\u0017')) {
            this.parseStructuralElement();
            this.addUnwrappedLine();
        }
    }

    private void parseCaseLabel() {
        assert (this.FormatTok.Tok.is('M')) : "'case' expected";
        do {
            this.nextToken();
        } while (!this.eof() && !this.FormatTok.Tok.is('<'));
        this.parseLabel();
    }

    private void parseSwitch() {
        assert (this.FormatTok.Tok.is('f')) : "'switch' expected";
        this.nextToken();
        if (this.FormatTok.Tok.is('\u0015')) {
            this.parseParens();
        }
        if (this.FormatTok.Tok.is('\u0017')) {
            CompoundStatementIndenter Indenter = null;
            try {
                Indenter = new CompoundStatementIndenter(this, this.Style, ((UnwrappedLine)this.Line.$arrow()).Level_ref);
                this.parseBlock(false);
                this.addUnwrappedLine();
            }
            finally {
                if (Indenter != null) {
                    Indenter.$destroy();
                }
            }
        } else {
            this.addUnwrappedLine();
            ++((UnwrappedLine)this.Line.$arrow()).Level;
            this.parseStructuralElement();
            --((UnwrappedLine)this.Line.$arrow()).Level;
        }
    }

    private void parseNamespace() {
        assert (this.FormatTok.Tok.is('\u0086')) : "'namespace' expected";
        FormatToken InitialToken = this.FormatTok;
        this.nextToken();
        while (this.FormatTok.isOneOf('\u0005', 'F')) {
            this.nextToken();
        }
        if (this.FormatTok.Tok.is('\u0017')) {
            if (FormatStatics.ShouldBreakBeforeBrace(this.Style, InitialToken)) {
                this.addUnwrappedLine();
            }
            boolean AddLevel = this.Style.NamespaceIndentation == FormatStyle.NamespaceIndentationKind.NI_All || this.Style.NamespaceIndentation == FormatStyle.NamespaceIndentationKind.NI_Inner && Unsigned.$greater_uint((int)this.DeclarationScopeStack.size(), (int)1);
            this.parseBlock(true, AddLevel);
            if (this.FormatTok.Tok.is('=')) {
                this.nextToken();
            }
            this.addUnwrappedLine();
        }
    }

    private void parseNew() {
        assert (this.FormatTok.is_TokenKind('\u0087')) : "'new' expected";
        this.nextToken();
        if (this.Style.Language != FormatStyle.LanguageKind.LK_Java) {
            return;
        }
        do {
            if (this.FormatTok.isOneOf('=', '\u0017', '\u0018')) {
                return;
            }
            if (this.FormatTok.is_TokenKind('\u0015')) {
                this.parseParens();
                if (this.FormatTok.is_TokenKind('\u0017')) {
                    this.parseChildBlock();
                }
                return;
            }
            this.nextToken();
        } while (!this.eof());
    }

    private void parseAccessSpecifier() {
        this.nextToken();
        if (this.FormatTok.isOneOf(this.Keywords.kw_slots, this.Keywords.kw_qslots)) {
            this.nextToken();
        }
        if (this.FormatTok.Tok.is('<')) {
            this.nextToken();
        }
        this.addUnwrappedLine();
    }

    private boolean parseEnum() {
        boolean HasError;
        if (this.FormatTok.Tok.is('U')) {
            this.nextToken();
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && this.FormatTok.isOneOf('<', ';')) {
            return false;
        }
        if (this.FormatTok.Tok.is('}') || this.FormatTok.Tok.is('e')) {
            this.nextToken();
        }
        while (this.FormatTok.Tok.getIdentifierInfo() != null || this.FormatTok.isOneOf('<', 'F', '.', '2', '@', ';')) {
            this.nextToken();
            if (this.FormatTok.is_TokenKind('\u0015')) {
                this.parseParens();
            }
            if (!this.FormatTok.is_TokenKind('\u0005')) continue;
            this.nextToken();
            if (this.Style.Language != FormatStyle.LanguageKind.LK_Cpp || !this.FormatTok.is_TokenKind('\u0005')) continue;
            return false;
        }
        if (this.FormatTok.isNot('\u0017')) {
            return true;
        }
        this.FormatTok.BlockKind = BraceBlockKind.BK_Block;
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Java) {
            this.parseJavaEnumBody();
            return true;
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
            this.parseBlock(true);
            return true;
        }
        boolean bl = HasError = !this.parseBracedList(true);
        if (HasError) {
            if (this.FormatTok.is_TokenKind('=')) {
                this.nextToken();
            }
            this.addUnwrappedLine();
        }
        return true;
    }

    private void parseJavaEnumBody() {
        int StoredPosition = this.Tokens.getPosition();
        boolean IsSimple = true;
        FormatToken Tok = this.Tokens.getNextToken();
        while (Tok != null && !Tok.is_TokenKind('\u0018')) {
            if (Tok.isOneOf('\u0017', '=')) {
                IsSimple = false;
                break;
            }
            Tok = this.Tokens.getNextToken();
        }
        this.FormatTok = this.Tokens.setPosition(StoredPosition);
        if (IsSimple) {
            this.parseBracedList();
            this.addUnwrappedLine();
            return;
        }
        this.nextToken();
        this.addUnwrappedLine();
        ++((UnwrappedLine)this.Line.$arrow()).Level;
        while (this.FormatTok != null) {
            if (this.FormatTok.is_TokenKind('\u0017')) {
                this.parseBlock(true, true, false);
                continue;
            }
            if (this.FormatTok.is_TokenKind('\u0015')) {
                this.parseParens();
                continue;
            }
            if (this.FormatTok.is_TokenKind('@')) {
                this.nextToken();
                this.addUnwrappedLine();
                continue;
            }
            if (this.FormatTok.is_TokenKind('=')) {
                this.nextToken();
                this.addUnwrappedLine();
                break;
            }
            if (this.FormatTok.is_TokenKind('\u0018')) {
                this.addUnwrappedLine();
                break;
            }
            this.nextToken();
        }
        this.parseLevel(true);
        this.nextToken();
        --((UnwrappedLine)this.Line.$arrow()).Level;
        this.addUnwrappedLine();
    }

    private void parseRecord() {
        FormatToken InitialToken = this.FormatTok;
        this.nextToken();
        while (this.FormatTok.isOneOf('\u0005', 'F', 'B', '\u00ac', '\u0101', '\u0098') || (this.Style.Language == FormatStyle.LanguageKind.LK_Java || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) && this.FormatTok.isOneOf('\u0019', '@')) {
            boolean IsNonMacroIdentifier = this.FormatTok.is_TokenKind('\u0005') && llvm.$noteq_StringRef((StringRef)this.FormatTok.TokenText, (StringRef)new StringRef(this.FormatTok.TokenText.upper()));
            this.nextToken();
            if (IsNonMacroIdentifier || !this.FormatTok.Tok.is('\u0015')) continue;
            this.parseParens();
        }
        if (this.FormatTok.isOneOf('<', '.')) {
            while (!this.eof()) {
                if (this.FormatTok.is_TokenKind('\u0017')) {
                    this.calculateBraceTypes(true);
                    if (!this.tryToParseBracedList()) break;
                }
                if (this.FormatTok.Tok.is('=')) {
                    return;
                }
                this.nextToken();
            }
        }
        if (this.FormatTok.Tok.is('\u0017')) {
            if (FormatStatics.ShouldBreakBeforeBrace(this.Style, InitialToken)) {
                this.addUnwrappedLine();
            }
            this.parseBlock(true, true, false);
        }
    }

    private void parseObjCProtocolList() {
        assert (this.FormatTok.Tok.is('.')) : "'<' expected.";
        do {
            this.nextToken();
        } while (!this.eof() && this.FormatTok.Tok.isNot('2'));
        this.nextToken();
    }

    private void parseObjCUntilAtEnd() {
        do {
            if (this.FormatTok.Tok.isObjCAtKeyword('\u0005')) {
                this.nextToken();
                this.addUnwrappedLine();
                break;
            }
            if (this.FormatTok.is_TokenKind('\u0017')) {
                this.parseBlock(false);
                this.addUnwrappedLine();
                continue;
            }
            if (this.FormatTok.is_TokenKind('\u0018')) {
                this.nextToken();
                this.addUnwrappedLine();
                continue;
            }
            this.parseStructuralElement();
        } while (!this.eof());
    }

    private void parseObjCInterfaceOrImplementation() {
        this.nextToken();
        this.nextToken();
        if (this.FormatTok.Tok.is('<')) {
            this.nextToken();
            this.nextToken();
        } else if (this.FormatTok.Tok.is('\u0015')) {
            this.parseParens();
        }
        if (this.FormatTok.Tok.is('.')) {
            this.parseObjCProtocolList();
        }
        if (this.FormatTok.Tok.is('\u0017')) {
            if (this.Style.BraceWrapping.AfterObjCDeclaration) {
                this.addUnwrappedLine();
            }
            this.parseBlock(true);
        }
        this.addUnwrappedLine();
        this.parseObjCUntilAtEnd();
    }

    private void parseObjCProtocol() {
        this.nextToken();
        this.nextToken();
        if (this.FormatTok.Tok.is('.')) {
            this.parseObjCProtocolList();
        }
        if (this.FormatTok.Tok.is('=')) {
            this.nextToken();
            this.addUnwrappedLine();
            return;
        }
        this.addUnwrappedLine();
        this.parseObjCUntilAtEnd();
    }

    private void parseJavaScriptEs6ImportExport() {
        boolean IsImport = this.FormatTok.is(this.Keywords.kw_import);
        assert (IsImport || this.FormatTok.is_TokenKind('\u0082'));
        this.nextToken();
        if (this.FormatTok.is_TokenKind('Q')) {
            this.nextToken();
        }
        if (this.FormatTok.is(this.Keywords.kw_async)) {
            this.nextToken();
        }
        if (this.FormatTok.is(this.Keywords.kw_function)) {
            this.nextToken();
            return;
        }
        if (!(IsImport || this.FormatTok.isOneOf('\u0017', '\u001e') || this.FormatTok.isStringLiteral())) {
            return;
        }
        while (!this.eof() && this.FormatTok.isNot('=')) {
            if (this.FormatTok.is_TokenKind('\u0017')) {
                this.FormatTok.BlockKind = BraceBlockKind.BK_Block;
                this.parseBracedList();
                continue;
            }
            this.nextToken();
        }
    }

    private boolean tryToParseLambda() {
        if (this.Style.Language != FormatStyle.LanguageKind.LK_Cpp) {
            this.nextToken();
            return false;
        }
        FormatToken Previous = this.getPreviousToken();
        if (Previous != null && (Previous.isOneOf('\u0005', '\u0088', '\u0087', '\u007f') || Previous.closesScope() || Previous.isSimpleTypeSpecifier())) {
            this.nextToken();
            return false;
        }
        assert (this.FormatTok.is_TokenKind('\u0013'));
        FormatToken LSquare = this.FormatTok;
        if (!this.tryToParseLambdaIntroducer()) {
            return false;
        }
        block6: while (this.FormatTok.isNot('\u0017')) {
            if (this.FormatTok.isSimpleTypeSpecifier()) {
                this.nextToken();
                continue;
            }
            switch (this.FormatTok.Tok.getKind()) {
                case '\u0017': {
                    continue block6;
                }
                case '\u0015': {
                    this.parseParens();
                    continue block6;
                }
                case '\u0005': 
                case '\u0007': 
                case '\u001b': 
                case '\u001e': 
                case '.': 
                case '2': 
                case '@': 
                case 'F': 
                case 'O': 
                case '\u0085': {
                    this.nextToken();
                    continue block6;
                }
                case '$': {
                    this.FormatTok.Type = TokenType.TT_LambdaArrow;
                    this.nextToken();
                    continue block6;
                }
            }
            return true;
        }
        LSquare.Type = TokenType.TT_LambdaLSquare;
        this.parseChildBlock();
        return true;
    }

    private boolean tryToParseLambdaIntroducer() {
        this.nextToken();
        if (this.FormatTok.is_TokenKind('>')) {
            this.nextToken();
            if (this.FormatTok.is_TokenKind('\u0014')) {
                this.nextToken();
                return true;
            }
            if (this.FormatTok.isNot('@')) {
                return false;
            }
            this.nextToken();
        } else if (this.FormatTok.is_TokenKind('\u001b')) {
            this.nextToken();
            if (this.FormatTok.is_TokenKind('\u0014')) {
                this.nextToken();
                return true;
            }
            if (!this.FormatTok.isOneOf('@', '\u0005')) {
                return false;
            }
            if (this.FormatTok.is_TokenKind('@')) {
                this.nextToken();
            }
        } else if (this.FormatTok.is_TokenKind('\u0014')) {
            this.nextToken();
            return true;
        }
        do {
            if (this.FormatTok.is_TokenKind('\u001b')) {
                this.nextToken();
            }
            if (!this.FormatTok.isOneOf('\u0005', '\u008f')) {
                return false;
            }
            this.nextToken();
            if (this.FormatTok.is_TokenKind('\u001a')) {
                this.nextToken();
            }
            if (!this.FormatTok.is_TokenKind('@')) {
                if (this.FormatTok.is_TokenKind('\u0014')) {
                    this.nextToken();
                    return true;
                }
                return false;
            }
            this.nextToken();
        } while (!this.eof());
        return false;
    }

    private void tryToParseJSFunction() {
        assert (this.FormatTok.is(this.Keywords.kw_function) || this.FormatTok.startsSequence(this.Keywords.kw_async, this.Keywords.kw_function));
        if (this.FormatTok.is(this.Keywords.kw_async)) {
            this.nextToken();
        }
        this.nextToken();
        if (this.FormatTok.is_TokenKind('\u001e')) {
            this.nextToken();
        }
        if (this.FormatTok.is_TokenKind('\u0005')) {
            this.nextToken();
        }
        if (this.FormatTok.isNot('\u0015')) {
            return;
        }
        this.parseParens();
        if (this.FormatTok.is_TokenKind('<')) {
            this.nextToken();
            if (this.FormatTok.is_TokenKind('\u0017')) {
                this.tryToParseBracedList();
            } else {
                while (this.FormatTok.isNot('\u0017') && !this.eof()) {
                    this.nextToken();
                }
            }
        }
        this.parseChildBlock();
    }

    public void addUnwrappedLine() {
        if (((UnwrappedLine)this.Line.$arrow()).Tokens.empty()) {
            return;
        }
        this.CurrentLines.push_back_T$RR(std.move((Object)this.Line.$star()));
        ((UnwrappedLine)this.Line.$arrow()).Tokens.clear();
        if (this.CurrentLines == this.Lines && !this.PreprocessorDirectives.empty()) {
            this.CurrentLines.append_T((type.iterator)std.make_move_iterator((type.ptr)this.PreprocessorDirectives.begin()), (type.iterator)std.make_move_iterator((type.ptr)this.PreprocessorDirectives.end()));
            this.PreprocessorDirectives.clear();
        }
    }

    private boolean eof() {
        return this.FormatTok.Tok.is('\u0001');
    }

    private void nextToken() {
        if (this.eof()) {
            return;
        }
        this.flushComments(this.isOnNewLine(this.FormatTok));
        this.pushToken(this.FormatTok);
        if (this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript) {
            this.readToken();
        } else {
            this.readTokenWithJavaScriptASI();
        }
    }

    private FormatToken getPreviousToken() {
        if (!this.Line.$bool() || ((UnwrappedLine)this.Line.$arrow()).Tokens.empty()) {
            return null;
        }
        return ((UnwrappedLineNode)((UnwrappedLine)this.Line.$arrow()).Tokens.back()).Tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readToken() {
        boolean CommentsInCurrentLine = true;
        do {
            this.FormatTok = this.Tokens.getNextToken();
            assert (Native.$bool((Object)this.FormatTok));
            while (!((UnwrappedLine)this.Line.$arrow()).InPPDirective && this.FormatTok.Tok.is('A') && (this.FormatTok.HasUnescapedNewline || this.FormatTok.IsFirst)) {
                ScopedLineState BlockState = null;
                try {
                    boolean SwitchToPreprocessorLines = !((UnwrappedLine)this.Line.$arrow()).Tokens.empty();
                    BlockState = new ScopedLineState(this, SwitchToPreprocessorLines);
                    this.flushComments(this.isOnNewLine(this.FormatTok));
                    this.parsePPDirective();
                }
                finally {
                    if (BlockState == null) continue;
                    BlockState.$destroy();
                }
            }
            while (this.FormatTok.Type == TokenType.TT_ConflictStart || this.FormatTok.Type == TokenType.TT_ConflictEnd || this.FormatTok.Type == TokenType.TT_ConflictAlternative) {
                if (this.FormatTok.Type == TokenType.TT_ConflictStart) {
                    this.conditionalCompilationStart(false);
                } else if (this.FormatTok.Type == TokenType.TT_ConflictAlternative) {
                    this.conditionalCompilationAlternative();
                } else if (this.FormatTok.Type == TokenType.TT_ConflictEnd) {
                    this.conditionalCompilationEnd();
                }
                this.FormatTok = this.Tokens.getNextToken();
                this.FormatTok.MustBreakBefore = true;
            }
            if (!this.PPStack.empty() && this.PPStack.back() == PPBranchKind.PP_Unreachable && !((UnwrappedLine)this.Line.$arrow()).InPPDirective) continue;
            if (!this.FormatTok.Tok.is('\u0004')) {
                return;
            }
            if (this.isOnNewLine(this.FormatTok) || this.FormatTok.IsFirst) {
                CommentsInCurrentLine = false;
            }
            if (CommentsInCurrentLine) {
                this.pushToken(this.FormatTok);
                continue;
            }
            this.CommentsBeforeNextToken.push_back((Object)this.FormatTok);
        } while (!this.eof());
    }

    private void flushComments(boolean NewlineBeforeNext) {
        boolean JustComments = ((UnwrappedLine)this.Line.$arrow()).Tokens.empty();
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)this.CommentsBeforeNextToken.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.CommentsBeforeNextToken.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            if (this.isOnNewLine((FormatToken)I.$star()) && JustComments) {
                this.addUnwrappedLine();
            }
            this.pushToken((FormatToken)I.$star());
            I.$preInc();
        }
        if (NewlineBeforeNext && JustComments) {
            this.addUnwrappedLine();
        }
        this.CommentsBeforeNextToken.clear();
    }

    private void pushToken(FormatToken Tok) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ((UnwrappedLine)this.Line.$arrow()).Tokens.push_back_T$RR($c$.track((Object)new UnwrappedLineNode(Tok)));
            $c$.clean();
            if (this.MustBreakBeforeNextToken) {
                ((UnwrappedLineNode)((UnwrappedLine)this.Line.$arrow()).Tokens.back()).Tok.MustBreakBefore = true;
                this.MustBreakBeforeNextToken = false;
            }
        }
        finally {
            $c$.$destroy();
        }
    }

    private void calculateBraceTypes() {
        this.calculateBraceTypes(false);
    }

    private void calculateBraceTypes(boolean ExpectClassBody) {
        int StoredPosition = this.Tokens.getPosition();
        FormatToken Tok = this.FormatTok;
        FormatToken PrevTok = this.getPreviousToken();
        SmallVector LBraceStack = new SmallVector(8, (Object)null);
        assert (Tok.Tok.is('\u0017'));
        do {
            FormatToken NextTok;
            int ReadTokens = 0;
            do {
                NextTok = this.Tokens.getNextToken();
                ++ReadTokens;
            } while (NextTok.is_TokenKind('\u0004'));
            switch (Tok.Tok.getKind()) {
                case '\u0017': {
                    Tok.BlockKind = this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && PrevTok != null && PrevTok.is_TokenKind('<') ? BraceBlockKind.BK_BracedInit : BraceBlockKind.BK_Unknown;
                    LBraceStack.push_back((Object)Tok);
                    break;
                }
                case '\u0018': {
                    if (LBraceStack.empty()) break;
                    if (((FormatToken)LBraceStack.back()).BlockKind == BraceBlockKind.BK_Unknown) {
                        boolean ProbablyBracedList = false;
                        if (this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
                            ProbablyBracedList = NextTok.isOneOf('@', '\u0014');
                        } else {
                            boolean NextIsObjCMethod = NextTok.isOneOf(' ', '#') && NextTok.OriginalColumn == 0;
                            boolean bl = ProbablyBracedList = this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && NextTok.isOneOf(this.Keywords.kw_of, this.Keywords.kw_in) || NextTok.isOneOf('@', '\u0019', '<', '\u0016', '\u0014', '\u0017', '\u0013', '\u0015', '\u001a') || NextTok.is_TokenKind('=') && (!ExpectClassBody || LBraceStack.size() != 1) || NextTok.isBinaryOperator() && !NextIsObjCMethod;
                        }
                        if (ProbablyBracedList) {
                            Tok.BlockKind = BraceBlockKind.BK_BracedInit;
                            ((FormatToken)LBraceStack.back()).BlockKind = BraceBlockKind.BK_BracedInit;
                        } else {
                            Tok.BlockKind = BraceBlockKind.BK_Block;
                            ((FormatToken)LBraceStack.back()).BlockKind = BraceBlockKind.BK_Block;
                        }
                    }
                    LBraceStack.pop_back();
                    break;
                }
                case '=': 
                case 'G': 
                case 'X': 
                case 'Z': 
                case 'f': 
                case 'l': 
                case '\u0092': 
                case '\u0138': {
                    if (LBraceStack.empty() || ((FormatToken)LBraceStack.back()).BlockKind != BraceBlockKind.BK_Unknown) break;
                    ((FormatToken)LBraceStack.back()).BlockKind = BraceBlockKind.BK_Block;
                    break;
                }
            }
            PrevTok = Tok;
            Tok = NextTok;
        } while (Tok.Tok.isNot('\u0001') && !LBraceStack.empty());
        int e = LBraceStack.size();
        for (int i = 0; i != e; ++i) {
            if (((FormatToken)LBraceStack.$at((int)i)).BlockKind != BraceBlockKind.BK_Unknown) continue;
            ((FormatToken)LBraceStack.$at((int)i)).BlockKind = BraceBlockKind.BK_Block;
        }
        this.FormatTok = this.Tokens.setPosition(StoredPosition);
    }

    private void conditionalCompilationCondition(boolean Unreachable) {
        if (Unreachable || !this.PPStack.empty() && this.PPStack.back() == PPBranchKind.PP_Unreachable) {
            this.PPStack.push_back((Object)PPBranchKind.PP_Unreachable);
        } else {
            this.PPStack.push_back((Object)PPBranchKind.PP_Conditional);
        }
    }

    private void conditionalCompilationStart(boolean Unreachable) {
        ++this.PPBranchLevel;
        assert (this.PPBranchLevel >= 0 && this.PPBranchLevel <= this.PPLevelBranchIndex.size());
        if (this.PPBranchLevel == this.PPLevelBranchIndex.size()) {
            this.PPLevelBranchIndex.push_back(0);
            this.PPLevelBranchCount.push_back(0);
        }
        this.PPChainBranchIndex.push_value_type(0);
        boolean Skip = this.PPLevelBranchIndex.$at(this.PPBranchLevel) > 0;
        this.conditionalCompilationCondition(Unreachable || Skip);
    }

    private void conditionalCompilationAlternative() {
        if (!this.PPStack.empty()) {
            this.PPStack.pop_back();
        }
        assert (this.PPBranchLevel < this.PPLevelBranchIndex.size());
        if (!this.PPChainBranchIndex.empty()) {
            this.PPChainBranchIndex.top$ref().$set$preInc();
        }
        this.conditionalCompilationCondition(this.PPBranchLevel >= 0 && !this.PPChainBranchIndex.empty() && this.PPLevelBranchIndex.$at(this.PPBranchLevel) != this.PPChainBranchIndex.top());
    }

    private void conditionalCompilationEnd() {
        assert (this.PPBranchLevel < this.PPLevelBranchIndex.size());
        if (this.PPBranchLevel >= 0 && !this.PPChainBranchIndex.empty() && this.PPChainBranchIndex.top() + 1 > this.PPLevelBranchCount.$at(this.PPBranchLevel)) {
            this.PPLevelBranchCount.$set(this.PPBranchLevel, this.PPChainBranchIndex.top() + 1);
        }
        if (this.PPBranchLevel > 0) {
            --this.PPBranchLevel;
        }
        if (!this.PPChainBranchIndex.empty()) {
            this.PPChainBranchIndex.pop();
        }
        if (!this.PPStack.empty()) {
            this.PPStack.pop_back();
        }
    }

    private boolean isOnNewLine(FormatToken FormatTok) {
        return (((UnwrappedLine)this.Line.$arrow()).InPPDirective || FormatTok.HasUnescapedNewline) && Unsigned.$greater_uint((int)FormatTok.NewlinesBefore, (int)0);
    }

    public void $destroy() {
        this.PPChainBranchIndex.$destroy();
        this.PPLevelBranchCount.$destroy();
        this.PPLevelBranchIndex.$destroy();
        this.PPStack.$destroy();
        this.DeclarationScopeStack.$destroy();
        this.PreprocessorDirectives.$destroy();
        this.Lines.$destroy();
        this.CommentsBeforeNextToken.$destroy();
        this.Line.$destroy();
    }

    public String toString() {
        return "Line=" + this.Line + ", CommentsBeforeNextToken=" + this.CommentsBeforeNextToken + ", FormatTok=" + this.FormatTok + ", MustBreakBeforeNextToken=" + this.MustBreakBeforeNextToken + ", Lines=" + this.Lines + ", PreprocessorDirectives=" + this.PreprocessorDirectives + ", CurrentLines=" + this.CurrentLines + ", DeclarationScopeStack=" + this.DeclarationScopeStack + ", Style=" + this.Style + ", Keywords=" + this.Keywords + ", Tokens=[FormatTokenSource], Callback=[UnwrappedLineConsumer], AllTokens=" + this.AllTokens + ", PPStack=" + this.PPStack + ", PPBranchLevel=" + this.PPBranchLevel + ", PPLevelBranchIndex=" + this.PPLevelBranchIndex + ", PPLevelBranchCount=" + this.PPLevelBranchCount + ", PPChainBranchIndex=" + this.PPChainBranchIndex;
    }

    private static final class PPBranchKind
    extends Enum<PPBranchKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ PPBranchKind PP_Conditional = new PPBranchKind(0);
        public static final /* enum */ PPBranchKind PP_Unreachable = new PPBranchKind(PP_Conditional.getValue() + 1);
        private final int value;
        private static final /* synthetic */ PPBranchKind[] $VALUES;

        public static PPBranchKind[] values() {
            return (PPBranchKind[])$VALUES.clone();
        }

        public static PPBranchKind valueOf(String name) {
            return Enum.valueOf(PPBranchKind.class, name);
        }

        public static PPBranchKind valueOf(int val) {
            PPBranchKind out;
            PPBranchKind pPBranchKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private PPBranchKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new PPBranchKind[]{PP_Conditional, PP_Unreachable};
        }

        private static final class Values {
            private static final PPBranchKind[] VALUES;
            private static final PPBranchKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (PPBranchKind kind : PPBranchKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new PPBranchKind[min < 0 ? 1 - min : 0];
                VALUES = new PPBranchKind[max >= 0 ? 1 + max : 0];
                for (PPBranchKind kind : PPBranchKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((PPBranchKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((PPBranchKind)kind).value] = kind;
                }
            }
        }
    }
}

