/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Comparator;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.ContinuationIndenter;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.LevelIndentTracker;
import org.clang.format.impl.LineJoiner;
import org.clang.format.impl.LineType;
import org.clang.format.impl.NoColumnLimitLineFormatter;
import org.clang.format.impl.NoLineBreakFormatter;
import org.clang.format.impl.OptimizingLineFormatter;
import org.clang.format.impl.WhitespaceManager;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdMapTypeUInt;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.llvm.adt.aliases.SmallVectorImpl;

public class UnwrappedLineFormatter
implements Destructors.ClassWithDestructor {
    private std_map.mapTypeUInt<std_pair.pairTypeUInt<SmallVectorImpl<AnnotatedLine>>> PenaltyCache = new std_map.mapTypeUInt((Comparator)new Comparator<std_pair.pairTypeUInt<SmallVectorImpl<AnnotatedLine>>>(){

        @Override
        public int compare(std_pair.pairTypeUInt<SmallVectorImpl<AnnotatedLine>> o1, std_pair.pairTypeUInt<SmallVectorImpl<AnnotatedLine>> o2) {
            int res = System.identityHashCode(o1.first) - System.identityHashCode(o2.first);
            if (res == 0) {
                return o1.second - o2.second;
            }
            return res;
        }
    }, 0);
    private ContinuationIndenter Indenter;
    private WhitespaceManager Whitespaces;
    private final FormatStyle Style;
    private final AdditionalKeywords Keywords;
    private bool.ptr IncompleteFormat;

    public UnwrappedLineFormatter(ContinuationIndenter Indenter, WhitespaceManager Whitespaces, FormatStyle Style, AdditionalKeywords Keywords, bool.ptr IncompleteFormat) {
        this.Indenter = Indenter;
        this.Whitespaces = Whitespaces;
        this.Style = Style;
        this.Keywords = Keywords;
        this.IncompleteFormat = (bool.ptr)Native.$tryClone((NativeCloneable)IncompleteFormat);
    }

    public int format(SmallVectorImpl<AnnotatedLine> Lines) {
        return this.format(Lines, false, 0, false);
    }

    public int format(SmallVectorImpl<AnnotatedLine> Lines, boolean DryRun) {
        return this.format(Lines, DryRun, 0, false);
    }

    public int format(SmallVectorImpl<AnnotatedLine> Lines, boolean DryRun, int AdditionalIndent) {
        return this.format(Lines, DryRun, AdditionalIndent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int format(SmallVectorImpl<AnnotatedLine> Lines, boolean DryRun, int AdditionalIndent, boolean FixBadIndentation) {
        LevelIndentTracker IndentTracker = null;
        try {
            LineJoiner Joiner = new LineJoiner(this.Style, this.Keywords, Lines);
            std_pair.pairPtrUInt CacheKey = new std_pair.pairPtrUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, Lines, AdditionalIndent);
            StdMapTypeUInt.iterator CacheIt = this.PenaltyCache.find((Object)CacheKey);
            if (DryRun && CacheIt.$noteq((Object)this.PenaltyCache.end())) {
                int n = CacheIt.$arrow().second;
                return n;
            }
            assert (!Lines.empty());
            int Penalty = 0;
            IndentTracker = new LevelIndentTracker(this.Style, this.Keywords, ((AnnotatedLine)Lines.$at$Const((int)0)).Level, AdditionalIndent);
            AnnotatedLine PreviousLine = null;
            AnnotatedLine NextLine = null;
            int RangeMinLevel = -1;
            AnnotatedLine Line = Joiner.getNextMergedLine(DryRun, IndentTracker);
            while (Line != null) {
                boolean ShouldFormat;
                AnnotatedLine TheLine = Line;
                int Indent = IndentTracker.getIndent();
                boolean ContinueFormatting = Unsigned.$greater_uint((int)TheLine.Level, (int)RangeMinLevel) || TheLine.Level == RangeMinLevel && !TheLine.startsWith('\u0018');
                boolean FixIndentation = (FixBadIndentation || ContinueFormatting) && Indent != TheLine.First.OriginalColumn;
                boolean bl = ShouldFormat = TheLine.Affected || FixIndentation;
                if (ShouldFormat && TheLine.Type == LineType.LT_Invalid && Native.$bool((Native.Native$Bool)this.IncompleteFormat)) {
                    this.IncompleteFormat.$set(true);
                }
                if (ShouldFormat && TheLine.Type != LineType.LT_Invalid) {
                    JavaCleaner $c$;
                    int ColumnLimit;
                    boolean FitsIntoOneLine;
                    if (!DryRun) {
                        this.formatFirstToken(TheLine.First, PreviousLine, TheLine.Level, Indent, TheLine.InPPDirective);
                    }
                    boolean bl2 = FitsIntoOneLine = Unsigned.$lesseq_uint((int)(TheLine.Last.TotalLength + Indent), (int)(ColumnLimit = this.getColumnLimit(TheLine.InPPDirective, NextLine = Joiner.getNextMergedLine(DryRun, IndentTracker)))) || TheLine.Type == LineType.LT_ImportStatement && (this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript || !this.Style.JavaScriptWrapImports);
                    if (this.Style.ColumnLimit == 0) {
                        $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean(((NoColumnLimitLineFormatter)$c$.track((Object)new NoColumnLimitLineFormatter(this.Indenter, this.Whitespaces, this.Style, this))).formatLine(TheLine, Indent, DryRun));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                    if (FitsIntoOneLine) {
                        $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean(Penalty += ((NoLineBreakFormatter)$c$.track((Object)new NoLineBreakFormatter(this.Indenter, this.Whitespaces, this.Style, this))).formatLine(TheLine, Indent, DryRun));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean(Penalty += ((OptimizingLineFormatter)$c$.track((Object)new OptimizingLineFormatter(this.Indenter, this.Whitespaces, this.Style, this))).formatLine(TheLine, Indent, DryRun));
                    }
                    finally {
                        $c$.$destroy();
                    }
                    RangeMinLevel = std.min_uint((int)RangeMinLevel, (int)TheLine.Level);
                } else {
                    boolean StartsNewLine;
                    if (TheLine.ChildrenAffected) {
                        FormatToken Tok = TheLine.First;
                        while (Tok != null) {
                            if (!Tok.Children.empty()) {
                                this.format((SmallVectorImpl<AnnotatedLine>)Tok.Children, DryRun);
                            }
                            Tok = Tok.Next;
                        }
                    }
                    boolean bl3 = StartsNewLine = Unsigned.$greater_uint((int)TheLine.First.NewlinesBefore, (int)0) || TheLine.First.IsFirst;
                    if (StartsNewLine) {
                        IndentTracker.adjustToUnmodifiedLine(TheLine);
                    }
                    if (!DryRun) {
                        boolean ReformatLeadingWhitespace;
                        boolean bl4 = ReformatLeadingWhitespace = StartsNewLine && (PreviousLine != null && PreviousLine.Affected || TheLine.LeadingEmptyLinesAffected);
                        if (ReformatLeadingWhitespace) {
                            this.formatFirstToken(TheLine.First, PreviousLine, TheLine.Level, TheLine.First.OriginalColumn, TheLine.InPPDirective);
                        } else {
                            this.Whitespaces.addUntouchableToken(TheLine.First, TheLine.InPPDirective);
                        }
                        FormatToken Tok = TheLine.First.Next;
                        while (Tok != null) {
                            this.Whitespaces.addUntouchableToken(Tok, TheLine.InPPDirective);
                            Tok = Tok.Next;
                        }
                    }
                    NextLine = Joiner.getNextMergedLine(DryRun, IndentTracker);
                    RangeMinLevel = -1;
                }
                if (!DryRun) {
                    FormatStatics.markFinalized(TheLine.First);
                }
                PreviousLine = TheLine;
                Line = NextLine;
            }
            this.PenaltyCache.$set((Object)CacheKey, Penalty);
            int n = Penalty;
            return n;
        }
        finally {
            if (IndentTracker != null) {
                IndentTracker.$destroy();
            }
        }
    }

    private void formatFirstToken(FormatToken RootToken, AnnotatedLine PreviousLine, int IndentLevel, int Indent, boolean InPPDirective) {
        if (RootToken.is_TokenKind('\u0001')) {
            int Newlines = std.min_uint((int)RootToken.NewlinesBefore, (int)1);
            this.Whitespaces.replaceWhitespace(RootToken, Newlines, 0, 0, 0);
            return;
        }
        int Newlines = std.min_uint((int)RootToken.NewlinesBefore, (int)(this.Style.MaxEmptyLinesToKeep + 1));
        if (RootToken.is_TokenKind('\u0018') && (RootToken.Next == null || RootToken.Next.is_TokenKind('=') && RootToken.Next.Next == null)) {
            Newlines = std.min_uint((int)Newlines, (int)1);
        }
        if (Newlines == 0 && !RootToken.IsFirst) {
            Newlines = 1;
        }
        if (RootToken.IsFirst && !RootToken.HasUnescapedNewline) {
            Newlines = 0;
        }
        if (!this.Style.KeepEmptyLinesAtTheStartOfBlocks && PreviousLine != null && PreviousLine.Last.is_TokenKind('\u0017') && PreviousLine.First.isNot('\u0086') && !FormatStatics.startsExternCBlock(PreviousLine)) {
            Newlines = 1;
        }
        if (PreviousLine != null && PreviousLine.Last.isOneOf('=', '\u0018') && RootToken.isAccessSpecifier() && RootToken.NewlinesBefore == 1) {
            ++Newlines;
        }
        if (!(PreviousLine == null || !PreviousLine.First.isAccessSpecifier() || PreviousLine.InPPDirective && RootToken.HasUnescapedNewline)) {
            Newlines = std.min_uint((int)1, (int)Newlines);
        }
        this.Whitespaces.replaceWhitespace(RootToken, Newlines, IndentLevel, Indent, Indent, InPPDirective && !RootToken.HasUnescapedNewline);
    }

    private int getColumnLimit(boolean InPPDirective, AnnotatedLine NextLine) {
        boolean ContinuesPPDirective = InPPDirective && (NextLine == null || NextLine.InPPDirective && !NextLine.First.HasUnescapedNewline);
        return this.Style.ColumnLimit - (ContinuesPPDirective ? 2 : 0);
    }

    public void $destroy() {
        this.PenaltyCache.$destroy();
    }

    public String toString() {
        return "PenaltyCache=" + this.PenaltyCache + ", Indenter=" + this.Indenter + ", Whitespaces=[WhitespaceManager], Style=" + this.Style + ", Keywords=" + this.Keywords + ", IncompleteFormat=" + this.IncompleteFormat;
    }
}

