/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.FileID;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierTable;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.format.FormatGlobals;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.EncodingStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.FormatTokenLexer$tryMergePreviousTokens$$;
import org.clang.format.impl.TokenType;
import org.clang.format.java.FormatFunctionPointers;
import org.clang.lex.Lexer;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUShort;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.Regex;
import org.llvm.support.SpecificBumpPtrAllocator;
import org.llvm.support.llvm;

public class FormatTokenLexer
implements Destructors.ClassWithDestructor {
    private FormatToken FormatTok = null;
    private boolean IsFirstToken = true;
    private boolean GreaterStashed = false;
    private boolean LessStashed = false;
    private int Column = 0;
    private int TrailingWhitespace = 0;
    private std_ptr.unique_ptr<Lexer> Lex = new std_ptr.unique_ptr();
    private final SourceManager SourceMgr;
    private FileID ID;
    private final FormatStyle Style;
    private IdentifierTable IdentTable;
    private AdditionalKeywords Keywords;
    private EncodingStatics.Encoding Encoding;
    private SpecificBumpPtrAllocator<FormatToken> Allocator;
    private int FirstInLineIndex;
    private SmallVector<FormatToken> Tokens;
    private SmallVector<IdentifierInfo> ForEachMacros;
    private boolean FormattingDisabled;
    private Regex MacroBlockBeginRegex;
    private Regex MacroBlockEndRegex;

    public FormatTokenLexer(SourceManager SourceMgr, FileID ID, FormatStyle Style, EncodingStatics.Encoding $Encoding) {
        this.SourceMgr = SourceMgr;
        this.ID = new FileID(ID);
        this.Style = Style;
        this.IdentTable = new IdentifierTable(FormatGlobals.getFormattingLangOpts(Style));
        this.Keywords = new AdditionalKeywords(this.IdentTable);
        this.Encoding = $Encoding;
        this.Allocator = new SpecificBumpPtrAllocator(FormatToken.class);
        this.FirstInLineIndex = 0;
        this.Tokens = new SmallVector(16, (Object)null);
        this.ForEachMacros = new SmallVector(8, (Object)null);
        this.FormattingDisabled = false;
        this.MacroBlockBeginRegex = new Regex(new StringRef(Style.MacroBlockBegin));
        this.MacroBlockEndRegex = new Regex(new StringRef(Style.MacroBlockEnd));
        this.Lex.reset((Object)new Lexer(ID, SourceMgr.getBuffer(ID), SourceMgr, FormatGlobals.getFormattingLangOpts(Style)));
        ((Lexer)this.Lex.$arrow()).SetKeepWhitespaceMode(true);
        for (std.string ForEachMacro : Style.ForEachMacros) {
            this.ForEachMacros.push_back((Object)this.IdentTable.get(ForEachMacro));
        }
        std.sort((type.iterator)this.ForEachMacros.begin(), (type.iterator)this.ForEachMacros.end());
    }

    public ArrayRef<FormatToken> lex() {
        assert (this.Tokens.empty());
        assert (this.FirstInLineIndex == 0);
        do {
            this.Tokens.push_back((Object)this.getNextToken());
            if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                this.tryParseJSRegexLiteral();
                this.tryParseTemplateString();
            }
            this.tryMergePreviousTokens();
            if (!Unsigned.$greater_uint((int)((FormatToken)this.Tokens.back()).NewlinesBefore, (int)0) && !((FormatToken)this.Tokens.back()).IsMultiline) continue;
            this.FirstInLineIndex = this.Tokens.size() - 1;
        } while (((FormatToken)this.Tokens.back()).Tok.isNot('\u0001'));
        return new ArrayRef(this.Tokens, true);
    }

    public AdditionalKeywords getKeywords() {
        return this.Keywords;
    }

    private void tryMergePreviousTokens() {
        if (this.tryMerge_TMacro()) {
            return;
        }
        if (this.tryMergeConflictMarkers()) {
            return;
        }
        if (this.tryMergeLessLess()) {
            return;
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
            char[] JSIdentity = FormatTokenLexer$tryMergePreviousTokens$$.JSIdentity;
            char[] JSNotIdentity = FormatTokenLexer$tryMergePreviousTokens$$.JSNotIdentity;
            char[] JSShiftEqual = FormatTokenLexer$tryMergePreviousTokens$$.JSShiftEqual;
            char[] JSRightArrow = FormatTokenLexer$tryMergePreviousTokens$$.JSRightArrow;
            if (this.tryMergeTokens(new ArrayRefUShort(JSIdentity), TokenType.TT_BinaryOperator)) {
                return;
            }
            if (this.tryMergeTokens(new ArrayRefUShort(JSNotIdentity), TokenType.TT_BinaryOperator)) {
                return;
            }
            if (this.tryMergeTokens(new ArrayRefUShort(JSShiftEqual), TokenType.TT_BinaryOperator)) {
                return;
            }
            if (this.tryMergeTokens(new ArrayRefUShort(JSRightArrow), TokenType.TT_JsFatArrow)) {
                return;
            }
        }
    }

    private boolean tryMergeLessLess() {
        type.ptr First;
        if (Unsigned.$less_uint((int)this.Tokens.size(), (int)3)) {
            return false;
        }
        boolean FourthTokenIsLess = false;
        if (Unsigned.$greater_uint((int)this.Tokens.size(), (int)3)) {
            FourthTokenIsLess = ((FormatToken)((type.ptr)this.Tokens.end().$sub(4)).$at(0)).is_TokenKind('.');
        }
        if (((FormatToken)(First = (type.ptr)Native.$tryClone((NativeCloneable)this.Tokens.end().$sub(3))).$at(2)).is_TokenKind('.') || ((FormatToken)First.$at(1)).isNot('.') || ((FormatToken)First.$at(0)).isNot('.') || FourthTokenIsLess) {
            return false;
        }
        if (BasicClangGlobals.$noteq_SourceLocation$C((SourceLocation)((FormatToken)First.$at((int)1)).WhitespaceRange.getBegin(), (SourceLocation)((FormatToken)First.$at((int)1)).WhitespaceRange.getEnd())) {
            return false;
        }
        ((FormatToken)First.$at((int)0)).Tok.setKind('/');
        ((FormatToken)First.$at((int)0)).TokenText.$assignMove(NativePointer.$LT_LT);
        ++((FormatToken)First.$at((int)0)).ColumnWidth;
        this.Tokens.erase((type.ptr)this.Tokens.end().$sub(2));
        return true;
    }

    private boolean tryMergeTokens(ArrayRefUShort Kinds, TokenType NewType) {
        if (Unsigned.$less_uint((int)this.Tokens.size(), (int)Kinds.size())) {
            return false;
        }
        type.ptr First = (type.ptr)Native.$tryClone((NativeCloneable)this.Tokens.end().$sub(Kinds.size()));
        if (!((FormatToken)First.$at(0)).is_TokenKind(Kinds.$at(0))) {
            return false;
        }
        int AddLength = 0;
        int i = 1;
        while (Unsigned.$less_uint((int)i, (int)Kinds.size())) {
            if (!((FormatToken)First.$at(i)).is_TokenKind(Kinds.$at(i)) || BasicClangGlobals.$noteq_SourceLocation$C((SourceLocation)((FormatToken)First.$at((int)i)).WhitespaceRange.getBegin(), (SourceLocation)((FormatToken)First.$at((int)i)).WhitespaceRange.getEnd())) {
                return false;
            }
            AddLength += ((FormatToken)First.$at((int)i)).TokenText.size();
            ++i;
        }
        this.Tokens.resize(this.Tokens.size() - Kinds.size() + 1);
        ((FormatToken)First.$at((int)0)).TokenText.$assignMove(new StringRef(((FormatToken)First.$at((int)0)).TokenText.data(), ((FormatToken)First.$at((int)0)).TokenText.size() + AddLength));
        ((FormatToken)First.$at((int)0)).ColumnWidth += AddLength;
        ((FormatToken)First.$at((int)0)).Type = NewType;
        return true;
    }

    private boolean precedesOperand(FormatToken Tok) {
        return Tok.isOneOf('\u0019', '\u0015', '@', '\u0017', '\u0018', '\u0013', '=', '(', '<', ';', '\'') || Tok.isOneOf('`', 'R', 'M', '\u0090', 'T', '\u0087', '\u007f', 'j', '\u00bb') || Tok.isOneOf(this.Keywords.kw_instanceof, this.Keywords.kw_in) || Tok.isBinaryOperator();
    }

    private boolean canPrecedeRegexLiteral(FormatToken Prev) {
        if (Prev == null) {
            return true;
        }
        if (Prev.isOneOf('!', '%')) {
            return Unsigned.$less_uint((int)this.Tokens.size(), (int)3) || this.precedesOperand((FormatToken)this.Tokens.$at(this.Tokens.size() - 3));
        }
        return this.precedesOperand(Prev);
    }

    private void tryParseJSRegexLiteral() {
        FormatToken RegexToken = (FormatToken)this.Tokens.back();
        if (!RegexToken.isOneOf('*', '+')) {
            return;
        }
        FormatToken Prev = null;
        std.reverse_iterator I = this.Tokens.rbegin().$add(1);
        std.reverse_iterator E = this.Tokens.rend();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
            if (((FormatToken)I.$star()).isNot('\u0004')) {
                Prev = (FormatToken)I.$star();
                break;
            }
            I.$preInc();
        }
        if (!this.canPrecedeRegexLiteral(Prev)) {
            return;
        }
        char.ptr Offset = Native.$tryClone((char.ptr)((Lexer)this.Lex.$arrow()).getBufferLocation());
        char.ptr RegexBegin = Native.$tryClone((char.ptr)((char.ptr)Offset.$sub(RegexToken.TokenText.size())));
        StringRef Buffer = ((Lexer)this.Lex.$arrow()).getBuffer();
        boolean InCharacterClass = false;
        boolean HaveClosingSlash = false;
        while (!HaveClosingSlash && Native.$noteq_ptr((void.ptr)Offset, (void.ptr)Buffer.end())) {
            switch (Offset.$star()) {
                case 92: {
                    Offset.$preInc();
                    break;
                }
                case 91: {
                    InCharacterClass = true;
                    break;
                }
                case 93: {
                    InCharacterClass = false;
                    break;
                }
                case 47: {
                    if (InCharacterClass) break;
                    HaveClosingSlash = true;
                }
            }
            Offset.$preInc();
        }
        RegexToken.Type = TokenType.TT_RegexLiteral;
        RegexToken.Tok.setKind('\r');
        RegexToken.TokenText.$assignMove(new StringRef(RegexBegin, Offset.$sub((abstract_iterator)RegexBegin)));
        RegexToken.ColumnWidth = RegexToken.TokenText.size();
        this.resetLexer(this.SourceMgr.getFileOffset(((Lexer)this.Lex.$arrow()).getCharSourceLocation(Offset)));
    }

    private void tryParseTemplateString() {
        FormatToken BacktickToken = (FormatToken)this.Tokens.back();
        if (!BacktickToken.is_TokenKind('\u0000') && !BacktickToken.Tok.isIncomplete() || llvm.$noteq_StringRef((StringRef)BacktickToken.TokenText, (String)"`")) {
            return;
        }
        char.ptr Offset = Native.$tryClone((char.ptr)((Lexer)this.Lex.$arrow()).getBufferLocation());
        char.ptr TmplBegin = Native.$tryClone((char.ptr)((char.ptr)Offset.$sub(BacktickToken.TokenText.size())));
        while (Native.$noteq_ptr((void.ptr)Offset, (void.ptr)((Lexer)this.Lex.$arrow()).getBuffer().end()) && Offset.$star() != 96) {
            if (Offset.$star() == 92) {
                Offset.$preInc();
            }
            Offset.$preInc();
        }
        StringRef LiteralText = new StringRef(TmplBegin, Offset.$sub((abstract_iterator)TmplBegin) + 1);
        BacktickToken.Type = TokenType.TT_TemplateString;
        BacktickToken.Tok.setKind('\r');
        BacktickToken.TokenText.$assign(LiteralText);
        int FirstBreak = LiteralText.find((byte)10);
        StringRef FirstLineText = FirstBreak == StringRef.npos ? new StringRef(LiteralText) : LiteralText.substr(0, FirstBreak);
        BacktickToken.ColumnWidth = EncodingStatics.columnWidthWithTabs(new StringRef(FirstLineText), BacktickToken.OriginalColumn, this.Style.TabWidth, this.Encoding);
        int LastBreak = LiteralText.rfind((byte)10);
        if (LastBreak != StringRef.npos) {
            BacktickToken.IsMultiline = true;
            int StartColumn = 0;
            BacktickToken.LastLineColumnWidth = EncodingStatics.columnWidthWithTabs(LiteralText.substr(LastBreak + 1, LiteralText.size()), StartColumn, this.Style.TabWidth, this.Encoding);
        }
        this.resetLexer(this.SourceMgr.getFileOffset(((Lexer)this.Lex.$arrow()).getCharSourceLocation((char.ptr)Offset.$add(1))));
    }

    private boolean tryMerge_TMacro() {
        if (Unsigned.$less_uint((int)this.Tokens.size(), (int)4)) {
            return false;
        }
        FormatToken Last = (FormatToken)this.Tokens.back();
        if (!Last.is_TokenKind('\u0016')) {
            return false;
        }
        FormatToken String2 = (FormatToken)this.Tokens.$at(this.Tokens.size() - 2);
        if (!String2.is_TokenKind('\r') || String2.IsMultiline) {
            return false;
        }
        if (!((FormatToken)this.Tokens.$at(this.Tokens.size() - 3)).is_TokenKind('\u0015')) {
            return false;
        }
        FormatToken Macro = (FormatToken)this.Tokens.$at(this.Tokens.size() - 4);
        if (llvm.$noteq_StringRef((StringRef)Macro.TokenText, (String)"_T")) {
            return false;
        }
        char.ptr Start = Native.$tryClone((char.ptr)Macro.TokenText.data());
        char.ptr End = Native.$tryClone((char.ptr)((char.ptr)Last.TokenText.data().$add(Last.TokenText.size())));
        String2.TokenText.$assignMove(new StringRef(Start, End.$sub((abstract_iterator)Start)));
        String2.IsFirst = Macro.IsFirst;
        String2.LastNewlineOffset = Macro.LastNewlineOffset;
        String2.WhitespaceRange.$assign(Macro.WhitespaceRange);
        String2.OriginalColumn = Macro.OriginalColumn;
        String2.ColumnWidth = EncodingStatics.columnWidthWithTabs(new StringRef(String2.TokenText), String2.OriginalColumn, this.Style.TabWidth, this.Encoding);
        String2.NewlinesBefore = Macro.NewlinesBefore;
        String2.HasUnescapedNewline = Macro.HasUnescapedNewline;
        this.Tokens.pop_back();
        this.Tokens.pop_back();
        this.Tokens.pop_back();
        this.Tokens.ref$back().$set((Object)String2);
        return true;
    }

    private boolean tryMergeConflictMarkers() {
        if (((FormatToken)this.Tokens.back()).NewlinesBefore == 0 && ((FormatToken)this.Tokens.back()).isNot('\u0001')) {
            return false;
        }
        std_pair.pairTypeUInt tmp = this.SourceMgr.getDecomposedLoc(((FormatToken)this.Tokens.$at(this.FirstInLineIndex)).getStartOfNonWhitespace());
        FileID ID = (FileID)tmp.first;
        int FirstInLineOffset = tmp.second;
        StringRef Buffer = this.SourceMgr.getBuffer(ID).getBuffer();
        int LineOffset = Buffer.rfind((byte)10, FirstInLineOffset);
        LineOffset = LineOffset == StringRef.npos ? 0 : ++LineOffset;
        int FirstSpace = Buffer.find_first_of(" \n", LineOffset);
        StringRef LineStart = new StringRef();
        if (FirstSpace == StringRef.npos) {
            LineStart.$assignMove(Buffer.substr(LineOffset));
        } else {
            LineStart.$assignMove(Buffer.substr(LineOffset, FirstSpace - LineOffset));
        }
        TokenType Type2 = TokenType.TT_Unknown;
        if (llvm.$eq_StringRef((StringRef)LineStart, (String)"<<<<<<<") || llvm.$eq_StringRef((StringRef)LineStart, (String)">>>>")) {
            Type2 = TokenType.TT_ConflictStart;
        } else if (llvm.$eq_StringRef((StringRef)LineStart, (String)"|||||||") || llvm.$eq_StringRef((StringRef)LineStart, (String)"=======") || llvm.$eq_StringRef((StringRef)LineStart, (String)"====")) {
            Type2 = TokenType.TT_ConflictAlternative;
        } else if (llvm.$eq_StringRef((StringRef)LineStart, (String)">>>>>>>") || llvm.$eq_StringRef((StringRef)LineStart, (String)"<<<<")) {
            Type2 = TokenType.TT_ConflictEnd;
        }
        if (Type2 != TokenType.TT_Unknown) {
            FormatToken Next = (FormatToken)this.Tokens.back();
            this.Tokens.resize(this.FirstInLineIndex + 1);
            ((FormatToken)this.Tokens.back()).Type = Type2;
            ((FormatToken)this.Tokens.back()).Tok.setKind('\u0144');
            this.Tokens.push_back((Object)Next);
            return true;
        }
        return false;
    }

    private FormatToken getStashedToken() {
        Token Tok = new Token(this.FormatTok.Tok);
        StringRef TokenText = new StringRef(this.FormatTok.TokenText);
        int OriginalColumn = this.FormatTok.OriginalColumn;
        this.FormatTok = (FormatToken)Native.$new_uint_voidPtr((Object)this.Allocator.Allocate(), New$Mem -> new FormatToken());
        this.FormatTok.Tok.$assign(Tok);
        SourceLocation TokLocation = this.FormatTok.Tok.getLocation().getLocWithOffset(Tok.getLength() - 1);
        this.FormatTok.Tok.setLocation(TokLocation);
        this.FormatTok.WhitespaceRange.$assignMove(new SourceRange(TokLocation, TokLocation));
        this.FormatTok.TokenText.$assign(TokenText);
        this.FormatTok.ColumnWidth = 1;
        this.FormatTok.OriginalColumn = OriginalColumn + 1;
        return this.FormatTok;
    }

    private FormatToken getNextToken() {
        StringRef Text;
        if (this.GreaterStashed) {
            this.GreaterStashed = false;
            return this.getStashedToken();
        }
        if (this.LessStashed) {
            this.LessStashed = false;
            return this.getStashedToken();
        }
        this.FormatTok = (FormatToken)Native.$new_uint_voidPtr((Object)this.Allocator.Allocate(), New$Mem -> new FormatToken());
        this.readRawToken(this.FormatTok);
        SourceLocation WhitespaceStart = this.FormatTok.Tok.getLocation().getLocWithOffset(-this.TrailingWhitespace);
        this.FormatTok.IsFirst = this.IsFirstToken;
        this.IsFirstToken = false;
        int WhitespaceLength = this.TrailingWhitespace;
        while (this.FormatTok.Tok.is('\u0000') || this.FormatTok.Tok.isIncomplete()) {
            Text = new StringRef(this.FormatTok.TokenText);
            FormatFunctionPointers.Int2UInt EscapesNewline = pos -> {
                if (pos >= 0 && Text.$at(pos) == 13) {
                    --pos;
                }
                int count = 0;
                while (pos >= 0 && Text.$at(pos) == 92) {
                    --pos;
                    ++count;
                }
                return count & 1;
            };
            int e = Text.size();
            for (int i = 0; i != e; ++i) {
                switch (Text.$at(i)) {
                    case 10: {
                        ++this.FormatTok.NewlinesBefore;
                        this.FormatTok.HasUnescapedNewline = EscapesNewline.$call(i - 1) == 0;
                        this.FormatTok.LastNewlineOffset = WhitespaceLength + i + 1;
                        this.Column = 0;
                        break;
                    }
                    case 13: {
                        this.FormatTok.LastNewlineOffset = WhitespaceLength + i + 1;
                        this.Column = 0;
                        break;
                    }
                    case 11: 
                    case 12: {
                        this.Column = 0;
                        break;
                    }
                    case 32: {
                        ++this.Column;
                        break;
                    }
                    case 9: {
                        this.Column += this.Style.TabWidth - Unsigned.$rem_uint((int)this.Column, (int)this.Style.TabWidth);
                        break;
                    }
                    case 92: {
                        if (i + 1 != e && (Text.$at(i + 1) == 13 || Text.$at(i + 1) == 10)) break;
                        this.FormatTok.Type = TokenType.TT_ImplicitStringLiteral;
                        break;
                    }
                    default: {
                        this.FormatTok.Type = TokenType.TT_ImplicitStringLiteral;
                    }
                }
                if (this.FormatTok.Type == TokenType.TT_ImplicitStringLiteral) break;
            }
            if (this.FormatTok.is_TokenType(TokenType.TT_ImplicitStringLiteral)) break;
            WhitespaceLength += this.FormatTok.Tok.getLength();
            this.readRawToken(this.FormatTok);
        }
        while (Unsigned.$greater_uint((int)this.FormatTok.TokenText.size(), (int)1) && this.FormatTok.TokenText.$at(0) == 92 && this.FormatTok.TokenText.$at(1) == 10) {
            ++this.FormatTok.NewlinesBefore;
            WhitespaceLength += 2;
            this.FormatTok.LastNewlineOffset = 2;
            this.Column = 0;
            this.FormatTok.TokenText.$assignMove(this.FormatTok.TokenText.substr(2));
        }
        this.FormatTok.WhitespaceRange.$assignMove(new SourceRange(WhitespaceStart, WhitespaceStart.getLocWithOffset(WhitespaceLength)));
        this.FormatTok.OriginalColumn = this.Column;
        this.TrailingWhitespace = 0;
        if (this.FormatTok.Tok.is('\u0004')) {
            StringRef UntrimmedText = new StringRef(this.FormatTok.TokenText);
            this.FormatTok.TokenText.$assignMove(this.FormatTok.TokenText.rtrim(" \t\u000b\f"));
            this.TrailingWhitespace = UntrimmedText.size() - this.FormatTok.TokenText.size();
        } else if (this.FormatTok.Tok.is('\u0006')) {
            IdentifierInfo Info = this.IdentTable.get(this.FormatTok.TokenText.$string());
            this.FormatTok.Tok.setIdentifierInfo(Info);
            this.FormatTok.Tok.setKind(Info.getTokenID());
            if (this.Style.Language == FormatStyle.LanguageKind.LK_Java && this.FormatTok.isOneOf('e', 'h', '\u007f', '\u0088')) {
                this.FormatTok.Tok.setKind('\u0005');
                this.FormatTok.Tok.setIdentifierInfo((IdentifierInfo)null);
            } else if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && this.FormatTok.isOneOf('e', 'h', '\u0088')) {
                this.FormatTok.Tok.setKind('\u0005');
                this.FormatTok.Tok.setIdentifierInfo((IdentifierInfo)null);
            }
        } else if (this.FormatTok.Tok.is('3')) {
            this.FormatTok.Tok.setKind('2');
            this.FormatTok.TokenText.$assignMove(this.FormatTok.TokenText.substr(0, 1));
            this.GreaterStashed = true;
        } else if (this.FormatTok.Tok.is('/')) {
            this.FormatTok.Tok.setKind('.');
            this.FormatTok.TokenText.$assignMove(this.FormatTok.TokenText.substr(0, 1));
            this.LessStashed = true;
        }
        Text = new StringRef(this.FormatTok.TokenText);
        int FirstNewlinePos = Text.find((byte)10);
        if (FirstNewlinePos == StringRef.npos) {
            this.FormatTok.ColumnWidth = EncodingStatics.columnWidthWithTabs(new StringRef(Text), this.Column, this.Style.TabWidth, this.Encoding);
            this.Column += this.FormatTok.ColumnWidth;
        } else {
            this.FormatTok.IsMultiline = true;
            this.FormatTok.ColumnWidth = EncodingStatics.columnWidthWithTabs(Text.substr(0, FirstNewlinePos), this.Column, this.Style.TabWidth, this.Encoding);
            this.Column = this.FormatTok.LastLineColumnWidth = EncodingStatics.columnWidthWithTabs(Text.substr(Text.find_last_of((byte)10) + 1), 0, this.Style.TabWidth, this.Encoding);
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Cpp) {
            if ((!Unsigned.$greater_uint((int)this.Tokens.size(), (int)0) || ((FormatToken)this.Tokens.back()).Tok.getIdentifierInfo() == null || ((FormatToken)this.Tokens.back()).Tok.getIdentifierInfo().getPPKeywordID() != '\n') && Native.$noteq_ptr((void.ptr)((void.ptr)std.find((type.iterator)this.ForEachMacros.begin(), (type.iterator)this.ForEachMacros.end(), (Object)this.FormatTok.Tok.getIdentifierInfo(), (boolean)true)), (void.ptr)this.ForEachMacros.end())) {
                this.FormatTok.Type = TokenType.TT_ForEachMacro;
            } else if (this.FormatTok.is_TokenKind('\u0005')) {
                if (this.MacroBlockBeginRegex.find(Text)) {
                    this.FormatTok.Type = TokenType.TT_MacroBlockBegin;
                } else if (this.MacroBlockEndRegex.find(Text)) {
                    this.FormatTok.Type = TokenType.TT_MacroBlockEnd;
                }
            }
        }
        return this.FormatTok;
    }

    private void readRawToken(FormatToken Tok) {
        ((Lexer)this.Lex.$arrow()).LexFromRawLexer(Tok.Tok);
        Tok.TokenText.$assignMove(this.SourceMgr.getCharacterDataStringRef_ValidOnly(Tok.Tok.getLocation().getRawEncoding(), Tok.Tok.getEndLoc().getRawEncoding()));
        if (Tok.is_TokenKind('\u0000') || Tok.Tok.isIncomplete()) {
            if (!Tok.TokenText.empty() && Tok.TokenText.$at(0) == 34) {
                if (Tok.Tok.getKind() == '\r') {
                    Tok.Tok.clearFlag('\u8000');
                } else {
                    Tok.Tok.setKind('\r');
                }
                Tok.IsUnterminatedLiteral = true;
            } else if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && llvm.$eq_StringRef((StringRef)Tok.TokenText, (String)"''")) {
                Tok.Tok.setKind('\r');
            }
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && Tok.is_TokenKind('\b')) {
            Tok.Tok.setKind('\r');
        }
        if (Tok.is_TokenKind('\u0004') && (llvm.$eq_StringRef((StringRef)Tok.TokenText, (String)"// clang-format on") || llvm.$eq_StringRef((StringRef)Tok.TokenText, (String)"/* clang-format on */"))) {
            this.FormattingDisabled = false;
        }
        Tok.Finalized = this.FormattingDisabled;
        if (Tok.is_TokenKind('\u0004') && (llvm.$eq_StringRef((StringRef)Tok.TokenText, (String)"// clang-format off") || llvm.$eq_StringRef((StringRef)Tok.TokenText, (String)"/* clang-format off */"))) {
            this.FormattingDisabled = true;
        }
    }

    private void resetLexer(int Offset) {
        StringRef Buffer = this.SourceMgr.getBufferData(this.ID);
        this.Lex.reset((Object)new Lexer(this.SourceMgr.getLocForStartOfFile(this.ID), FormatGlobals.getFormattingLangOpts(this.Style), Buffer.begin(), (char.ptr)Buffer.begin().$add(Offset), Buffer.end()));
        ((Lexer)this.Lex.$arrow()).SetKeepWhitespaceMode(true);
        this.TrailingWhitespace = 0;
    }

    public void $destroy() {
        this.MacroBlockEndRegex.$destroy();
        this.MacroBlockBeginRegex.$destroy();
        this.ForEachMacros.$destroy();
        this.Tokens.$destroy();
        this.Allocator.$destroy();
        this.IdentTable.$destroy();
        this.Lex.$destroy();
    }

    public String toString() {
        return "FormatTok=" + this.FormatTok + ", IsFirstToken=" + this.IsFirstToken + ", GreaterStashed=" + this.GreaterStashed + ", LessStashed=" + this.LessStashed + ", Column=" + this.Column + ", TrailingWhitespace=" + this.TrailingWhitespace + ", Lex=[Unique_ptr$Lexer], SourceMgr=[SourceManager], ID=" + this.ID + ", Style=" + this.Style + ", IdentTable=" + this.IdentTable + ", Keywords=" + this.Keywords + ", Encoding=" + (Object)((Object)this.Encoding) + ", Allocator=" + this.Allocator + ", FirstInLineIndex=" + this.FirstInLineIndex + ", Tokens=" + this.Tokens + ", ForEachMacros=" + this.ForEachMacros + ", FormattingDisabled=" + this.FormattingDisabled + ", MacroBlockBeginRegex=" + this.MacroBlockBeginRegex + ", MacroBlockEndRegex=" + this.MacroBlockEndRegex;
    }
}

