/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.prec;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.TokenType;

public class ExpressionParser {
    private final FormatStyle Style;
    private final AdditionalKeywords Keywords;
    private FormatToken Current;

    public ExpressionParser(FormatStyle Style, AdditionalKeywords Keywords, AnnotatedLine Line) {
        this.Style = Style;
        this.Keywords = Keywords;
        this.Current = Line.First;
    }

    public void parse() {
        this.parse(0);
    }

    public void parse(int Precedence) {
        while (this.Current != null && (this.Current.is_TokenKind('`') || this.Current.is_TokenKind('<') && this.Current.isOneOf(TokenType.TT_ObjCMethodExpr, TokenType.TT_DictLiteral))) {
            this.next();
        }
        if (this.Current == null || Precedence > FormatStatics.PrecedenceArrowAndPeriod) {
            return;
        }
        if (Precedence == prec.Level.Conditional.getValue()) {
            this.parseConditionalExpr();
            return;
        }
        if (Precedence == FormatStatics.PrecedenceUnaryOperator) {
            this.parseUnaryOperator();
            return;
        }
        FormatToken Start = this.Current;
        FormatToken LatestOperator = null;
        int OperatorIndex = 0;
        while (this.Current != null) {
            this.parse(Precedence + 1);
            int CurrentPrecedence = this.getCurrentPrecedence();
            if (this.Current != null && this.Current.is_TokenType(TokenType.TT_SelectorName) && Precedence == CurrentPrecedence) {
                if (LatestOperator != null) {
                    this.addFakeParenthesis(Start, prec.Level.valueOf((int)Precedence));
                }
                Start = this.Current;
            }
            if (this.Current == null || this.Current.closesScope() && this.Current.MatchingParen != null || CurrentPrecedence != -1 && CurrentPrecedence < Precedence || CurrentPrecedence == prec.Level.Conditional.getValue() && Precedence == prec.Level.Assignment.getValue() && this.Current.is_TokenKind('<')) break;
            if (this.Current.opensScope()) {
                while (this.Current != null && !this.Current.closesScope()) {
                    this.next();
                    this.parse();
                }
                this.next();
                continue;
            }
            if (CurrentPrecedence == Precedence) {
                if (LatestOperator != null) {
                    LatestOperator.NextOperator = this.Current;
                }
                LatestOperator = this.Current;
                this.Current.OperatorIndex = OperatorIndex++;
            }
            this.next(Precedence > 0);
        }
        if (LatestOperator != null && (this.Current != null || Precedence > 0)) {
            if (Precedence == FormatStatics.PrecedenceArrowAndPeriod) {
                this.addFakeParenthesis(Start, prec.Level.Unknown);
            } else {
                this.addFakeParenthesis(Start, prec.Level.valueOf((int)Precedence));
            }
        }
    }

    private int getCurrentPrecedence() {
        if (this.Current != null) {
            FormatToken NextNonComment = this.Current.getNextNonComment();
            if (this.Current.is_TokenType(TokenType.TT_ConditionalExpr)) {
                return prec.Level.Conditional.getValue();
            }
            if (NextNonComment != null && NextNonComment.is_TokenKind('<') && NextNonComment.is_TokenType(TokenType.TT_DictLiteral)) {
                return prec.Level.Comma.getValue();
            }
            if (this.Current.is_TokenType(TokenType.TT_LambdaArrow)) {
                return prec.Level.Comma.getValue();
            }
            if (this.Current.is_TokenType(TokenType.TT_JsFatArrow)) {
                return prec.Level.Assignment.getValue();
            }
            if (this.Current.isOneOf('=', TokenType.TT_InlineASMColon, TokenType.TT_SelectorName, TokenType.TT_JsComputedPropertyName) || this.Current.is_TokenKind('\u0004') && NextNonComment != null && NextNonComment.is_TokenType(TokenType.TT_SelectorName)) {
                return 0;
            }
            if (this.Current.is_TokenType(TokenType.TT_RangeBasedForLoopColon)) {
                return prec.Level.Comma.getValue();
            }
            if ((this.Style.Language == FormatStyle.LanguageKind.LK_Java || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) && this.Current.is(this.Keywords.kw_instanceof)) {
                return prec.Level.Relational.getValue();
            }
            if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && this.Current.is(this.Keywords.kw_in)) {
                return prec.Level.Relational.getValue();
            }
            if (this.Current.is_TokenType(TokenType.TT_BinaryOperator) || this.Current.is_TokenKind('@')) {
                return this.Current.getPrecedence().getValue();
            }
            if (this.Current.isOneOf('\u0019', '$')) {
                return FormatStatics.PrecedenceArrowAndPeriod;
            }
            if ((this.Style.Language == FormatStyle.LanguageKind.LK_Java || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) && this.Current.isOneOf(this.Keywords.kw_extends, this.Keywords.kw_implements, this.Keywords.kw_throws)) {
                return 0;
            }
        }
        return -1;
    }

    private void addFakeParenthesis(FormatToken Start, prec.Level Precedence) {
        Start.FakeLParens.push_back((Object)Precedence);
        if (Precedence.getValue() > prec.Level.Unknown.getValue()) {
            Start.StartsBinaryExpression = true;
        }
        if (this.Current != null) {
            FormatToken Previous = this.Current.Previous;
            while (Previous.is_TokenKind('\u0004') && Previous.Previous != null) {
                Previous = Previous.Previous;
            }
            ++Previous.FakeRParens;
            if (Precedence.getValue() > prec.Level.Unknown.getValue()) {
                Previous.EndsBinaryExpression = true;
            }
        }
    }

    private void parseUnaryOperator() {
        if (this.Current == null || this.Current.isNot(TokenType.TT_UnaryOperator)) {
            this.parse(FormatStatics.PrecedenceArrowAndPeriod);
            return;
        }
        FormatToken Start = this.Current;
        this.next();
        this.parseUnaryOperator();
        this.addFakeParenthesis(Start, prec.Level.Unknown);
    }

    private void parseConditionalExpr() {
        while (this.Current != null && this.Current.isTrailingComment()) {
            this.next();
        }
        FormatToken Start = this.Current;
        this.parse(prec.Level.LogicalOr.getValue());
        if (this.Current == null || !this.Current.is_TokenKind(';')) {
            return;
        }
        this.next();
        this.parse(prec.Level.Assignment.getValue());
        if (this.Current == null || this.Current.isNot(TokenType.TT_ConditionalExpr)) {
            return;
        }
        this.next();
        this.parse(prec.Level.Assignment.getValue());
        this.addFakeParenthesis(Start, prec.Level.Conditional);
    }

    private void next() {
        this.next(true);
    }

    private void next(boolean SkipPastLeadingComments) {
        if (this.Current != null) {
            this.Current = this.Current.Next;
        }
        while (this.Current != null && (this.Current.NewlinesBefore == 0 || SkipPastLeadingComments) && this.Current.isTrailingComment()) {
            this.Current = this.Current.Next;
        }
    }

    public String toString() {
        return "Style=" + this.Style + ", Keywords=" + this.Keywords + ", Current=" + this.Current;
    }
}

