/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Iterator;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileID;
import org.clang.basic.FileManager;
import org.clang.basic.FileSystemOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.basic.vfs.InMemoryFileSystem;
import org.clang.tooling.core.Range;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;

public class Environment
implements Destructors.ClassWithDestructor {
    private FileID ID;
    private StringRef FileName;
    private SmallVector<CharSourceRange> CharRanges;
    private final SourceManager SM;
    private std_ptr.unique_ptr<FileManager> FileMgr;
    private std_ptr.unique_ptr<SourceManager> VirtualSM;
    private std_ptr.unique_ptr<DiagnosticsEngine> Diagnostics;

    public Environment(SourceManager SM, FileID ID, ArrayRef<CharSourceRange> Ranges) {
        this.ID = new FileID(ID);
        this.FileName = new StringRef();
        this.CharRanges = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, (type.iterator)Ranges.begin(), (type.iterator)Ranges.end(), (Object)new CharSourceRange());
        this.SM = SM;
        this.FileMgr = new std_ptr.unique_ptr();
        this.VirtualSM = new std_ptr.unique_ptr();
        this.Diagnostics = new std_ptr.unique_ptr();
    }

    public Environment(FileID ID, std_ptr.unique_ptr<FileManager> FileMgr, std_ptr.unique_ptr<SourceManager> VirtualSM, std_ptr.unique_ptr<DiagnosticsEngine> Diagnostics, std.vector<CharSourceRange> CharRanges) {
        this.ID = new FileID(ID);
        this.FileName = new StringRef();
        this.CharRanges = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, (type.iterator)CharRanges.begin$Const(), (type.iterator)CharRanges.end$Const(), (Object)new CharSourceRange());
        this.SM = (SourceManager)VirtualSM.$star();
        this.FileMgr = new std_ptr.unique_ptr(JavaDifferentiators.JD$Move.INSTANCE, (std_ptr.unique_ptr)std.move(FileMgr));
        this.VirtualSM = new std_ptr.unique_ptr(JavaDifferentiators.JD$Move.INSTANCE, (std_ptr.unique_ptr)std.move(VirtualSM));
        this.Diagnostics = new std_ptr.unique_ptr(JavaDifferentiators.JD$Move.INSTANCE, (std_ptr.unique_ptr)std.move(Diagnostics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_ptr.unique_ptr<Environment> CreateVirtualEnvironment(StringRef Code, StringRef FileName, ArrayRef<Range> Ranges) {
        IntrusiveRefCntPtr InMemoryFileSystem2 = null;
        std_ptr.unique_ptr FileMgr = null;
        std_ptr.unique_ptr Diagnostics = null;
        std_ptr.unique_ptr VirtualSM = null;
        std.vector CharRanges = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            InMemoryFileSystem2 = new IntrusiveRefCntPtr((Object)new InMemoryFileSystem());
            FileMgr = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr((Object)new FileManager(new FileSystemOptions(), (IntrusiveRefCntPtr)$c$.track((Object)new IntrusiveRefCntPtr(ADTAliases.JD$IntrusiveRefCntPtr$X$C.INSTANCE, InMemoryFileSystem2)))));
            Diagnostics = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr((Object)new DiagnosticsEngine((IntrusiveRefCntPtr)$c$.track((Object)new IntrusiveRefCntPtr((Object)new DiagnosticIDs())), new DiagnosticOptions())));
            VirtualSM = new std_ptr.unique_ptr((Object)new SourceManager((DiagnosticsEngine)Diagnostics.$star(), (FileManager)FileMgr.$star()));
            $c$.clean(((InMemoryFileSystem)InMemoryFileSystem2.$arrow()).addFile(new Twine(FileName), 0L, $c$.track(MemoryBuffer.getMemBuffer((StringRef)new StringRef(Code), (StringRef)new StringRef(FileName), (boolean)false))));
            FileID ID = ((SourceManager)VirtualSM.$arrow()).createFileID(((FileManager)FileMgr.$arrow()).getFile(FileName), new SourceLocation(), SrcMgr.CharacteristicKind.C_User);
            assert (ID.isValid());
            SourceLocation StartOfFile = ((SourceManager)VirtualSM.$arrow()).getLocForStartOfFile(ID);
            CharRanges = new std.vector((Object)new CharSourceRange());
            for (Range $Range : Ranges) {
                SourceLocation Start = StartOfFile.getLocWithOffset($Range.getOffset());
                SourceLocation End = Start.getLocWithOffset($Range.getLength());
                CharRanges.push_back_T$RR((Object)CharSourceRange.getCharRange((SourceLocation)Start, (SourceLocation)End));
            }
            Iterator iterator2 = llvm.make_unique((Object)new Environment(ID, (std_ptr.unique_ptr<FileManager>)((std_ptr.unique_ptr)std.move((Object)FileMgr)), (std_ptr.unique_ptr<SourceManager>)((std_ptr.unique_ptr)std.move((Object)VirtualSM)), (std_ptr.unique_ptr<DiagnosticsEngine>)((std_ptr.unique_ptr)std.move((Object)Diagnostics)), (std.vector<CharSourceRange>)CharRanges));
            return iterator2;
        }
        finally {
            if (CharRanges != null) {
                CharRanges.$destroy();
            }
            if (VirtualSM != null) {
                VirtualSM.$destroy();
            }
            if (Diagnostics != null) {
                Diagnostics.$destroy();
            }
            if (FileMgr != null) {
                FileMgr.$destroy();
            }
            if (InMemoryFileSystem2 != null) {
                InMemoryFileSystem2.$destroy();
            }
            $c$.$destroy();
        }
    }

    public FileID getFileID() {
        return new FileID(this.ID);
    }

    public StringRef getFileName() {
        return new StringRef(this.FileName);
    }

    public ArrayRef<CharSourceRange> getCharRanges() {
        return new ArrayRef(this.CharRanges, false);
    }

    public SourceManager getSourceManager() {
        return this.SM;
    }

    public void $destroy() {
        this.Diagnostics.$destroy();
        this.VirtualSM.$destroy();
        this.FileMgr.$destroy();
        this.CharRanges.$destroy();
    }

    public String toString() {
        return "ID=" + this.ID + ", FileName=" + this.FileName + ", CharRanges=" + this.CharRanges + ", SM=[SourceManager], FileMgr=[Unique_ptr$FileManager], VirtualSM=[Unique_ptr$SourceManager], Diagnostics=[Unique_ptr$DiagnosticsEngine]";
    }
}

