/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.SourceManager;
import org.clang.basic.prec;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.BraceBlockKind;
import org.clang.format.impl.BreakableBlockComment;
import org.clang.format.impl.BreakableLineComment;
import org.clang.format.impl.BreakableStringLiteral;
import org.clang.format.impl.BreakableToken;
import org.clang.format.impl.EncodingStatics;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.LineState;
import org.clang.format.impl.LineType;
import org.clang.format.impl.ParameterPackingKind;
import org.clang.format.impl.ParenState;
import org.clang.format.impl.TokenRole;
import org.clang.format.impl.TokenType;
import org.clang.format.impl.WhitespaceManager;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.support.Regex;
import org.llvm.support.llvm;

public class ContinuationIndenter
implements Destructors.ClassWithDestructor {
    private FormatStyle Style;
    private final AdditionalKeywords Keywords;
    private final SourceManager SourceMgr;
    private final WhitespaceManager Whitespaces;
    private EncodingStatics.Encoding Encoding;
    private boolean BinPackInconclusiveFunctions;
    private Regex CommentPragmasRegex;

    public ContinuationIndenter(FormatStyle Style, AdditionalKeywords Keywords, SourceManager SourceMgr, WhitespaceManager Whitespaces, EncodingStatics.Encoding $Encoding, boolean BinPackInconclusiveFunctions) {
        this.Style = new FormatStyle(Style);
        this.Keywords = Keywords;
        this.SourceMgr = SourceMgr;
        this.Whitespaces = Whitespaces;
        this.Encoding = $Encoding;
        this.BinPackInconclusiveFunctions = BinPackInconclusiveFunctions;
        this.CommentPragmasRegex = new Regex(new StringRef(Style.CommentPragmas));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineState getInitialState(int FirstIndent, AnnotatedLine Line, boolean DryRun) {
        LineState State = null;
        try {
            State = new LineState();
            State.FirstIndent = FirstIndent;
            State.Column = FirstIndent;
            State.Line = Line;
            State.NextToken = Line.First;
            State.Stack.push_back_T$RR((Object)new ParenState(FirstIndent, Line.Level, FirstIndent, false, false));
            State.LineContainsContinuedForLoopSection = false;
            State.StartOfStringLiteral = 0;
            State.StartOfLineLevel = 0;
            State.LowestLevelOnLine = 0;
            State.IgnoreStackForComparison = false;
            this.moveStateToNextToken(State, DryRun, false);
            LineState lineState = new LineState(JavaDifferentiators.JD$Move.INSTANCE, State);
            return lineState;
        }
        finally {
            if (State != null) {
                State.$destroy();
            }
        }
    }

    public boolean canBreak(LineState State) {
        FormatToken Current = State.NextToken;
        FormatToken Previous = Current.Previous;
        assert (Previous == Current.Previous);
        if (!(Current.CanBreakBefore || ((ParenState)State.Stack.back$Const()).BreakBeforeClosingBrace && Current.closesBlockOrBlockTypeList(this.Style))) {
            return false;
        }
        if (!Current.MustBreakBefore && Previous.is_TokenKind('\u0017') && Previous.isNot(TokenType.TT_DictLiteral) && Previous.BlockKind == BraceBlockKind.BK_BracedInit && Previous.Previous != null && Previous.Previous.isOneOf('\u0017', '\u0015', '@')) {
            return false;
        }
        if (Previous.opensScope() && Previous.isNot('\u0017') && Unsigned.$less_uint((int)State.LowestLevelOnLine, (int)State.StartOfLineLevel) && Unsigned.$less_uint((int)State.LowestLevelOnLine, (int)Current.NestingLevel)) {
            return false;
        }
        if (Current.isMemberAccess() && ((ParenState)State.Stack.back$Const()).ContainsUnwrappedBuilder) {
            return false;
        }
        if (Previous.is_TokenKind('\u0017') && Unsigned.$greater_uint((int)State.Stack.size(), (int)1) && ((ParenState)State.Stack.$at$Const((int)(State.Stack.size() - 2))).NestedBlockInlined && ((ParenState)State.Stack.$at$Const((int)(State.Stack.size() - 2))).HasMultipleNestedBlocks) {
            return false;
        }
        if (Current.is_TokenType(TokenType.TT_FunctionDeclarationName) && Unsigned.$less_uint((int)State.Column, (int)6) && this.Style.AlwaysBreakAfterReturnType == FormatStyle.ReturnTypeBreakingStyle.RTBS_None) {
            return false;
        }
        return !((ParenState)State.Stack.back$Const()).NoLineBreak;
    }

    public boolean mustBreak(LineState State) {
        FormatToken Current = State.NextToken;
        FormatToken Previous = Current.Previous;
        if (Current.MustBreakBefore || Current.is_TokenType(TokenType.TT_InlineASMColon)) {
            return true;
        }
        if (((ParenState)State.Stack.back$Const()).BreakBeforeClosingBrace && Current.closesBlockOrBlockTypeList(this.Style)) {
            return true;
        }
        if (Previous.is_TokenKind('=') && State.LineContainsContinuedForLoopSection) {
            return true;
        }
        if ((FormatStatics.startsNextParameter(Current, this.Style) || Previous.is_TokenKind('=') || Previous.is_TokenType(TokenType.TT_TemplateCloser) && Current.is_TokenType(TokenType.TT_StartOfName) && this.Style.Language == FormatStyle.LanguageKind.LK_Cpp && (Previous.NestingLevel == 1 || this.Style.BinPackParameters) || this.Style.BreakBeforeTernaryOperators && Current.is_TokenType(TokenType.TT_ConditionalExpr) && Previous.isNot(';') || !this.Style.BreakBeforeTernaryOperators && Previous.is_TokenType(TokenType.TT_ConditionalExpr)) && ((ParenState)State.Stack.back$Const()).BreakBeforeParameter && !Current.isTrailingComment() && !Current.isOneOf('\u0016', '\u0018')) {
            return true;
        }
        if ((Previous.is_TokenType(TokenType.TT_DictLiteral) && Previous.is_TokenKind('\u0017') || Previous.is_TokenType(TokenType.TT_ArrayInitializerLSquare) && Unsigned.$greater_uint((int)Previous.ParameterCount, (int)1)) && Unsigned.$greater_uint((int)this.Style.ColumnLimit, (int)0) && Unsigned.$greater_uint((int)(FormatStatics.getLengthToMatchingParen(Previous) + State.Column - 1), (int)this.getColumnLimit(State))) {
            return true;
        }
        if (Current.is_TokenType(TokenType.TT_CtorInitializerColon) && (Unsigned.$greater_uint((int)(State.Column + State.Line.Last.TotalLength - Current.TotalLength + 2), (int)this.getColumnLimit(State)) || ((ParenState)State.Stack.back$Const()).BreakBeforeParameter) && (this.Style.AllowShortFunctionsOnASingleLine != FormatStyle.ShortFunctionStyle.SFS_All || this.Style.BreakConstructorInitializersBeforeComma || this.Style.ColumnLimit != 0)) {
            return true;
        }
        if (Current.is_TokenType(TokenType.TT_SelectorName) && ((ParenState)State.Stack.back$Const()).ObjCSelectorNameFound && ((ParenState)State.Stack.back$Const()).BreakBeforeParameter) {
            return true;
        }
        int NewLineColumn = this.getNewLineColumn(State);
        if (Current.isMemberAccess() && this.Style.ColumnLimit != 0 && Unsigned.$greater_uint((int)(State.Column + FormatStatics.getLengthToNextOperator(Current)), (int)this.Style.ColumnLimit) && (Unsigned.$greater_uint((int)State.Column, (int)NewLineColumn) || Unsigned.$less_uint((int)Current.NestingLevel, (int)State.StartOfLineLevel))) {
            return true;
        }
        if (Unsigned.$lesseq_uint((int)State.Column, (int)NewLineColumn)) {
            return false;
        }
        if (this.Style.AlwaysBreakBeforeMultilineStrings && (NewLineColumn == State.FirstIndent + this.Style.ContinuationIndentWidth || Previous.is_TokenKind('@') || Unsigned.$less_uint((int)Current.NestingLevel, (int)2)) && !Previous.isOneOf('`', '/', 'G') && !Previous.isOneOf(TokenType.TT_InlineASMColon, TokenType.TT_ConditionalExpr) && this.nextIsMultilineString(State)) {
            return true;
        }
        if (Previous.is_TokenType(TokenType.TT_BinaryOperator) && Current.CanBreakBefore) {
            boolean LHSIsBinaryExpr;
            boolean IsComparison = (Previous.getPrecedence() == prec.Level.Relational || Previous.getPrecedence() == prec.Level.Equality) && Previous.Previous != null && Previous.Previous.isNot(TokenType.TT_BinaryOperator);
            boolean bl = LHSIsBinaryExpr = Previous.Previous != null && Previous.Previous.EndsBinaryExpression;
            if ((!IsComparison || LHSIsBinaryExpr) && !Current.isTrailingComment() && Previous.getPrecedence() != prec.Level.Assignment && ((ParenState)State.Stack.back$Const()).BreakBeforeParameter) {
                return true;
            }
        } else if (Current.is_TokenType(TokenType.TT_BinaryOperator) && Current.CanBreakBefore && ((ParenState)State.Stack.back$Const()).BreakBeforeParameter) {
            return true;
        }
        if (Current.is_TokenKind('/') && Current.isNot(TokenType.TT_OverloadedOperator) && ((ParenState)State.Stack.back$Const()).BreakBeforeParameter && ((ParenState)State.Stack.back$Const()).FirstLessLess == 0) {
            return true;
        }
        if (Current.NestingLevel == 0 && !Current.isTrailingComment()) {
            if (Previous.ClosesTemplateDeclaration) {
                return true;
            }
            if (Previous.is_TokenType(TokenType.TT_FunctionAnnotationRParen)) {
                return true;
            }
            if (Previous.is_TokenType(TokenType.TT_LeadingJavaAnnotation) && Current.isNot('\u0015') && Current.isNot(TokenType.TT_LeadingJavaAnnotation)) {
                return true;
            }
        }
        if ((Current.is_TokenType(TokenType.TT_FunctionDeclarationName) || Current.is_TokenKind('\u0088') && !Previous.is_TokenKind('F')) && !Previous.is_TokenKind('\u008e') && ((ParenState)State.Stack.back$Const()).BreakBeforeParameter) {
            return true;
        }
        if (FormatStatics.startsSegmentOfBuilderTypeCall(Current) && (((ParenState)State.Stack.back$Const()).CallContinuation != 0 || ((ParenState)State.Stack.back$Const()).BreakBeforeParameter)) {
            return true;
        }
        if (this.Style.ColumnLimit != 0 && Previous.BlockKind == BraceBlockKind.BK_Block && Previous.is_TokenKind('\u0017') && !Current.isOneOf('\u0018', '\u0004')) {
            return true;
        }
        return Current.is_TokenKind('/') && (Previous.is_TokenKind('\u0005') && llvm.$eq_StringRef((StringRef)Previous.TokenText, (String)"endl") || Previous.Tok.isLiteral() && (Previous.TokenText.endswith("\\n\"") || llvm.$eq_StringRef((StringRef)Previous.TokenText, (String)"'\\n'")));
    }

    public int addTokenToState(LineState State, boolean Newline, boolean DryRun) {
        return this.addTokenToState(State, Newline, DryRun, 0);
    }

    public int addTokenToState(LineState State, boolean Newline, boolean DryRun, int ExtraSpaces) {
        FormatToken Current = State.NextToken;
        assert (!State.Stack.empty());
        if (Current.is_TokenType(TokenType.TT_ImplicitStringLiteral) && (Current.Previous.Tok.getIdentifierInfo() == null || Current.Previous.Tok.getIdentifierInfo().getPPKeywordID() == '\u0000')) {
            int EndColumn = this.SourceMgr.getSpellingColumnNumber(Current.WhitespaceRange.getEnd());
            if (Current.LastNewlineOffset != 0) {
                State.Column = EndColumn;
            } else {
                int StartColumn = this.SourceMgr.getSpellingColumnNumber(Current.WhitespaceRange.getBegin());
                assert (Unsigned.$greatereq_uint((int)EndColumn, (int)StartColumn));
                State.Column += EndColumn - StartColumn;
            }
            this.moveStateToNextToken(State, DryRun, false);
            return 0;
        }
        int Penalty = 0;
        if (Newline) {
            Penalty = this.addTokenOnNewLine(State, DryRun);
        } else {
            this.addTokenOnCurrentLine(State, DryRun, ExtraSpaces);
        }
        return this.moveStateToNextToken(State, DryRun, Newline) + Penalty;
    }

    public int getColumnLimit(LineState State) {
        return this.Style.ColumnLimit - (State.Line.InPPDirective ? 2 : 0);
    }

    private int moveStateToNextToken(LineState State, boolean DryRun, boolean Newline) {
        FormatToken Previous;
        assert (Native.$bool((int)State.Stack.size()));
        FormatToken Current = State.NextToken;
        if (Current.is_TokenType(TokenType.TT_InheritanceColon)) {
            ((ParenState)State.Stack.back()).AvoidBinPacking = true;
        }
        if (Current.is_TokenKind('/') && Current.isNot(TokenType.TT_OverloadedOperator)) {
            if (((ParenState)State.Stack.back()).FirstLessLess == 0) {
                ((ParenState)State.Stack.back()).FirstLessLess = State.Column;
            } else {
                ((ParenState)State.Stack.back()).LastOperatorWrapped = Newline;
            }
        }
        if (Current.is_TokenType(TokenType.TT_BinaryOperator) && Current.isNot('/') || Current.is_TokenType(TokenType.TT_ConditionalExpr)) {
            ((ParenState)State.Stack.back()).LastOperatorWrapped = Newline;
        }
        if (Current.is_TokenType(TokenType.TT_ArraySubscriptLSquare) && ((ParenState)State.Stack.back()).StartOfArraySubscripts == 0) {
            ((ParenState)State.Stack.back()).StartOfArraySubscripts = State.Column;
        }
        if (this.Style.BreakBeforeTernaryOperators && Current.is_TokenKind(';')) {
            ((ParenState)State.Stack.back()).QuestionColumn = State.Column;
        }
        if (!this.Style.BreakBeforeTernaryOperators && Current.isNot('<')) {
            Previous = Current.Previous;
            while (Previous != null && Previous.isTrailingComment()) {
                Previous = Previous.Previous;
            }
            if (Previous != null && Previous.is_TokenKind(';')) {
                ((ParenState)State.Stack.back()).QuestionColumn = State.Column;
            }
        }
        if (!Current.opensScope() && !Current.closesScope()) {
            State.LowestLevelOnLine = std.min_uint((int)State.LowestLevelOnLine, (int)Current.NestingLevel);
        }
        if (Current.isMemberAccess()) {
            int n = ((ParenState)State.Stack.back()).StartOfFunctionCall = Current.NextOperator == null ? 0 : State.Column;
        }
        if (Current.is_TokenType(TokenType.TT_SelectorName)) {
            ((ParenState)State.Stack.back()).ObjCSelectorNameFound = true;
            if (this.Style.IndentWrappedFunctionNames) {
                ((ParenState)State.Stack.back()).Indent = State.FirstIndent + this.Style.ContinuationIndentWidth;
            }
        }
        if (Current.is_TokenType(TokenType.TT_CtorInitializerColon)) {
            ((ParenState)State.Stack.back()).Indent = State.Column + (this.Style.BreakConstructorInitializersBeforeComma ? 0 : 2);
            ((ParenState)State.Stack.back()).NestedBlockIndent = ((ParenState)State.Stack.back()).Indent;
            if (this.Style.ConstructorInitializerAllOnOneLineOrOnePerLine) {
                ((ParenState)State.Stack.back()).AvoidBinPacking = true;
            }
            ((ParenState)State.Stack.back()).BreakBeforeParameter = false;
        }
        if (Current.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_ConditionalExpr) && Newline) {
            ((ParenState)State.Stack.back()).NestedBlockIndent = State.Column + Current.ColumnWidth + 1;
        }
        Previous = Current.getPreviousNonComment();
        if (Current.isNot('\u0004') && Previous != null && Previous.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare) && !Previous.is_TokenType(TokenType.TT_DictLiteral) && Unsigned.$greater_uint((int)State.Stack.size(), (int)1)) {
            if (((ParenState)State.Stack.$at((int)(State.Stack.size() - 2))).NestedBlockInlined && Newline) {
                int e = State.Stack.size() - 1;
                for (int i = 0; i != e; ++i) {
                    ((ParenState)State.Stack.$at((int)i)).NoLineBreak = true;
                }
            }
            ((ParenState)State.Stack.$at((int)(State.Stack.size() - 2))).NestedBlockInlined = false;
        }
        if (Previous != null && (Previous.isOneOf('\u0015', '@', '<') || Previous.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_ConditionalExpr)) && !Previous.isOneOf(TokenType.TT_DictLiteral, TokenType.TT_ObjCMethodExpr)) {
            ((ParenState)State.Stack.back()).NestedBlockInlined = !Newline && (Previous.isNot('\u0015') || Unsigned.$greater_uint((int)Previous.ParameterCount, (int)1));
        }
        this.moveStatePastFakeLParens(State, Newline);
        this.moveStatePastScopeOpener(State, Newline);
        this.moveStatePastScopeCloser(State);
        this.moveStatePastFakeRParens(State);
        if (Current.isStringLiteral() && State.StartOfStringLiteral == 0) {
            State.StartOfStringLiteral = State.Column;
        }
        if (Current.is_TokenType(TokenType.TT_ObjCStringLiteral) && State.StartOfStringLiteral == 0) {
            State.StartOfStringLiteral = State.Column + 1;
        } else if (!Current.isOneOf('\u0004', '\u0005', 'A') && !Current.isStringLiteral()) {
            State.StartOfStringLiteral = 0;
        }
        State.Column += Current.ColumnWidth;
        State.NextToken = State.NextToken.Next;
        int Penalty = this.breakProtrudingToken(Current, State, DryRun);
        if (Unsigned.$greater_uint((int)State.Column, (int)this.getColumnLimit(State))) {
            int ExcessCharacters = State.Column - this.getColumnLimit(State);
            Penalty += this.Style.PenaltyExcessCharacter * ExcessCharacters;
        }
        if (Current.Role.$bool()) {
            ((TokenRole)Current.Role.$arrow()).formatFromToken(State, this, DryRun);
        }
        if (Previous != null && Previous.Role.$bool()) {
            Penalty += ((TokenRole)Previous.Role.$arrow()).formatAfterToken(State, this, DryRun);
        }
        return Penalty;
    }

    private void moveStatePastFakeLParens(LineState State, boolean Newline) {
        FormatToken Current = State.NextToken;
        FormatToken Previous = Current.getPreviousNonComment();
        boolean SkipFirstExtraIndent = Previous != null && (Previous.opensScope() || Previous.isOneOf('=', '`') || Previous.getPrecedence() == prec.Level.Assignment && this.Style.AlignOperands || Previous.is_TokenType(TokenType.TT_ObjCMethodExpr));
        std.reverse_iterator I = Current.FakeLParens.rbegin$Const();
        std.reverse_iterator E = Current.FakeLParens.rend$Const();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
            ParenState NewParenState = new ParenState((ParenState)State.Stack.back());
            NewParenState.ContainsLineBreak = false;
            if (!(Current.isTrailingComment() || !this.Style.AlignOperands && ((prec.Level)I.$star()).getValue() >= prec.Level.Assignment.getValue() || Previous != null && !Previous.isNot('`') && (this.Style.Language == FormatStyle.LanguageKind.LK_Java || ((prec.Level)I.$star()).getValue() <= 0) || this.Style.AlignAfterOpenBracket == FormatStyle.BracketAlignmentStyle.BAS_DontAlign && I.$star() == prec.Level.Comma && Current.NestingLevel != 0)) {
                NewParenState.Indent = std.max((int)std.max((int)State.Column, (int)NewParenState.Indent), (int)((ParenState)State.Stack.back()).LastSpace);
            }
            if (Previous != null && Previous.getPrecedence() != prec.Level.Assignment && Previous.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_ConditionalExpr) && Previous.getPrecedence() != prec.Level.Relational) {
                boolean BreakBeforeOperator;
                boolean bl = BreakBeforeOperator = Previous.is_TokenKind('/') || Previous.is_TokenType(TokenType.TT_BinaryOperator) && this.Style.BreakBeforeBinaryOperators != FormatStyle.BinaryOperatorStyle.BOS_None || Previous.is_TokenType(TokenType.TT_ConditionalExpr) && this.Style.BreakBeforeTernaryOperators;
                if (!Newline && !BreakBeforeOperator || !((ParenState)State.Stack.back()).LastOperatorWrapped && BreakBeforeOperator) {
                    NewParenState.NoLineBreak = true;
                }
            }
            if (((prec.Level)I.$star()).getValue() > prec.Level.Unknown.getValue()) {
                NewParenState.LastSpace = std.max((int)NewParenState.LastSpace, (int)State.Column);
            }
            if (I.$star() != prec.Level.Conditional && !Current.is_TokenType(TokenType.TT_UnaryOperator) && this.Style.AlignAfterOpenBracket != FormatStyle.BracketAlignmentStyle.BAS_DontAlign) {
                NewParenState.StartOfFunctionCall = State.Column;
            }
            if (I.$star() == prec.Level.Conditional || !SkipFirstExtraIndent && ((prec.Level)I.$star()).getValue() > prec.Level.Assignment.getValue() && !Current.isTrailingComment()) {
                NewParenState.Indent += this.Style.ContinuationIndentWidth;
            }
            if (Previous != null && !Previous.opensScope() || I.$star() != prec.Level.Comma) {
                NewParenState.BreakBeforeParameter = false;
            }
            State.Stack.push_back_T$C$R((Object)NewParenState);
            SkipFirstExtraIndent = false;
            I.$preInc();
        }
    }

    private void moveStatePastFakeRParens(LineState State) {
        int e = State.NextToken.FakeRParens;
        for (int i = 0; i != e; ++i) {
            int VariablePos = ((ParenState)State.Stack.back()).VariablePos;
            if (State.Stack.size() == 1) break;
            State.Stack.pop_back();
            ((ParenState)State.Stack.back()).VariablePos = VariablePos;
        }
    }

    private void moveStatePastScopeOpener(LineState State, boolean Newline) {
        boolean AvoidBinPacking;
        int NewIndent;
        FormatToken Current = State.NextToken;
        if (!Current.opensScope()) {
            return;
        }
        if (Current.MatchingParen != null && Current.BlockKind == BraceBlockKind.BK_Block) {
            this.moveStateToNewBlock(State);
            return;
        }
        int NewIndentLevel = ((ParenState)State.Stack.back()).IndentLevel;
        int LastSpace = ((ParenState)State.Stack.back()).LastSpace;
        boolean BreakBeforeParameter = false;
        int NestedBlockIndent = std.max((int)((ParenState)State.Stack.back()).StartOfFunctionCall, (int)((ParenState)State.Stack.back()).NestedBlockIndent);
        if (Current.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare)) {
            if (Current.opensBlockOrBlockTypeList(this.Style)) {
                NewIndent = ((ParenState)State.Stack.back()).NestedBlockIndent + this.Style.IndentWidth;
                NewIndent = std.min_uint((int)(State.Column + 2), (int)NewIndent);
                ++NewIndentLevel;
            } else {
                NewIndent = ((ParenState)State.Stack.back()).LastSpace + this.Style.ContinuationIndentWidth;
            }
            FormatToken NextNoComment = Current.getNextNonComment();
            boolean EndsInComma = Current.MatchingParen != null && Current.MatchingParen.Previous != null && Current.MatchingParen.Previous.is_TokenKind('@');
            boolean bl = AvoidBinPacking = Current.is_TokenType(TokenType.TT_ArrayInitializerLSquare) && EndsInComma || Current.is_TokenType(TokenType.TT_DictLiteral) || this.Style.Language == FormatStyle.LanguageKind.LK_Proto || !this.Style.BinPackArguments || NextNoComment != null && NextNoComment.is_TokenType(TokenType.TT_DesignatedInitializerPeriod);
            if (Unsigned.$greater_uint((int)Current.ParameterCount, (int)1)) {
                NestedBlockIndent = std.max((int)NestedBlockIndent, (int)(State.Column + 1));
            }
        } else {
            NewIndent = this.Style.ContinuationIndentWidth + std.max((int)((ParenState)State.Stack.back()).LastSpace, (int)((ParenState)State.Stack.back()).StartOfFunctionCall);
            if (Current.Tok.getKind() == '.' && Current.ParentBracket == '\u0015') {
                NewIndent = std.max((int)NewIndent, (int)((ParenState)State.Stack.back()).Indent);
                LastSpace = std.max((int)LastSpace, (int)((ParenState)State.Stack.back()).Indent);
            }
            boolean bl = AvoidBinPacking = State.Line.MustBeDeclaration && !this.Style.BinPackParameters || !State.Line.MustBeDeclaration && !this.Style.BinPackArguments || this.Style.ExperimentalAutoDetectBinPacking && (Current.PackingKind == ParameterPackingKind.PPK_OnePerLine || !this.BinPackInconclusiveFunctions && Current.PackingKind == ParameterPackingKind.PPK_Inconclusive);
            if (Current.is_TokenType(TokenType.TT_ObjCMethodExpr) && Current.MatchingParen != null) {
                if (this.Style.ColumnLimit != 0) {
                    if (Unsigned.$greater_uint((int)(FormatStatics.getLengthToMatchingParen(Current) + State.Column), (int)this.getColumnLimit(State))) {
                        BreakBeforeParameter = true;
                    }
                } else {
                    FormatToken Tok = Current;
                    while (Tok != null && Tok != Current.MatchingParen) {
                        if (Tok.MustBreakBefore || Tok.CanBreakBefore && Unsigned.$greater_uint((int)Tok.NewlinesBefore, (int)0)) {
                            BreakBeforeParameter = true;
                            break;
                        }
                        Tok = Tok.Next;
                    }
                }
            }
        }
        boolean NoLineBreak = Current.Children.empty() && !Current.isOneOf(TokenType.TT_DictLiteral, TokenType.TT_ArrayInitializerLSquare) && (((ParenState)State.Stack.back()).NoLineBreak || Current.is_TokenType(TokenType.TT_TemplateOpener) && ((ParenState)State.Stack.back()).ContainsUnwrappedBuilder);
        State.Stack.push_back_T$RR((Object)new ParenState(NewIndent, NewIndentLevel, LastSpace, AvoidBinPacking, NoLineBreak));
        ((ParenState)State.Stack.back()).NestedBlockIndent = NestedBlockIndent;
        ((ParenState)State.Stack.back()).BreakBeforeParameter = BreakBeforeParameter;
        ((ParenState)State.Stack.back()).HasMultipleNestedBlocks = Unsigned.$greater_uint((int)Current.BlockParameterCount, (int)1);
    }

    private void moveStatePastScopeCloser(LineState State) {
        FormatToken NextNonComment;
        FormatToken Current = State.NextToken;
        if (!Current.closesScope()) {
            return;
        }
        if (Unsigned.$greater_uint((int)State.Stack.size(), (int)1) && (Current.isOneOf('\u0016', '\u0014') || Current.is_TokenKind('\u0018') && State.NextToken != State.Line.First || State.NextToken.is_TokenType(TokenType.TT_TemplateCloser))) {
            State.Stack.pop_back();
        }
        if (Current.is_TokenKind('\u0014') && (NextNonComment = Current.getNextNonComment()) != null && NextNonComment.isNot('\u0013')) {
            ((ParenState)State.Stack.back()).StartOfArraySubscripts = 0;
        }
    }

    private void moveStateToNewBlock(LineState State) {
        int NestedBlockIndent = ((ParenState)State.Stack.back()).NestedBlockIndent;
        int NewIndent = NestedBlockIndent + (State.NextToken.is_TokenType(TokenType.TT_ObjCBlockLBrace) ? this.Style.ObjCBlockIndentWidth : this.Style.IndentWidth);
        State.Stack.push_back_T$RR((Object)new ParenState(NewIndent, ((ParenState)State.Stack.back()).IndentLevel + 1, ((ParenState)State.Stack.back()).LastSpace, true, false));
        ((ParenState)State.Stack.back()).NestedBlockIndent = NestedBlockIndent;
        ((ParenState)State.Stack.back()).BreakBeforeParameter = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int breakProtrudingToken(FormatToken Current, LineState State, boolean DryRun) {
        std_ptr.unique_ptr Token2 = null;
        try {
            if (Current.isNot(TokenType.TT_BlockComment) && Current.IsMultiline) {
                int n = this.addMultilineToken(Current, State);
                return n;
            }
            if (Current.is_TokenType(TokenType.TT_ImplicitStringLiteral) || State.Line.Type == LineType.LT_ImportStatement) {
                int n = 0;
                return n;
            }
            if (!Current.isStringLiteral() && !Current.is_TokenKind('\u0004')) {
                int n = 0;
                return n;
            }
            Token2 = new std_ptr.unique_ptr();
            int StartColumn = State.Column - Current.ColumnWidth;
            int ColumnLimit = this.getColumnLimit(State);
            if (Current.isStringLiteral()) {
                if (this.Style.Language == FormatStyle.LanguageKind.LK_Java || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript || !this.Style.BreakStringLiterals) {
                    int n = 0;
                    return n;
                }
                if (State.Line.Type == LineType.LT_PreprocessorDirective) {
                    int n = 0;
                    return n;
                }
                if (Current.IsUnterminatedLiteral) {
                    int n = 0;
                    return n;
                }
                StringRef Text = new StringRef(Current.TokenText);
                StringRef Prefix = new StringRef();
                StringRef Postfix = new StringRef();
                boolean IsNSStringLiteral = false;
                if (Text.startswith("\"") && Current.Previous != null && Current.Previous.is_TokenKind('G')) {
                    IsNSStringLiteral = true;
                    Prefix.$assignMove("@\"");
                }
                if (!(Text.endswith(Postfix.$assignMove(NativePointer.$DBL_QUOTE)) && (IsNSStringLiteral || Text.startswith(Prefix.$assignMove(NativePointer.$DBL_QUOTE)) || Text.startswith(Prefix.$assignMove("u\"")) || Text.startswith(Prefix.$assignMove("U\"")) || Text.startswith(Prefix.$assignMove("u8\"")) || Text.startswith(Prefix.$assignMove("L\""))) || Text.startswith(Prefix.$assignMove("_T(\"")) && Text.endswith(Postfix.$assignMove("\")")))) {
                    int n = 0;
                    return n;
                }
                Token2.reset((Object)new BreakableStringLiteral(Current, State.Line.Level, StartColumn, new StringRef(Prefix), new StringRef(Postfix), State.Line.InPPDirective, this.Encoding, this.Style));
            } else if (Current.is_TokenType(TokenType.TT_BlockComment)) {
                if (!Current.isTrailingComment() || !this.Style.ReflowComments || this.CommentPragmasRegex.find(Current.TokenText.substr(2))) {
                    int Text = this.addMultilineToken(Current, State);
                    return Text;
                }
                Token2.reset((Object)new BreakableBlockComment(Current, State.Line.Level, StartColumn, Current.OriginalColumn, Current.Previous == null, State.Line.InPPDirective, this.Encoding, this.Style));
            } else if (Current.is_TokenType(TokenType.TT_LineComment) && (Current.Previous == null || Current.Previous.isNot(TokenType.TT_ImplicitStringLiteral))) {
                if (!this.Style.ReflowComments || this.CommentPragmasRegex.find(Current.TokenText.substr(2))) {
                    int Text = 0;
                    return Text;
                }
                Token2.reset((Object)new BreakableLineComment(Current, State.Line.Level, StartColumn, false, this.Encoding, this.Style));
                ColumnLimit = this.Style.ColumnLimit;
            } else {
                int Text = 0;
                return Text;
            }
            if (Unsigned.$greatereq_uint((int)Current.UnbreakableTailLength, (int)ColumnLimit)) {
                int Text = 0;
                return Text;
            }
            int RemainingSpace = ColumnLimit - Current.UnbreakableTailLength;
            boolean BreakInserted = false;
            int Penalty = 0;
            int RemainingTokenColumns = 0;
            int EndIndex = ((BreakableToken)Token2.$arrow()).getLineCount();
            block14: for (int LineIndex = 0; LineIndex != EndIndex; ++LineIndex) {
                if (!DryRun) {
                    ((BreakableToken)Token2.$arrow()).replaceWhitespaceBefore(LineIndex, this.Whitespaces);
                }
                int TailOffset = 0;
                RemainingTokenColumns = ((BreakableToken)Token2.$arrow()).getLineLengthAfterSplit(LineIndex, TailOffset, StringRef.npos);
                while (Unsigned.$greater_uint((int)RemainingTokenColumns, (int)RemainingSpace)) {
                    std_pair.pairUIntUInt Split = ((BreakableToken)Token2.$arrow()).getSplit(LineIndex, TailOffset, ColumnLimit);
                    if (Split.first == StringRef.npos) {
                        if (!Unsigned.$less_uint((int)LineIndex, (int)(EndIndex - 1))) continue block14;
                        Penalty += this.Style.PenaltyExcessCharacter * (RemainingTokenColumns - RemainingSpace);
                        continue block14;
                    }
                    assert (Split.first != 0);
                    int NewRemainingTokenColumns = ((BreakableToken)Token2.$arrow()).getLineLengthAfterSplit(LineIndex, TailOffset + Split.first + Split.second, StringRef.npos);
                    if (Unsigned.$lesseq_uint((int)(RemainingTokenColumns + 1 - Split.second), (int)RemainingSpace)) {
                        RemainingTokenColumns = 0;
                        if (DryRun) continue block14;
                        ((BreakableToken)Token2.$arrow()).replaceWhitespace(LineIndex, TailOffset, new std_pair.pairUIntUInt(Split), this.Whitespaces);
                        continue block14;
                    }
                    if (NewRemainingTokenColumns == RemainingTokenColumns) continue block14;
                    assert (Unsigned.$less_uint((int)NewRemainingTokenColumns, (int)RemainingTokenColumns));
                    if (!DryRun) {
                        ((BreakableToken)Token2.$arrow()).insertBreak(LineIndex, TailOffset, new std_pair.pairUIntUInt(Split), this.Whitespaces);
                    }
                    Penalty += Current.SplitPenalty;
                    int ColumnsUsed = ((BreakableToken)Token2.$arrow()).getLineLengthAfterSplit(LineIndex, TailOffset, Split.first);
                    if (Unsigned.$greater_uint((int)ColumnsUsed, (int)ColumnLimit)) {
                        Penalty += this.Style.PenaltyExcessCharacter * (ColumnsUsed - ColumnLimit);
                    }
                    TailOffset += Split.first + Split.second;
                    RemainingTokenColumns = NewRemainingTokenColumns;
                    BreakInserted = true;
                }
            }
            State.Column = RemainingTokenColumns;
            if (BreakInserted) {
                if (Current.isNot(TokenType.TT_LineComment)) {
                    int e = State.Stack.size();
                    for (int i = 0; i != e; ++i) {
                        ((ParenState)State.Stack.$at((int)i)).BreakBeforeParameter = true;
                    }
                }
                Penalty += Current.isStringLiteral() ? this.Style.PenaltyBreakString : this.Style.PenaltyBreakComment;
                ((ParenState)State.Stack.back()).LastSpace = StartColumn;
            }
            int n = Penalty;
            return n;
        }
        finally {
            if (Token2 != null) {
                Token2.$destroy();
            }
        }
    }

    private void addTokenOnCurrentLine(LineState State, boolean DryRun, int ExtraSpaces) {
        FormatToken Current = State.NextToken;
        FormatToken Previous = State.NextToken.Previous;
        if (Current.is_TokenKind('>') && (State.Line.First.is_TokenKind('X') || Current.NestingLevel == 0) && ((ParenState)State.Stack.back()).VariablePos == 0) {
            ((ParenState)State.Stack.back()).VariablePos = State.Column;
            FormatToken Tok = Previous;
            while (Tok != null && Unsigned.$greatereq_uint((int)((ParenState)State.Stack.back()).VariablePos, (int)Tok.ColumnWidth)) {
                ((ParenState)State.Stack.back()).VariablePos -= Tok.ColumnWidth;
                if (Tok.SpacesRequiredBefore != 0) break;
                Tok = Tok.Previous;
            }
            if (Previous.PartOfMultiVariableDeclStmt) {
                ((ParenState)State.Stack.back()).LastSpace = ((ParenState)State.Stack.back()).VariablePos;
            }
        }
        int Spaces = Current.SpacesRequiredBefore + ExtraSpaces;
        if (!DryRun) {
            this.Whitespaces.replaceWhitespace(Current, 0, 0, Spaces, State.Column + Spaces);
        }
        if (Current.is_TokenType(TokenType.TT_SelectorName) && !((ParenState)State.Stack.back()).ObjCSelectorNameFound) {
            int MinIndent = std.max((int)(State.FirstIndent + this.Style.ContinuationIndentWidth), (int)((ParenState)State.Stack.back()).Indent);
            int FirstColonPos = State.Column + Spaces + Current.ColumnWidth;
            if (Current.LongestObjCSelectorName == 0) {
                ((ParenState)State.Stack.back()).AlignColons = false;
            } else {
                ((ParenState)State.Stack.back()).ColonPos = Unsigned.$greater_uint((int)(MinIndent + Current.LongestObjCSelectorName), (int)FirstColonPos) ? MinIndent + Current.LongestObjCSelectorName : FirstColonPos;
            }
        }
        if (this.Style.AlignAfterOpenBracket == FormatStyle.BracketAlignmentStyle.BAS_AlwaysBreak && Previous.isOneOf('\u0015', TokenType.TT_TemplateOpener, '\u0013') && Unsigned.$greater_uint((int)State.Column, (int)this.getNewLineColumn(State)) && (Previous.Previous == null || !Previous.Previous.isOneOf('X', 'l', 'f')) && Unsigned.$greater_uint((int)Current.FakeLParens.size(), (int)0) && ((prec.Level)Current.FakeLParens.back()).getValue() > prec.Level.Unknown.getValue()) {
            ((ParenState)State.Stack.back()).NoLineBreak = true;
        }
        if (this.Style.AlignAfterOpenBracket != FormatStyle.BracketAlignmentStyle.BAS_DontAlign && Previous.opensScope() && Previous.isNot(TokenType.TT_ObjCMethodExpr) && (Current.isNot(TokenType.TT_LineComment) || Previous.BlockKind == BraceBlockKind.BK_BracedInit)) {
            ((ParenState)State.Stack.back()).Indent = State.Column + Spaces;
        }
        if (((ParenState)State.Stack.back()).AvoidBinPacking && FormatStatics.startsNextParameter(Current, this.Style)) {
            ((ParenState)State.Stack.back()).NoLineBreak = true;
        }
        if (FormatStatics.startsSegmentOfBuilderTypeCall(Current) && Unsigned.$greater_uint((int)State.Column, (int)this.getNewLineColumn(State))) {
            ((ParenState)State.Stack.back()).ContainsUnwrappedBuilder = true;
        }
        if (Current.is_TokenType(TokenType.TT_LambdaArrow) && this.Style.Language == FormatStyle.LanguageKind.LK_Java) {
            ((ParenState)State.Stack.back()).NoLineBreak = true;
        }
        if (Current.isMemberAccess() && Previous.is_TokenKind('\u0016') && Previous.MatchingParen != null && Unsigned.$greater_uint((int)(Previous.TotalLength - Previous.MatchingParen.TotalLength), (int)10)) {
            ((ParenState)State.Stack.back()).NoLineBreak = true;
        }
        State.Column += Spaces;
        if (Current.isNot('\u0004') && Previous.is_TokenKind('\u0015') && Previous.Previous != null && Previous.Previous.isOneOf('Z', 'X')) {
            ((ParenState)State.Stack.back()).LastSpace = State.Column;
            ((ParenState)State.Stack.back()).NestedBlockIndent = State.Column;
        } else if (!Current.isOneOf('\u0004', '6') && (Previous.is_TokenKind('@') && !Previous.is_TokenType(TokenType.TT_OverloadedOperator) || Previous.is_TokenKind('<') && Previous.is_TokenType(TokenType.TT_ObjCMethodExpr))) {
            ((ParenState)State.Stack.back()).LastSpace = State.Column;
        } else if (Previous.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_ConditionalExpr, TokenType.TT_CtorInitializerColon) && (Previous.getPrecedence() != prec.Level.Assignment && (Previous.isNot('/') || Previous.OperatorIndex != 0 || Previous.NextOperator != null) || Current.StartsBinaryExpression)) {
            ((ParenState)State.Stack.back()).LastSpace = State.Column;
        } else if (Previous.is_TokenType(TokenType.TT_InheritanceColon)) {
            ((ParenState)State.Stack.back()).Indent = State.Column;
            ((ParenState)State.Stack.back()).LastSpace = State.Column;
        } else if (Previous.opensScope()) {
            boolean HasTrailingCall = false;
            if (Previous.MatchingParen != null) {
                FormatToken Next = Previous.MatchingParen.getNextNonComment();
                boolean bl = HasTrailingCall = Next != null && Next.isMemberAccess();
            }
            if (HasTrailingCall && Unsigned.$greater_uint((int)State.Stack.size(), (int)1) && ((ParenState)State.Stack.$at((int)(State.Stack.size() - 2))).CallContinuation == 0) {
                ((ParenState)State.Stack.back()).LastSpace = State.Column;
            }
        }
    }

    private int addTokenOnNewLine(LineState State, boolean DryRun) {
        boolean NestedBlockSpecialCase;
        FormatToken Current = State.NextToken;
        FormatToken Previous = State.NextToken.Previous;
        int Penalty = 0;
        FormatToken PreviousNonComment = Current.getPreviousNonComment();
        FormatToken NextNonComment = Previous.getNextNonComment();
        if (NextNonComment == null) {
            NextNonComment = Current;
        }
        if (!((ParenState)State.Stack.back()).ContainsLineBreak) {
            Penalty += 15;
        }
        ((ParenState)State.Stack.back()).ContainsLineBreak = true;
        Penalty += State.NextToken.SplitPenalty;
        if (NextNonComment.is_TokenKind('/') && ((ParenState)State.Stack.back()).FirstLessLess == 0 && (Unsigned.$lesseq_uint((int)State.Column, (int)Unsigned.$div_uint((int)this.Style.ColumnLimit, (int)3)) || ((ParenState)State.Stack.back()).BreakBeforeParameter)) {
            Penalty += this.Style.PenaltyBreakFirstLessLess;
        }
        State.Column = this.getNewLineColumn(State);
        if (!(Current.is_TokenType(TokenType.TT_LambdaArrow) || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && Current.NestingLevel == 0 && PreviousNonComment != null && PreviousNonComment.is_TokenKind('>') && Current.isOneOf(this.Keywords.kw_async, this.Keywords.kw_function))) {
            ((ParenState)State.Stack.back()).NestedBlockIndent = State.Column;
        }
        if (NextNonComment.isMemberAccess()) {
            if (((ParenState)State.Stack.back()).CallContinuation == 0) {
                ((ParenState)State.Stack.back()).CallContinuation = State.Column;
            }
        } else if (NextNonComment.is_TokenType(TokenType.TT_SelectorName)) {
            if (!((ParenState)State.Stack.back()).ObjCSelectorNameFound) {
                if (NextNonComment.LongestObjCSelectorName == 0) {
                    ((ParenState)State.Stack.back()).AlignColons = false;
                } else {
                    ((ParenState)State.Stack.back()).ColonPos = (this.Style.IndentWrappedFunctionNames ? std.max((int)((ParenState)State.Stack.back()).Indent, (int)(State.FirstIndent + this.Style.ContinuationIndentWidth)) : ((ParenState)State.Stack.back()).Indent) + NextNonComment.LongestObjCSelectorName;
                }
            } else if (((ParenState)State.Stack.back()).AlignColons && Unsigned.$lesseq_uint((int)((ParenState)State.Stack.back()).ColonPos, (int)NextNonComment.ColumnWidth)) {
                ((ParenState)State.Stack.back()).ColonPos = State.Column + NextNonComment.ColumnWidth;
            }
        } else if (PreviousNonComment != null && PreviousNonComment.is_TokenKind('<') && PreviousNonComment.isOneOf(TokenType.TT_ObjCMethodExpr, TokenType.TT_DictLiteral) && Unsigned.$greater_uint((int)State.Stack.size(), (int)1)) {
            ((ParenState)State.Stack.$at((int)(State.Stack.size() - 2))).LastSpace = std.max((int)((ParenState)State.Stack.back()).LastSpace, (int)((ParenState)State.Stack.back()).Indent) + this.Style.ContinuationIndentWidth;
        }
        if (Previous.isOneOf('@', '=') && !((ParenState)State.Stack.back()).AvoidBinPacking || Previous.is_TokenType(TokenType.TT_BinaryOperator)) {
            ((ParenState)State.Stack.back()).BreakBeforeParameter = false;
        }
        if (Previous.isOneOf(TokenType.TT_TemplateCloser, TokenType.TT_JavaAnnotation) && Current.NestingLevel == 0) {
            ((ParenState)State.Stack.back()).BreakBeforeParameter = false;
        }
        if (NextNonComment.is_TokenKind(';') || PreviousNonComment != null && PreviousNonComment.is_TokenKind(';')) {
            ((ParenState)State.Stack.back()).BreakBeforeParameter = true;
        }
        if (Current.is_TokenType(TokenType.TT_BinaryOperator) && Current.CanBreakBefore) {
            ((ParenState)State.Stack.back()).BreakBeforeParameter = false;
        }
        if (!DryRun) {
            int Newlines = std.max((int)1, (int)std.min_uint((int)Current.NewlinesBefore, (int)(this.Style.MaxEmptyLinesToKeep + 1)));
            this.Whitespaces.replaceWhitespace(Current, Newlines, ((ParenState)State.Stack.back()).IndentLevel, State.Column, State.Column, State.Line.InPPDirective);
        }
        if (!Current.isTrailingComment()) {
            ((ParenState)State.Stack.back()).LastSpace = State.Column;
        }
        if (Current.is_TokenKind('/')) {
            ((ParenState)State.Stack.back()).LastSpace += 3;
        }
        State.StartOfLineLevel = Current.NestingLevel;
        State.LowestLevelOnLine = Current.NestingLevel;
        boolean bl = NestedBlockSpecialCase = this.Style.Language != FormatStyle.LanguageKind.LK_Cpp && Current.is_TokenKind('\u0018') && Unsigned.$greater_uint((int)State.Stack.size(), (int)1) && ((ParenState)State.Stack.$at((int)(State.Stack.size() - 2))).NestedBlockInlined;
        if (!NestedBlockSpecialCase) {
            int e = State.Stack.size() - 1;
            for (int i = 0; i != e; ++i) {
                ((ParenState)State.Stack.$at((int)i)).BreakBeforeParameter = true;
            }
        }
        if (!(PreviousNonComment == null || PreviousNonComment.isOneOf('@', '=') || !PreviousNonComment.isNot(TokenType.TT_TemplateCloser) && Current.NestingLevel == 0 || PreviousNonComment.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_FunctionAnnotationRParen, TokenType.TT_JavaAnnotation, TokenType.TT_LeadingJavaAnnotation) || !Current.isNot(TokenType.TT_BinaryOperator) || PreviousNonComment.opensScope())) {
            ((ParenState)State.Stack.back()).BreakBeforeParameter = true;
        }
        if (PreviousNonComment != null && PreviousNonComment.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare)) {
            ((ParenState)State.Stack.back()).BreakBeforeClosingBrace = true;
        }
        if (((ParenState)State.Stack.back()).AvoidBinPacking && (!Previous.isOneOf('\u0015', '\u0017', TokenType.TT_BinaryOperator) || !this.Style.AllowAllParametersOfDeclarationOnNextLine && State.Line.MustBeDeclaration || Previous.is_TokenType(TokenType.TT_DictLiteral))) {
            ((ParenState)State.Stack.back()).BreakBeforeParameter = true;
        }
        return Penalty;
    }

    private int getNewLineColumn(LineState State) {
        if (State.NextToken == null || State.NextToken.Previous == null) {
            return 0;
        }
        FormatToken Current = State.NextToken;
        FormatToken Previous = Current.Previous;
        int ContinuationIndent = std.max((int)((ParenState)State.Stack.back$Const()).LastSpace, (int)((ParenState)State.Stack.back$Const()).Indent) + this.Style.ContinuationIndentWidth;
        FormatToken PreviousNonComment = Current.getPreviousNonComment();
        FormatToken NextNonComment = Previous.getNextNonComment();
        if (NextNonComment == null) {
            NextNonComment = Current;
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Java && Current.isOneOf(this.Keywords.kw_implements, this.Keywords.kw_extends)) {
            return std.max((int)((ParenState)State.Stack.back$Const()).LastSpace, (int)(((ParenState)State.Stack.back$Const()).Indent + this.Style.ContinuationIndentWidth));
        }
        if (NextNonComment.is_TokenKind('\u0017') && NextNonComment.BlockKind == BraceBlockKind.BK_Block) {
            return Current.NestingLevel == 0 ? State.FirstIndent : ((ParenState)State.Stack.back$Const()).Indent;
        }
        if (Current.isOneOf('\u0018', '\u0014') && Unsigned.$greater_uint((int)State.Stack.size(), (int)1)) {
            if (Current.closesBlockOrBlockTypeList(this.Style)) {
                return ((ParenState)State.Stack.$at$Const((int)(State.Stack.size() - 2))).NestedBlockIndent;
            }
            if (Current.MatchingParen != null && Current.MatchingParen.BlockKind == BraceBlockKind.BK_BracedInit) {
                return ((ParenState)State.Stack.$at$Const((int)(State.Stack.size() - 2))).LastSpace;
            }
            return State.FirstIndent;
        }
        if (Current.is_TokenKind('\u0005') && Current.Next != null && Current.Next.is_TokenType(TokenType.TT_DictLiteral)) {
            return ((ParenState)State.Stack.back$Const()).Indent;
        }
        if (NextNonComment.isStringLiteral() && State.StartOfStringLiteral != 0) {
            return State.StartOfStringLiteral;
        }
        if (NextNonComment.is_TokenType(TokenType.TT_ObjCStringLiteral) && State.StartOfStringLiteral != 0) {
            return State.StartOfStringLiteral - 1;
        }
        if (NextNonComment.is_TokenKind('/') && ((ParenState)State.Stack.back$Const()).FirstLessLess != 0) {
            return ((ParenState)State.Stack.back$Const()).FirstLessLess;
        }
        if (NextNonComment.isMemberAccess()) {
            if (((ParenState)State.Stack.back$Const()).CallContinuation == 0) {
                return ContinuationIndent;
            }
            return ((ParenState)State.Stack.back$Const()).CallContinuation;
        }
        if (((ParenState)State.Stack.back$Const()).QuestionColumn != 0 && (NextNonComment.is_TokenKind('<') && NextNonComment.is_TokenType(TokenType.TT_ConditionalExpr) || Previous.is_TokenType(TokenType.TT_ConditionalExpr))) {
            return ((ParenState)State.Stack.back$Const()).QuestionColumn;
        }
        if (Previous.is_TokenKind('@') && ((ParenState)State.Stack.back$Const()).VariablePos != 0) {
            return ((ParenState)State.Stack.back$Const()).VariablePos;
        }
        if (PreviousNonComment != null && (PreviousNonComment.ClosesTemplateDeclaration || PreviousNonComment.isOneOf(TokenType.TT_AttributeParen, TokenType.TT_FunctionAnnotationRParen, TokenType.TT_JavaAnnotation, TokenType.TT_LeadingJavaAnnotation)) || !this.Style.IndentWrappedFunctionNames && NextNonComment.isOneOf('\u0088', TokenType.TT_FunctionDeclarationName)) {
            return std.max((int)((ParenState)State.Stack.back$Const()).LastSpace, (int)((ParenState)State.Stack.back$Const()).Indent);
        }
        if (NextNonComment.is_TokenType(TokenType.TT_SelectorName)) {
            if (!((ParenState)State.Stack.back$Const()).ObjCSelectorNameFound) {
                if (NextNonComment.LongestObjCSelectorName == 0) {
                    return ((ParenState)State.Stack.back$Const()).Indent;
                }
                return (this.Style.IndentWrappedFunctionNames ? std.max((int)((ParenState)State.Stack.back$Const()).Indent, (int)(State.FirstIndent + this.Style.ContinuationIndentWidth)) : ((ParenState)State.Stack.back$Const()).Indent) + NextNonComment.LongestObjCSelectorName - NextNonComment.ColumnWidth;
            }
            if (!((ParenState)State.Stack.back$Const()).AlignColons) {
                return ((ParenState)State.Stack.back$Const()).Indent;
            }
            if (Unsigned.$greater_uint((int)((ParenState)State.Stack.back$Const()).ColonPos, (int)NextNonComment.ColumnWidth)) {
                return ((ParenState)State.Stack.back$Const()).ColonPos - NextNonComment.ColumnWidth;
            }
            return ((ParenState)State.Stack.back$Const()).Indent;
        }
        if (NextNonComment.is_TokenType(TokenType.TT_ArraySubscriptLSquare)) {
            if (((ParenState)State.Stack.back$Const()).StartOfArraySubscripts != 0) {
                return ((ParenState)State.Stack.back$Const()).StartOfArraySubscripts;
            }
            return ContinuationIndent;
        }
        if (NextNonComment.is_TokenKind('\u0005') && NextNonComment.FakeRParens == 0 && NextNonComment.Next != null && NextNonComment.Next.is_TokenType(TokenType.TT_ObjCMethodExpr)) {
            return ((ParenState)State.Stack.back$Const()).Indent;
        }
        if (NextNonComment.isOneOf(TokenType.TT_StartOfName, TokenType.TT_PointerOrReference) || Previous.isOneOf('F', '>', TokenType.TT_JsTypeColon)) {
            return ContinuationIndent;
        }
        if (PreviousNonComment != null && PreviousNonComment.is_TokenKind('<') && PreviousNonComment.isOneOf(TokenType.TT_ObjCMethodExpr, TokenType.TT_DictLiteral)) {
            return ContinuationIndent;
        }
        if (NextNonComment.is_TokenType(TokenType.TT_CtorInitializerColon)) {
            return State.FirstIndent + this.Style.ConstructorInitializerIndentWidth;
        }
        if (NextNonComment.is_TokenType(TokenType.TT_CtorInitializerComma)) {
            return ((ParenState)State.Stack.back$Const()).Indent;
        }
        if (Previous.is_TokenKind('\u0016') && !Current.isBinaryOperator() && !Current.isOneOf('<', '\u0004')) {
            return ContinuationIndent;
        }
        if (((ParenState)State.Stack.back$Const()).Indent == State.FirstIndent && PreviousNonComment != null && PreviousNonComment.isNot('\u0018')) {
            return ((ParenState)State.Stack.back$Const()).Indent + this.Style.ContinuationIndentWidth;
        }
        return ((ParenState)State.Stack.back$Const()).Indent;
    }

    private int addMultilineToken(FormatToken Current, LineState State) {
        if (!Current.IsMultiline) {
            return 0;
        }
        int e = State.Stack.size();
        for (int i = 0; i != e; ++i) {
            ((ParenState)State.Stack.$at((int)i)).BreakBeforeParameter = true;
        }
        int ColumnsUsed = State.Column;
        State.Column = Current.LastLineColumnWidth;
        if (Unsigned.$greater_uint((int)ColumnsUsed, (int)this.getColumnLimit(State))) {
            return this.Style.PenaltyExcessCharacter * (ColumnsUsed - this.getColumnLimit(State));
        }
        return 0;
    }

    private boolean nextIsMultilineString(LineState State) {
        FormatToken Current = State.NextToken;
        if (!Current.isStringLiteral() || Current.is_TokenType(TokenType.TT_ImplicitStringLiteral)) {
            return false;
        }
        if (Current.TokenText.startswith("R\"")) {
            return false;
        }
        if (Current.IsMultiline) {
            return true;
        }
        if (Current.getNextNonComment() != null && Current.getNextNonComment().isStringLiteral()) {
            return true;
        }
        return this.Style.ColumnLimit != 0 && Unsigned.$greater_uint((int)(State.Column + Current.ColumnWidth + Current.UnbreakableTailLength), (int)this.Style.ColumnLimit);
    }

    public void $destroy() {
        this.CommentPragmasRegex.$destroy();
        this.Style.$destroy();
    }

    public String toString() {
        return "Style=" + this.Style + ", Keywords=" + this.Keywords + ", SourceMgr=[SourceManager], Whitespaces=[WhitespaceManager], Encoding=" + (Object)((Object)this.Encoding) + ", BinPackInconclusiveFunctions=" + this.BinPackInconclusiveFunctions + ", CommentPragmasRegex=" + this.CommentPragmasRegex;
    }
}

