/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clang.format.impl.BreakableToken;
import org.clang.format.impl.EncodingStatics;
import org.clang.format.impl.FormatToken;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;

public abstract class BreakableSingleLineToken
extends BreakableToken
implements Destructors.ClassWithDestructor {
    protected int StartColumn;
    protected StringRef Prefix;
    protected StringRef Postfix;
    protected StringRef Line;

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public int getLineLengthAfterSplit(int LineIndex, int Offset, int Length) {
        return this.StartColumn + this.Prefix.size() + this.Postfix.size() + EncodingStatics.columnWidthWithTabs(this.Line.substr(Offset, Length), this.StartColumn + this.Prefix.size(), this.Style.TabWidth, this.Encoding);
    }

    protected BreakableSingleLineToken(FormatToken Tok, int IndentLevel, int StartColumn, StringRef Prefix, StringRef Postfix, boolean InPPDirective, EncodingStatics.Encoding $Encoding, FormatStyle Style) {
        super(Tok, IndentLevel, InPPDirective, $Encoding, Style);
        this.StartColumn = StartColumn;
        this.Prefix = new StringRef(Prefix);
        this.Postfix = new StringRef(Postfix);
        this.Line = new StringRef();
        assert (Tok.TokenText.endswith(Postfix));
        this.Line.$assignMove(Tok.TokenText.substr(Prefix.size(), Tok.TokenText.size() - Prefix.size() - Postfix.size()));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "StartColumn=" + this.StartColumn + ", Prefix=" + this.Prefix + ", Postfix=" + this.Postfix + ", Line=" + this.Line + super.toString();
    }
}

