package noria.ui.examples

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.size
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.Button
import fleet.compose.theme.components.gallery.gallery
import noria.ui.core.LocalWindow
import noria.ui.loop.LocalWindowManager
import noria.windowManagement.api.Size
import noria.windowManagement.extensions.size

internal fun windowManagerExamples() = gallery("Window Manager", NoriaExamples.sourceCodeForFile("WindowManager.kt")) {
  example("Window Size") {
    val windowManager = LocalWindowManager.current
    val window = LocalWindow.current
    Column {
      //                window.title = Random.nextInt().toString()
      Button(text = "Reset") {
        window.size = Size(1200f, 800f)
      }
      Spacer(Modifier.size(4.dp, 4.dp))
      Button(text = "Test") {
        window.size = Size(1200f, 600f)
        //                window.title = Random.nextInt().toString()
        window.size = Size(1200f, 800f)
      }
    }
  }
}