package noria.ui.examples

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.ui.core.inputLagDetector
import noria.ui.core.vsyncTester
import fleet.compose.theme.text.NoriaParagraphStyle
import fleet.compose.theme.components.UiText
import noria.ui.text.WebLink

internal fun renderPerformanceExamples(): Gallery = gallery("Render Metrics", NoriaExamples.sourceCodeForFile("RenderMetrics.kt")) {
  example("Vsync Tester") {
    Column {
      UiText("Click to toggle animation. When v-sync works smooth, text should looks grey.",
             paragraphStyle = NoriaParagraphStyle.multiline)
      Spacer(Modifier.height(4.dp))
      WebLink("https://www.vsynctester.com/manual.html")
      Spacer(Modifier.height(4.dp))
      vsyncTester()
      Spacer(Modifier.height(4.dp))
//      inputLagDetector()
    }
  }
}