package noria.ui.examples

import androidx.compose.animation.core.*
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.*
import kotlinx.coroutines.delay
import noria.state
import fleet.compose.theme.components.gallery.gallery
import noria.ui.core.boundary
import fleet.compose.theme.launchOnce

internal fun progressExamples() = gallery("Progress", NoriaExamples.sourceCodeForFile("Progress.kt")) {
  example("Determinate") {
    val transition = rememberInfiniteTransition()
    val completedPercent = transition.noriaAnimateFloat(this, initialValue = 0f,
                                                        targetValue = 100f,
                                                        infiniteRepeatable(tween(easing = LinearEasing, durationMillis = 5 * 1000),
                                                                      RepeatMode.Restart))
    Column {
      boundary {
        DeterminateProgress(completedPercent = completedPercent.value)
      }
    }
  }

  example("Indeterminate") {
    Column {
      IndeterminateProgress(2.dp)
    }
  }

  example("Determinate with ProgressIndicator API") {
    ProgressIndicatorBox(isDeterminate = true) { progressIndicator ->
      val actions = listOf(
        { progressIndicator.run { setState(ProgressState.RUNNING); setCompletedPercent(0f) } },
        { progressIndicator.setCompletedPercent(10f) },
        { progressIndicator.setCompletedPercent(20f) },
        { progressIndicator.setCompletedPercent(40f) },
        { progressIndicator.setCompletedPercent(80f) },
        { progressIndicator.setState(ProgressState.FINISHED) },
        { progressIndicator.setState(ProgressState.NOT_STARTED) },
      )
      val actionNumber = state { 0 }
      launchOnce {
        while (true) {
          delay(1000)
          actionNumber.update { it + 1 }
        }
      }
      actions[actionNumber.read().coerceAtMost(actions.size - 1)].invoke()

      Column(horizontalAlignment = Alignment.CenterHorizontally) {
        UiText("Computing…")
        Spacer(Modifier.height(8.dp))
        Button(text = "Restart", onClick = { actionNumber.update { 0 } })
      }
    }
  }
}
