package noria.ui.examples

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import noria.sideEffect
import noria.state
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.UiText

internal fun lazyConstraint(): Gallery = gallery("Lazy Constrain", NoriaExamples.sourceCodeForFile("LazyConstrain.kt")) {
  example("Lazy Constrain") {
    val headerHeight = state { 0.dp }
    val height = 32.dp
    sideEffect { headerHeight.update { height } }
    Row(Modifier.height(height = headerHeight.read()), verticalAlignment = Alignment.CenterVertically) {
      Spacer(Modifier.width(12.dp))
      UiText("TEXT")
    }
  }
}
