package noria.ui.examples

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.graphics.css
import fleet.compose.theme.keys.TextStyleKeys

internal fun typographyExamples(): Gallery = gallery("Typography", NoriaExamples.sourceCodeForFile("Typography.kt")) {
  val backgroundColor = Color.css("18191B")
  val foregroundColor = Color.White

  example("Typography") {
    Column {
      UiText("H0 SemiBold",
             textStyleKey = TextStyleKeys.Header0SemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(30.dp))

      UiText(text = "H1 SemiBold",
             textStyleKey = TextStyleKeys.Header1SemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(32.dp))

      UiText(text = "H1",
             textStyleKey = TextStyleKeys.Header1,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(34.dp))

      UiText(text = "H2 SemiBold",
             textStyleKey = TextStyleKeys.Header2SemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(36.dp))

      UiText(text = "H2",
             textStyleKey = TextStyleKeys.Header2,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(38.dp))

      UiText(text = "H3 SemiBold",
             textStyleKey = TextStyleKeys.Header3SemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(40.dp))

      UiText(text = "H3",
             textStyleKey = TextStyleKeys.Header3,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(41.dp))

      UiText(text = "H4 SemiBold",
             textStyleKey = TextStyleKeys.Header4SemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(44.dp))

      UiText(text = "H5 SEMIBOLD",
             textStyleKey = TextStyleKeys.Header5SemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(45.dp))

      UiText(text = "Default",
             textStyleKey = TextStyleKeys.Default,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(44.dp))

      UiText(text = "Default Italic",
             textStyleKey = TextStyleKeys.DefaultItalic,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(44.dp))

      UiText(text = "Default SemiBold",
             textStyleKey = TextStyleKeys.DefaultSemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(43.dp))

      UiText(text = "Default Multiline",
             textStyleKey = TextStyleKeys.DefaultMultiline,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(43.dp))

      UiText(text = "Medium",
             textStyleKey = TextStyleKeys.Medium,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(44.dp))

      UiText(text = "Medium SemiBold",
             textStyleKey = TextStyleKeys.MediumSemiBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(46.dp))

      UiText(text = "Small",
             textStyleKey = TextStyleKeys.Small,
             color = foregroundColor,
             backgroundColor = backgroundColor)
    }
  }

  example("Typography Code") {
    Column {
      UiText("Code",
             textStyleKey = TextStyleKeys.Code,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(42.dp))

      UiText(text = "Code Italic",
             textStyleKey = TextStyleKeys.CodeItalic,
             color = foregroundColor,
             backgroundColor = backgroundColor)
      Spacer(Modifier.height(38.dp))

      UiText(text = "Code Bold",
             textStyleKey = TextStyleKeys.CodeBold,
             color = foregroundColor,
             backgroundColor = backgroundColor)
    }
  }
}