package noria.ui.examples

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.width
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.*
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.keys.TextStyleKeys
import fleet.compose.theme.text.*
import noria.ui.withModifier

internal fun trimmedTextExamples(): Gallery {
  return gallery("TrimmedText", NoriaExamples.sourceCodeForFile("TrimmedText.kt")) {
    example("TextWithVisiblieRegion") {
      UiText(text = buildAnnotatedString {
        append("Some text with an [")
        withAlwaysVisible {
          withStyle(SpanStyle(Color.Green)) {
            append("ellipsis")
          }
        }
        append("] in the end and underscored")
      }, textStyleKey = TextStyleKeys.Default, trim = Trim.CenterVisibleRegion)
    }

    example("TextWithVisiblieRegion At The End") {
      UiText(text = buildAnnotatedString {
        append("Some text with an [")
        withAlwaysVisible {
          withStyle(SpanStyle(Color.Green)) {
            append("ellipsis")
          }
        }
      }, textStyleKey = TextStyleKeys.Default, trim = Trim.CenterVisibleRegion)
    }

    example("TextWithVisiblieRegion BaseLine") {
      val text = buildAnnotatedString {
        append("Some text with an [")
        withAlwaysVisible {
          withStyle(SpanStyle(Color.Green)) {
            append("ellipsis")
          }
        }
      }
      Row {
        UiText(text, textStyleKey = TextStyleKeys.Default)
        UiText(text, textStyleKey = TextStyleKeys.Default, trim = Trim.CenterVisibleRegion)
      }
    }

    example("TextWithVisiblieRegion Very Long Text") {
      val text = remember {
        buildAnnotatedString {
          repeat(1000) {
            append("before!")
          }
          append("Some text with an [")
          withAlwaysVisible {
            withStyle(SpanStyle(Color.Green)) {
              append("ellipsis")
            }
          }
          append("] in the end and underscored")
          repeat(1000) {
            append("after!")
          }
        }
      }
      UiText(text, textStyleKey = TextStyleKeys.Default, trim = Trim.CenterVisibleRegion)
    }

    example("Ellipsis At The Start") {
      UiText("Some reasonably long Text with ellipsis at the start should be here",
             paragraphStyle = NoriaParagraphStyle(alignment = NoriaTextAlignment.RIGHT,
                                                  ellipsis = "…",
                                                  maxLinesCount = 1))
    }

    example("Trimmed Text With Middle Ellipsis") {
      UiText(buildAnnotatedString { append("Some reasonably long Text with ellipsis at the start should be here") },
             textStyleKey = TextStyleKeys.Default,
             trim = Trim.Middle)
    }

    example("Trimmed Text With Start Ellipsis") {
      UiText(buildAnnotatedString { append("Some reasonably long Text with ellipsis at the start should be here") },
             textStyleKey = TextStyleKeys.Default,
             trim = Trim.Start)
    }

    example("Short Trimmed Text") {
      UiText("1", trim = Trim.Middle)
    }

    example("Trimmed Text") {
      Box(contentAlignment = Alignment.TopStart) {
        withModifier(Modifier.width(width = 120.dp)) {
          Column {
            UiText("Some text with an ellipsis in the middle", trim = Trim.Middle)
            UiText("Some text with an ellipsis in the end", trim = Trim.End)
            UiText("Some text with an ellipsis in the end and underscored",
                   noriaTextDecoration = NoriaTextDecoration(style = NoriaTextDecoration.Style.SOLID),
                   trim = Trim.End)
          }
        }
      }
    }
  }
}
