package noria.ui.examples

import androidx.compose.foundation.layout.Column
import noria.model.Propagate
import noria.state
import noria.ui.components.clickable
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.withTooltip
import fleet.compose.theme.components.UiText
import java.util.Date

internal fun tooltipExamples(): Gallery = gallery("Tooltip", NoriaExamples.sourceCodeForFile("Tooltip.kt")) {
  example("Tooltip") {
    Column {
      val state = state { 0 }
      withTooltip("Tooltip text " + state.read()) {
        clickable(onClick = {
          state.update { s -> s + 1 }
          println("Click! " + state.read() + " " + Date())
        }, propagate = Propagate.CONTINUE) {
          UiText("Point or click on me")
        }
      }
    }
  }
}