package noria.ui.examples

import androidx.compose.foundation.layout.Arrangement.Absolute.spacedBy
import androidx.compose.foundation.layout.Row
import androidx.compose.ui.Alignment
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.DefaultToolbarSeparator
import fleet.compose.theme.components.GhostButton
import fleet.compose.theme.components.LargeGhostButton
import fleet.compose.theme.components.LargeToolbarSeparator
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.model.IconKey

internal fun toolbarExamples(): Gallery = gallery("Toolbar", NoriaExamples.sourceCodeForFile("Toolbar.kt")) {
  example("Default Toolbar") {
    Row(horizontalArrangement = spacedBy(2.dp), verticalAlignment = Alignment.CenterVertically) {
      GhostButton(IconKey("icons.settings")) {}
      GhostButton(IconKey("icons.settings")) {}
      GhostButton(IconKey("icons.settings")) {}

      DefaultToolbarSeparator()

      GhostButton(IconKey("icons.settings")) {}
      GhostButton(IconKey("icons.settings")) {}
    }
  }
  example("Large Toolbar") {
    Row(horizontalArrangement = spacedBy(2.dp), verticalAlignment = Alignment.CenterVertically) {
      LargeGhostButton(IconKey("icons.settings")) {}
      LargeGhostButton(IconKey("icons.settings")) {}
      LargeGhostButton(IconKey("icons.settings")) {}

      LargeToolbarSeparator()

      LargeGhostButton(IconKey("icons.settings")) {}
      LargeGhostButton(IconKey("icons.settings")) {}
    }
  }
}
