package noria.ui.examples

import androidx.compose.foundation.*
import androidx.compose.foundation.layout.*
import androidx.compose.ui.Alignment
import noria.ui.components.*
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp

internal fun nestedScrollingExamples(): Gallery = gallery("Nested Scrolling", NoriaExamples.sourceCodeForFile("NestedScrolling.kt")) {
  /**
   * There are two special cases when scrollable panels are nested which we need to pay attention to:
   * - When the mouse is hovering the inner scrollable panel and the panel is scrolled all the way to its end, the scrolling should
   *   propagate through to the surrounding scrollable panels
   * - When the scrolling starts on the outer scrollable panel, and another scrollable panel is moved under the cursor in the process of
   *   scrolling, the inner panel should not be scrolled as long as the cursor is not moved
   */
  /**
   * There are two special cases when scrollable panels are nested which we need to pay attention to:
   * - When the mouse is hovering the inner scrollable panel and the panel is scrolled all the way to its end, the scrolling should
   *   propagate through to the surrounding scrollable panels
   * - When the scrolling starts on the outer scrollable panel, and another scrollable panel is moved under the cursor in the process of
   *   scrolling, the inner panel should not be scrolled as long as the cursor is not moved
   */
  example("Nested Scrolling") {
    Box(Modifier.height(200.dp)) {
      scroll(verticalScrollBarVisibility = ScrollBarVisibility.ALWAYS_VISIBLE) {
        Box(Modifier.background(Color.Blue).height(400.dp).padding(50.dp)) {
          scroll(verticalScrollBarVisibility = ScrollBarVisibility.ALWAYS_VISIBLE) {
            Box(Modifier.background(Color.Green).size(300.dp, 400.dp))
          }
        }
      }
    }
  }

  example("Nested Scrolling via Compose Modifiers") {
    Box(Modifier.height(200.dp)) {
      val outerScrollState = rememberScrollState()
      Box(Modifier.background(Color.Blue).height(200.dp).verticalScroll(outerScrollState).padding(50.dp)) {
        val innerScrollState = rememberScrollState()
        Box(Modifier.background(Color.Yellow).height(300.dp).verticalScroll(innerScrollState)) {
          Box(Modifier.background(Color.Green).size(300.dp, 400.dp))
        }
        VerticalScrollbar(rememberScrollbarAdapter(innerScrollState), Modifier.height(300.dp).align(Alignment.CenterEnd))
      }
      VerticalScrollbar(rememberScrollbarAdapter(outerScrollState), Modifier.height(200.dp).align(Alignment.CenterEnd))
    }
  }
}