package noria.ui.examples

import andel.editor.simpleEditor
import andel.intervals.Interval
import andel.intervals.Intervals
import andel.text.Text
import androidx.compose.foundation.layout.width
import androidx.compose.ui.Modifier
import fleet.util.nextLongValue
import noria.model.ThemeKey
import noria.model.components.editor.TextAttributesKey
import noria.state
import fleet.compose.theme.text.NoriaTextDecoration
import noria.ui.components.editor.editorData
import noria.ui.components.editor.simpleEditorModel
import noria.ui.core.boundary
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.theme
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import fleet.compose.theme.text.TextAttributes
import noria.ui.components.editor.Editor
import noria.ui.withModifier
import java.util.*

internal fun editorViewGallery(): Gallery =
  gallery("Editor View", NoriaExamples.sourceCodeForFile("EditorView.kt")) {
    example("Text Decorations") {
      withModifier(Modifier.width(width = 500.dp)) {
        val color = Color.Red
        var text = ""
        val intervals = mutableListOf<Interval<Long, TextAttributesKey>>()
        val themeMap = mutableMapOf<ThemeKey<*>, TextAttributes>()
        NoriaTextDecoration.Style.entries
          .forEach { style ->
            NoriaTextDecoration.Position.entries.forEach { pos ->
              text += "${style.toString().lowercase(Locale.getDefault()).replaceFirstChar { if (it.isLowerCase()) it.titlecase(Locale.getDefault()) else it.toString() }} ${pos.toString().lowercase(Locale.getDefault()).replaceFirstChar { if (it.isLowerCase()) it.titlecase(Locale.getDefault()) else it.toString() }} "
              listOf(1, 2, 3).forEach { thickness ->
                val key = "$style $pos ${thickness}"
                themeMap[ThemeKey<Any>(key)] = TextAttributes(decoration = NoriaTextDecoration(color, style, pos, thickness.toFloat()))
                var start = text.length.toLong()
                text += "$thickness >"
                intervals.add(Interval(nextLongValue(), start, text.length.toLong(), false, false, TextAttributesKey(key)))
                start = text.length.toLong()
                text += "< px pi_qp-fg–ly"
                intervals.add(Interval(nextLongValue(), start, text.length.toLong(), false, false, TextAttributesKey(key)))
                text += " "
              }
              text += "\n\n"
            }
          }
        val model = state { simpleEditor(Text.fromString(text)) }
        boundary {
          val simpleEditorState = model.read()
          val editorModel = simpleEditorModel(model)
          var data = simpleEditorState.editorData(model, theme.copy(map = theme.map.putAll(themeMap)))
          data = data.copy(markup = Intervals.droppingCollapsed().fromIntervals(intervals))
          Editor(data, editorModel)
        }
      }
    }
  }
