package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.text.BasicText
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import noria.NoriaContext
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.UiText

internal fun composeIntrinsicsExamples(): Gallery = gallery("Compose Intrinsics", NoriaExamples.sourceCodeForFile("ComposeIntrinsics.kt")) {
  example("Compose Two Texts") {
    Column(Modifier.heightIn(max  = 500.dp)) {
      Row {
        TwoTexts(text1 = "Hi", text2 = "there")
      }
    }
  }
  example("Compose Two UI Texts") {
    Column(Modifier.heightIn(max  = 500.dp)) {
      Row {
        TwoUITexts(text1 = "Hi", text2 = "there")
      }
    }
  }
}


@Composable
fun NoriaContext.TwoTexts(modifier: Modifier = Modifier, text1: String, text2: String) {
  Row(modifier = modifier.height(IntrinsicSize.Min)) {
    BasicText(
      modifier = Modifier
        .weight(1f)
        .padding(start = 4.dp)
        .wrapContentWidth(Alignment.Start),
      text = text1
    )
    Spacer(
      modifier = Modifier.fillMaxHeight().width(1.dp).background(Color.Black)
    )
    BasicText(
      modifier = Modifier
        .weight(1f)
        .padding(end = 4.dp)
        .wrapContentWidth(Alignment.End),
      text = text2
    )
  }
}


@Composable
fun NoriaContext.TwoUITexts(modifier: Modifier = Modifier, text1: String, text2: String) {
  Row(modifier = modifier.height(IntrinsicSize.Min)) {
    UiText(
      modifier = Modifier
        .weight(1f)
        .padding(start = 4.dp)
        .wrapContentWidth(Alignment.Start),
      text = text1
    )
    Spacer(
      modifier = Modifier.fillMaxHeight().width(1.dp).background(Color.Black)
    )
    UiText(
      modifier = Modifier
        .weight(1f)
        .padding(end = 4.dp)
        .wrapContentWidth(Alignment.End),

      text = text2
    )
  }
}