package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.runtime.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.buildStringWithMatcher
import fleet.compose.theme.components.combobox.ComboBox
import fleet.compose.theme.components.combobox.LargeComboBox
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.popupItemCellColors
import fleet.compose.theme.keys.TextStyleKeys
import noria.NoriaContext
import noria.model.Propagate
import noria.set
import noria.ui.components.list.ListItem
import noria.ui.components.list.ListViewOptions
import noria.ui.components.list.listModel
import noria.ui.components.textInputModel

internal fun comboBoxExamples(): Gallery = gallery("ComboBox", NoriaExamples.sourceCodeForFile("ComboBox.kt")) {
  example("Simple ComboBox") {
    Box(Modifier.width(300.dp)) {
      Column(verticalArrangement = Arrangement.spacedBy(10.dp)) {
        ComboxBoxExample()

        LargeComboxBoxExample()
      }
    }
  }
}

@Composable
private fun NoriaContext.ComboxBoxExample(modifier: Modifier = Modifier) {
  val text = textInputModel("")
  val listModel = listModel(
    (0 until 10).map {
      val title = "example $it"
      ListItem(title, title, textToMatch = title) {
        val colors = popupItemCellColors(it)
        Box(modifier.padding(horizontal = 4.dp).height(28.dp).background(colors.fill, RoundedCornerShape(8.dp)).padding(horizontal = 12.dp), contentAlignment = Alignment.CenterStart) {
          UiText(buildStringWithMatcher(title, matcher = it.matcher), textStyleKey = TextStyleKeys.Default)
        }
      }
    },
    options = ListViewOptions(
      confirmOnClick = true,
    ),
    onConfirm = { items ->
      Propagate.STOP
    }
  )
  ComboBox(text, listModel, enabled = true, modifier = modifier)
}


@Composable
private fun NoriaContext.LargeComboxBoxExample(modifier: Modifier = Modifier) {
  val text = textInputModel("")
  val listModel = listModel(
    (0 until 10).map {
      val title = "example $it"
      ListItem(title, title, textToMatch = title) {
        val colors = popupItemCellColors(it)
        Box(modifier.padding(horizontal = 4.dp).height(28.dp).background(colors.fill, RoundedCornerShape(8.dp)).padding(horizontal = 12.dp), contentAlignment = Alignment.CenterStart) {
          UiText(buildStringWithMatcher(title, matcher = it.matcher), textStyleKey = TextStyleKeys.Default)
        }
      }
    },
    options = ListViewOptions(
      confirmOnClick = true,
    ),
    onConfirm = { items ->
      Propagate.STOP
    }
  )
  LargeComboBox(text, listModel, enabled = true, modifier = modifier)
}
