/*
 * Decompiled with CFR 0.152.
 */
package fleet.profiling.core.idea;

import fleet.profiling.core.idea.MemoryDumpHelper;
import fleet.util.logging.KLogger;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lfleet/profiling/core/idea/MemoryDumpHelper;", "", "()V", "HOT_SPOT_BEAN_NAME", "", "dumpHeap", "Ljava/lang/reflect/Method;", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "mxBean", "captureMemoryDump", "", "dumpPath", "memoryDumpAvailable", "", "fleet.profiling.core"})
public final class MemoryDumpHelper {
    @NotNull
    public static final MemoryDumpHelper INSTANCE;
    @NotNull
    private static final Lazy logger$delegate;
    @NotNull
    private static final String HOT_SPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    @Nullable
    private static final Object mxBean;
    @Nullable
    private static final Method dumpHeap;

    private MemoryDumpHelper() {
    }

    private final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    public final boolean memoryDumpAvailable() {
        boolean bl;
        try {
            bl = mxBean != null;
        }
        catch (UnsupportedOperationException e) {
            bl = false;
        }
        return bl;
    }

    public final synchronized void captureMemoryDump(@NotNull String dumpPath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)dumpPath, (String)"dumpPath");
        Method method = dumpHeap;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray = new Object[]{dumpPath, true};
        method.invoke(mxBean, objectArray);
    }

    private static final Object _init_$lambda$0(Class $hotSpotMxBeanClass) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> s = server.queryNames(new ObjectName(HOT_SPOT_BEAN_NAME), null);
        Iterator<ObjectName> itr = s.iterator();
        if (itr.hasNext()) {
            ObjectName name = itr.next();
            return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), $hotSpotMxBeanClass);
        }
        return null;
    }

    static {
        Pair hotSpotMxBeanClass;
        INSTANCE = new MemoryDumpHelper();
        logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        try {
            Object mxBean;
            hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Object object = mxBean = AccessController.doPrivileged(() -> MemoryDumpHelper._init_$lambda$0(hotSpotMxBeanClass));
            Intrinsics.checkNotNull((Object)object);
            Class[] classArray = new Class[]{String.class, Boolean.TYPE};
            Method dumpHeap = object.getClass().getMethod("dumpHeap", classArray);
            hotSpotMxBeanClass = new Pair(mxBean, (Object)dumpHeap);
        }
        catch (Throwable t) {
            INSTANCE.getLogger().info((Object)t.getMessage());
            hotSpotMxBeanClass = new Pair(null, null);
        }
        Pair pair = hotSpotMxBeanClass;
        Object mxb = pair.component1();
        Method dh = (Method)pair.component2();
        mxBean = mxb;
        dumpHeap = dh;
    }
}

