/*
 * Decompiled with CFR 0.152.
 */
package fleet.profiling.core.idea;

import fleet.api.Arch;
import fleet.api.Os;
import fleet.profiling.core.idea.AbstractLazyCachingExtractor;
import fleet.profiling.core.idea.LazyCachingExtractorFromJar;
import fleet.profiling.core.idea.Platform;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lfleet/profiling/core/idea/AsyncProfilerExtractor;", "", "()V", "agentExtractors", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lfleet/profiling/core/idea/AbstractLazyCachingExtractor;", "binaryRelativePathInJar", "platform", "Lfleet/profiling/core/idea/Platform;", "fileNameWithExtension", "getExtractor", "os", "Lfleet/api/Os;", "arch", "Lfleet/api/Arch;", "getLibrary", "Lfleet/profiling/core/idea/AsyncProfilerExtractor$LibraryInfo;", "getLibraryPath", "LibraryInfo", "fleet.profiling.core"})
public final class AsyncProfilerExtractor {
    @NotNull
    public static final AsyncProfilerExtractor INSTANCE = new AsyncProfilerExtractor();
    @NotNull
    private static final ConcurrentHashMap<String, AbstractLazyCachingExtractor> agentExtractors = new ConcurrentHashMap();

    private AsyncProfilerExtractor() {
    }

    @NotNull
    public final String getLibraryPath(@NotNull Os os, @NotNull Arch arch) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        String string = this.getExtractor(os, arch).getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    private final LibraryInfo getLibrary(Os os, Arch arch) {
        Platform platform = Platform.Companion.from(os, arch);
        String pathInJar = this.binaryRelativePathInJar(platform);
        Class<AsyncProfiler> classFromJar = AsyncProfiler.class;
        return new LibraryInfo(pathInJar, classFromJar);
    }

    private final String binaryRelativePathInJar(Platform platform) {
        String osPart = platform.getPlatformName();
        return "/binaries/" + osPart + "/" + this.fileNameWithExtension(platform);
    }

    private final AbstractLazyCachingExtractor getExtractor(Os os, Arch arch) {
        AbstractLazyCachingExtractor abstractLazyCachingExtractor = agentExtractors.computeIfAbsent(os.name(), arg_0 -> AsyncProfilerExtractor.getExtractor$lambda$0((Function1)new Function1<String, AbstractLazyCachingExtractor>(os, arch){
            final /* synthetic */ Os $os;
            final /* synthetic */ Arch $arch;
            {
                this.$os = $os;
                this.$arch = $arch;
                super(1);
            }

            @NotNull
            public final AbstractLazyCachingExtractor invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new LazyCachingExtractorFromJar(AsyncProfilerExtractor.access$getLibrary(AsyncProfilerExtractor.INSTANCE, this.$os, this.$arch), null, 2, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)abstractLazyCachingExtractor, (String)"computeIfAbsent(...)");
        return abstractLazyCachingExtractor;
    }

    private final String fileNameWithExtension(Platform platform) {
        return switch (WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
            case 1, 2 -> "libasyncProfiler.dylib";
            case 3, 4 -> "libasyncProfiler.so";
            case 5, 6 -> "libasyncProfiler.dll";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final AbstractLazyCachingExtractor getExtractor$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AbstractLazyCachingExtractor)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LibraryInfo access$getLibrary(AsyncProfilerExtractor $this, Os os, Arch arch) {
        return $this.getLibrary(os, arch);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lfleet/profiling/core/idea/AsyncProfilerExtractor$LibraryInfo;", "", "pathInJar", "", "classFromJar", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "getClassFromJar", "()Ljava/lang/Class;", "getPathInJar", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "fleet.profiling.core"})
    public static final class LibraryInfo {
        @NotNull
        private final String pathInJar;
        @NotNull
        private final Class<? extends Object> classFromJar;

        public LibraryInfo(@NotNull String pathInJar, @NotNull Class<? extends Object> classFromJar) {
            Intrinsics.checkNotNullParameter((Object)pathInJar, (String)"pathInJar");
            Intrinsics.checkNotNullParameter(classFromJar, (String)"classFromJar");
            this.pathInJar = pathInJar;
            this.classFromJar = classFromJar;
        }

        @NotNull
        public final String getPathInJar() {
            return this.pathInJar;
        }

        @NotNull
        public final Class<? extends Object> getClassFromJar() {
            return this.classFromJar;
        }

        @NotNull
        public final String component1() {
            return this.pathInJar;
        }

        @NotNull
        public final Class<? extends Object> component2() {
            return this.classFromJar;
        }

        @NotNull
        public final LibraryInfo copy(@NotNull String pathInJar, @NotNull Class<? extends Object> classFromJar) {
            Intrinsics.checkNotNullParameter((Object)pathInJar, (String)"pathInJar");
            Intrinsics.checkNotNullParameter(classFromJar, (String)"classFromJar");
            return new LibraryInfo(pathInJar, classFromJar);
        }

        public static /* synthetic */ LibraryInfo copy$default(LibraryInfo libraryInfo, String string, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                string = libraryInfo.pathInJar;
            }
            if ((n & 2) != 0) {
                clazz = libraryInfo.classFromJar;
            }
            return libraryInfo.copy(string, clazz);
        }

        @NotNull
        public String toString() {
            return "LibraryInfo(pathInJar=" + this.pathInJar + ", classFromJar=" + this.classFromJar + ")";
        }

        public int hashCode() {
            int result = this.pathInJar.hashCode();
            result = result * 31 + this.classFromJar.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LibraryInfo)) {
                return false;
            }
            LibraryInfo libraryInfo = (LibraryInfo)other;
            if (!Intrinsics.areEqual((Object)this.pathInJar, (Object)libraryInfo.pathInJar)) {
                return false;
            }
            return Intrinsics.areEqual(this.classFromJar, libraryInfo.classFromJar);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.MACOS_X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.MACOS_M1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.LINUX_X64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.LINUX_AARCH64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.WINDOWS_X64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.WINDOWS_AARCH64.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

