/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tooling.core;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.rewrite.core.Rewriter;
import org.clang.tooling.core.Range;
import org.clang.tooling.impl.ToolingStatics;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.support.raw_string_ostream;

public class Replacement
implements Destructors.ClassWithDestructor,
Native.ComparableLower {
    private std.string FilePath;
    private Range ReplacementRange;
    private std.string ReplacementText;

    public Replacement() {
        this.FilePath = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, ToolingStatics.InvalidLocation);
        this.ReplacementRange = new Range();
        this.ReplacementText = new std.string();
    }

    public Replacement(StringRef FilePath, int Offset, int Length, StringRef ReplacementText) {
        this.FilePath = FilePath.$string();
        this.ReplacementRange = new Range(Offset, Length);
        this.ReplacementText = ReplacementText.$string();
    }

    public Replacement(SourceManager Sources, SourceLocation Start, int Length, StringRef ReplacementText) {
        this.FilePath = new std.string();
        this.ReplacementRange = new Range();
        this.ReplacementText = new std.string();
        this.setFromSourceLocation(Sources, new SourceLocation(Start), Length, new StringRef(ReplacementText));
    }

    public Replacement(SourceManager Sources, CharSourceRange Range2, StringRef ReplacementText) {
        this(Sources, Range2, ReplacementText, new LangOptions());
    }

    public Replacement(SourceManager Sources, CharSourceRange Range2, StringRef ReplacementText, LangOptions LangOpts) {
        this.FilePath = new std.string();
        this.ReplacementRange = new Range();
        this.ReplacementText = new std.string();
        this.setFromSourceRange(Sources, Range2, new StringRef(ReplacementText), LangOpts);
    }

    public boolean isApplicable() {
        return std.$noteq_string$C_T$C$P((std.string)this.FilePath, (String)ToolingStatics.InvalidLocation.toString());
    }

    public StringRef getFilePath() {
        return new StringRef(this.FilePath);
    }

    public int getOffset() {
        return this.ReplacementRange.getOffset();
    }

    public int getLength() {
        return this.ReplacementRange.getLength();
    }

    public StringRef getReplacementText() {
        return new StringRef(this.ReplacementText);
    }

    public boolean apply(Rewriter Rewrite) {
        boolean RewriteSucceeded;
        SourceManager SM = Rewrite.getSourceMgr();
        FileEntry Entry2 = SM.getFileManager().getFile(new StringRef(this.FilePath));
        if (Entry2 == null) {
            return false;
        }
        FileID ID = SM.getOrCreateFileID(Entry2, SrcMgr.CharacteristicKind.C_User);
        SourceLocation Start = SM.getLocForStartOfFile(ID).getLocWithOffset(this.ReplacementRange.getOffset());
        boolean bl = RewriteSucceeded = !Rewrite.ReplaceText(new SourceLocation(Start), this.ReplacementRange.getLength(), new StringRef(this.ReplacementText));
        assert (RewriteSucceeded);
        return RewriteSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string __toString() {
        raw_string_ostream Stream2 = null;
        try {
            std.string Result = new std.string();
            Stream2 = new raw_string_ostream(Result);
            Stream2.$out(this.FilePath).$out(": ").$out_uint(this.ReplacementRange.getOffset()).$out(":+").$out_uint(this.ReplacementRange.getLength()).$out(":\"").$out(this.ReplacementText).$out(NativePointer.$DBL_QUOTE);
            std.string string2 = new std.string(Stream2.str());
            return string2;
        }
        finally {
            if (Stream2 != null) {
                Stream2.$destroy();
            }
        }
    }

    private void setFromSourceLocation(SourceManager Sources, SourceLocation Start, int Length, StringRef ReplacementText) {
        std_pair.pairTypeUInt DecomposedLocation = Sources.getDecomposedLoc(Start);
        FileEntry Entry2 = Sources.getFileEntryForID((FileID)DecomposedLocation.first);
        this.FilePath.$assign_T$C$P(Entry2 != null ? Entry2.getName() : ToolingStatics.InvalidLocation);
        this.ReplacementRange.$assignMove(new Range(DecomposedLocation.second, Length));
        this.ReplacementText.$assignMove(ReplacementText.$string());
    }

    private void setFromSourceRange(SourceManager Sources, CharSourceRange Range2, StringRef ReplacementText, LangOptions LangOpts) {
        this.setFromSourceLocation(Sources, Sources.getSpellingLoc(Range2.getBegin()), ToolingStatics.getRangeSize(Sources, Range2, LangOpts), new StringRef(ReplacementText));
    }

    public Replacement(Replacement $Prm0) {
        this.FilePath = new std.string($Prm0.FilePath);
        this.ReplacementRange = new Range($Prm0.ReplacementRange);
        this.ReplacementText = new std.string($Prm0.ReplacementText);
    }

    public Replacement(JavaDifferentiators.JD.Move _dparam, Replacement $Prm0) {
        this.FilePath = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.FilePath);
        this.ReplacementRange = new Range(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.ReplacementRange);
        this.ReplacementText = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.ReplacementText);
    }

    public Replacement $assign(Replacement $Prm0) {
        this.FilePath.$assign($Prm0.FilePath);
        this.ReplacementRange.$assign($Prm0.ReplacementRange);
        this.ReplacementText.$assign($Prm0.ReplacementText);
        return this;
    }

    public Replacement $assignMove(Replacement $Prm0) {
        this.FilePath.$assignMove($Prm0.FilePath);
        this.ReplacementRange.$assignMove($Prm0.ReplacementRange);
        this.ReplacementText.$assignMove($Prm0.ReplacementText);
        return this;
    }

    public void $destroy() {
        this.ReplacementText.$destroy();
        this.FilePath.$destroy();
    }

    public boolean $less(Object other) {
        if (this.FilePath.$less((Object)((Replacement)other).FilePath)) {
            return true;
        }
        if (this.FilePath.$eq((Object)((Replacement)other).FilePath)) {
            int res = this.ReplacementRange.getOffset() - ((Replacement)other).getOffset();
            if (res < 0) {
                return true;
            }
            if (res == 0) {
                return this.ReplacementText.$less((Object)((Replacement)other).ReplacementText);
            }
        }
        return false;
    }

    public String toString() {
        return "Replacement{" + this.__toString().toJavaString() + "}";
    }
}

